/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
* PReP Version 1.0
*
* TagList: subclass of vector class, which stores all the tags
*
* History: - Creation nh
*
* @author nh
* @version 1.0
* @see PRePMain, TagList, PRePTag, PRePTagCode
*/
package com.delec.prep;
import com.delec.prettylog.*;
import java.util.*;
import java.io.*;

public class TagList extends Vector
{

	/**
	 * Constructor - sets also certain predefined tags in the list
	 */
	public TagList()
	{
		addElement(new PRePTagIFDEF());
		addElement(new PRePTagDEF());
		addElement(new PRePTagIF());
		addElement(new PRePTagEXEC());
		addElement(new PRePTagDATE());
		addElement(new PRePTagLIST());
		addElement(new PRePTagLISTITEM());
		addElement(new PRePTagDBMS());
		addElement(new PRePTagFOREACHARG());
		addElement(new PRePTagNBSP());
		addElement(new PRePTagTAGLIST());
		addElement(new PRePTagEXCEPTION());
		addElement(new PRePTagBOOLEAN());
		addElement(new PRePTagCALCULATE());
		addElement(new PRePTagIMG());
		addElement(new PRePTagPARSE());
		addElement(new PRePTagFILEREADER());
	}


	/**
	 * find the MAIN tag in the tagList
	 * @param String the searched tag
	 * @return the found PRePTag
	 */
	public PRePTag find(String searchedTag)
	{

		PRePTag tag = null;
		String strSearchedTagTrim = searchedTag.trim();
		for ( int i = size()-1; i >= 0; i-- )
		{
			tag = (PRePTag)elementAt(i);
			if ( tag.sTagName.equals(strSearchedTagTrim) )
			{
				return(PRePTag)tag;
			}
		}
		return null; 
	}

	/**
	 * @param String the value which is to be compile
	 */
	public void compile(String strCompile, Session session)
	{
		PRePTag tag = find(strCompile);
		if ( tag != null )
		{
			tag.compile(session);
		}
	} 

	/**
	 * outputs the whole TagList
	 */
	public void outTag()
	{
		for ( int i = 0; i < size(); i++ )
		{
			PRePTag prepTag = (PRePTag)elementAt(i);
			PrettyLog.log(prepTag.debugOutput(), prepTag.getName());
		}
	}
	/**
	 * outputs the whole TagList in the specified PrintWriter
	 */
	public void outTag(PrintWriter pwriter)
	{
		pwriter.print("<P>");
		for ( int i = 0; i < size(); i++ )
		{
			PRePTag prepTag = (PRePTag)elementAt(i);
			//temporarily changed by se: prepTag.debugOutput()
			//pwriter.println("<font color=red>*"+prepTag.getName().trim()+"</font>  <pre>\""+prepTag.getValue().trim()+"\"</pre>");
			if ( prepTag != null )
			{
				pwriter.println("*"+prepTag.getName()+"<BR>"+prepTag.getValue()+"<P>");
			}
			pwriter.flush();
		}
	}

}
