/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
* PReP Version 1.0
*
* PRePHandler: is the interface between all input like PReP or InputServlet and
*              its subclasses, and the PRePMain and its subclasses
*
*              It takes the input and give it to the PRePMain class
*
* History: - Creation 03/11/99 nh
*
* Date: 03/11/99
*
* @author nh
* @version 1.0
*/

package com.delec.prep;

import com.delec.global.dbms.*;
import java.io.*;
import java.util.*;

public class PRePHandler
{
	private static final boolean LOG = false;

	protected static final String HASH_FILE = "FILE";
	protected static final String HASH_SECURITY = "SECURITY";
	protected static final String HASH_DB = "DB";
	protected static final String HASH_PRePTAGS = "PRePTAGS";

	protected static final String JDBCDRIVER = "sun.jdbc.odbc.JdbcOdbcDriver";
	protected static final String URL = "jdbc:odbc:doc";
	protected static final String UID = "sa";
	protected static final String PWD = "";

	protected static final String HASH_DB_DRIVER = "JDBCDRIVER";
	protected static final String HASH_DB_URL = "URL";
	protected static final String HASH_DB_UID = "UID";
	protected static final String HASH_DB_PWD = "PWD";  

	protected static final String CONFIGFILE = "config.file";

	protected ConnectionPool connectionPool;
	protected Hashtable hashSecurity;
	protected int iSecurity;
	protected String strConfigName = "";

	public PRePHandler(int iSecurity)
	{

		if ( LOG )
		{
			System.out.println("new PRePHandler");
		}

		this.iSecurity = iSecurity;
	}

	public PRePMain getPRePMain()
	{
		if ( LOG )
		{
			System.out.println("getPRePMain");
		}

		return new PRePMain();
	}


	protected String getDBValue(String strFromDB, String strFromConfig, String strDefault)
	{
		if ( hashSecurity != null )
		{
			Hashtable hashDB = (Hashtable)hashSecurity.get(HASH_DB);

			if ( (strFromConfig = findValue(hashDB, strFromConfig)) != null )
			{
				return strFromConfig;
			}
		}

		else if ( strFromDB != null )
		{
			return strFromDB;
		}

		return strDefault;  
	}

	public boolean setDatabaseConnection()
	{
		return setDatabaseConnection(null, null, null, null);   
	}

	public boolean setDatabaseConnection(String strJDBCDriver, String strURL, String strUID, String strPWD)
	{
	    if (iSecurity == 0)
	    {
		return setDatabaseConnection(strJDBCDriver, strURL, strUID, strPWD, 1);
	    }

	    return setDatabaseConnection(strJDBCDriver, strURL, strUID, strPWD, 0);
	}
	public boolean setDatabaseConnection(String strJDBCDriver, String strURL, String strUID, String strPWD, int iConnections)
	{
		this.connectionPool = new ConnectionPool();

		strJDBCDriver = getDBValue(strJDBCDriver, HASH_DB_DRIVER, getJDBCDRIVER());
		strURL = getDBValue(strURL, HASH_DB_URL, getURL());
		strUID = getDBValue(strUID, HASH_DB_UID, getUID());
		strPWD = getDBValue(strPWD, HASH_DB_PWD, getPWD());

		if ( LOG )
		{
			System.out.println("jdbcdriver: "+strJDBCDriver+" URL: "+strURL+" UID: "+strUID+" PWD: "+strPWD);
		}

		try
		{
			connectionPool.initialize(strJDBCDriver, strURL, strUID, strPWD, iConnections);
		}
		catch ( Exception e )
		{
			return false;
		}

		return true;
	}

	public String getJDBCDRIVER()
	{
		return JDBCDRIVER; 

	}

	public String getURL()
	{
		return URL;
	}

	public String getUID()
	{
		return UID;
	}

	public String getPWD()
	{
		return PWD;
	}

	protected File getFile()
	{
		if ( LOG )
		{
			System.out.println("getting File...");
		}

		File file = null;

		try
		{
		    if (!(this.strConfigName.equals("")))
		    {
			file = new File(this.strConfigName);
		    }
		    else
		    {
			file = new File(CONFIGFILE);
		    }
		}
		catch ( Exception e )
		{
		}

		return file;
	}

	protected void getFile(String strValue)
	{
	    this.strConfigName = strValue;
	}

	public void createSecurityHashtable()
	{
		if ( LOG )
		{
			System.out.println("createSecurityHashtable()");
		}

		hashSecurity = new Hashtable();
		File fileConfig = getFile();
		BufferedReader br = getBReader(fileConfig);

		if ( fileConfig != null )
		{
			Hashtable hashFile = fillHashtable(fileConfig, "*"+HASH_FILE);
			Hashtable hashSecure = fillHashtable(fileConfig, "*"+HASH_SECURITY);
			Hashtable hashDB = fillHashtable(fileConfig, "*"+HASH_DB);

			if ( LOG )
			{
				System.out.println("hashDB: "+hashDB.toString());
			}

			Hashtable hashPrepTags = fillHashtable(fileConfig, "*"+HASH_PRePTAGS);

			if ( LOG )
			{
				System.out.println("hashPRePTags: "+hashPrepTags.toString());
			}

			if ( !hashFile.isEmpty() )
			{

				hashSecurity.put(HASH_FILE, hashFile);
			}

			if ( !hashSecure.isEmpty() )
			{

				hashSecurity.put(HASH_SECURITY, hashSecure);
			}

			if ( !hashDB.isEmpty() )
			{

				hashSecurity.put(HASH_DB, hashDB);
			}

			if ( !hashPrepTags.isEmpty() )
			{

				hashSecurity.put(HASH_PRePTAGS, hashPrepTags);
			}
			//System.out.println("HashSecurity: "+hashSecurity.toString());
		}
		else
		{
			hashSecurity = null;
		}
	}

	protected Hashtable fillHashtable(File fileConfig, String strTagName)
	{

		if ( LOG )
		{
			System.out.println("fillHashtable()");
		}

		Hashtable hashFile = new Hashtable();
		BufferedReader bReader = getBReader(fileConfig);

		if ( bReader != null )
		{
			String strLine = getNextLine(bReader);
			String strKey = "";
			String strValue = "";

			while ( strLine != null )
			{

				if ( strLine.startsWith(strTagName) )
				{
					strLine = getNextLine(bReader);

					while ( strLine != null && !strLine.startsWith("*") )
					{
						strKey = getKey(strLine);
						strValue = getValue(strLine);
						hashFile.put(strKey, strValue);
						strLine = getNextLine(bReader);
					}
				}
				strLine = getNextLine(bReader);
			}

		}
		else
		{
			hashSecurity = null;
		}
		return hashFile;
	}

	protected BufferedReader getBReader(File fileConfig)
	{
		FileReader fReader = null;
		BufferedReader bReader = null;

		try
		{
			fReader = new FileReader(fileConfig);
			bReader = new BufferedReader(fReader);
		}
		catch ( Exception e )
		{
		}

		return bReader;
	}

	protected String getKey(String strLine)
	{
		int iIndex = getIndex(strLine);

		if ( iIndex != -1 )
		{
			return strLine.substring(0, iIndex);
		}
		else
		{
			return strLine;
		}
	}


	protected int getIndex(String strLine)
	{
		return strLine.indexOf("::");
	}

	protected String getValue(String strLine)
	{

		int iIndex = getIndex(strLine);

		if ( iIndex != -1 )
		{
			return strLine.substring(iIndex+2);	// this are the '::'
		}
		else
		{
			return strLine;
		}
	}

	protected String findValue(Hashtable hashtable, String strKey)
	{
		if ( LOG )
		{
			System.out.println("finding Value: "+strKey);
		}
		if ( hashtable != null )
		{
			return(String)hashtable.get(strKey);   
		}
		else
		{
			return null;
		}
	}

	protected boolean isInList(String strKey)
	{
		if ( LOG )
		{
			System.out.println("checks if key is in list "+strKey);
		}

		Hashtable hashtable = (Hashtable)hashSecurity.get(HASH_FILE);

		if ( hashtable.containsKey(strKey) )
		{
			return true;
		}
		else
		{
			if ( hashtable.containsValue(strKey) )
			{
				return true;
			}

			return false;
		}
	}

	protected String getNextLine(BufferedReader br)
	{
		PRePPreparse pPreparse = new PRePPreparse();
		return pPreparse.preparse(br);  
	}

	public void putPRePTags(PRePMain prepMain)
	{
		// put special and new PReP tags
		// is to be overwritten by any subclass
		// which uses different PReP tags 
		if ( LOG )
		{
			System.out.println("putPRePTags");
		}

		if ( hashSecurity != null )
		{
			Hashtable hash_prepTags = (Hashtable)hashSecurity.get(HASH_PRePTAGS);

			if ( hash_prepTags != null )
			{

				Enumeration enumeration = hash_prepTags.keys();

				while ( enumeration.hasMoreElements() )
				{

					try
					{
						PRePTag prepTag = (PRePTag)Class.forName(findValue(hash_prepTags, (String)enumeration.nextElement())).newInstance();
						putField(prepMain, prepTag);
					}
					catch ( Exception e )
					{
					}
				}
			}
		}
	}

	public File getDefaultDocument()
	{
		File file = new File("start.prep");
		return file;
	}


	public void putField(PRePMain prepMain, PRePTag prepTag)
	{
		if ( LOG )
		{
			System.out.println("putField(prepTag): "+prepTag.getName());
		}

		prepMain.putField(prepTag);
	}


	public void putField(PRePMain prepMain, String strName, String strValue)
	{
		if ( LOG )
		{
			System.out.println("putField(name, value): "+strName+" "+strValue);
		}

		prepMain.putField(strName, strValue);
	}


	public void putFile(PRePMain prepMain, File file)
	{
		if ( LOG )
		{
			System.out.println("putFile "+file.getName());
		}


		// this comes from a servlet if the security is > 0
		if ( getSecurity() > 0 && hashSecurity != null )
		{

			Hashtable hashSecure = (Hashtable)hashSecurity.get(HASH_SECURITY);
			String strSecurity = findValue(hashSecure, "FILE");

			// files must be checked if security is on
			if ( strSecurity.trim().toLowerCase().equals("on") )
			{

				if ( LOG )
				{
					System.out.println("security is on "+file.getName());
				}

				if ( isInList(file.getName()) && !(file.getName().equals("default")) )
				{

					if ( LOG )
					{
						System.out.println("is in list and is not default...");
					}

					prepMain.putFile(file);
				}
				else
				{
					putDefaultFile(prepMain);
				}
			}
			else // security is off
			{
				if ( file.getName().equals("default") )
				{
					prepMain.putFile(getDefaultDocument());
				}
				else
				{
					prepMain.putFile(file);         
				}
			}       
		}
		else // this comes from a commandline version
		{
			if ( file.getName().equals("default") )
			{
				prepMain.putFile(getDefaultDocument());
			}
			else
			{

				if ( LOG )
				{
					System.out.println("no default file: "+file.getName());
				}

				prepMain.putFile(file);     
			}
		}
	}

	protected void putDefaultFile(PRePMain prepMain)
	{
		if ( isInList("default") )
		{

			if ( LOG )
			{
				System.out.println("default is in the list");
			}

			Hashtable hashFile = (Hashtable)hashSecurity.get(HASH_FILE);
			String strDefault = findValue(hashFile, "default");
			File fileDefault = new File(strDefault);
			prepMain.putFile(fileDefault);
		}
	}

	protected int getSecurity()
	{
		return iSecurity;
	}

	protected void setSecurity(int iSecurity)
	{
		System.out.println("The security status is changed - it may be caused because of a lack of the config file");
		this.iSecurity = iSecurity;
	}

	public void checkReload(PRePMain prepMain)
	{
		if ( LOG )
		{
			System.out.println("checkReload");
		}

		if ( prepMain.getValue("RELOAD") != null )
		{
			reload();
		}
	}

	public void setPrintWriter(PrintWriter pWriter, PRePMain prepMain)
	{
		if ( LOG )
		{
			System.out.println("setPrintWriter");
		}

		prepMain.setWriter(pWriter);
	}

	protected void reload()
	{
		if ( LOG )
		{
			System.out.println("reloading...");
		}

		createSecurityHashtable();
	}

	public boolean checkCookie(PRePMain prepMain)
	{
		if ( LOG )
		{
			System.out.println("checkCookie");
		}
		return true;
	}

	public Object[] getNewCookies(PRePMain prepMain)
	{
		if ( LOG )
		{
			System.out.println("getNewCookies");
		}

		return null;
	}

	public void loginOk(PRePMain prepMain)
	{
		if ( LOG )
		{
			System.out.println("loginOk");
		}

		String strFileName = prepMain.getValue("FILE");

		if ( strFileName != null )
		{

			if ( LOG )
			{
				System.out.println("FILE: "+prepMain.getValue("FILE"));
			}

			putFile(prepMain, new File(strFileName));
		}
		else if ( iSecurity > 0 )
		{
//	    strFileName = getDefaultDocument();
			putFile(prepMain, new File("default"));
		}
	}

	public void loginNotOk(PRePMain prepMain)
	{
		if ( LOG )
		{
			System.out.println("loginNotOk");   
		}
	}

	public void finishHandle(PRePMain prepMain)
	{
		if ( LOG )
		{
			System.out.println("finishHandle");
		}

		//don't forget prepMain.output();   
		if ( connectionPool != null )
		{
			prepMain.getSession().put(ConnectionPool.SESSION_NAME, connectionPool);
		}
		prepMain.output();
		finishRest(prepMain);
		prepMain = null;
	}

	protected void finishRest(PRePMain prepMain)
	{
		prepMain.destroy();
	}

	public void destroy()
	{
		if ( LOG )
		{
			System.out.println("destroy");
		}

		if ( connectionPool != null )
		{
			connectionPool.destroy();
		}
	}
}
