/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui;

import java.util.EventListener;

/**
 * WindowMessageListener interface.
 *
 * @author Serge Piletsky
 */
public interface WindowMessageListener extends EventListener
{
    /**
     * Tests if listener can handle specified message.
     * @param message
     * @param beforeWindowProc flag specifies that event occured before or after window procedure
     * @return true if message can be processed; otherwise false.
     */
    public boolean canHandle(WindowMessage message, boolean beforeWindowProc);

    /**
     * Handles window message.
     * @param message
     * @return result of message processing
     */
    public int handle(WindowMessage message);
}
