/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.ui;

import java.awt.*;

/**
 * Class AWTWindowDecorator provides ability to change native attributes of AWT or Swing
 * window.
 *
 * In order to decorate window that contains Swing components add
 * option  -Dsun.java2d.noddraw=True to VM parameters.
 *
 * @author Serge Piletsky
 */
public class AWTWindowDecorator extends WindowDecorator
{
    private Window _window;

    public AWTWindowDecorator()
    {
        String value = System.getProperty("sun.java2d.noddraw");
        if (value == null || value.length() == 0)
            throw new IllegalStateException("System property sun.java2d.noddraw required");
    }

    public AWTWindowDecorator(Window component)
    {
        this();
        setWindow(component);
    }

    public Window getWindow()
    {
        return _window;
    }

    /**
     *  Call this function only when window is visible.
     *
     * @param window
     */
    public void setWindow(Window window)
    {
        if (window == null)
            throw new IllegalArgumentException();

        _window = window;
        Wnd hWnd = new Wnd(WindowTools.getWindowHandle(window));
        setWindowHandle(hWnd);
    }

    public void setTransparent(boolean transparent)
    {
        super.setTransparent(transparent);
        forceWindowRepaint();
    }

    private void forceWindowRepaint()
    {
        Dimension size = getWindow().getSize();
        getWindow().setSize(0, 0);
        getWindow().setSize(size);
    }
}
