/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.shell;

import com.jniwrapper.*;
import com.jniwrapper.win32.Kernel32;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.VersionInfo;

/**
 * This class represents NOTIFYICONDATA structure.
 *
 * Note: In previous version of WinPack there were two implementations of this structure (NotifyData and NotifyDataExt)
 * for different API versions; now they are merged into one structure that represents this class.
 *
 * @author AKireyev
 * @author Serge Piletsky
 */
class NotifyIconData extends Structure
{
    private UInt32 _cbSize = new UInt32();
    private Pointer.Void _hWnd = new Pointer.Void();
    private UInt32 _uID = new UInt32();
    private UInt32 _uFlags = new UInt32();
    private UInt32 _uCallbackMessage = new UInt32();
    private Icon _hIcon = new Icon();
    private ZeroTerminatedString _szTip;
    private UInt32 _dwState = new UInt32();
    private UInt32 _dwStateMask = new UInt32();
    private ZeroTerminatedString _szInfo;
    private UInt32 _uTimeout = new UInt32();
    private ZeroTerminatedString _szInfoTitle;
    private UInt32 _dwInfoFlags = new UInt32();

    public NotifyIconData(long hwnd, int id)
    {
        initStringParameters();
        VersionInfo versionInfo = new VersionInfo();
        if (versionInfo.isWin2k() | versionInfo.isWinMe())
            init(new Parameter[]{_cbSize, _hWnd, _uID, _uFlags, _uCallbackMessage, _hIcon, _szTip,
                                 _dwState, _dwStateMask, _szInfo, _uTimeout, _szInfoTitle, _dwInfoFlags});
        else
            init(new Parameter[]{_cbSize, _hWnd, _uID, _uFlags, _uCallbackMessage, _hIcon, _szTip});
        _cbSize.setValue(getLength());
        _hWnd.setValue(hwnd);
        _uID.setValue(id);
    }

    private void initStringParameters()
    {
        final Kernel32 kernel32 = Kernel32.getInstance();
        _szTip = kernel32.stringParam("", 128);
        _szInfo = kernel32.stringParam("", 256);
        _szInfoTitle = kernel32.stringParam("", 64);
    }

    public void setCallbackMessage(int callbackMessage)
    {
        _uCallbackMessage.setValue(callbackMessage);
    }

    public void setFlags(long flags)
    {
        _uFlags.setValue(flags);
    }

    public void setIcon(Icon icon)
    {
        _hIcon.setValue(icon.getValue());
    }

    public void setToolTip(String tip)
    {
        _szTip.setValue(tip);
    }

    public void setState(long value)
    {
        _dwState.setValue(value);
    }

    public void setStateMask(long value)
    {
        _dwStateMask.setValue(value);
    }

    public void setInfo(String value)
    {
        _szInfo.setValue(value);
    }

    public void setTimeout(long value)
    {
        _uTimeout.setValue(value);
    }

    public void setInfoTitle(String value)
    {
        _szInfoTitle.setValue(value);
    }

    public void setInfoFlags(long value)
    {
        _dwInfoFlags.setValue(value);
    }
}
