/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.io;

/**
 *
 * @author Serge Piletsky
 */
public abstract class WatcherStrategy
{
    private FileSystemWatcher _fileSystemWatcher;
    private boolean _watching = false;

    public WatcherStrategy(FileSystemWatcher fileSystemWatcher)
    {
        _fileSystemWatcher = fileSystemWatcher;
    }

    public FileSystemWatcher getFileSystemWatcher()
    {
        return _fileSystemWatcher;
    }

    protected boolean isWatching()
    {
        return _watching;
    }

    protected void setWatching(boolean value)
    {
        _watching = value;
    }

    public abstract void start() throws FileSystemException;
    public abstract void stop() throws FileSystemException;
}
