/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.io;

import java.io.File;

/**
 * Class ExtFile is extension of the standatd {@link File}
 * implementation and adds several useful functions.
 *
 * @author Serge Piletsky
 *
 * @deprecated Will be removed in the next version. Use FileSystem functionaliry instead
 */
public class ExtFile extends File
{
    public ExtFile(String pathname)
    {
        super(pathname);
    }

    public ExtFile(String parent, String child)
    {
        super(parent, child);
    }

    public ExtFile(File parent, String child)
    {
        super(parent, child);
    }

    /**
     * @return free disk space in bytes
     */
    public long getFreeDiskSpace()
    {
        return FileSystem.getDiskFreeSpace(getAbsolutePath());
    }

    /**
     * @return attributes of a file
     */
    public long getAttributes()
    {
        final FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(getAbsolutePath());
        return fileAttributes.getFlags();
    }

    /**
     * @param attributes
     */
    public void setAttributes(long attributes)
    {
        SecurityManager security = System.getSecurityManager();
        if (security != null)
            security.checkWrite(getAbsolutePath());
        FileSystem.setFileAttributes(this, new FileSystem.FileAttributes(attributes));
    }

    /**
     * Adds specified file attribute
     * @param attribute
     */
    public void addAttribute(int attribute)
    {
        setAttributes(getAttributes() | attribute);
    }

    /**
     * Removes specifies file attribute
     * @param attribute
     */
    public void removeAttribute(int attribute)
    {
        setAttributes(getAttributes() & ~attribute);
    }

    /**
     * Checks if file has specified attribute
     * @param attribute
     * @return true if specified attribute present
     */
    public boolean hasAttribute(int attribute)
    {
        long attributes = getAttributes();
        return (attributes & attribute) == attribute;
    }

    /**
     * Default File implementation just allows to set read only file attribute but not to check.
     * @return true if file has readonly attribute
     */
    public boolean isReadOnly()
    {
        final FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(getAbsolutePath());
        return fileAttributes.isReadOnly();
    }

    /**
     * Checks if file has Archive attribute
     * @return
     */
    public boolean isArchive()
    {
        final FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(getAbsolutePath());
        return fileAttributes.isArchive();
    }

    /**
     * Checks if file has System attribute
     * @return
     */
    public boolean isSystem()
    {
        final FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(getAbsolutePath());
        return fileAttributes.isSystem();
    }

    public boolean isNormal()
    {
        final FileSystem.FileAttributes fileAttributes = FileSystem.getFileAttributes(getAbsolutePath());
        return fileAttributes.contains(FileSystem.FileAttributes.NORMAL);
    }

    /**
     * Returns drive type. Possible file types specified in DriveTypes interface
     * @return
     */
    public int getDriveType()
    {
        int driveType = FileSystem.getDriveType(this).getValue();
        return driveType;
    }

    /**
     * Checks if specified drive is CD-ROM
     * @return
     */
    public boolean isCDROM()
    {
        return FileSystem.getDriveType(this).equals(FileSystem.DriveType.CDROM);
    }

    /**
     * Checks if specified drive if RAM Disk
     * @return
     */
    public boolean isRAMDisk()
    {
        return FileSystem.getDriveType(this).equals(FileSystem.DriveType.RAMDISK);
    }

    /**
     * Checks if specified drive if Removable Disk
     * @return
     */
    public boolean isRemovableDisk()
    {
        return FileSystem.getDriveType(this).equals(FileSystem.DriveType.REMOVABLE);
    }

    /**
     * Checks if specified drive is Remove Disk
     * @return
     */
    public boolean isRemoteDisk()
    {
        return FileSystem.getDriveType(this).equals(FileSystem.DriveType.REMOTE);
    }

    /**
     * Checks if specified drive is Fixed Disk
     * @return
     */
    public boolean isFixedDisk()
    {
        return FileSystem.getDriveType(this).equals(FileSystem.DriveType.FIXED);
    }
}
