/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples.demo;

import com.jniwrapper.win32.gdi.Region;
import com.jniwrapper.win32.ui.WindowTools;
import com.jniwrapper.win32.ui.Wnd;

import javax.swing.*;
import java.awt.*;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

/**
 * @author Serge Piletsky
 */
class CustomShapeWindow extends JWindow implements MouseMotionListener
{
    private JLabel _imageLabel = new JLabel();
    private int _mouseX = 0, _mouseY = 0;
    private Region _windowShape;
    private ImageIcon _image;

    public CustomShapeWindow(Window owner)
    {
        super(owner);
        init();
    }

    private void init()
    {
        getContentPane().add(_imageLabel);
        addMouseMotionListener(this);
        addWindowListener(new WindowAdapter()
        {
            public void windowOpened(WindowEvent e)
            {
                applyWindowRegion();
            }
        });
    }

    private void applyWindowRegion()
    {
        Wnd wnd = new Wnd(WindowTools.getWindowHandle(CustomShapeWindow.this));
        wnd.setWindowRegion(getWindowShape());
    }

    public void setWindowShape(Region value)
    {
        _windowShape = value;
        _imageLabel.setIcon(_image);
        setSize(_image.getIconWidth(), _image.getIconHeight());
        validate();
        applyWindowRegion();
    }

    public Region getWindowShape()
    {
        if (_windowShape == null)
            throw new IllegalStateException("Custom shape is not assigned.");
        return _windowShape;
    }

    public ImageIcon getImage()
    {
        return _image;
    }

    public void setImage(ImageIcon image)
    {
        _image = image;
    }

    public void mouseMoved(MouseEvent e)
    {
        _mouseX = e.getX();
        _mouseY = e.getY();
    }

    public void mouseDragged(MouseEvent e)
    {
        final int x = e.getX();
        final int y = e.getY();
        int dx = x - _mouseX;
        int dy = y - _mouseY;
        setLocation(getX() + dx, getY() + dy);
    }
}
