/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.ui.AWTWindowDecorator;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;

/**
 * This samples demonstrates how to decorate a Swing frame containing components
 * using {@link com.jniwrapper.win32.ui.AWTWindowDecorator}
 *
 * @author Serge Piletsky
 */
public class WindowDecoratorDemo extends JFrame
{
    static
    {
        DefaultLibraryLoader.getInstance().addPath("bin");
    }

    private JLabel lblMessage;
    private JCheckBox chkTransparent;
    private JButton btnClose;
    private AWTWindowDecorator _decorator = new AWTWindowDecorator();
    private JCheckBox chkTopmost;
    private JCheckBox chkPalette;
    private JCheckBox chkRounded;
    private JButton btnShowCustomShapeWindow;
    private JSlider _slider;

    public WindowDecoratorDemo()
    {
        setTitle("Window Decorator Demo");

        Container contentPane = getContentPane();
        contentPane.setLayout(new GridBagLayout());

        lblMessage = new JLabel("This window demonstrates different window decorator features.");
        contentPane.add(lblMessage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0,
                  GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(10, 60, 10, 10), 0, 0));

        chkTransparent = new JCheckBox("Transparent", false);
        chkTransparent.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                final boolean transparent = chkTransparent.isSelected();
                final byte transparency = (byte)_slider.getValue();

                _decorator.setTransparent(transparent);
                _decorator.setTransparency(transparency);
            }
        });
        contentPane.add(chkTransparent, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 60, 10, 10), 0, 0));

        _slider = new JSlider(JSlider.HORIZONTAL);
        _slider.setMinimum(AWTWindowDecorator.TRANSPARENT);
        _slider.setMaximum(AWTWindowDecorator.OPAQUE);
        _slider.setValue(AWTWindowDecorator.OPAQUE);
        Hashtable labelTable = new Hashtable();
        labelTable.put(new Integer(AWTWindowDecorator.TRANSPARENT), new JLabel("Transparent"));
        labelTable.put(new Integer(AWTWindowDecorator.OPAQUE), new JLabel("Opaque"));
        _slider.setLabelTable( labelTable );
        _slider.setMajorTickSpacing(10);
        _slider.setPaintTicks(true);
        _slider.setPaintLabels(true);
        _slider.addChangeListener(new ChangeListener()
        {
            public void stateChanged(ChangeEvent e)
            {
                JSlider source = (JSlider)e.getSource();
                if (_decorator.isTransparent() & !source.getValueIsAdjusting())
                {
                    byte transparency = (byte)source.getValue();
                    _decorator.setTransparency(transparency);
                }
            }
        });
        contentPane.add(_slider, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 0, 10, 10), 0, 0));

        chkTopmost = new JCheckBox("Topmost", false);
        chkTopmost.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                _decorator.setTopmost(chkTopmost.isSelected());
            }
        });
        contentPane.add(chkTopmost, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 60, 10, 10), 0, 0));

        chkPalette = new JCheckBox("Palette Style", false);
        chkPalette.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                _decorator.setPalleteWindow(chkPalette.isSelected());
            }
        });
        contentPane.add(chkPalette, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 60, 10, 10), 0, 0));

        chkRounded = new JCheckBox("Rounded Corners", false);
        chkRounded.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                _decorator.setRounded(chkRounded.isSelected());
            }
        });
        contentPane.add(chkRounded, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 60, 10, 10), 0, 0));

        btnShowCustomShapeWindow = new JButton("Show Custom Window");
        btnShowCustomShapeWindow.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
            }
        });
        contentPane.add(btnShowCustomShapeWindow, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0,
                  GridBagConstraints.WEST, GridBagConstraints.NONE, new Insets(10, 60, 10, 10), 0, 0));

        btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                System.exit(0);
            }
        });
        contentPane.add(btnClose, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0,
                  GridBagConstraints.EAST, GridBagConstraints.NONE, new Insets(10, 10, 10, 10), 0, 0));

        this.addWindowListener(new WindowAdapter()
        {
            public void windowOpened(WindowEvent e)
            {
                _decorator.setWindow(WindowDecoratorDemo.this);

                Icon smallIcon = new Icon();
                smallIcon.loadFromFile("jniwrapper.ico");
                Icon bigIcon = new Icon(Icon.ICON_BIG);
                bigIcon.loadFromFile("jniwrapper.ico");
                _decorator.setWindowIcon(smallIcon);
                _decorator.setWindowIcon(bigIcon);
            }
        });
        this.pack();
    }

    public void setVisible(boolean b)
    {
        super.setVisible(b);
        if (!b)
        {
            System.exit(0);
        }
    }

    public static void main(String[] arguments)
    {
        WindowDecoratorDemo window = new WindowDecoratorDemo();
        window.setVisible(true);
    }
}
