/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.Rect;
import com.jniwrapper.win32.gdi.Brush;
import com.jniwrapper.win32.gdi.DC;
import com.jniwrapper.win32.system.Module;
import com.jniwrapper.win32.VersionInfo;
import com.jniwrapper.win32.ui.*;

/**
 * This samples demonstrates how to decorate native window
 * using {@link com.jniwrapper.win32.ui.WindowDecorator}.
 *
 * @author Serge Piletsky
 */
public class TransparentNativeWindow
{
    static private WndClass _wndClass;

    private Wnd _hWnd;

    static
    {
        DefaultLibraryLoader.getInstance().addPath("bin");
        String windowClassName = TransparentNativeWindow.class.getName();
        _wndClass = new WndClass(new TransparentWindowProc(), windowClassName);
        _wndClass.setBackground(new Brush(Brush.BrushStyle.NULL));
        _wndClass.register();
    }

    public TransparentNativeWindow()
    {
        VersionInfo versionInfo = new VersionInfo();
        int extStyle = Wnd.WS_OVERLAPPEDWINDOW;
        String caption = "Transparent Window";
        if (versionInfo.isWin9x())
        {
            extStyle = 0;
            caption = "Window";
        }
        Module hModule = Module.getCurrent();
        Wnd nullParent = new Wnd();
        Handle NULL = new Handle();
        _hWnd = Wnd.createWindow(
                Wnd.WS_EX_OVERLAPPEDWINDOW | Wnd.WS_EX_TOPMOST,
                this.getClass().getName(),
                caption,
                extStyle,
                10,
                10,
                400,
                200,
                nullParent,
                NULL,
                hModule,
                NULL);

    }

    public void run()
    {
        _hWnd.show(Wnd.SW_SHOW);
        WindowDecorator decorator = new WindowDecorator(_hWnd);
        decorator.setTransparency((byte)150);
        decorator.setPalleteWindow(true);
        _hWnd.eventLoop();
    }

    public static void main(String[] args)
    {
        TransparentNativeWindow window = new TransparentNativeWindow();
        window.run();
    }

    private static class TransparentWindowProc extends WindowProc
    {
        public void callback()
        {
            int message = (int)_msg.getValue();
            switch (message)
            {
                case Msg.WM_PAINT:
                {
                    Rect updateRect = new Rect();
                    if (_wnd.getUpdateRect(updateRect))
                    {
                        PaintStruct paintStruct = new PaintStruct();
                        DC hDC = _wnd.beginPaint(paintStruct);
                        hDC.textOut(10, 10, "This sample demonstrates native window");
                        hDC.textOut(10, 30, "created with topmost style and decorated");
                        hDC.textOut(10, 50, "with WindowDecorator by adding transparency");
                        hDC.textOut(10, 70, "and applying tool window style.");
                        _wnd.endPaint(paintStruct);
                        _lResult.setValue(0);
                    }
                    break;
                }
                default:
                {
                    super.callback();
                    break;
                }
            }
        }
    }
}
