/*  
 * Copyright (c) 2002-2003 MIIK Ltd. All rights reserved.  
 *  
 * Use is subject to license terms.  
 *   
 * The complete licence text can be found at   
 * http://www.jniwrapper.com/license.jsp?prod=winpack  
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.shell.TrayIcon;
import com.jniwrapper.win32.shell.TrayIconListener;
import com.jniwrapper.win32.shell.TrayMessage;
import com.jniwrapper.win32.ui.AWTWindowDecorator;
import com.jniwrapper.win32.ui.Msg;
import com.jniwrapper.win32.ui.Wnd;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

/**
 * This class demonstrates TrayIcon class features.
 *
 * @author Alexander Kireyev
 */
public class SampleTrayApp
{
    static
    {
        DefaultLibraryLoader.getInstance().addPath(new File("bin"));
    }

    private static Window _invoker;
    private static TrayIcon _trayIcon;
    private static PopupMenu _popupMenu;
    private static final String MENU_ITEM_SHOW_STANDARD_ICON = "Show Stadard System Icon";
    private static final String MENU_ITEM_SHOW_CUSTOM_ICON = "Show Custom Icon";
    private static final String MENU_ITEM_SHOW_CALLOUT = "Show Tray Balloon";
    private static final String MENU_ITEM_HIDE_ICON = "Hide Tray Icon (hides tray icon for a second)";
    private static final String MENU_ITEM_EXIT = "Exit";

    public static void main(String[] args)
    {
        new Frame();
        _trayIcon = new TrayIcon(Icon.SystemIcon.BANG.getIcon());
        _trayIcon.setToolTip("Tray Tooltip");
        _trayIcon.addTrayListener(new TrayIconListener()
        {
            public void trayActionPerformed(long message, int x, int y)
            {
                if (message == Msg.WM_RBUTTONUP)
                {
                    showPopup(x, y);
                }
                else if (message == Msg.WM_LBUTTONDBLCLK)
                {
                    _trayIcon.setIcon(Icon.SystemIcon.HAND.getIcon());
                }
                else if (message == Msg.WM_MOUSELEAVE)
                {
                    System.out.println("Mouse leave event");
                }
                else if (message == Msg.WM_MOUSEHOVER)
                {
                    System.out.println("Mouse hover event");
                }
             }
        });

        _popupMenu = new PopupMenu("My Menu");
        _popupMenu.add(MENU_ITEM_SHOW_STANDARD_ICON);
        _popupMenu.add(MENU_ITEM_SHOW_CUSTOM_ICON);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_ITEM_SHOW_CALLOUT);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_ITEM_HIDE_ICON);
        _popupMenu.addSeparator();
        _popupMenu.add(MENU_ITEM_EXIT);
        _popupMenu.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                if (e.getActionCommand().equals(MENU_ITEM_SHOW_STANDARD_ICON))
                {
                    changeIconToQuestion();
                }
                if (e.getActionCommand().equals(MENU_ITEM_SHOW_CUSTOM_ICON))
                {
                    changeIconToCustom();
                }
                if (e.getActionCommand().equals(MENU_ITEM_SHOW_CALLOUT))
                {
                    showCallout();
                }
                if (e.getActionCommand().equals(MENU_ITEM_HIDE_ICON))
                {
                    _trayIcon.setVisible(false);
                    try
                    {
                        Thread.sleep(1000);
                    }
                    catch (InterruptedException e1)
                    {
                        e1.printStackTrace();
                    }
                    _trayIcon.setVisible(true);
                }
                if (e.getActionCommand().equals(MENU_ITEM_EXIT))
                {
                    removeIcon();
                    System.exit(0);
                }
            }
        });
        getInvokerWindow(); // force to create frame
    }

    private static void showPopup(final int x, final int y)
    {
        Component invoker = getInvokerWindow();
        _popupMenu.show(invoker, x, y);
    }

    private static Component getInvokerWindow()
    {
        if (_invoker == null)
        {
            _invoker = new JWindow();
            _invoker.setLocation(0, 0);
            _invoker.setVisible(true);
            _invoker.add(_popupMenu);
            AWTWindowDecorator windowDecorator = new AWTWindowDecorator(_invoker);
            long windowStyle = windowDecorator.getWindowStyle();
            windowStyle &= ~Wnd.WS_VISIBLE;
            windowDecorator.setWindowStyle(windowStyle);
        }
        return _invoker;
    }

    private static void changeIconToQuestion()
    {
        _trayIcon.setIcon(Icon.SystemIcon.QUES.getIcon());
    }

    private static void changeIconToCustom()
    {
        Icon customIcon = new Icon();
        customIcon.loadFromFile("jniwrapper.ico");
        _trayIcon.setIcon(customIcon);
    }

    private static void showCallout()
    {
        _trayIcon.showMessage(new TrayMessage.Warning("Tray Balloon",
                "This program demonstrates the WinPack for JNIWrapper library abilities:\n" +
                "\t - tray icon\n" +
                "\t - menu for tray icon\n" +
                "\t - balloons from tray icon\n" +
                "etc."));
    }

    private static void removeIcon()
    {
        _trayIcon.dispose();
    }
}
