/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.util;

import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt16;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.FunctionCache;

public class ProcessorInfo
extends FunctionCache {
    static final String FUNCTION_CALL_CPUID = "_callCPUID@20";
    static final String FUNCTION_GET_CPU_FREQUENCY = "_retrieveProcessorFrequency@0";
    private static ProcessorInfo _instance;
    private int _maxCPUID;
    private long _frequency;
    private int _family;
    private int _model;
    private int _stepping;
    private int _type;
    private int _familyExt;
    private int _modelExt;
    private int _steppingExt;
    private boolean _fpu;
    private boolean _mmx;
    private boolean _mmxPlus;
    private boolean _3dnow;
    private boolean _3dnowPlus;
    private boolean _sse;
    private boolean _sse2;
    private String _vendor;
    private String _processorName;
    private int _maxExtendedFunctions;
    private int _id;

    private ProcessorInfo() {
        super("jniwrap");
    }

    private void readExtendedProcessorName(UInt32 uInt32, UInt32 uInt322, UInt32 uInt323, UInt32 uInt324, UInt16 uInt16) {
        StringBuffer stringBuffer = new StringBuffer();
        uInt32.setValue(-2147483646L);
        uInt322.setValue(0L);
        uInt323.setValue(0L);
        uInt324.setValue(0L);
        ProcessorInfo.callCPUID(uInt32, uInt322, uInt323, uInt324, uInt16);
        ProcessorInfo.readChars(uInt32.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt322.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt323.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt324.getValue(), stringBuffer);
        uInt32.setValue(-2147483645L);
        uInt322.setValue(0L);
        uInt323.setValue(0L);
        uInt324.setValue(0L);
        ProcessorInfo.callCPUID(uInt32, uInt322, uInt323, uInt324, uInt16);
        ProcessorInfo.readChars(uInt32.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt322.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt323.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt324.getValue(), stringBuffer);
        uInt32.setValue(-2147483644L);
        uInt322.setValue(0L);
        uInt323.setValue(0L);
        uInt324.setValue(0L);
        ProcessorInfo.callCPUID(uInt32, uInt322, uInt323, uInt324, uInt16);
        ProcessorInfo.readChars(uInt32.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt322.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt323.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt324.getValue(), stringBuffer);
        this._processorName = stringBuffer.toString().trim();
    }

    public static ProcessorInfo getInstance() {
        if (_instance == null) {
            _instance = new ProcessorInfo();
            ProcessorInfo.readProcessorInformation();
        }
        return _instance;
    }

    private static void readProcessorInformation() {
        UInt32 uInt32 = new UInt32();
        UInt32 uInt322 = new UInt32();
        UInt32 uInt323 = new UInt32();
        UInt32 uInt324 = new UInt32();
        UInt16 uInt16 = new UInt16();
        ProcessorInfo._instance._frequency = ProcessorInfo.getCPUFrequency();
        ProcessorInfo.callCPUID(uInt32, uInt322, uInt323, uInt324, uInt16);
        ProcessorInfo._instance._maxCPUID = (int)uInt32.getValue();
        StringBuffer stringBuffer = new StringBuffer();
        ProcessorInfo.readChars(uInt322.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt324.getValue(), stringBuffer);
        ProcessorInfo.readChars(uInt323.getValue(), stringBuffer);
        ProcessorInfo._instance._vendor = stringBuffer.toString();
        uInt32.setValue(Integer.MIN_VALUE);
        uInt322.setValue(0L);
        uInt323.setValue(0L);
        uInt324.setValue(0L);
        ProcessorInfo.callCPUID(uInt32, uInt322, uInt323, uInt324, uInt16);
        long l2 = uInt32.getValue();
        ProcessorInfo._instance._maxExtendedFunctions = (int)l2;
        uInt32.setValue(1L);
        uInt322.setValue(0L);
        uInt323.setValue(0L);
        uInt324.setValue(0L);
        ProcessorInfo.callCPUID(uInt32, uInt322, uInt323, uInt324, uInt16);
        l2 = uInt324.getValue();
        ProcessorInfo._instance._fpu = (l2 & 1L) != 0L;
        ProcessorInfo._instance._mmx = (l2 & 0x800000L) != 0L;
        ProcessorInfo._instance._sse = (l2 & 0x2000000L) != 0L;
        ProcessorInfo._instance._sse2 = (l2 & 0x4000000L) != 0L;
        l2 = uInt32.getValue();
        ProcessorInfo._instance._family = (int)(l2 & 0xF00L) >> 8;
        ProcessorInfo._instance._model = (int)(l2 & 0xF0L) >> 4;
        ProcessorInfo._instance._stepping = (int)(l2 & 0xFL);
        ProcessorInfo._instance._type = (int)(l2 & 0xF000L) >> 12;
        uInt32.setValue(-2147483647L);
        uInt322.setValue(0L);
        uInt323.setValue(0L);
        uInt324.setValue(0L);
        ProcessorInfo.callCPUID(uInt32, uInt322, uInt323, uInt324, uInt16);
        l2 = uInt324.getValue();
        ProcessorInfo._instance._mmxPlus = (l2 & 0x400000L) != 0L;
        ProcessorInfo._instance._3dnow = (l2 & Integer.MIN_VALUE) != 0L;
        ProcessorInfo._instance._3dnowPlus = (l2 & 0x40000000L) != 0L;
        ProcessorInfo._instance._id = (int)uInt16.getValue();
        l2 = uInt32.getValue();
        ProcessorInfo._instance._familyExt = (int)(l2 & 0xF00L) >> 8;
        ProcessorInfo._instance._modelExt = (int)(l2 & 0xF0L) >> 4;
        ProcessorInfo._instance._steppingExt = (int)(l2 & 0xFL);
        if (ProcessorInfo._instance._vendor.equals("AuthenticAMD")) {
            switch (ProcessorInfo._instance._family) {
                case 4: {
                    ProcessorInfo._instance._processorName = "AMD 486";
                    break;
                }
                case 5: {
                    if (ProcessorInfo._instance._maxExtendedFunctions > 4) {
                        _instance.readExtendedProcessorName(uInt32, uInt322, uInt323, uInt324, uInt16);
                        ProcessorInfo._instance._family = ProcessorInfo._instance._familyExt;
                        ProcessorInfo._instance._model = ProcessorInfo._instance._modelExt;
                        ProcessorInfo._instance._stepping = ProcessorInfo._instance._steppingExt;
                        break;
                    }
                    if (ProcessorInfo._instance._model == 0) {
                        ProcessorInfo._instance._processorName = "AMD K5";
                        break;
                    }
                    _instance.readExtendedProcessorName(uInt32, uInt322, uInt323, uInt324, uInt16);
                    break;
                }
                default: {
                    _instance.readExtendedProcessorName(uInt32, uInt322, uInt323, uInt324, uInt16);
                    ProcessorInfo._instance._family = ProcessorInfo._instance._familyExt;
                    ProcessorInfo._instance._model = ProcessorInfo._instance._modelExt;
                    ProcessorInfo._instance._stepping = ProcessorInfo._instance._steppingExt;
                    break;
                }
            }
        } else if (ProcessorInfo._instance._vendor.equals("GenuineIntel")) {
            switch (ProcessorInfo._instance._family) {
                case 4: {
                    ProcessorInfo._instance._processorName = "Intel 486";
                    break;
                }
                case 5: {
                    if (ProcessorInfo._instance._mmx) {
                        ProcessorInfo._instance._processorName = "Intel Pentium(r) MMX(tm)";
                        break;
                    }
                    ProcessorInfo._instance._processorName = "Intel Pentium(r)";
                    break;
                }
                case 6: {
                    if (ProcessorInfo._instance._id == 0) {
                        ProcessorInfo._instance._processorName = "Intel Celeron(r)";
                        break;
                    }
                    if (ProcessorInfo._instance._id == 3) {
                        ProcessorInfo._instance._processorName = "Intel Pentium(r) III";
                        break;
                    }
                    if (!ProcessorInfo._instance._mmx) {
                        ProcessorInfo._instance._processorName = "Intel Pentium(r) PRO";
                        break;
                    }
                    ProcessorInfo._instance._processorName = "Intel Pentium(r) II";
                    break;
                }
                default: {
                    _instance.readExtendedProcessorName(uInt32, uInt322, uInt323, uInt324, uInt16);
                    break;
                }
            }
        } else if (ProcessorInfo._instance._vendor.equals("CyrixInstead")) {
            switch (ProcessorInfo._instance._family) {
                case 4: {
                    ProcessorInfo._instance._processorName = "VIA Cyrix 4x86";
                    break;
                }
                case 5: {
                    ProcessorInfo._instance._processorName = "VIA Cyrix 5x86";
                    break;
                }
                default: {
                    if (ProcessorInfo._instance._maxExtendedFunctions > 0) {
                        _instance.readExtendedProcessorName(uInt32, uInt322, uInt323, uInt324, uInt16);
                        ProcessorInfo._instance._family = ProcessorInfo._instance._familyExt;
                        ProcessorInfo._instance._model = ProcessorInfo._instance._modelExt;
                        ProcessorInfo._instance._stepping = ProcessorInfo._instance._steppingExt;
                        break;
                    }
                    if (ProcessorInfo._instance._mmx) {
                        ProcessorInfo._instance._processorName = "VIA Cyrix 6x86MII";
                        break;
                    }
                    ProcessorInfo._instance._processorName = "VIA Cyrix 6x86";
                    break;
                }
            }
        } else if (ProcessorInfo._instance._maxExtendedFunctions > 0) {
            _instance.readExtendedProcessorName(uInt32, uInt322, uInt323, uInt324, uInt16);
            ProcessorInfo._instance._family = ProcessorInfo._instance._familyExt;
            ProcessorInfo._instance._model = ProcessorInfo._instance._modelExt;
            ProcessorInfo._instance._stepping = ProcessorInfo._instance._steppingExt;
        } else {
            ProcessorInfo._instance._processorName = "Unknown CPU";
        }
    }

    private static void readChars(long l2, StringBuffer stringBuffer) {
        char c2 = (char)(l2 & 0xFFL);
        stringBuffer.append(c2);
        char c3 = (char)((l2 & 0xFF00L) >> 8);
        stringBuffer.append(c3);
        char c4 = (char)((l2 & 0xFF0000L) >> 16);
        stringBuffer.append(c4);
        char c5 = (char)((l2 & 0xFFFFFFFFFF000000L) >> 24);
        stringBuffer.append(c5);
    }

    private static void callCPUID(UInt32 uInt32, UInt32 uInt322, UInt32 uInt323, UInt32 uInt324, UInt16 uInt16) {
        Function function = ProcessorInfo.getInstance().getFunction(FUNCTION_CALL_CPUID);
        function.invoke(null, new Parameter[]{new Pointer(uInt32), new Pointer(uInt322), new Pointer(uInt323), new Pointer(uInt324), new Pointer(uInt16)});
    }

    private static long getCPUFrequency() {
        Function function = ProcessorInfo.getInstance().getFunction(FUNCTION_GET_CPU_FREQUENCY);
        UInt32 uInt32 = new UInt32();
        function.invoke(uInt32);
        return uInt32.getValue();
    }

    public long getFrequency() {
        return this._frequency;
    }

    public int getFamily() {
        return this._family;
    }

    public int getModel() {
        return this._model;
    }

    public int getStepping() {
        return this._stepping;
    }

    public int getType() {
        return this._type;
    }

    public boolean hasFPU() {
        return this._fpu;
    }

    public boolean hasMMX() {
        return this._mmx;
    }

    public boolean hasMMXPlus() {
        return this._mmxPlus;
    }

    public boolean has3DNow() {
        return this._3dnow;
    }

    public boolean has3DNowPlus() {
        return this._3dnowPlus;
    }

    public boolean hasSSE() {
        return this._sse;
    }

    public boolean hasSSE2() {
        return this._sse2;
    }

    public String getVendor() {
        return this._vendor;
    }

    public String getProcessorName() {
        return this._processorName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Processor info: [");
        stringBuffer.append("Vendor=").append(this._vendor).append("; Processor Name=").append(this._processorName).append("; Frequency=").append(this._frequency).append(" MHz").append("; FPU=").append(this._fpu).append("; MMX=").append(this._mmx).append("; MMXPlus=").append(this._mmxPlus).append("; SSE=").append(this._sse).append("; SSE2=").append(this._sse2).append("; 3DNow!=").append(this._3dnow).append("; 3DNow!Plus=").append(this._3dnowPlus).append("; Family=").append(this._family).append("; Model=").append(this._model).append("; Stepping=").append(this._stepping).append("]");
        return stringBuffer.toString();
    }

    static {
        FUNCTION_CALL_CPUID = FUNCTION_CALL_CPUID;
        FUNCTION_GET_CPU_FREQUENCY = FUNCTION_GET_CPU_FREQUENCY;
    }
}

