/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DataBuffer;
import com.jniwrapper.PlatformContext;
import com.jniwrapper.ZeroTerminatedString;

public class WideString
extends ZeroTerminatedString {
    private static final int WIDE_CHAR_LENGTH = PlatformContext.getWideCharLength();

    public WideString() {
        this(256);
    }

    public WideString(int n2) {
        this("", n2);
    }

    public WideString(String string) {
        this(WideString.wideStringToBytes(string));
    }

    public WideString(String string, int n2) {
        this(WideString.wideStringToBytes(string), n2 * WIDE_CHAR_LENGTH);
    }

    private WideString(byte[] byArray) {
        this(byArray, byArray.length + WIDE_CHAR_LENGTH);
    }

    private WideString(byte[] byArray, int n2) {
        super(byArray, n2, WIDE_CHAR_LENGTH);
    }

    public WideString(WideString wideString) {
        this(wideString.getValue(), wideString.getMaxLength());
    }

    protected String bytesToString(byte[] byArray) {
        char[] cArray = new char[this.getMaxLength()];
        int n2 = 0;
        while (n2 < this.getMaxLength()) {
            char c2 = '\u0000';
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.getCharLength()) {
                c2 = (char)(c2 | byArray[n2 * this.getCharLength() + n3] << n4);
                ++n3;
                n4 += 8;
            }
            if (c2 == '\u0000') break;
            cArray[n2] = c2;
            ++n2;
        }
        return new String(cArray, 0, n2);
    }

    protected byte[] stringToBytes(String string) {
        byte[] byArray = WideString.wideStringToBytes(string);
        return byArray;
    }

    private static byte[] wideStringToBytes(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * PlatformContext.getWideCharLength()];
        int n2 = 0;
        while (n2 < cArray.length) {
            int n3 = 255;
            int n4 = 0;
            int n5 = 0;
            while (n4 < PlatformContext.getWideCharLength()) {
                byArray[n2 * PlatformContext.getWideCharLength() + n4] = (byte)((long)cArray[n2] >> n5 & (long)n3);
                n3 = n3 << 8 | 0xFF;
                ++n4;
                n5 += 8;
            }
            ++n2;
        }
        return byArray;
    }

    public Object clone() {
        return new WideString(this);
    }

    protected int getStrLen(DataBuffer dataBuffer, int n2) {
        int n3 = n2;
        while (n3 < n2 + this.getLength()) {
            boolean bl = true;
            int n4 = n3;
            while (n4 < n3 + WIDE_CHAR_LENGTH) {
                if (dataBuffer.readByte(n4) != 0) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                return (n3 - n2) / WIDE_CHAR_LENGTH;
            }
            n3 += WIDE_CHAR_LENGTH;
        }
        return this.getLength() / WIDE_CHAR_LENGTH;
    }
}

