/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.Function;
import com.jniwrapper.LibraryLoader;
import com.jniwrapper.LibraryNotFoundException;
import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.f;
import com.jniwrapper.k;
import java.io.File;

public class Library {
    public static final String NATIVE_CODE = "jniwrap";
    private static boolean _nativeCodeLoaded;
    private String _name;
    private a _libraryResource;
    private static LibraryLoader _defaultLibraryLoader;

    public Library(String string) {
        this._name = string;
    }

    public static void loadNativeCode(LibraryLoader libraryLoader) throws SecurityException, UnsatisfiedLinkError {
        if (!_nativeCodeLoaded) {
            libraryLoader.loadLibrary(NATIVE_CODE);
            _nativeCodeLoaded = true;
        }
    }

    public static void loadNativeCode(String string) throws SecurityException, UnsatisfiedLinkError {
        if (!_nativeCodeLoaded) {
            System.load(string);
            _nativeCodeLoaded = true;
        }
    }

    public static void loadNativeCode() throws SecurityException, UnsatisfiedLinkError {
        Library.loadNativeCode(Library.getDefaultLibraryLoader());
    }

    public static void ensureNativeCode() {
        if (!_nativeCodeLoaded) {
            Library.loadNativeCode();
        }
    }

    public void load() throws LibraryNotFoundException {
        Library.ensureNativeCode();
        if (this.isLoaded()) {
            return;
        }
        File file = Library.getDefaultLibraryLoader().findLibrary(this._name);
        if (file == null) {
            throw new LibraryNotFoundException(this._name);
        }
        this.loadInternal(file.getAbsolutePath());
    }

    private void loadInternal(String string) throws LibraryNotFoundException {
        int n2 = Library.loadLibrary(string);
        this._libraryResource = new a(n2);
        f.if().a(this, this._libraryResource);
    }

    public void load(File file) throws LibraryNotFoundException {
        Library.ensureNativeCode();
        if (this.isLoaded()) {
            return;
        }
        File file2 = new File(file, this._name);
        this.loadInternal(file2.getAbsolutePath());
    }

    public void load(LibraryLoader libraryLoader) throws LibraryNotFoundException {
        Library.ensureNativeCode();
        if (this.isLoaded()) {
            return;
        }
        File file = libraryLoader.findLibrary(this._name);
        if (file == null) {
            throw new LibraryNotFoundException(this._name);
        }
        this.loadInternal(file.getAbsolutePath());
    }

    protected void unload() {
        this._libraryResource.new();
    }

    public boolean isLoaded() {
        if (this._libraryResource != null) {
            return this._libraryResource.int();
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    int getID() {
        return this._libraryResource.try();
    }

    public Function getFunction(String string, Class[] classArray) throws NoSuchFunctionException, LibraryNotFoundException {
        if (!this.isLoaded()) {
            this.load();
        }
        return new Function(this, string);
    }

    public Function getFunction(String string) throws NoSuchFunctionException, LibraryNotFoundException {
        return this.getFunction(string, null);
    }

    public static LibraryLoader getDefaultLibraryLoader() {
        if (_defaultLibraryLoader == null) {
            _defaultLibraryLoader = DefaultLibraryLoader.getInstance();
        }
        return _defaultLibraryLoader;
    }

    public static void setDefaultLibraryLoader(LibraryLoader libraryLoader) {
        _defaultLibraryLoader = libraryLoader;
    }

    private static native int loadLibrary(String var0) throws LibraryNotFoundException;

    private static native void freeLibrary(int var0);

    static {
        NATIVE_CODE = NATIVE_CODE;
        _nativeCodeLoaded = false;
        _defaultLibraryLoader = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class a
    implements k {
        private boolean _loaded;
        private int _libID;

        public a(int n2) {
            this._libID = n2;
            this._loaded = true;
        }

        public boolean int() {
            return this._loaded;
        }

        public int try() {
            return this._libID;
        }

        public void new() {
            if (this._loaded) {
                Library.freeLibrary(this._libID);
            }
            this._loaded = false;
        }

        public void a() throws Throwable {
            this.new();
        }
    }
}

