/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper;

import com.jniwrapper.LibraryLoader;
import com.jniwrapper.l;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;

public class DefaultLibraryLoader
implements LibraryLoader {
    private static final String PROPERTY_JAVA_LIBRARY_PATH = "java.library.path";
    private static DefaultLibraryLoader _instance;
    private l _fileFinder;
    private static String _libExtension;

    private DefaultLibraryLoader() {
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty(DefaultLibraryLoader.PROPERTY_JAVA_LIBRARY_PATH);
                return new l(string);
            }
        };
        this._fileFinder = (l)AccessController.doPrivileged(privilegedAction);
    }

    public static DefaultLibraryLoader getInstance() {
        if (_instance == null) {
            _instance = new DefaultLibraryLoader();
        }
        return _instance;
    }

    public void addPath(File file) {
        this._fileFinder.a(file);
    }

    public void addPath(List list) {
        this._fileFinder.a(list);
    }

    public void addPath(String string) {
        this._fileFinder.a(string);
    }

    public File findLibrary(String string) {
        String string2 = string;
        if (!new File(string).isAbsolute()) {
            string2 = DefaultLibraryLoader.mapLibraryName(string);
        }
        final String string3 = string2;
        PrivilegedAction privilegedAction = new PrivilegedAction(){

            public Object run() {
                return DefaultLibraryLoader.this._fileFinder.do(string3);
            }
        };
        return (File)AccessController.doPrivileged(privilegedAction);
    }

    public void loadLibrary(final String string) {
        File file = this.findLibrary(string);
        if (file == null) {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary(string);
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        } else {
            System.load(file.getAbsolutePath());
        }
    }

    l getFileFinder() {
        return this._fileFinder;
    }

    public static String mapLibraryName(String string) {
        if (string.endsWith(DefaultLibraryLoader.getLibraryExtension())) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    public static String getLibraryExtension() {
        if (_libExtension == null) {
            String string = "FooLibraryName";
            String string2 = System.mapLibraryName("FooLibraryName");
            int n2 = string2.indexOf("FooLibraryName");
            _libExtension = n2 == -1 ? "" : string2.substring(n2 + "FooLibraryName".length());
        }
        return _libExtension;
    }

    static {
        PROPERTY_JAVA_LIBRARY_PATH = PROPERTY_JAVA_LIBRARY_PATH;
        _instance = null;
        _libExtension = null;
    }
}

