/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.gdi.Icon;
import com.jniwrapper.win32.ui.AWTWindowDecorator;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WindowDecoratorDemo
extends JFrame {
    private JLabel lblMessage;
    private JCheckBox chkTransparent;
    private JButton btnClose;
    private AWTWindowDecorator _decorator = new AWTWindowDecorator();
    private JCheckBox chkTopmost;
    private JCheckBox chkPalette;
    private JCheckBox chkRounded;
    private JButton btnShowCustomShapeWindow;
    private JSlider _slider;

    public WindowDecoratorDemo() {
        this.setTitle("Window Decorator Demo");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.lblMessage = new JLabel("This window demonstrates different window decorator features.");
        contentPane.add((Component)this.lblMessage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 60, 10, 10), 0, 0));
        this.chkTransparent = new JCheckBox("Transparent", false);
        this.chkTransparent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean transparent = WindowDecoratorDemo.this.chkTransparent.isSelected();
                byte transparency = (byte)WindowDecoratorDemo.this._slider.getValue();
                WindowDecoratorDemo.this._decorator.setTransparent(transparent);
                WindowDecoratorDemo.this._decorator.setTransparency(transparency);
            }
        });
        contentPane.add((Component)this.chkTransparent, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 60, 10, 10), 0, 0));
        this._slider = new JSlider(0);
        this._slider.setMinimum(0);
        this._slider.setMaximum(255);
        this._slider.setValue(255);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        labelTable.put(new Integer(0), new JLabel("Transparent"));
        labelTable.put(new Integer(255), new JLabel("Opaque"));
        this._slider.setLabelTable(labelTable);
        this._slider.setMajorTickSpacing(10);
        this._slider.setPaintTicks(true);
        this._slider.setPaintLabels(true);
        this._slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                if (WindowDecoratorDemo.this._decorator.isTransparent() & !source.getValueIsAdjusting()) {
                    byte transparency = (byte)source.getValue();
                    WindowDecoratorDemo.this._decorator.setTransparency(transparency);
                }
            }
        });
        contentPane.add((Component)this._slider, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 10), 0, 0));
        this.chkTopmost = new JCheckBox("Topmost", false);
        this.chkTopmost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecoratorDemo.this._decorator.setTopmost(WindowDecoratorDemo.this.chkTopmost.isSelected());
            }
        });
        contentPane.add((Component)this.chkTopmost, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 60, 10, 10), 0, 0));
        this.chkPalette = new JCheckBox("Palette Style", false);
        this.chkPalette.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecoratorDemo.this._decorator.setPalleteWindow(WindowDecoratorDemo.this.chkPalette.isSelected());
            }
        });
        contentPane.add((Component)this.chkPalette, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 60, 10, 10), 0, 0));
        this.chkRounded = new JCheckBox("Rounded Corners", false);
        this.chkRounded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WindowDecoratorDemo.this._decorator.setRounded(WindowDecoratorDemo.this.chkRounded.isSelected());
            }
        });
        contentPane.add((Component)this.chkRounded, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 60, 10, 10), 0, 0));
        this.btnShowCustomShapeWindow = new JButton("Show Custom Window");
        this.btnShowCustomShapeWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        contentPane.add((Component)this.btnShowCustomShapeWindow, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 60, 10, 10), 0, 0));
        this.btnClose = new JButton("Close");
        this.btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        contentPane.add((Component)this.btnClose, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent e) {
                WindowDecoratorDemo.this._decorator.setWindow((Window)WindowDecoratorDemo.this);
                Icon smallIcon = new Icon();
                smallIcon.loadFromFile("jniwrapper.ico");
                Icon bigIcon = new Icon(1);
                bigIcon.loadFromFile("jniwrapper.ico");
                WindowDecoratorDemo.this._decorator.setWindowIcon(smallIcon);
                WindowDecoratorDemo.this._decorator.setWindowIcon(bigIcon);
            }
        });
        this.pack();
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            System.exit(0);
        }
    }

    public static void main(String[] arguments) {
        WindowDecoratorDemo window = new WindowDecoratorDemo();
        window.setVisible(true);
    }

    static {
        DefaultLibraryLoader.getInstance().addPath("bin");
    }
}

