/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.samples;

import com.jniwrapper.DefaultLibraryLoader;
import com.jniwrapper.win32.io.FileSystemEvent;
import com.jniwrapper.win32.io.FileSystemEventListener;
import com.jniwrapper.win32.io.FileSystemWatcher;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class FileSystemWatcherSample {
    static final String[] ACTION_NAMES = new String[]{"added", "removed", "modified", "renamed"};
    static final String MESSAGE_TEMPLATE = "File ''{0}'' was {1}";

    public static void main(String[] args) {
        File f;
        DefaultLibraryLoader.getInstance().addPath("Bin");
        String folder = new File("").getAbsolutePath();
        if (args.length > 0 && (f = new File(args[0])).exists()) {
            folder = args[0];
        }
        System.out.println("Watched folder = " + folder);
        FileSystemWatcher watcher = new FileSystemWatcher(folder, true);
        watcher.addFileSystemListener(new FileSystemEventListener(){

            public void handle(FileSystemEvent event) {
                String actionName = ACTION_NAMES[event.getAction()];
                String message = MessageFormat.format(FileSystemWatcherSample.MESSAGE_TEMPLATE, event.getFileInfo(), actionName);
                if (event.getAction() == 4) {
                    message = message + " from '" + event.getOldFileInfo() + "'";
                }
                System.out.println(message);
            }
        });
        try {
            watcher.start();
            System.out.println("Watching stared");
            JOptionPane.showConfirmDialog(null, "Watching in progress. Terminate?", "FileSystemWatcher Sample", -1);
            watcher.stop();
            System.out.println("Watching stoped");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        MESSAGE_TEMPLATE = MESSAGE_TEMPLATE;
    }
}

