/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry.ui;

import com.jniwrapper.win32.registry.RegistryKey;
import com.jniwrapper.win32.registry.RegistryKeyType;
import com.jniwrapper.win32.registry.RegistryKeyValues;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public class RegistryKeyValuesTableModel
extends AbstractTableModel {
    private RegistryKey _registryKey;
    private static final Map _typeNames = new HashMap();

    public RegistryKeyValuesTableModel() {
    }

    public RegistryKeyValuesTableModel(RegistryKey registryKey) {
        this._registryKey = registryKey;
    }

    public int getRowCount() {
        if (this._registryKey == null) {
            return 0;
        }
        return this._registryKey.values().size();
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Value";
            }
        }
        throw new IllegalArgumentException("Invalid column index");
    }

    protected RegistryKeyValues.RegistryValueEntry getEntry(int rowIndex) {
        List entries = this._registryKey.values().getEntries();
        RegistryKeyValues.RegistryValueEntry entry = (RegistryKeyValues.RegistryValueEntry)entries.get(rowIndex);
        return entry;
    }

    private static String toHexString(byte value) {
        int lb = value & 0xF;
        int hb = (value & 0xF0) >> 4;
        int lc = lb > 9 ? 65 + lb % 10 : 48 + lb;
        int hc = hb > 9 ? 65 + hb % 10 : 48 + hb;
        StringBuffer result = new StringBuffer();
        result.append((char)hc).append((char)lc);
        return result.toString();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this._registryKey == null) {
            return null;
        }
        RegistryKeyValues.RegistryValueEntry entry = this.getEntry(rowIndex);
        switch (columnIndex) {
            case 0: {
                String key = entry.getKey().toString();
                return key.length() == 0 ? "(Default)" : key;
            }
            case 1: {
                Object typeName = _typeNames.get((Object)entry.getType());
                return typeName;
            }
            case 2: {
                if (entry.getType().equals((Object)RegistryKeyType.BINARY) || entry.getType().equals((Object)RegistryKeyType.RESOURCE_LIST) || entry.getType().equals((Object)RegistryKeyType.FULL_RESOURCE_DESCRIPTOR) || entry.getType().equals((Object)RegistryKeyType.RESOURCE_REQUIREMENTS_LIST)) {
                    byte[] binaryData = (byte[])entry.getValue();
                    StringBuffer result = new StringBuffer();
                    int i = 0;
                    while (i < binaryData.length) {
                        result.append(RegistryKeyValuesTableModel.toHexString(binaryData[i])).append(' ');
                        ++i;
                    }
                    return result.toString();
                }
                return entry.getValue();
            }
        }
        throw new IllegalArgumentException("Invalid column index");
    }

    public RegistryKey getRegistryKey() {
        return this._registryKey;
    }

    public void setRegistryKey(RegistryKey registryKey) {
        this._registryKey = registryKey;
        this.fireTableDataChanged();
    }

    static {
        _typeNames.put(RegistryKeyType.NONE, "REG_NONE");
        _typeNames.put(RegistryKeyType.SZ, "REG_SZ");
        _typeNames.put(RegistryKeyType.EXPAND_SZ, "REG_EXPAND_SZ");
        _typeNames.put(RegistryKeyType.BINARY, "REG_BINARY");
        _typeNames.put(RegistryKeyType.DWORD, "REG_DWORD");
        _typeNames.put(RegistryKeyType.MULTI_SZ, "REG_MULTI_SZ");
        _typeNames.put(RegistryKeyType.LINK, "REG_LINK");
        _typeNames.put(RegistryKeyType.RESOURCE_LIST, "REG_RESOURCE_LIST");
        _typeNames.put(RegistryKeyType.FULL_RESOURCE_DESCRIPTOR, "REG_FULL_RESOURCE_DESCRIPTOR");
        _typeNames.put(RegistryKeyType.RESOURCE_REQUIREMENTS_LIST, "REG_RESOURCE_REQUIREMENTS_LIST");
    }
}

