/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.io;

import com.jniwrapper.win32.io.FileInfo;
import com.jniwrapper.win32.io.FileSystem;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class FolderInfo
extends FileInfo {
    private List _files = new ArrayList();
    private boolean _recursive = true;
    private int _fileCount = 0;
    private FileFilter _fileFilter = null;

    public FolderInfo(String path, FileFilter filter, boolean recursive) {
        super(path, FileSystem.getFileAttributes(path).getFlags(), new File(path).length(), new File(path).lastModified());
        this._fileFilter = filter;
        this._recursive = recursive;
    }

    public FolderInfo(String path, boolean recursive) {
        this(path, null, recursive);
    }

    protected void loadFiles(FolderInfo result, File rootFolder) {
        File[] files = this._fileFilter == null ? rootFolder.listFiles() : rootFolder.listFiles(this._fileFilter);
        while (files == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            File[] fileArray = files = this._fileFilter == null ? rootFolder.listFiles() : rootFolder.listFiles(this._fileFilter);
        }
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            ++this._fileCount;
            String fileName = file.getAbsolutePath();
            if (this._recursive && file.isDirectory()) {
                FolderInfo subfolder = new FolderInfo(fileName, this._recursive);
                this.loadFiles(subfolder, file);
                result._files.add(subfolder);
                this._fileCount += subfolder.getFileCount();
            } else {
                result._files.add(new FileInfo(fileName, FileSystem.getFileAttributes(fileName).getFlags(), file.length(), file.lastModified()));
            }
            ++i;
        }
    }

    public void load() {
        this._files.clear();
        this.loadFiles(this, new File(this.getFileName()));
    }

    public int getFileCount() {
        return this._fileCount;
    }

    public List getFiles() {
        return this._files;
    }
}

