/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.gdi;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.util.EnumItem;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.LastErrorException;
import com.jniwrapper.win32.gdi.Gdi32;

public abstract class GdiObject
extends Handle {
    public static final int GDI_ERROR = -1;
    public static final int HGDI_ERROR = -1;
    static final FunctionName FUNCTION_GET_OBJECT;
    static final String FUNCTION_DELETE_OBJECT = "DeleteObject";
    static final String FUNCTION_GET_OBJECT_TYPE = "GetObjectType";

    public GdiObject() {
    }

    public GdiObject(long value) {
        super(value);
    }

    public void deleteObject() {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_DELETE_OBJECT);
        Bool result = new Bool();
        function.invoke((Parameter)result, (Parameter)this);
        if (!result.getValue()) {
            throw new LastErrorException("Failed to delete object");
        }
    }

    public long getObject(GdiObject object, Parameter data) {
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_OBJECT.toString());
        Int result = new Int();
        int length = data.getLength();
        function.invoke((Parameter)result, (Parameter)object, (Parameter)new Int((long)length), (Parameter)new Pointer(data));
        if (result.getValue() == 0L || (long)length != result.getValue()) {
            throw new LastErrorException("Failed to get object.");
        }
        return result.getValue();
    }

    public GdiObjectType getObjectType() {
        UInt32 result = new UInt32();
        Function function = Gdi32.getInstance().getFunction(FUNCTION_GET_OBJECT_TYPE);
        function.invoke((Parameter)result, (Parameter)this);
        return new GdiObjectType((int)result.getValue());
    }

    static {
        GDI_ERROR = -1;
        HGDI_ERROR = -1;
        FUNCTION_GET_OBJECT = new FunctionName("GetObject");
        FUNCTION_DELETE_OBJECT = FUNCTION_DELETE_OBJECT;
        FUNCTION_GET_OBJECT_TYPE = FUNCTION_GET_OBJECT_TYPE;
    }

    public static class GdiObjectType
    extends EnumItem {
        public static final GdiObjectType PEN = new GdiObjectType(1);
        public static final GdiObjectType BRUSH = new GdiObjectType(2);
        public static final GdiObjectType DC = new GdiObjectType(3);
        public static final GdiObjectType METADC = new GdiObjectType(4);
        public static final GdiObjectType PAL = new GdiObjectType(5);
        public static final GdiObjectType FONT = new GdiObjectType(6);
        public static final GdiObjectType BITMAP = new GdiObjectType(7);
        public static final GdiObjectType REGION = new GdiObjectType(8);
        public static final GdiObjectType METAFILE = new GdiObjectType(9);
        public static final GdiObjectType MEMDC = new GdiObjectType(10);
        public static final GdiObjectType EXTPEN = new GdiObjectType(11);
        public static final GdiObjectType ENHMETADC = new GdiObjectType(12);
        public static final GdiObjectType ENHMETAFILE = new GdiObjectType(13);

        private GdiObjectType(int value) {
            super(value);
        }
    }

    public static class ImageLoadParameters
    extends FlagSet {
        public static final int DEFAULTCOLOR = 0;
        public static final int MONOCHROME = 1;
        public static final int COLOR = 2;
        public static final int COPYRETURNORG = 4;
        public static final int COPYDELETEORG = 8;
        public static final int LOADFROMFILE = 16;
        public static final int LOADTRANSPARENT = 32;
        public static final int DEFAULTSIZE = 64;
        public static final int VGACOLOR = 128;
        public static final int LOADMAP3DCOLORS = 4096;
        public static final int CREATEDIBSECTION = 8192;
        public static final int COPYFROMRESOURCE = 16384;
        public static final int SHARED = 32768;

        static {
            DEFAULTCOLOR = 0;
            MONOCHROME = 1;
            COLOR = 2;
            COPYRETURNORG = 4;
            COPYDELETEORG = 8;
            LOADFROMFILE = 16;
            LOADTRANSPARENT = 32;
            DEFAULTSIZE = 64;
            VGACOLOR = 128;
            LOADMAP3DCOLORS = 4096;
            CREATEDIBSECTION = 8192;
            COPYFROMRESOURCE = 16384;
            SHARED = 32768;
        }
    }

    public static class ImageType
    extends EnumItem {
        public static final ImageType BITMAP = new ImageType(0);
        public static final ImageType ICON = new ImageType(1);
        public static final ImageType CURSOR = new ImageType(2);
        public static final ImageType ENHMETAFILE = new ImageType(3);

        private ImageType(int value) {
            super(value);
        }
    }
}

