/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import jdbees.JBeesHelpNode;
import jdbees.JBeesTreeCellRenderer;
import jdbees.JBeesUtils;

public class JBeesHelpDlg
extends JFrame
implements TreeSelectionListener {
    private JSplitPane jSplitPane1;
    private JScrollPane jScrollPane1;
    private JTree helpTree;
    private JScrollPane jScrollPane2;
    private JTextArea helpArea;
    private final String addjobStr = "There are 4 ways to add a new job:\n\n 1. Select from the menu bar: Select <Edit>-<Add>\n\n2. Click the Add button:\n\n3. Click the right mouse button in the table area\n\n4. Drag and drop a link from Netscape Navigator to the table area\nAfter any of the above actions, a \"Add New Job\" dialog will appear. Give the destination URL and the local file name ( this  information will appear if using the above 4 method, or if you use the system clipboard), and the authentication information ( if the website requires under http protocol or for non-anonymous user under ftp protocol). Click <OK> button, and the newly added job will appear in the <Current Jobs>-<Running> table.";
    private final String deljobStr = "Any jobs residing in <Current Jobs>-<In Queue> table, <Current Jobs>-<Resume Queue> table, or <History>-<Downloaded Files> table can be deleted.\n\nSelect a job or jobs from any of the tables mentioned above, then do any of these actions:\n\n1. Select <Edit>-<Delete> from menu bar\n\n2. Click the Delete button \n\n3. Click the right mouse button, and click <Delete>\n\nAll selected jobs will be deleted from the corresponding table.";
    private final String stopjobStr = "To stop a running job in the <Current Jobs>-<Running> table, any of these ways is available:\n\n1. Select the running job you want to stop, and select <Download>-<Stop> from the menu bar\n\n2. Select the running job you want to stop, and click the Stop button\n\n3. Select the running job to stop, click the right mouse button, and click <Stop> \n\nThe stopped job will appear in the <Current Jobs>-<Resume Queue> if it has not completed, or <History>-<Downloaded Files> if it has finished when you try to stop it.";
    private final String resumejobStr = "In order to re-start an unfinished job,  it can be done in a similar way as to stop a job in any of these methods:\n\n1. Select the unfinished job to be re-started, then select <Download>-<Start> from the menu bar\n\n2. Select the unfinished job to be re-started, and click the Start button \n\n3. Select the unfinished job, click the right mouse button, and click the <Start>\n\nThe selected job will reside in the <Current Jobs>-<Running> table again.\n\nTo start all jobs appearing in the <Current Jobs>-<Resume Queue> table, first make this table the currently available one, then do either of these:\n\n1. Select <Download>-<Start All> from the menu bar\n\n2. Click the right mouse button, and click the <Start All>\n\nAll unfinished jobs will start in <Current Jobs>-<Running> table, or wait in <Current Jobs>-<In Queue> if there are so many jobs in running table.";
    private final String preStr = "In order to make JDBees work correctly and effectively, some preferences should be configured before starting file download. Select <Options>-<Preferences> from the menu bar, and a \"Preferences\" dialog will appear,\n\n<Connection> part:\n\n    For fast speed Internet connection or not-so-big files, give <Attempts> and <Time out> a small value; otherwise, a higher <Time out> value will be more feasible. Here <Time out> is calculated in second unit.\n\n<Job> part:\n\n    In this part, you can set <Max Jobs> and <Java Bees>. At any time, there are <Max Jobs>*<Java Bees> bees busy with file download at the same time at most. So if you have many jobs currently, it is suitable to raise the <Max Jobs> value and lower the <Java Bees> value. On the other hand, if you just want to download one or two large file(s), it is more effective to lower the <Max Jobs> value and raise the <Java Bees> value. Those jobs outside of Max Jobs will wait in the <Current Jobs>-<In Queue> table.\n\n<Proxy> part:\n\n    If you connect to the Internet through proxy server, give the JDBees the correct proxy information in this part. Make sure you get and set the correct proxy host and port values; otherwise, JDBees will fail to locate the destination URL from which you want to download files. Leave these two fields blank if you connect to the Internet directly. Currently, JDBees supports HTTP proxy.\n\n<Security> part:\n\n    This part is used for those websites which require HTTP proxy authentication or FTP non-anonymous users. This is the default user information for all download jobs if you do not provide other authentication information when adding a new job. Make sure what you set in <Security> part is workable, or leave it blank if there is no such need.";
    private final String dndStr = "Currently, JDBees supports drag-and-drop URL links from Netscape Navigator. If you use any other browsers, you can first use the system clipboard to copy URL links before you add a new job. The links and related file name will appear in the \"Add New Job\" dialog.";
    private final String miscStr = "If you want to enjoy some Chinese traditional music when downloading, select <Options>-<Music>.";

    public JBeesHelpDlg() {
        this.setTitle("JDBees Help");
        this.initComponents();
        Image ig = JBeesUtils.getImage("bee1r.gif", this);
        this.setIconImage(ig);
        this.helpTree.setModel(new DefaultTreeModel(new JBeesHelpNode()));
        this.helpTree.addTreeSelectionListener(this);
        this.helpTree.setSelectionInterval(0, 0);
        this.helpTree.getSelectionModel().setSelectionMode(1);
        this.helpTree.setCellRenderer(new JBeesTreeCellRenderer());
        this.setSize(500, 400);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((d.width - 500) / 2, (d.height - 400) / 2);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.helpTree = new JTree();
        this.jScrollPane2 = new JScrollPane();
        this.helpArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JBeesHelpDlg.this.closeDialog(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.helpTree);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.helpArea.setWrapStyleWord(true);
        this.helpArea.setLineWrap(true);
        this.helpArea.setEditable(false);
        this.helpArea.setMargin(new Insets(10, 10, 10, 15));
        this.jScrollPane2.setViewportView(this.helpArea);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void valueChanged(TreeSelectionEvent evt) {
        JTree tree = (JTree)evt.getSource();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        Object nodeInfo = node.getUserObject();
        String str = (String)nodeInfo;
        if (str.equals("Add a job")) {
            this.helpArea.setText("There are 4 ways to add a new job:\n\n 1. Select from the menu bar: Select <Edit>-<Add>\n\n2. Click the Add button:\n\n3. Click the right mouse button in the table area\n\n4. Drag and drop a link from Netscape Navigator to the table area\nAfter any of the above actions, a \"Add New Job\" dialog will appear. Give the destination URL and the local file name ( this  information will appear if using the above 4 method, or if you use the system clipboard), and the authentication information ( if the website requires under http protocol or for non-anonymous user under ftp protocol). Click <OK> button, and the newly added job will appear in the <Current Jobs>-<Running> table.");
        } else if (str.equals("Stop a job")) {
            this.helpArea.setText("To stop a running job in the <Current Jobs>-<Running> table, any of these ways is available:\n\n1. Select the running job you want to stop, and select <Download>-<Stop> from the menu bar\n\n2. Select the running job you want to stop, and click the Stop button\n\n3. Select the running job to stop, click the right mouse button, and click <Stop> \n\nThe stopped job will appear in the <Current Jobs>-<Resume Queue> if it has not completed, or <History>-<Downloaded Files> if it has finished when you try to stop it.");
        } else if (str.equals("Resume a job")) {
            this.helpArea.setText("In order to re-start an unfinished job,  it can be done in a similar way as to stop a job in any of these methods:\n\n1. Select the unfinished job to be re-started, then select <Download>-<Start> from the menu bar\n\n2. Select the unfinished job to be re-started, and click the Start button \n\n3. Select the unfinished job, click the right mouse button, and click the <Start>\n\nThe selected job will reside in the <Current Jobs>-<Running> table again.\n\nTo start all jobs appearing in the <Current Jobs>-<Resume Queue> table, first make this table the currently available one, then do either of these:\n\n1. Select <Download>-<Start All> from the menu bar\n\n2. Click the right mouse button, and click the <Start All>\n\nAll unfinished jobs will start in <Current Jobs>-<Running> table, or wait in <Current Jobs>-<In Queue> if there are so many jobs in running table.");
        } else if (str.equals("Delete a job")) {
            this.helpArea.setText("Any jobs residing in <Current Jobs>-<In Queue> table, <Current Jobs>-<Resume Queue> table, or <History>-<Downloaded Files> table can be deleted.\n\nSelect a job or jobs from any of the tables mentioned above, then do any of these actions:\n\n1. Select <Edit>-<Delete> from menu bar\n\n2. Click the Delete button \n\n3. Click the right mouse button, and click <Delete>\n\nAll selected jobs will be deleted from the corresponding table.");
        } else if (str.equals("Preferences")) {
            this.helpArea.setText("In order to make JDBees work correctly and effectively, some preferences should be configured before starting file download. Select <Options>-<Preferences> from the menu bar, and a \"Preferences\" dialog will appear,\n\n<Connection> part:\n\n    For fast speed Internet connection or not-so-big files, give <Attempts> and <Time out> a small value; otherwise, a higher <Time out> value will be more feasible. Here <Time out> is calculated in second unit.\n\n<Job> part:\n\n    In this part, you can set <Max Jobs> and <Java Bees>. At any time, there are <Max Jobs>*<Java Bees> bees busy with file download at the same time at most. So if you have many jobs currently, it is suitable to raise the <Max Jobs> value and lower the <Java Bees> value. On the other hand, if you just want to download one or two large file(s), it is more effective to lower the <Max Jobs> value and raise the <Java Bees> value. Those jobs outside of Max Jobs will wait in the <Current Jobs>-<In Queue> table.\n\n<Proxy> part:\n\n    If you connect to the Internet through proxy server, give the JDBees the correct proxy information in this part. Make sure you get and set the correct proxy host and port values; otherwise, JDBees will fail to locate the destination URL from which you want to download files. Leave these two fields blank if you connect to the Internet directly. Currently, JDBees supports HTTP proxy.\n\n<Security> part:\n\n    This part is used for those websites which require HTTP proxy authentication or FTP non-anonymous users. This is the default user information for all download jobs if you do not provide other authentication information when adding a new job. Make sure what you set in <Security> part is workable, or leave it blank if there is no such need.");
        } else if (str.equals("Drag and Drop")) {
            this.helpArea.setText("Currently, JDBees supports drag-and-drop URL links from Netscape Navigator. If you use any other browsers, you can first use the system clipboard to copy URL links before you add a new job. The links and related file name will appear in the \"Add New Job\" dialog.");
        } else if (str.equals("Misc")) {
            this.helpArea.setText("If you want to enjoy some Chinese traditional music when downloading, select <Options>-<Music>.");
        } else if (str.equals("JDBees Help")) {
            this.helpArea.setText("Help information for Java Dancing Bees.");
        } else {
            this.helpArea.setText("Some tips for using Java Dancing Bees");
        }
    }
}

