/*
 * Decompiled with CFR 0.152.
 */
package jdbees.ftpbatch.model;

import java.util.HashMap;

public class JBeesFTPFileChosed {
    private boolean debug = false;
    private String host;
    private int port;
    private String user;
    private String passwd;
    private String savedBegDir;
    private HashMap fileChosed;
    private String fileSeparator;

    public JBeesFTPFileChosed(String host, int port, String savedBegDir, String user, String passwd) {
        this.savedBegDir = savedBegDir;
        this.host = host;
        this.port = port;
        this.user = user;
        this.passwd = passwd;
        this.fileSeparator = System.getProperty("file.separator");
        this.fileChosed = new HashMap();
    }

    public void addFile(String file, String path) {
        if (this.isExist(file, path)) {
            return;
        }
        String key = this.getKey(file, path);
        this.getSavedBegDir();
        StringBuffer sb = new StringBuffer();
        sb.append(this.savedBegDir);
        if (!this.savedBegDir.endsWith(this.fileSeparator)) {
            sb.append(this.fileSeparator);
        }
        if (this.debug) {
            System.out.println("before replacing, path = " + path + "," + this.fileSeparator.charAt(0));
        }
        path = path.replace('/', this.fileSeparator.charAt(0));
        if (this.debug) {
            System.out.println("after replacing, path = " + path);
        }
        if (path.startsWith(this.fileSeparator) && path.length() > 1) {
            sb.append(path.substring(1));
        } else {
            sb.append(path);
        }
        if (!path.endsWith(this.fileSeparator)) {
            sb.append(this.fileSeparator);
        }
        sb.append(file);
        this.fileChosed.put(key, sb.toString());
    }

    public void addFiles(Object[] files, String path) {
        int i = 0;
        while (i < files.length) {
            this.addFile((String)files[i], path);
            ++i;
        }
    }

    public void deleteFile(String file) {
        if (file == null || file.trim().length() == 0) {
            return;
        }
        this.fileChosed.remove(file);
    }

    public void deleteFiles(Object[] files) {
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            this.deleteFile((String)files[i]);
            ++i;
        }
    }

    public boolean isExist(String file, String path) {
        String key = this.getKey(file, path);
        if (key == null) {
            return true;
        }
        return this.fileChosed.containsKey(key);
    }

    public String getSavedBegDir() {
        if (this.savedBegDir == null) {
            return System.getProperty("user.dir");
        }
        return this.savedBegDir;
    }

    private String getKey(String file, String path) {
        if (file == null || file.trim().length() == 0 || path == null || path.trim().length() == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("ftp://").append(this.host).append(":").append(this.port);
        if (!path.startsWith("/")) {
            sb.append("/");
        }
        sb.append(path);
        if (path.length() > 1 && !path.endsWith("/")) {
            sb.append("/");
        }
        sb.append(file);
        return sb.toString();
    }

    public Object[] getURLs() {
        return this.fileChosed.keySet().toArray();
    }

    public String getLocalFile(String key) {
        return (String)this.fileChosed.get(key);
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return this.passwd;
    }
}

