/*
 * Decompiled with CFR 0.152.
 */
package jdbees;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;

public class JBeesUtils {
    public static String getTimeStr(int secs) {
        int hour = secs / 3600;
        int minute = secs % 3600 / 60;
        int second = secs % 60;
        StringBuffer sb = new StringBuffer();
        if (hour >= 10) {
            sb.append(hour).append(":");
        } else {
            sb.append(0).append(hour).append(":");
        }
        if (minute >= 10) {
            sb.append(minute).append(":");
        } else {
            sb.append(0).append(minute).append(":");
        }
        if (second >= 10) {
            sb.append(second);
        } else {
            sb.append(0).append(second);
        }
        return sb.toString();
    }

    public static void tableSelected(JTable table) {
        int[] selectedIndice = table.getSelectedRows();
        int i = 0;
        while (i < selectedIndice.length) {
            if (table.getValueAt(selectedIndice[i], 0) == null) {
                table.getSelectionModel().removeSelectionInterval(selectedIndice[i], selectedIndice[i]);
            }
            ++i;
        }
    }

    public static void adjustLookandFeel(String plaf, JFrame frame) {
        try {
            UIManager.setLookAndFeel(plaf);
            SwingUtilities.updateComponentTreeUI(frame);
        }
        catch (Exception exception) {}
    }

    public static JMenu buildMenuDetail(String menuName, Action[] ac, JMenuBar jmb) {
        JMenu m = new JMenu(menuName);
        int i = 0;
        while (i < ac.length) {
            if (ac[i] == null) {
                m.addSeparator();
            } else {
                m.add(ac[i]);
            }
            ++i;
        }
        jmb.add(m);
        return m;
    }

    public static Image getImage(String name, JFrame frame) {
        URL url = frame.getClass().getResource(name);
        Image img = frame.getToolkit().getImage(url);
        try {
            MediaTracker tracker = new MediaTracker(frame);
            tracker.addImage(img, 0);
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            return null;
        }
        return img;
    }

    public static int[] deleteTableRow(JTable table, int maxRow) {
        DefaultTableModel dtm = (DefaultTableModel)table.getModel();
        int[] selectedIndice = table.getSelectedRows();
        int i = selectedIndice.length - 1;
        while (i >= 0) {
            dtm.removeRow(selectedIndice[i]);
            --i;
        }
        int size = table.getRowCount();
        if (size < maxRow) {
            int cols = table.getColumnCount();
            Object[] o = new Object[cols];
            int i2 = 0;
            while (i2 < cols) {
                o[i2] = null;
                ++i2;
            }
            i2 = 0;
            while (i2 < maxRow - size) {
                dtm.addRow(o);
                ++i2;
            }
        }
        return selectedIndice;
    }

    public static void fillTableRow(JTable table, Object[] col, int maxRow) {
        DefaultTableModel dtm = (DefaultTableModel)table.getModel();
        if (table.getRowCount() > maxRow) {
            dtm.addRow(col);
        } else {
            boolean insert = false;
            int i = 0;
            while (i < maxRow) {
                if (table.getValueAt(i, 0) == null) {
                    int j = 0;
                    while (j < col.length) {
                        dtm.setValueAt(col[j], i, j);
                        ++j;
                    }
                    insert = true;
                    break;
                }
                ++i;
            }
            if (!insert) {
                dtm.addRow(col);
            }
        }
    }

    public static void add(Component c, GridBagConstraints gbc, Container con, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        con.add(c, gbc);
    }

    public static void setTableRow(JTable table, Object[] o, int index) {
        int i = 0;
        while (i < o.length) {
            table.setValueAt(o[i], index, i);
            ++i;
        }
    }

    public static String getProtocol(String urlstr) {
        try {
            URL url = new URL(urlstr);
            return url.getProtocol().toLowerCase().trim();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }
}

