package com.tolstoy.imagemeister;

import java.awt.Window;

/**
Interface supported by objects which own objects implementing the InfoViewerI interface. For a
given plugin, an object implementing this interface is passed to the plugin's createInfoViewer()
method.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

public interface InfoViewerOwner {
	static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

/**
Tells the owner of an InfoViewerI to close the info viewer. For instance, the info viewer
should call this method when the user clicks in the info viewer's close box. The owner will
then dispose of the info viewer.
*/

	void closeInfoViewer( InfoViewerI w );
}

