/****************************************************

	JConfig Source Code Distribution
	version: 2.1.0      written: Mon May 28 10:11:26 PDT 2001

	Unless otherwise noted, all contents
	Copyright (c) 1997,1998,1999,2000 Samizdat Productions.
	All Rights Reserved.
	All contents are subject to the terms of the
	JConfig Source Code License Agreement

****************************************************/

#include "SAppFinder.h"
#include "SVolumes.h"
#include <string.h>
#include "CUtils.h"
#include "MoreDesktopMgr.h"
#include "Debugger.h"

ErrCode SAppFinder::findAPPLMultiple( long creator, long *vRefsP, long *parIDsP, StringPtr namesP,
								long maxToReturn, long flags, long *numWritten, long maxNameLen )
{
	DTPBRec			dtRec;
	DTPBPtr			dtp;
	ErrCode			theErr;
	Str255			pName;
	long			vRefArray[ 32 ], numVolumes, i, numDone, volIndex;
	short			dbRef;

	UNUSED( flags );

	numDone = 0;
	dtp = &dtRec;

	theErr = SVolumes::getAllVRefNums( &vRefArray[ 0 ], 32, &numVolumes );
	if ( theErr != kErrNoErr || numVolumes < 1 ) {
		if ( theErr == kErrNoErr )
			theErr = nsvErr;
		Debugger::debug( __LINE__, "findAPPLMultiple: err from getAllVRefNums", NULL, NULL, theErr, 0 );
		goto bail; 
	}

	for ( volIndex = 0; volIndex < numVolumes && numDone < maxToReturn; volIndex++ ) {
		CUtils::zeroset( dtp, sizeof(DTPBRec) );
		dtp->ioNamePtr = pName;
		dtp->ioVRefNum = vRefArray[ volIndex ];
		
		theErr = PBDTGetPath( dtp );
		if ( theErr != kErrNoErr )
			continue;
		
		dbRef = dtp->ioDTRefNum;

		CUtils::zeroset( dtp, sizeof(DTPBRec) );
		
		dtp->ioNamePtr = pName;
		dtp->ioDTRefNum = dbRef;
		dtp->ioFileCreator = creator;

		for ( i = 0; numDone < maxToReturn; i++ ) {
			dtp->ioIndex = i + 1;

			theErr = PBDTGetAPPL( dtp, false );
			if ( theErr != kErrNoErr )
				break;

			*vRefsP++ = vRefArray[ volIndex ];
			*parIDsP++ = dtp->ioAPPLParID;
			CUtils::pStrncpy( namesP, pName, maxNameLen - 1 );
			namesP += maxNameLen;
			++numDone;
		}
	}

	if ( numDone > 0 )
		theErr = kErrNoErr;
	else if ( theErr == kErrNoErr )
		theErr = nsvErr;

bail:

	*numWritten = numDone;

	return theErr;
}

ErrCode SAppFinder::findAPPLSingle( long creator, long *vRef, long *parID, StringPtr pName,
									long flags )
{
	ErrCode			theErr;
	long			vRefArray[ 32 ], numVolumes, i;
	short			sVRef;
	Boolean			bSearch;

	bSearch = ( flags == 0 ) ? false : true;
	
	theErr = SVolumes::getAllVRefNums( &vRefArray[ 0 ], 32, &numVolumes );
	if ( theErr != kErrNoErr || numVolumes < 1 ) {
		if ( theErr == kErrNoErr )
			theErr = nsvErr;
		goto bail; 
	}

	for ( i = 0; i < numVolumes; i++ ) {
		theErr = DTXGetAPPL( NULL, vRefArray[ i ], creator, bSearch, &sVRef, parID, pName );
		*vRef = sVRef;
		if ( theErr == kErrNoErr )
			break;
	}
	
bail:

	return theErr;
}


