@ECHO OFF

	REM    This file creates JConfig.zip in {SRCDIR}\jcout
	REM
	REM    You'll need to edit the following properties depending on
	REM    the locations where you have things stored.
	REM
	REM    See 'wininstall.html' for details.
	REM
	REM    SRCDRV and SRCDIR are the locations of the JConfig source
	REM
	REM    JDK102 is the location of Java 1.0.2
	REM
	REM    ZIPHOME is the location of InfoZip's zip.exe; replace
	REM    with another command line zip program if you don't have
	REM    this
	REM
	REM    Compilation is complicated because the code is compiled twice,
	REM    once using Java 1.0.2, and then again using Java 1.1
	REM    This is because the file DefaultFileUtils11MRJ.java uses 1.1
	REM    features


set SRCDRV=c:
set SRCDIR=c:\samizdat\source
set JDK102=e:\java
set JDK114=f:\jdk1.1.4
set ZIPHOME=e:\infozip
set JJIKES=f:\jikes\jikes
set USEJIKES=0

	REM	if USEJIKES is set to 1, jikes is used to compile
	REM	otherwise, javac is used

if %USEJIKES%==1 goto SETJIKES 
 set J102COMPILER=%JDK102%\bin\javac
 set J102CLASSES=%JDK102%\lib\classes.zip
 set J114COMPILER=%JDK114%\bin\javac
 set J114CLASSES=%JDK114%\lib\classes.zip
 set JIKESCOMMAND1=
 set JIKESCOMMAND2=
 set JIKESCOMMAND3=
 set JIKESCOMMAND4=

 goto OVER1

:SETJIKES
 set J102COMPILER=%JJIKES%
 set J102CLASSES=%JDK102%\lib\classes.zip
 set J114COMPILER=%JJIKES%
 set J114CLASSES=%JDK114%\lib\classes.zip
 set JIKESCOMMAND1=-Xstdout
 set JIKESCOMMAND2=
 set JIKESCOMMAND3=
 set JIKESCOMMAND4=


:OVER1

	REM all the java packages


set PACKAGES=com\jconfig\mac\*.java com\jconfig\win\*.java com\jconfig\nix\*.java com\jconfig\*.java com\tolstoy\testjc\*.java



	REM the files which will be compiled using Java 1.1.4


set FILESFOR11=com\jconfig\mac\DefaultFileUtils11MRJ.java com\jconfig\FileUtilsI.java







%SRCDRV%
cd %SRCDIR%


	REM delete old files

if exist jvcerrors.txt del jvcerrors.txt
if exist srcdcec.zip del srcdcec.zip


	REM create the output directory

if exist jcout\NUL deltree/y jcout
mkdir jcout



	REM zip the source code, which will be unzipped later on

%ZIPHOME%\zip -9 -r -q srcdcec.zip com


	REM create the temp directories
	REM tttemp10 will hold the version compiled using 1.0.2
	REM tttemp11 will hold the version compiled using 1.1.4

if exist tttemp10\NUL deltree/y tttemp10
mkdir tttemp10
if exist tttemp11\NUL deltree/y tttemp11
mkdir tttemp11


	REM copy the zipped source code to each temp directory, and unzip it

copy srcdcec.zip tttemp10
move srcdcec.zip tttemp11

cd tttemp10
%ZIPHOME%\unzip -q srcdcec.zip
del srcdcec.zip
cd ..

cd tttemp11
%ZIPHOME%\unzip -q srcdcec.zip
del srcdcec.zip
cd ..



	REM compile two of the classes using 1.1.4, and then temporarily move DefaultFileUtils11MRJ.class
	REM to {SRCDIR} This will be inserted into JConfig.zip below.

cd tttemp11
mkdir out11
set CLASSPATH=.;%J114CLASSES%
set JIKESPATH=.;%J114CLASSES%
%J114COMPILER% -d out11 %JIKESCOMMAND1% %JIKESCOMMAND2% %JIKESCOMMAND3% %JIKESCOMMAND4% %FILESFOR11% >%SRCDIR%\jvcerrors.txt

move out11\com\jconfig\mac\DefaultFileUtils11MRJ.class ..\

	REM compile the source code using 1.0.2. DefaultFileUtils11MRJ is not needed here (and would
	REM generate errors). It was compiled using 1.1.4 in the previous step

cd ..\tttemp10
del com\jconfig\mac\DefaultFileUtils11MRJ.java
mkdir out10
set CLASSPATH=.;%J102CLASSES%
set JIKESPATH=.;%J102CLASSES%
%J102COMPILER% -d out10 %JIKESCOMMAND1% %JIKESCOMMAND2% %JIKESCOMMAND3% %JIKESCOMMAND4% %PACKAGES% >>%SRCDIR%\jvcerrors.txt

	REM move DefaultFileUtils11MRJ, which was compiled with 1.1.4, into the files which were just
	REM compiled using 1.0.2

move ..\DefaultFileUtils11MRJ.class out10\com\jconfig\mac



	REM Zip the final file, and move it into the {SRCDIR}\jcout directory

cd out10
%ZIPHOME%\zip -0 -r -q JConfig.zip com
cd ..\..
copy tttemp10\out10\JConfig.zip jcout\JConfig.zip



	REM delete the temp directories

if exist tttemp10\NUL deltree/y tttemp10
if exist tttemp11\NUL deltree/y tttemp11

