/*
Author: Pramod S. Jaiswal
November 6, 2001

This programs depicts how to use the 
setCalendarOwner(Frame) & setCalendarOwner(Dialog) method

Note: 
The Frame/Dialog class in which you have actually added the DatePicker should not be
used as the OWNER of the DatePickerCalendar. These might result in some runtime errors that 
can't be trapped. I have noted such error on Win 98/Me but not under Win NT/2000

PLEASE ADD DatePicker.jar to your classpath and then do Javac

How to test ?

Once you run this application you will get the CalOwnerDemo Frame with 
a Button 'Set Owner' at the bottom & the DatePicker at the top.

1.Click the DatePicker & the calendar will be displayed.
2.Minimize the CalOwnerDemo Frame without closing the Calendar.
	You will notice that Although the Frame gets Minimized the Calendar does'nt.

3.Now Click the Set Owner Button.
4.Now repeat step 1 & 2
	You will now notice that both the Frame & the Calendar gets Minimized.



*/

import java.awt.*;
import java.awt.event.*;
import DatePickerBean.*;

public class CalOwnerDemo extends Frame implements DatePickerListener,ActionListener
{

	DatePicker dp=new DatePicker();
	Dialog dlg;
	Button b=new Button("Set Owner");
	Label l=new Label("");
	public CalOwnerDemo()
	{
		super("CalOwnerDemo");

		add(dp,BorderLayout.NORTH);
		add(b,BorderLayout.SOUTH);
		add(l);
		

		
		dp.showTodayInCalendar(true);
		dp.showDateRangeInCalendar(false);

		// adding a DatePickerListener
		dp.addDatePickerListener(this);
		dp.addDatePickerListener(new second());	

		b.addActionListener(this);
		
		//adding window closing for the frame
		addWindowListener( new WindowAdapter()
		{
			public void windowClosing(WindowEvent e)
			{
				System.exit(0);
			}
		}
		);


		setSize(200,200);
		setVisible(true);
		
		
		//Note: I have set the current Frame as the Owner of this newly created Dialog
		dlg=new Dialog(this);
		//This new object will now be used to set the owner of the Calendar.

	}
	public void actionPerformed(ActionEvent e)
	{
		//Note: I have added the newly created Dialog object 
		dp.setCalendarOwner(dlg);//setCalendarOwner(Dialog)

		/* So now we have dlg as the owner of the Calendar & the current Frame as the Owner of dlg.
		So in a way the Current Frame has now become the owner of the Calendar.

		You may argue that this could have directly been achevied by the foll:
			
			dp.setCalendarOwner(this);//setCalendarOwner(Frame)

		Although this syntax works well under Win NT/2000
		Some error crops up under Win98/Me. Either the OS itself hangs up or the JRE crashes.
		Try it out under Both the types of OS.

		So its better to use this method in the way I have depicted
		if your application will be running under Win98/Me.*/
		
	}
	public void dateChanged(DatePicker DatePickerObj)
	{
		l.setText(DatePickerObj.getLabel());
	}

	public static void main(String args[])
	{
		CalOwnerDemo c=new CalOwnerDemo();
	}
}

class second implements DatePickerListener
{
	public void dateChanged(DatePicker DatePickerObj)
	{
		System.out.println(DatePickerObj.toString());
	}
};

