package  com.db4o.sql;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import  com.db4o.jgen.*;
import  com.db4o.lib.*;
import  java.sql.*;
import  java.lang.reflect.*;


/**
 * imports data previously exported with
 * <A HREF="SqlExport.html">SqlExport</A>.
 * <br><br>
 * <b>Note:</b> An import run imports all data. A check for duplicates does
 * not take place yet. Be careful to call SqlReImport only once.
 *
 */
public class SqlReImport {

    /**
	 * starts SqlReImport
	 * @param arguments
	 * <br>1.) JDBC driver<br>
	 * 2.) JDBC connection String to database used as source<br>
	 * 3.) db4o datafile destination
 	 * 4.) optional user for the JDBC connection
	 * 5.) optional password for the JDBC connection
     */
    public static void main (String[] args) {
        try {
            SqlConfiguration config = new SqlConfiguration(args, false);
            try {
                Timer.start("SqlReImport completed");
                Connection con = Sql.connect(config);
                if (con != null) {
                    go(config, con);
                    Timer.stop("SqlReImport completed");
                }
            } catch (Exception e) {
                Sql.exception("SQLReImport raises Exception:");
                Sql.exception(e.getMessage());
            }
        } catch (Exception e) {}
    }

    /**
     * @param a_config
     * @param a_connection
     */
    static void go (SqlConfiguration a_config, Connection a_connection) {
        SqlUpdate update = new SqlUpdate();
        update.setField(Sql.TO_ID, "0");
        String sql;
        Collection tables = Sql.getTables(a_connection, false);
        Iterator i = tables.iterator();
        while (i.hasNext()) {
            if (!((SqlTable)i.next()).mapToClass()) {
                i.remove();
            }
        }
        Statement selectStatement = Sql.createStatement(a_connection);
        Statement updateStatement = Sql.createStatement(a_connection);
        Sql.createMap(updateStatement);
        ObjectContainer db = Db4o.openFile(a_config.getDbFile());
        i.reset();
        while (i.hasNext()) {
            ((SqlTable)i.next()).reImportObjects(db, selectStatement, updateStatement);
        }
        try {
            a_connection.commit();
        } catch (Exception e) {
            Sql.error("Commit failed after importing objects.");
        }
        i.reset();
        while (i.hasNext()) {
            ((SqlTable)i.next()).reWire(db, a_connection, selectStatement);
        }
        db.close();
    }
}



