package com.db4o.samples;

import com.db4o.*;
import com.db4o.lib.Logger;

public class S08_Update
{
	public static void main(String[] args)
	{
		try{
			ObjectContainer db = Db4o.openFile("samples.yap");
			Logger.log("*** S08 Updating all Individual where firstName is 'Alice'");

			Individual individual = new Individual();
			individual.firstName = "Alice";
			ObjectSet os = db.get(individual);
			// Query By Example as in example S07

			Person alice = (Person)os.next();
			if(alice != null){


				alice.name = "Pan";
				alice.addresses = new Address[1];
				alice.addresses[0] = new Address();
				alice.addresses[0].city = "Oz";
				alice.addresses[0].street = "One Rabbit Way";
				// modifying alice


				db.set(alice);
				// calling db.set() with an object that is already stored
				// updates the object.
				// Alle new members are stored as well.


			}
			db.close();

			S07_Query_By_Example.main(null);
			// we call sample S07 for the convenience to output 'Alice'

		}catch(Exception e){
			AllSamples.inARow();
		}
	}
}
