package  com.db4o.bench;

import  com.db4o.*;
import  com.db4o.lib.*; // library comes with db4o download
import  com.db4o.sql.*; // library comes with db4o download
import  java.sql.*;
import  java.io.File;

public class BenchMark {

	// Edit the following JDBC connection settings to test db4o
	// against the SQL database of your choice.

    private static String JDBC_Driver = "";
    private static String JDBC_ConnectString = "";
	private static String JDBC_User="";
	private static String JDBC_Password="";

	private static boolean skipBench = false;
    public static int runs = 1000;


    private static String db4oFile = "bench.yap";
    private static String i_runningTag;
    private static String i_tag;

    public static void main (String[] args) {
        if (args != null) {
            if (args.length > 0) {
                runs = new Integer(args[0]).intValue();
            }
			if(args.length  > 2){
				JDBC_Driver = args[1];
				JDBC_ConnectString = args[2];
			}
        }
        JDBC();
        db4o();
    }

    static void db4o () {
        Logger.log("");
		String tag = "Overall db4o performance";
		Timer.start(tag);

		BenchRelationalMismatch.run(null,false);

		if(skipBench){
			return;
		}

		ObjectContainer db;
        tagDb4o();
        new File(db4oFile).delete(); // a clean file ensures no duplicates

        db =  Db4o.openFile(db4oFile);
        BenchInsert.db4oInt(db);
        db.close();

		db = Db4o.openFile(db4oFile); // reopening the data file produces cold results
        BenchSelect.db4oInt(db);
        db.close();

        /*
		db = Db4o.openFile(db4oFile);
        BenchRetrieve.db4oInt(db);
        db.close();
		*/

        db = Db4o.openFile(db4oFile);
        BenchUpdate.db4oInt(db);
        db.close();

        db = Db4o.openFile(db4oFile);
        BenchInsert.db4oString(db);
        db.close();

        db = Db4o.openFile(db4oFile);
        BenchSelect.db4oString(db);
        db.close();

		/*
        db = Db4o.openFile(db4oFile);
        BenchRetrieve.db4oString(db);
        db.close();
		*/

        db = Db4o.openFile(db4oFile);
        BenchUpdate.db4oString(db);
        db.close();

		Logger.log("");
		Timer.stop(tag);

		// upDown();

		Logger.log("\nVersion: " + Db4o.version());

        Logger.log("\nMail results to bench@db4o.com to make us happy.");
        Logger.log("Please include information about your environment.\n");
    }

	static void upDown(){
		int upRuns = runs / 500;
		String tag = Integer.toString(upRuns) + " Ups and Downs";
        Timer.start(tag);
		ObjectContainer db;
		for(int i = 0; i < upRuns; i++){
			db = Db4o.openFile(db4oFile );
			db.close();
		}
		Timer.stop(tag);
	}

    static void JDBC () {
        if (JDBC_Driver.length() > 0 && JDBC_ConnectString.length() > 0) {
            try {
                Connection c = Sql.connect(
				           new SqlConfiguration(JDBC_Driver, JDBC_ConnectString, JDBC_User, JDBC_Password)
				);
                if (c != null) {
					c.setAutoCommit(false);  // we use explicit commit where appropriate
					BenchRelationalMismatch.run(c,true);

					if(! skipBench){

						Statement s = Sql.createStatement(c);
						tagSQL();
						BenchSql.prepareTables(c);
						BenchInsert.sqlInt(s);
						c.commit();
						BenchSelect.SqlInt(s);
						// BenchRetrieve.sqlInt(s);
						BenchUpdate.sqlInt(s);
						c.commit();
						BenchInsert.sqlString(s);
						c.commit();
						BenchSelect.SqlString(s);
						// BenchRetrieve.sqlString(s);
						BenchUpdate.sqlString(s);
						c.commit();
					}
                }

            } catch (Exception e) {
                Logger.log("The JDBC Benchmark run threw an exception.");
                Logger.log("Exception class:" + e.getClass().getName());
                Logger.log("Message: " + e.getMessage());
            }
        }
        else {
            Logger.log("Edit JDBC_Driver and JDBC_ConnectString in Benchmark.java for JDBC results. ");
        }

    }

    static void start (String tag) {
        i_tag = i_runningTag + tag;
        Timer.start(i_tag);
    }

    static void stop () {
        Timer.stop(i_tag);
    }

	static void tagDb4o(){
		i_runningTag = "db4o - ";
	}

	static void tagSQL(){
		i_runningTag = "SQL - ";
	}

}



