/*Data Access Library. v. 1.1.
 *Formatter. This class deals with nice source code presentation.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data.wizzard;

import java.io.*;
import java.util.*;

class Formatter {
    private FileWriter _out;
    private String _buf;
    private String _indUnit = "  ";
    private int _curInd = 0;
    private int _prefLineLength;
    
    private static final int _defLineLength = 80;
    private static final String LS = System.getProperty("line.separator");
    private static final boolean CONV_EOL = !LS.equals("\n");

    Formatter() {
	_buf = "";
	_prefLineLength = _defLineLength;
    }

    void open(String fName) throws IOException {
	if (fName.indexOf((int)File.separatorChar) >=0) {
	    String path = fName.substring(0,fName.lastIndexOf((int)File.separatorChar));
	    try {
		File p = new File(path);
		if (!p.exists())
		    if (!p.mkdirs())
			throw new IOException("Couldn't create "+fName);
	    } catch (SecurityException ex) {
		throw new IOException("Couldn't create "+fName+"\nSecurity:"+ex.getMessage());
	    }
	}
	_out = new FileWriter(fName);
    }

    void flush() throws IOException {
	checkOut();
	flushBuf();
	_out.flush();
    }

    void setPrefLineLength(int l) {
	_prefLineLength = l;
    }

    void setIndUnit(String iu) {
	_indUnit = iu;
    }

    void writeln(String s,int ind) throws IOException {
	_curInd = ind;
	if (s!= null)
	    writeln(s);
    }

    void writeln(String s) throws IOException {
	checkOut();
	flushBuf();
	if (_curInd>0)
	    _out.write(composeLine(s)+LS);
	else {
	    if (CONV_EOL) {
		StringTokenizer tok = new StringTokenizer(s,"\n");
		while(tok.hasMoreTokens())
		    _out.write(tok.nextToken()+LS);
	    } else
		_out.write(s+LS);
	}
    }

    void write(String s)  throws IOException  {
	checkOut();
	if (_buf.length()+s.length()+(_curInd*_indUnit.length()) > _prefLineLength)
	    flushBuf();
	_buf+=composeLine(s);
    }

    private String composeLine(String src) {
	String res = "";
	int allTok,curTok;
	if (_curInd > 0) {
	    StringTokenizer tok = new StringTokenizer(src,"\n",false);
	    allTok = tok.countTokens();
	    for(curTok=1;tok.hasMoreTokens();curTok++) {
		String t = tok.nextToken();
		if (t.indexOf('\t')>=0) {
		    int pos = t.indexOf('\t');
		    String tt = (pos>0?t.substring(0,pos):"");
		    tt+=_indUnit;
		    int pos2 = (pos==t.length()-1?-1:t.indexOf('\t',pos+1));
		    while(pos2>0) {
			if (pos2-pos>1)
			    tt+=t.substring(pos+1,pos2);
			tt+=_indUnit;
			pos = pos2;
			pos2 = (pos2==t.length()-1?-1:t.indexOf('\t',pos2+1));
		    }
		    t = tt+(pos==t.length()-1?"":t.substring(pos+1));
		}
		if (t.length()>0)
		    for (int i=0;i<_curInd;i++)
			res+=_indUnit;
		if (curTok<allTok)
		    res+=t+LS;
		else
		    res+=t;
	    }
	} else
	    res = src;
	return res;
    }
    
    private void flushBuf()  throws IOException {
	if (_buf.length()>0) {
	    _out.write(_buf+LS);
	    _buf = "";
	}
    }

    private void checkOut()  throws IOException {
	if (_out == null)
	    throw new IOException("File not yet opened.");
    }

}
