/*Data Access Library. v. 1.1.
 *Parameter Event. Support class of DA Library.
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

/**Supports data access event model in DA Library.
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
*/
public class ParameterEvent extends java.util.EventObject {

    private String actionName;
    private Object parameter;

    public ParameterEvent(Object src) {
	super(src);
    }
	
    public ParameterEvent(Object src,String acnName) {
	super(src);
	actionName = acnName;
    }

    public ParameterEvent(Object src,String acnName,Object param) {
	super(src);
	actionName = acnName;
	parameter = param;
    }

    public String getActionName() {
	return actionName;
    }

    public Object getParameter() {
	return parameter;
    }

    public String toString() {
	return super.toString()+".\n\tParameterEvent: "+((actionName!=null)?("action: "+actionName):"") + ((parameter!=null)?("param: "+parameter.toString()):"");
    }

}
