/*Data Access Library. v. 1.1.
 *Connection listener interface. 
 *AUTHOR:  Alexander Jaremenko <jarem@altavista.net>
 *RELEASE DATE: 
 */

package JProjects.eab.data;

/**Interface for listeners of connection events.
 *@see ConnectionEvent
 *@see ConnectionSupport
 *@see DatastoreJDBC#addConnectionListener
 *@see DatastoreJDBC#removeConnectionListener
 *@author Alexander Jaremenko  <address><a href="mailto:jarem@altavista.net">&lt jarem@altavista.net &gt</a></address>
 */
public interface ConnectionListener extends ParameterListener {

    public abstract void connected(ConnectionEvent ev);
    public abstract void disconnected(ConnectionEvent ev);
    public abstract void committed(ConnectionEvent ev);
    public abstract void executedSQL(ConnectionEvent ev);
    public abstract void rolledback(ConnectionEvent ev);
    public abstract void cancelled(ConnectionEvent ev);
}
