/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Image;
import java.awt.event.MouseEvent;
import jms.graphics.GenericThumbnail;
import jms.graphics.ImageDisplayer;
import jms.graphics.ImageDisplayerObserver;
import jms.graphics.ThumbnailListener;

public class ImageThumbnail
extends GenericThumbnail
implements ImageDisplayerObserver {
    public static int BORDER = 10;
    private ImageDisplayer imageDisplayer;

    public ImageThumbnail(ThumbnailListener tl, Image img, String file_name, String path, long file_size) {
        super(tl, img, file_name, path, file_size);
    }

    public int getBorder() {
        return BORDER;
    }

    public boolean drawLabel() {
        return false;
    }

    public synchronized void imageDisplayerDone(ImageDisplayer id) {
        if (id == null || id == this.imageDisplayer) {
            this.imageDisplayer = null;
            Runtime rt = Runtime.getRuntime();
            rt.gc();
        }
    }

    public void mousePressed(MouseEvent evt) {
        if ((evt.getModifiers() & 4) != 0 || (evt.getModifiers() & 8) != 0) {
            super.mousePressed(evt);
        }
        this.mouseClicked(evt);
    }

    public void mouseClicked(MouseEvent evt) {
        if ((evt.getModifiers() & 0x10) == 0 || System.currentTimeMillis() - this.popupActionEventDate <= 1000L) {
            return;
        }
        if (this.imageDisplayer == null) {
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            this.imageDisplayer = new ImageDisplayer(String.valueOf(this.path) + this.fileName, String.valueOf(this.path) + this.fileName, (ImageDisplayerObserver)this);
            this.imageDisplayer.run();
        } else {
            this.imageDisplayer.show();
            this.imageDisplayer.toFront();
        }
    }

    public String getInfo() {
        if (this.imageWidth != -1 && this.imageHeight != -1) {
            return String.valueOf(super.getInfo()) + "  [" + this.imageWidth + "x" + this.imageHeight + "pixels]";
        }
        return "";
    }

    public String getProperties() {
        long l = this.fileSize;
        String ko = "";
        if (l > 1024L) {
            ko = (l /= 1024L) + " Ko";
        }
        String img_size = "";
        if (this.imageWidth != -1 && this.imageHeight != -1) {
            img_size = "|Image Size : [" + this.imageWidth + "x" + this.imageHeight + "] pixels";
        }
        return new String("File : " + this.getFileName() + "|Path : " + this.path + "|File Size : " + ko + " (" + this.fileSize + " bytes)" + img_size);
    }
}

