/*
 * Generator   : PPWIZARD version 01.002
 *             : FREE tool for Windows, OS/2, DOS and UNIX by Dennis Bareis (dbareis@labyrinth.net.au)
 *             : http://www.labyrinth.net.au/~dbareis/ppwizard.htm
 * Time        : Tuesday, 2 Jan 2001 7:34:41am
 * Input File  : C:\DBAREIS\Projects\MultiOs\PPWIZARD\ppwizard.x
 * Output File : out\ppwizard.rex
 */

if arg(1)="!CheckSyntax!" then exit(21924)

PgmVersion="01.002"
SupportedReginaVersions='0.08F, 0.08G or 0.08H, 2.0, 2.2'
RecommendedReginaVersions='2.0'
PpwStartSec=(time('S') || substr(time('L'),9,3))
TrapHandler=''
RedirMethod=''
call InitCommandLineOptions arg(1)
call InitConsoleOutputVarsPass1
PpwDoing='Initializing'
Dummy=time('Reset')
b2rNewSingleQuote="' || " || '"' || "'" || '" || ' || "'"
b2rAllHexCodes=''
b2rAllAsciiCodes=''
do b2rCharCode=0 to 31
b2rAllHexCodes=b2rAllHexCodes||d2c(b2rCharCode)
end
do b2rCharCode=32 to 126
b2rAllAsciiCodes=b2rAllAsciiCodes||d2c(b2rCharCode)
end
do b2rCharCode=127 to 255
b2rAllHexCodes=b2rAllHexCodes||d2c(b2rCharCode)
end
signal EndBIN2REXPXh

_QuoteAscii:
b2rAscii2Quote=arg(1)
if pos("'",b2rAscii2Quote)=0 then
return("'" || b2rAscii2Quote || "'")
else
do
if pos('"',b2rAscii2Quote)=0 then
return('"' || b2rAscii2Quote || '"')
else
do
return("'" || ReplaceString(b2rAscii2Quote, "'", b2rNewSingleQuote) || "'")
end
end

_FormatHex:
b2rHexString=arg(1)
b2rLengthHex=length(b2rHexString)
b2rFormattedHex="'"
if b2rLengthHex>7 then
do
b2rLeft1=left(b2rHexString,1)
b2rLeft1Pos=verify(b2rHexString,b2rLeft1)
if b2rLeft1Pos=0 then
return( "copies('" || c2x(b2rLeft1) || "'x, " || b2rLengthHex || ")" )
else
do
if b2rLeft1Pos>7 then
do
b2rFormattedHex="copies('" || c2x(b2rLeft1) || "'x, " || b2rLeft1Pos-1 || ") || '"
b2rHexString=substr(b2rHexString,b2rLeft1Pos)
b2rLengthHex=b2rLengthHex-(b2rLeft1Pos-1)
end
end
end
do b2rCharPosn=1 to b2rLengthHex
if(b2rCharPosn//8)=1 then
do
if b2rCharPosn<>1 then
b2rFormattedHex=b2rFormattedHex|| ' '
end
b2rFormattedHex=b2rFormattedHex||c2x(substr(b2rHexString,b2rCharPosn,1))
end
b2rFormattedHex=b2rFormattedHex|| "'x"
return(b2rFormattedHex)

_QuoteAsciiBreakIfRequired:
qabAscii=arg(1)
qabLength=length(qabAscii)
qabReturn=''
do while qabLength>256
qabLeft=left(qabAscii,256)
qabAscii=substr(qabAscii,256+1)
qabLength=qabLength-256
if qabReturn='' then
qabReturn=_QuoteAscii(qabLeft)
else
qabReturn=qabReturn|| " || " ||_QuoteAscii(qabLeft)
end
if qabLength=0 then
return(qabReturn)
else
do
if qabReturn='' then
return(_QuoteAscii(qabAscii))
else
return(qabReturn|| " || " ||_QuoteAscii(qabAscii))
end

_FormatHexBreakIfRequired:
fhbHex=arg(1)
fhbLength=length(fhbHex)
fhbReturn=''
do while fhbLength>80
fhbLeft=left(fhbHex,80)
fhbHex=substr(fhbHex,80+1)
fhbLength=fhbLength-80
if fhbReturn='' then
fhbReturn=_FormatHex(fhbLeft)
else
fhbReturn=fhbReturn|| " || " ||_FormatHex(fhbLeft)
end
if fhbLength=0 then
return(fhbReturn)
else
do
if fhbReturn='' then
return(_FormatHex(fhbHex))
else
return(fhbReturn|| " || " ||_FormatHex(fhbHex))
end

BIN2REXP:
call BIN2REXP_START
b2rValue=arg(1)
b2rValueLength=length(b2rValue)
if b2rValueLength=0 then
call BIN2REXP_ONEBIT '""'
else
do
do while b2rValue\==''
b2rEndAsciiPos=verify(b2rValue,b2rAllAsciiCodes)
if b2rEndAsciiPos=0 then
do
call BIN2REXP_ONEBIT _QuoteAsciiBreakIfRequired(b2rValue)
b2rValue=''
end
else
do
if b2rEndAsciiPos<>1 then
do
call BIN2REXP_ONEBIT _QuoteAsciiBreakIfRequired(left(b2rValue,b2rEndAsciiPos-1))
b2rValue=substr(b2rValue,b2rEndAsciiPos)
end
else
do
b2rEndBinaryPos=verify(b2rValue,b2rAllHexCodes)
if b2rEndBinaryPos=0 then
do
call BIN2REXP_ONEBIT _FormatHexBreakIfRequired(b2rValue)
b2rValue=''
end
else
do
call BIN2REXP_ONEBIT _FormatHexBreakIfRequired(left(b2rValue,b2rEndBinaryPos-1))
b2rValue=substr(b2rValue,b2rEndBinaryPos)
end
end
end
end
end
call BIN2REXP_END
return

EndBIN2REXPXh:
signal EndDUMPVARXh

DumpVarsInExpression:
dv_RexxExp=arg(1)
dv_Stem=translate(arg(2))
dv_VarHeading=arg(3)
dv_LineRoutine=arg(4)
if dv_Stem<> '' then
do
dv_AutoDump='N'
dv_StemDot=dv_Stem|| '.'
if symbol(dv_StemDot|| '0') = 'VAR' then
dv_VarCount=value(dv_StemDot|| '0')
else
do
call _DumpVarsLineOutput 'DumpVar: Could not find "' || dv_StemDot || '0' || '"'
return(0)
end
end
else
do
dv_AutoDump='Y'
dv_Stem='DV_VARLIST'
dv_StemDot=dv_Stem|| '.'
dv_VarCount=0
end
if dv_VarCount=0 then
dv_MaxVarLng=0
do while dv_RexxExp<> ''
parse value strip(dv_RexxExp, 'L')with dv_1stChar+1 dv_RexxExp
select
when datatype(dv_1stChar, 'S')then
do
dv_OneVar=dv_1stChar
do while dv_RexxExp<> ''
parse var dv_RexxExp dv_1stChar+1 dv_RexxExp
if datatype(dv_1stChar, 'S')then
dv_OneVar=dv_OneVar||dv_1stChar
else
do
dv_RexxExp=dv_1stChar||dv_RexxExp
leave
end
end
call _RememberDumpedVar dv_OneVar
if pos('.',dv_OneVar)<>0 then
do
do while dv_OneVar<> ''
parse var dv_OneVar dv_ThisBit '.' dv_OneVar
call _RememberDumpedVar dv_ThisBit
end
end
end
when dv_1stChar='"' | dv_1stChar = "'" then
do
dv_EndQuotePos=pos(dv_1stChar,dv_RexxExp)
if dv_EndQuotePos=0 then
dv_RexxExp=''
else
dv_RexxExp=substr(dv_RexxExp,dv_EndQuotePos+1)
end
otherwise
nop
end
end
call value dv_StemDot|| '0',dv_VarCount
if dv_AutoDump='Y' then
call DumpVarsInExpressionNow dv_Stem,dv_VarHeading,dv_LineRoutine
return(dv_VarCount)

DumpVarsInExpressionNow:
dv_StemDot=arg(1)|| '.'
dv_VarHeading=arg(2)
dv_LineRoutine=arg(3)
if symbol(dv_StemDot|| '0') = 'VAR' then
dv_VarCount=value(dv_StemDot|| '0')
else
do
call _DumpVarsLineOutput 'DumpVar: could not find "' || dv_StemDot || '0' || '"'
return(0)
end
if dv_VarCount<>0&dv_VarHeading<> '' then
do
call _DumpVarsLineOutput ''
call _DumpVarsLineOutput dv_VarHeading
call _DumpVarsLineOutput copies('~',length(dv_VarHeading))
end
dv_ShowVarLng=dv_MaxVarLng
if dv_MaxVarLng>30 then
dv_ShowVarLng=30
do dv_Index=1 to dv_VarCount
dv_OneVar=value(dv_StemDot||dv_Index)
if length(dv_OneVar)>=dv_ShowVarLng then
ShowVar=dv_OneVar
else
ShowVar=right(dv_OneVar,dv_ShowVarLng)
dv_OneVarValue=value(translate(dv_OneVar))
if datatype(dv_OneVarValue, 'N')=0 then
do
call BIN2REXP dv_OneVarValue
dv_OneVarValue=dv_Value
end
call _DumpVarsLineOutput ShowVar|| ' = ' ||dv_OneVarValue
end
return

_RememberDumpedVar:
dv_ThisVar=arg(1)
if symbol(dv_ThisVar)='VAR' then
do
dv_AlreadyHave='N'
dv_ThisVarUpper=translate(dv_ThisVar)
do dv_Index=1 to dv_VarCount
if dv_ThisVarUpper=translate(value(dv_StemDot||dv_Index))then
do
dv_AlreadyHave='Y'
leave
end
end
if dv_AlreadyHave='N' then
do
dv_VarCount=dv_VarCount+1
call value dv_StemDot||dv_VarCount,dv_ThisVar
if length(dv_ThisVar)>dv_MaxVarLng then
dv_MaxVarLng=length(dv_ThisVar)
end
end
return

_DumpVarsLineOutput:
if dv_LineRoutine='' then
say arg(1)
else
interpret 'call ' || dv_LineRoutine || ' arg(1)'
return

BIN2REXP_START:
dv_Value=''
return

BIN2REXP_ONEBIT:
if dv_Value<> '' then
dv_Value=dv_Value|| ' || '
dv_Value=dv_Value||arg(1)
return

BIN2REXP_END:
return

EndDUMPVARXh:
HaveCapturedTrapDetails='N'
MacroBeingExpanded=''
LastLineAfterMacroRep=''
LastFileLine=''
LastLine=''
ErrorHookCount=0
call RexxHookInit
signal on NOVALUE name SimpleRexxTrapUninitializedVariable
signal on SYNTAX name SimpleRexxTrapSyntaxError
TrapHandler='SIMPLE'
MyBaseHomeDir="http://www.labyrinth.net.au/~dbareis/"
PgmHomePage=MyBaseHomeDir|| "ppwizard.htm"
PgmAuthorHomePage=MyBaseHomeDir|| "index.htm"
PgmAuthor="Dennis Bareis"
PgmAuthorEmail="dbareis@labyrinth.net.au"
ExpressionKilledUs=''
SyntaxOkRc=21924
SyntaxOkText='!CheckSyntax!'
CopyrightDisplayed='N'
CurrentOutFile=''
IncludeLevel=0
DoOnExit=''
TryQuoteListAny='"' || "'" || '^~!@#$%&*-+=?./\|`:' || xrange('DB'x, 'FE'x) || xrange('80'x, 'DA'x)
TryQuoteListSd="'" || '"'
TryQuoteListDs='"' || "'"
OnExitSleepForOk=0
OnExitSleepForError=2
SleepSwitch='N'
call RemoveColorCodes
call RemoveBeepCode
if translate(strip(arg(1)))='DEBUG' then
call DisplayCopyright
/*
*REXSYSTM.XH Version 00.365 By Dennis Bareis
*http://www.labyrinth.net.au/~dbareis/index.htm(db0@anz.com)
*/
trace off
parse version RexVersionInfo
if pos('REGINA',translate(RexVersionInfo))<>0 then
do
RexWhich='REGINA'
parse value translate(RexVersionInfo)with . 'REGINA_' RexVerRegina ' '
RexVerRegina=translate(RexVerRegina, '.', '_')
end
else
do
RexVerRegina=''
RexWhich='STANDARD_OS/2'
end
parse source RexSystemOpSys .
if RexSystemOpSys="WIN32" then
do
parse value uname()with RexSystemOpSys .
if RexSystemOpSys<> "WIN95" & RexSystemOpSys <> "WIN98" & RexSystemOpSys <> "WINNT" then
do
call RexSystemFailure 'Regina uname() returned "' || uname() || '" (expected WIN95, WIN98 or WINNT)'
end
end
if RexSystemOpSys="BEOS" then
RexSystemOpSys="UNIX"
RexSystmRexxPgmName='?';RexSystmRexxPgmName=RexGetFullSourceName()
if arg(2)<> '' then
call RexSystemFailure 'ARG(2) contains unexpected data of ' || arg(2) || '.'
if translate(strip(arg(1)))='DEBUG' then
do
call RexDumpSystemInfo
exit(0)
end
if RexWhich='STANDARD_OS/2' then
do
call RxFuncAdd 'SysSleep',        'RexxUtil', 'SysSleep'
call RxFuncAdd 'SysFileDelete',   'RexxUtil', 'SysFileDelete'
call RxFuncAdd 'SysSearchPath',   'RexxUtil', 'SysSearchPath'
call RxFuncAdd 'SysFileTree',     'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysTempFileName', 'RexxUtil', 'SysTempFileName'
call SetLocal
RexEnvVarPool='OS2ENVIRONMENT'
RexStdoutStream='STDOUT'
RexStderrStream='STDERR'
RexTmpFileCntr=random(90000)
end
else
do
OPTIONS 'NOEXT_COMMANDS_AS_FUNCS'
numeric digits 11
RexEnvVarPool='SYSTEM'
RexStdoutStream='<stdout>'
RexStderrStream='<stderr>'
end
if RexSystemOpSys<> "UNIX" then
do
RexDirChar='\'
RexOptionChar='/'
end
else
do
RexDirChar='/'
RexOptionChar='-'
end
signal REXSYSTM_1

RexDumpSystemInfo:
say 'Program Name  : ' ||RexSystmRexxPgmName
say 'Op System     : ' ||RexSystemOpSys
say 'Rexx Ver      : ' ||RexVersionInfo
say 'Which System  : ' ||RexWhich
if RexWhich='REGINA' then
say 'regina uname(): ' ||uname()
return

RexNeedReginaWorkAround:
if RexWhich='STANDARD_OS/2' then
return('N')
else
return('Y')

RexGetFullSourceName:
parse source . . TmpRexxSrc
if RexWhich='REGINA' then
TmpRexxSrc=stream(strip(TmpRexxSrc), 'c', 'query exists')
if TmpRexxSrc='' then
call RexSystemFailure 'Could not determine the name of the rexx program!'
return(TmpRexxSrc)

RexQueryExists:
if arg(1)='' then
return('')
else
return(stream(arg(1), 'c', 'query exists'))

RexGetNameOfTmpDir:call TRACE "OFF"
TmpDir=strip(GetEnv('TMP'))
if TmpDir='' then
TmpDir=strip(GetEnv('TEMP'))
if TmpDir='' then
do
if RexSystemOpSys="UNIX" then
TmpDir='/tmp'
end
if right(TmpDir,1)==RexDirChar then
TmpDir=left(TmpDir,length(TmpDir)-1)
return(TmpDir)

RedirectStdOutAndErr2:
if RedirMethod<> '' then
do
select
when RedirMethod="@bash" then
return(' >' || arg(1) || ' 2>&1')
when RedirMethod="@csh" then
return(' >& ' ||arg(1))
otherwise
do
r12Meth=RedirMethod
r12Pos=pos('{?}',r12Meth)
do while r12Pos<>0
r12Meth=left(r12Meth,r12Pos-1)||arg(1)||substr(r12Meth,r12Pos+3)
r12Pos=pos('{?}',r12Meth)
end
end
end
return(' ' ||r12Meth)
end
if RexSystemOpSys="DOS" | RexSystemOpSys = "WIN95" | RexSystemOpSys = "WIN98" then
do
return(' >' ||arg(1))
end
else
do
return(' >' || arg(1) || ' 2>&1')
end

NameOfNulDevice:
if RexSystemOpSys="UNIX" then
return('/dev/null')
else
return('nul')

AllCmdOutput2Nul:
return(RedirectStdOutAndErr2(NameOfNulDevice()))

AddressCmd:call TRACE "OFF"
SysCmd2Exec=arg(1)
if RexWhich='STANDARD_OS/2' then
SysCmd2Exec='@' ||SysCmd2Exec
call DebugAddressCmdBefore SysCmd2Exec
SysCmd2Exec
SysCmdRc=Rc
FileIndex=2
SysCmdFile=arg(FileIndex)
do while SysCmdFile<> ''
call DebugAddressCmdOutput SysCmdFile, 'H1'
call DebugAddressCmdOutput copies('~', length(SysCmdFile)), 'H2'
if stream(SysCmdFile, 'c', 'query exists') = '' then
call DebugAddressCmdOutput '*File does not exist*',     '!'
else
do
SysCmdLine=0
CloseRc=stream(SysCmdFile, 'c', 'close')
do while lines(SysCmdFile)<>0
SysCmdLine=SysCmdLine+1
call DebugAddressCmdOutput linein(SysCmdFile),SysCmdLine
end
CloseRc=stream(SysCmdFile, 'c', 'close')
end
FileIndex=FileIndex+1
SysCmdFile=arg(FileIndex)
end
call DebugAddressCmdAfter SysCmdRc
Rc=SysCmdRc
return(SysCmdRc)

_filespec:call TRACE "OFF"
fsCmd=translate(arg(1))
select
when fsCmd='D' | fsCmd = 'DRIVE' then
do
if RexSystemOpSys="UNIX" then
return('')
fsPos=pos(':',arg(2))
if fsPos=0 then
return('')
else
return(left(arg(2),fsPos))
end
when fsCmd='P' | fsCmd = 'PATH' then
do
fsStartWith=substr(arg(2),length(_filespec('D',arg(2)))+1)
fsPos=lastpos(RexDirChar,fsStartWith)
if fsPos=0 then
return('')
else
return(left(fsStartWith,fsPos))
end
when fsCmd='N' | fsCmd = 'NAME' then
do
return(substr(arg(2),length(_filespec('L',arg(2)))+1))
end
when fsCmd='L' | fsCmd = 'LOCATION' then
do
return(_filespec('D', arg(2)) || _filespec('P',arg(2)))
end
when fsCmd='E' | fsCmd = 'EXTN' then
do
fsDotPos=lastpos('.',arg(2))
if fsDotPos=0 then
return('')
else
return(substr(arg(2),fsDotPos+1))
end
when fsCmd='W' | fsCmd = 'WITHOUTEXTN' then
do
fsDotPos=lastpos('.',arg(2))
if fsDotPos=0 then
return(arg(2))
else
return(left(arg(2),fsDotPos-1))
end
when fsCmd='B' | fsCmd = 'BASENAME' then
do
return(_filespec('W', _filespec('N',arg(2))))
end
otherwise
call RexSystemFailure 'Unknown _filespec() command of "' || arg(1) || '"'
end
return

_SysSleep:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
do
call SysSleep arg(1)
return
end
call sleep arg(1)
return

_SysFileTree:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
return(SysFileTree(arg(1),arg(2),arg(3),arg(4),arg(5)))
if pos('D',arg(3))<>0 then
stfType='D'
else
stfType='F'
TmpDirFile=RexGetTmpFileName()
if RexSystemOpSys<> "UNIX" then
do
DirCmd='dir /B '
if pos('S',arg(3))<>0 then
DirCmd=DirCmd|| "/S "
if stfType='F' then
DirCmd=DirCmd|| "/A-D "
else
DirCmd=DirCmd|| "/AD "
UseMask=arg(1)
if RexSystemOpSys<> "DOS" then
UseMask='"' || UseMask || '"'
DirCmd=DirCmd||UseMask||RedirectStdOutAndErr2(TmpDirFile)
end
else
do
DirCmd='find ' || _filespec('L', arg(1)) || ' '
if pos('FREEBSD',translate(uname()))=0 then
DirCmd=DirCmd|| '-noleaf '
if pos('S',arg(3))=0 then
do
if pos('FREEBSD',translate(uname()))=0 then
DirCmd=DirCmd|| '-maxdepth 1 '
else
DirCmd=DirCmd|| '-prune '
end
if stfType='F' then
DirCmd=DirCmd|| "-type f "
else
DirCmd=DirCmd|| "-type d "
stfSName=_filespec('N',arg(1))
if stfSName<> '' then
DirCmd=DirCmd|| '-name "' || stfSName || '"'
DirCmd=DirCmd||RedirectStdOutAndErr2(TmpDirFile)
end
Rc=AddressCmd(DirCmd,TmpDirFile)
LastSlash=lastpos(RexDirChar,arg(1))
CloseRc=stream(TmpDirFile, 'c', 'close')
TmpLine=0
do while lines(TmpDirFile)<>0
AFile=linein(TmpDirFile)
if AFile='' | AFile = '.' | AFile = '..' then
iterate
if RexSystemOpSys="UNIX" & stfType = 'D' then
do
if AFile=_filespec('L',arg(1))then
iterate
end
if LastSlash<>0 then
do
if pos(RexDirChar,AFile)==0 then
AFile=left(arg(1),LastSlash)||AFile
end
if stfType='F' then
do
AFile=stream(AFile, 'c', 'query exists')
if AFile='' then
iterate
end
else
do
if RexWhich='REGINA' then
do
if stream(AFile, 'c', 'query exists') = '' then
iterate
end
else
do
if pos(' ',AFile)<>0 then
iterate
end
end
TmpLine=TmpLine+1
call _valueS arg(2)|| '.' ||TmpLine,strip(AFile)
end
CloseRc=stream(TmpDirFile, 'c', 'close')
DeleteRc=_SysFileDelete(TmpDirFile)
call _valueS arg(2)|| '.0',TmpLine
return(0)

_SysFileDelete:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
return(SysFileDelete(arg(1)))
if RexSystemOpSys="DOS" | RexSystemOpSys = "WIN95" | RexSystemOpSys = "WIN98" then
return(AddressCmd('if exist ' || arg(1) || ' del ' ||arg(1)||AllCmdOutput2Nul()))
else
do
if RexSystemOpSys="UNIX" then
return(AddressCmd('rm -f ' ||arg(1)||AllCmdOutput2Nul()))
else
return(AddressCmd('del ' ||arg(1)||AllCmdOutput2Nul()))
end

RexGetTmpFileName:call TRACE "OFF"
if arg(1)<> '' then
TmpFileM=arg(1)
else
do
if RexSystemOpSys<> "UNIX" then
TmpFileM='RSTM????.TMP'
else
do
TmpFileM=GetEnv('USER')
if TmpFileM='' then
TmpFileM=GetEnv('user')
if TmpFileM='' then
TmpFileM='?????.rstm'
else
TmpFileM=TmpFileM|| '_?????.rstm'
end
end
TmpFileM=RexGetNameOfTmpDir()||RexDirChar||TmpFileM
if RexWhich='STANDARD_OS/2' then
do
TmpFileF=SysTempFileName(TmpFileM)
if TmpFileF='' then
do
RexTmpFileCntr=RexTmpFileCntr+1
TmpFileF='C_' || right(RexTmpFileCntr, 6, '0') || '.TMP'
end
return(TmpFileF)
end
TmpRandom=right(time('S'),3)||random(99999)
TmpRandomAdd=0
do until stream(TmpFileA, 'c', 'query exists') = ''
TmpRandomS=reverse(d2x(TmpRandom+TmpRandomAdd))
TmpRandomAdd=TmpRandomAdd+1
TmpFileA=TmpFileM
TmpWhich=1
QmPos=pos('?',TmpFileA)
do while QmPos<>0
TmpReplace=substr(TmpRandomS,TmpWhich,1)
TmpWhich=TmpWhich+1
if TmpReplace='' then
TmpWhich=1
else
do
TmpFileA=overlay(TmpReplace,TmpFileA,QmPos)
QmPos=pos('?',TmpFileA)
end
end
end
return(TmpFileA)

GetEnv:call TRACE "OFF"
rsGetEnv=value(arg(1),,RexEnvVarPool)
if rsGetEnv=='' & arg(2) = 'Y' then
call RexSystemFailure 'Could not find the environment variable "' || arg(1) || '"'
call DebugGetEnv arg(1),rsGetEnv
return(rsGetEnv)

SetEnv:call TRACE "OFF"
return(value(arg(1),arg(2),RexEnvVarPool))

_valueS:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
return(value(arg(1),arg(2)))
return(value(translate(arg(1)),arg(2)))

_valueG:call TRACE "OFF"
if RexWhich='STANDARD_OS/2' then
return(value(arg(1)))
return(value(arg(1)))

REXSYSTM_1:
PpWizardPgmName=RexSystmRexxPgmName
PpWizardOpSys=RexSystemOpSys
call InitConsoleOutputVarsPass2
if RexSystemOpSys<> "UNIX" then
call SetDebugChars '-1,-1,25',  'Y'
else
call SetDebugChars '-1,-1,165', 'Y'
LastSystemCmd="none"
LastSystemCmdFull="none"
LastSystemRc=999
signal System_2

ProcessSystem:
Rest=PerformReplacementsInCmdsParameters(arg(1))
Log2File=GetQuotedText(Rest, "Rest")
LastSystemCmd=GetQuotedRest(Rest)
select
when RexSystemOpSys="OS/2" then
CmdProc='CMD.EXE /c '
otherwise
CmdProc=''
end
LastSystemCmdFull=CmdProc||LastSystemCmd
DeleteFileAfter='N'
select
when translate(Log2File)='ASIS' then
Log2File=''
when Log2File='-' then
Log2File=NameOfNulDevice()
when Log2File='?' then
do
Log2File=RexGetTmpFileName()
DeleteFileAfter='Y'
end
otherwise
nop
end
if Log2File<> '' then
LastSystemCmdFull=LastSystemCmdFull||RedirectStdOutAndErr2(Log2File)
LastSystemRc=AddressCmd(LastSystemCmdFull,Log2File)
if DeleteFileAfter='Y' then
call _SysFileDelete(Log2File)
return(0)

System_2:
call InitTransformationCode
signal Transfrm_3

InitTransformationCode:
TransformCode=''
return

ProcessTransform:
HashDefRexx=arg(1)
if HashDefRexx<> '' then
do
HashDefRexx=PerformReplacementsInCmdsParameters(HashDefRexx)
HashDefRexx=GetQuotedText(HashDefRexx)
end
if HashDefRexx<> '' then
do
if OptionDebugOn='Y' then
call DebugLine 'Start of transformation block "' || HashDefRexx || '"'
if TransformCode<> '' then
CryAndDie("Already in tranformation block started at " ||TransformStartLoc)
TransformStartLoc=CurrentSourceLocation()
TransformCode=MacroGet(HashDefRexx)
TransformCode=PerformReplacementsInCmdsParameters(TransformCode)
end
else
do
if OptionDebugOn='Y' then
call DebugLine "End of transformation block"
if TransformCode='' then
CryAndDie('We were not in a tranformation block!')
TransformCode=''
end
return(0)

Transfrm_3:
NextIdStr=''
NextIdMarker='@@'
NextIdMask='z*_'
NextIdCounter=0
signal NextId_4

ProcessNextId:
nidParms=arg(1)
if nidParms='' then
nidParm=''
else
do
nidParms=PerformReplacementsInCmdsParameters(nidParms)
nidParm=GetQuotedText(nidParms, 'nidParms')
nidParmU=translate(nidParm)
if nidParmU='OFF' then
do
if OptionDebugOn='Y' then
call DebugLine 'Turning off Next ID processing'
NextIdStr=''
return(0)
end
if nidParmU='ON' then
do
if OptionDebugOn='Y' then
call DebugLine 'Resuming Next ID processing (counter not updated)'
NextIdCounter=NextIdCounter-1
nidParm=''
nidParms=''
end
end
if nidParm<> '' then
NextIdMarker=nidParm
if nidParms<> '' then
do
nidParm=GetQuotedText(nidParms, 'nidParms')
if nidParm<> '' then
NextIdMask=nidParm|| '_'
if nidParms<> '' then
do
nidParm=GetQuotedText(nidParms)
if nidParm<> '' then
NextIdCounter=nidParm-1
end
end
NextIdCounter=NextIdCounter+1
NextIdStr=ReplaceString(NextIdMask, '*',ConvertDecToBaseX(NextIdCounter))
if OptionDebugOn='Y' then
call DebugLine 'Any "' || NextIdMarker || '" strings will be replaced with "' || NextIdStr || '"'
return(0)

ConvertDecToBaseX:
parse arg z1_Dec,z1_Base
if z1_Base>36 then
CryAndDie("Can't convert to base " ||z1_Base)
if z1_Base='' then
z1_Base=36
z1_Digits=left(DecimalDigits||LowerCase,z1_Base)
z1_X=''
do until z1_Dec=0
z1_X=substr(z1_Digits,(z1_Dec//z1_Base)+1,1)||z1_X
z1_Dec=z1_Dec%z1_Base
end
return(z1_X)

NextId_4:
call InitINTERCEPTCode
signal Intercpt_5

InitINTERCEPTCode:
InterceptCode=''
InterceptStartLoc=''
InterceptOffMarker=''
return

ProcessIntercept:
RexxCode=arg(1)
if RexxCode<> '' then
do
RexxCode=PerformReplacementsInCmdsParameters(RexxCode)
RexxCode=GetQuotedText(RexxCode)
end
if RexxCode<> '' then
do
if OptionDebugOn='Y' then
call DebugLine 'Start of INTERCPT block "' || RexxCode || '"'
if InterceptCode<> '' then
CryAndDie("Already in tranformation block started at " ||InterceptStartLoc)
InterceptStartLoc=CurrentSourceLocation()
InterceptOffMarker=arg(2)
InterceptCode=MacroGet(RexxCode)
InterceptCode=PerformReplacementsInCmdsParameters(InterceptCode)
end
else
do
if OptionDebugOn='Y' then
call DebugLine "End of INTERCPT block"
if InterceptCode='' then
CryAndDie('We were not in a INTERCPT block!')
InterceptCode=''
end
return(0)

Intercpt_5:
OutputHoldLvl=0
call InitOutputHold
signal OutpHold_6

InitOutputHold:
HoldingOutput='N'
HeldOutput=''
OutpHoldStartLoc=''
return

OutputHoldPushAndClear:
OutputHoldLvl=OutputHoldLvl+1
OutHold_.OutputHoldLvl.!HoldingOutput=HoldingOutput
OutHold_.OutputHoldLvl.!HeldOutput=HeldOutput
OutHold_.OutputHoldLvl.!OutpHoldStartLoc=OutpHoldStartLoc
call InitOutputHold
return

OutputHoldPop:
HoldingOutput=OutHold_.OutputHoldLvl.!HoldingOutput
HeldOutput=OutHold_.OutputHoldLvl.!HeldOutput
OutpHoldStartLoc=OutHold_.OutputHoldLvl.!OutpHoldStartLoc
OutputHoldLvl=OutputHoldLvl-1
return

DieIfHoldingOutput:
if HoldingOutput='Y' then
CryAndDie('Missing #OutputHold (end)', 'Block started at ' ||OutpHoldStartLoc)
return

ProcessHashOutputHold:
OrexxRexx=arg(1)
if OrexxRexx='' then
do
if OptionDebugOn='Y' then
call DebugLine 'Start of hold output block'
if HoldingOutput='Y' then
CryAndDie("Already in hold output block started at " ||OutpHoldStartLoc)
call FlushQueuedOutput
HoldingOutput='Y'
OutpHoldStartLoc=CurrentSourceLocation()
end
else
do
if OptionDebugOn='Y' then
call DebugLine "End of hold output block - Held " || length(HeldOutput) || ' byte(s)'
if HoldingOutput='N' then
CryAndDie('We were not in a hold output block!')
call FlushQueuedOutput
OrexxRexx=PerformReplacementsInCmdsParameters(OrexxRexx)
OrexxRexx=GetQuotedText(OrexxRexx)
if translate(OrexxRexx)='DROP' then
HeldOutput=''
else
do
OutputModCode=MacroGet(OrexxRexx)
OutputModCode=PerformReplacementsInCmdsParameters(OutputModCode)
call ExecRexxCmd OutputModCode
end
if HeldOutput\=='' then
do
if OptionDebugOn='Y' then
call DebugLine 'Writing ' || length(HeldOutput) || ' byte(s) to output'
call DirectToOutputFile HeldOutput
end
call InitOutputHold
end
return(0)

OutpHold_6:
signal RexxHook_7

RexxHookSetBuildingParms:
parse arg HookBuildParmInput,HookBuildParmOutput,HookBuildParmTemplate
return

RexxHookInit:
RexxHookBefore=''
RexxHookAfter=''
RexxHookWarning=''
RexxHookError=''
RexxHookGetFileList=''
call RexxHookSetBuildingParms
return

RexxHookSet:
parse arg ThisCmd,ThisCmdOptions
parse var ThisCmdOptions rhWhen';'rhCmd
rhWhen=translate(rhWhen)
do until rhWhen=''
parse var rhWhen rhWhen1','rhWhen
rhDone='N'
if rhWhen1='' | abbrev("BEFORE",rhWhen1)then
do
rhDone='Y'
RexxHookBefore=rhCmd
end
if rhWhen1='' | abbrev("AFTER",rhWhen1)then
do
rhDone='Y'
RexxHookAfter=rhCmd
end
if rhWhen1='' | abbrev("WARNING",rhWhen1)then
do
rhDone='Y'
RexxHookWarning=rhCmd
end
if rhWhen1='' | abbrev("ERROR",rhWhen1)then
do
rhDone='Y'
RexxHookError=rhCmd
end
if rhWhen1='' | abbrev("GETFILELIST",rhWhen1)then
do
rhDone='Y'
RexxHookGetFileList=rhCmd
end
if rhDone='N' then
CryAndDie('The hook type of "' || rhWhen1 || '" is unknown')
end
return

CallHook:
parse arg CallHook,CallHookOkParmsOk,Parm1,Parm2,Parm3,Parm4
BuildDetailParms=', HookBuildParmInput, HookBuildParmOutput, HookBuildParmTemplate'
HookSpecificParms=', Parm1, Parm2, Parm3, Parm4'
select
when CallHook="WARNING" then
HookRexxCmd=RexxHookWarning
when CallHook="BEFORE" then
HookRexxCmd=RexxHookBefore
when CallHook="AFTER" then
HookRexxCmd=RexxHookAfter
when CallHook="ERROR" then
do
ErrorHookCount=ErrorHookCount+1
if ErrorHookCount>1 then
return
HookRexxCmd=RexxHookError
end
when CallHook="GETFILELIST" then
do
HookRexxCmd=RexxHookGetFileList
BuildDetailParms=''
end
end
SrcLineLoc=CurrentSourceLocation('')
if OptionDebugOn='Y' then
do
call DebugLine 'Calling hook: ' || CallHook || ' - ' ||HookRexxCmd
call DebugIncrement 1
end
HookCmd='HookRc =  "' || HookRexxCmd || '"("00.050", SrcLineLoc, "' || CallHook || '"' || BuildDetailParms || HookSpecificParms || ')'
HookRc='?'
signal ON SYNTAX NAME SyntaxErrorInHook
Interpret HookCmd
if OptionDebugOn='Y' then
call DebugLine 'Rc = ' ||HookRc
if abbrev(HookRc, 'OK:')=0 then
do
call DumpVarsInExpression HookCmd,, 'HOOK VARIABLES', 'Line1'
CryAndDie('Hook Command Failed: ' || HookCmd, "Hook's Return Code : " ||HookRc)
end
OkParms=substr(HookRc,4)
if OkParms<> '' & CallHookOkParmsOk <> 'Y' then
CryAndDie('OK parameters not allowed on "' || CallHook || '" hooks.')
if OptionDebugOn='Y' then
call DebugIncrement-1
return(OkParms)

SyntaxErrorInHook:
CryAndDie('Hook Cmd Failed: ' ||HookCmd)

RexxHook_7:
WarningSpecs=''
signal Warning_8

OutputWarningToScreen:
WarningPrefix=strip( 'WARNING ' ||strip(arg(1)))
WarningTextP=arg(2)
if IncludeLevel=0 then
LineText=''
else
LineText='(@' || AddCommasToDecimalNumber(IncludeLineNumber) || ')'
WarningTextUn=WarningPrefix|| ': ' ||WarningTextP
WarningText=LineText||WarningTextUn
WarningTextU=translate(WarningText)
IgnoreList=WarningSpecs
do while IgnoreList<> ''
parse var IgnoreList IgnoreThis (PathDelimiterChar) IgnoreList
IgnoreThis1=left(IgnoreThis,1)
IgnoreThisR=substr(IgnoreThis,2)
if IgnoreThis1<> '-' & IgnoreThis1 <> '+' & IgnoreThis1 <> '!' then
do
IgnoreThis1='-'
IgnoreThisR=IgnoreThis
IgnoreThis=IgnoreThis1||IgnoreThisR
end
if IgnoreThisR='' then
iterate
if IgnoreThisR='*' |pos(IgnoreThisR,WarningTextU)<>0 then
do
if OptionDebugOn='Y' then
call DebugLine 'Warning matched the spec => ' ||IgnoreThis
select
when IgnoreThis1='!' then
do
if OptionDebugOn='Y' then
call DebugLine 'Normal Warning => ' ||WarningText
leave
end
when IgnoreThis1='+' then
do
CryAndDie(WarningTextUn,, 'This warning was promoted to a fatal error by "' || IgnoreThis || '"')
end
when IgnoreThis1='-' then
do
if OptionDebugOn='Y' then
call DebugLine 'Ignoring Warning => ' ||WarningText
return
end
end
end
end
if RexxHookWarning<> '' then
do
WarnHookRc=translate(CallHook("WARNING", 'Y',WarningTextP))
if WarnHookRc='IGNORE+' then
Warnings=Warnings+1
if WarnHookRc='IGNORE' | WarnHookRc = 'IGNORE+' then
do
if OptionDebugOn='Y' then
call DebugLine "HOOK said to drop warning: " ||WarningTextP
return
end
if WarnHookRc<> '' then
CryAndDie('Unknown warning hook return code of: ' ||WarnHookRc)
end
call Line1 copies("  ", IncludeLevel) || WarningColor || '   ' ||WarningText||Reset
Warnings=Warnings+1
return

WarnAboutDepreciatedFeature:
call OutputWarningToScreen 'DEP0', 'Replace OBSOLETE Feature ASAP -> ' ||arg(1)
return

ProcessHashWarning:
Rest=PerformReplacementsInCmdsParameters(arg(1))
WarningCde=GetQuotedText(Rest, "Rest")
WarningMsg=GetQuotedRest(Rest)
call OutputWarningToScreen WarningCde,WarningMsg
return(0)

WARNINGS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'WARNINGS', 'Ignoring any warnings containing "' || WarningSpecs || '"'
return

WARNINGS_SET:
Tags=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'WARNINGS', 'Setting default ignore warnings to "' || Tags || '"'
Default4_WarningSpecs=Tags
return(0)
end
if Tags=='' then
Tags=Default4_WarningSpecs
if translate(Tags)=='NULL' then
Tags=''
WarningSpecs=Tags
call WARNINGS_DEBUG
return

WARNINGS_GET:
call WARNINGS_DEBUG
return(WarningSpecs)

Warning_8:
signal Tabs_9

TABS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'TABS', 'TABS is set to "' || OptionTabsString || '" (' || TabsMode || ')'
return

TABS_SET:
OptionTabsString=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'TABS', 'Setting default TABS to "' || OptionTabsString || '"'
DefaultTabsString=OptionTabsString
return(0)
end
if OptionTabsString=='' then
OptionTabsString=DefaultTabsString
WidthOfTab=0
OptionTabs=left(OptionTabsString,1)
select
when datatype(OptionTabsString, 'W')then
do
OptionTabs='E'
WidthOfTab=OptionTabsString
TabsMode='expanding tabs, fixed tabstop every ' || WidthOfTab || ' characters'
end
when OptionTabsString='WARNINGS' then
TabsMode='display warnings'
when OptionTabsString='IGNORE' then
TabsMode='ignore tabs, leave in place'
when OptionTabsString='TOSPACES' then
TabsMode='converting each tab to one space'
otherwise
CryAndDie('Invalid TABS option of "' || OptionTabsString || '"')
end
call TABS_DEBUG
return

TABS_GET:
call TABS_DEBUG
return(OptionTabsString)

Tabs_9:
SrTypePre=d2c(254)||d2c(174)
SrTypeSuf=d2c(175)
call SrInit
signal SR_TYPE_10

SrInit:
SrCaseIns=SrTypePre|| 'CI' ||SrTypeSuf
SrCaseIns_P=length(SrCaseIns)+1
SrFixed=SrTypePre|| 'FiX' ||SrTypeSuf
SrFixed_P=length(SrFixed)+1
return

CompareReplaceFixed:call TRACE "OFF"

CompareReplaceFixed2:
sr_FromOrig=arg(1)
sr_SSpec=arg(2)
sr_CaseInSens='N'
sr_From=sr_FromOrig
sr_From_L=length(sr_From)
if arg(3, 'E')=1 then
sr_NoMatch=sr_From
else
sr_NoMatch=0
do while sr_SSpec<> ''
parse var sr_SSpec sr_CmdChar +1 sr_SSpec
select
when sr_CmdChar='@' then
do
parse var sr_SSpec sr_Operator ',' sr_Posn '=' +1 sr_Delim +1 sr_CompWith (sr_Delim) sr_SSpec
sr_Length=length(sr_CompWith)
if datatype(sr_Posn, 'W')=0 then
CryAndDie("CompareReplaceFixed()", "The position must be a whole number, '" || sr_Posn || "' is invalid")
if sr_Posn<0 then
do
sr_Posn=sr_From_L+sr_Posn+1
if sr_Posn<1 then
return(sr_NoMatch)
end
if sr_CaseInSens='N' then
sr_bit=substr(sr_From,sr_Posn,sr_Length)
else
sr_bit=translate(substr(sr_From,sr_Posn,sr_Length))
select
when sr_Operator='=' then
srCompRc=sr_bit=sr_CompWith
when sr_Operator='<>' then
srCompRc=sr_bit<>sr_CompWith
when sr_Operator='==' then
srCompRc=sr_bit==sr_CompWith
when sr_Operator='\==' then
srCompRc=sr_bit\==sr_CompWith
when sr_Operator='<' then
srCompRc=sr_bit<sr_CompWith
when sr_Operator='>' then
srCompRc=sr_bit>sr_CompWith
when sr_Operator='<=' then
srCompRc=sr_bit<=sr_CompWith
when sr_Operator='>=' then
srCompRc=sr_bit>=sr_CompWith
otherwise
CryAndDie("CompareReplaceFixed()", "Unsupported operator of '" || sr_Operator || "' used", '', 'ONLY "=, <>, ==, \==, <, >, <=, >=" are supported!')
end
if srCompRc=0 then
return(sr_NoMatch)
end
when sr_CmdChar='!' then
do
parse var sr_SSpec sr_CmdChar2 +1 sr_SSpec
select
when sr_CmdChar2='B' | sr_CmdChar2 = 'L' | sr_CmdChar2 = 'T' then
do
sr_From=strip(sr_From,sr_CmdChar2)
sr_From_L=length(sr_From)
end
when sr_CmdChar2='I' then
do
sr_From=space(sr_From)
sr_From_L=length(sr_From)
end
when sr_CmdChar2='S' then
sr_CaseInSens='N'
when sr_CmdChar2='i' then
sr_CaseInSens='Y'
otherwise
CryAndDie("CompareReplaceFixed()", 'Invalid "!" command of "' || sr_CmdChar2 || '"')
end
end
when sr_CmdChar='?' then
do
parse var sr_SSpec sr_Operator +1 sr_Delim +1 sr_LookFor (sr_Delim) sr_SSpec
if sr_CaseInSens='N' then
sr_Pos=pos(sr_LookFor,sr_From)
else
sr_Pos=pos(sr_LookFor,translate(sr_From))
if sr_Operator='=' then
do
if sr_Pos=0 then
return(sr_NoMatch)
end
else
do
if sr_Pos<>0 then
return(sr_NoMatch)
end
end
otherwise
CryAndDie("CompareReplaceFixed()", 'Invalid compare command of "' || sr_CmdChar || '"')
end
end
if arg(3, 'O')=1 then
return(1)
sr_RSpec=arg(3)
ReplaceCount=ReplaceCount+1
sr_From=sr_FromOrig
sr_From_L=length(sr_From)
sr_output=''
do forever
parse var sr_RSpec sr_Before '@' sr_RSpec
sr_Output = sr_Output || sr_Before
if sr_RSpec=='' then
return(sr_Output)
parse var sr_RSpec sr_CmdChar +1 sr_RSpec
select
when sr_CmdChar='$' then
do
parse var sr_RSpec sr_Posn ',' sr_Length ';' sr_RSpec
if sr_Posn<0 then
do
sr_Posn=sr_From_L+sr_Posn+1
if sr_Posn<1 then
return(sr_From)
end
if sr_Length='*' then
sr_Output=sr_Output||substr(sr_From,sr_Posn)
else
sr_Output=sr_Output||substr(sr_From,sr_Posn,sr_Length)
end
when sr_CmdChar='=' then
do
parse var sr_RSpec sr_Delim +1 sr_Exec (sr_Delim) sr_RSpec
CompareString=sr_From
call ExecRexxCmd('sr_Output = sr_Output || ' ||sr_Exec)
end
when sr_CmdChar='@' then
sr_Output=sr_Output|| '@'
otherwise
CryAndDie("CompareReplaceFixed()", 'Invalid replace command of "' || sr_CmdChar || '"')
end
end

SR_TYPE_10:
DependsOnFmtVer="FORMAT 00.157"
call ClearDependancyTimeStampCache
signal DEPENDON_11

_CheckedLineout:
Lineout.FileName=arg(1)
Lineout.TheLine=arg(2)
if 0<>lineout(Lineout.FileName,Lineout.TheLine)then
CryAndDie('Write to "' || Lineout.FileName || '" failed!')
return

NeedToRemake:
DepFile4=arg(1)
if OptionDependsOn='' then
do
call DebugLine 'No Dependancy file to check - Need to make'
DepFileName=''
return("Y")
end
DepFileName=GenerateFileName(DepFile4,OptionDependsOn, 'Y')
if _NeedToRemakeCheckDependencies()='N' then
do
if OptionSeeDependsProgress='Y' then
call Line1 ''
return('N')
end
call MustDeleteFile DepFileName
InputDepCount=0
OutputDepCount=0
return('Y')

ClearDependancyTimeStampCache:
TimeStampCount=0
return

GetFileDateTimeButDontWarnOnError:
tsFile=arg(1)
do TimeIndex=1 to TimeStampCount
if tsFile==TimeStamp.TimeIndex.TSNAME then
return(TimeStamp.TimeIndex.TSTIME)
end
if SafeQueryExists(tsFile)=='' then
Ts=-1
else
Ts=GetFileTimeStamp(tsFile)
TimeStampCount=TimeStampCount+1
TimeStamp.TimeStampCount.TSNAME=tsFile
TimeStamp.TimeStampCount.TSTIME=Ts
return(Ts)

_ShowDependancyCheckProgress:
if OptionSeeDependsProgress='Y' then
call Line1 '  ?> ' ||arg(1)
else
call DebugLine arg(1)
return

_NeedToRemakeCheckDependencies:
TitleText='Checking Dependencies - "' || _filespec('name', CurrentOutFile) || '"'
if OptionSeeDependsProgress='N' then
call DebugLine TitleText
else
do
call Line1 TitleColor||TitleText
call Line1 copies('~',length(TitleText))||Reset
end
OutputTime=GetFileDateTimeButDontWarnOnError(CurrentOutFile)
if OutputTime=-1 then
do
call _ShowDependancyCheckProgress CurrentOutFile|| ' does not exist.'
return('Y')
end
if SafeQueryExists(DepFileName)='' then
do
call _ShowDependancyCheckProgress DepFileName|| ' does not exist.'
return('Y')
end
CloseRc=stream(DepFileName, 'c', 'close')
OpenRc=stream(DepFileName, 'c', 'open read')
DependLine=linein(DepFileName)
if DependLine<>DependsOnFmtVer then
do
call _ShowDependancyCheckProgress 'Dependency formatting is not at current level'
CloseRc=stream(DepFileName, 'c', 'close')
return('Y')
end
ReMake='N'
do while lines(DepFileName)<>0
DependLine=linein(DepFileName)
if DependLine='' then
iterate
parse var DependLine DepType DependLine
WhatStamped=GetQuotedText(DependLine, "DependLine")
LineStamp=GetQuotedRest(DependLine)
call _ShowDependancyCheckProgress 'Checking: "' || WhatStamped || '"'
ThisInputDepFile=WhatStamped
DependantTime=GetDependsStamp(LineStamp)
if DependantTime=-1 then
do
call _ShowDependancyCheckProgress "Can't locate the dependant file (" || DepType || ")!"
ReMake='Y'
leave
end
if DependantTime<>LineStamp then
do
call _ShowDependancyCheckProgress "The stamp of " || DepType || " differs from last make."
ReMake='Y'
leave
end
end
CloseRc=stream(DepFileName, 'c', 'close')
if ReMake='N' then
call _ShowDependancyCheckProgress 'No need to remake...'
return(ReMake)

GetDependsStamp:
gds4PrevValue=arg(1)
if left(ThisInputDepFile,1)='*' then
do
Stamp4U=translate(ThisInputDepFile)
select
when abbrev(Stamp4U, "*EXPIRES=")then
do
ExpWhen=translate(substr(ThisInputDepFile,10))
if ExpWhen<> 'NOW' then
CryAndDie('Sorry but only support value of "NOW" on expires dependancy check')
Val1='always expires!'
Val2=translate(Val1)
if gds4PrevValue=Val2 then
return(Val1)
else
return(Val2)
end
when abbrev(Stamp4U, "*EXEC=")then
do
TheCmd=substr(ThisInputDepFile,7)
TmpFile=RexGetTmpFileName("DEPON???.???")
call AddressCmd TheCmd|| ' >' || TmpFile || ' 2>&1'
ExecRc=Rc
call DebugLine 'Depend value is result of (Rc=' || ExecRc || '): ' ||TheCmd
CloseRc=stream(TmpFile, 'c', 'close')
TheCmdVal=charin(TmpFile,,999999)
CloseRc=stream(TmpFile, 'c', 'close')
TheCmdVal=translate(TheCmdVal,, '0D0A1A'x, ' ')
TheCmdVal='RC=' || ExecRc || '->' ||TheCmdVal
return(TheCmdVal)
end
when abbrev(Stamp4U, "*FILES=")then
do
TheMask=substr(ThisInputDepFile,8)
if left(TheMask,1)<> '+' then
sdDo='N'
else
do
sdDo='Y'
TheMask=substr(TheMask,2)
end
call GetListOfFiles TheMask, 'DepDirList',sdDo
DirStamp=DepDirList.0|| ' files'
do DepIndex=1 to DepDirList.0
DirStamp=DirStamp|| '; ' || DepDirList.DepIndex || '=' ||GetFileDateTimeButDontWarnOnError(DepDirList.DepIndex)
end
return(DirStamp)
end
otherwise
nop
end
end
if RexSystemOpSys<> "UNIX" then
ThisInputDepFile=translate(ThisInputDepFile)
return(GetFileDateTimeButDontWarnOnError(ThisInputDepFile))

AddInputFileToDependancyList:call TRACE "OFF"
if DepFileName='' then
return('N')
ThisInputDepFile=arg(1)
InputFileStamp=arg(2)
if InputFileStamp='' then
InputFileStamp=GetDependsStamp(InputFileStamp)
do LookIndex=1 to InputDepCount
if ThisInputDepFile=InputDepFile.LookIndex then
return('N')
end
InputDepCount=InputDepCount+1
InputDepFile.InputDepCount=ThisInputDepFile
InputDepStamp.InputDepCount=InputFileStamp
return('Y')

AddOutputFileToDependancyList:call TRACE "OFF"
if DepFileName='' then
return('N')
ThisOutputDepFile=arg(1)
do LookIndex=1 to OutputDepCount
if ThisOutputDepFile=OutputDepFile.LookIndex then
return('N')
end
OutputDepCount=OutputDepCount+1
OutputDepFile.OutputDepCount=ThisOutputDepFile
return('Y')

_OutputDepWhatToFile:
DepWhat=arg(1)
DepWhatQ=QuoteIt(DepWhat)
DepWhat=DepWhatQ||DepWhat||DepWhatQ
return(DepWhat)

CreateDependancyFileFromLists:
if DepFileName='' then
return
call DebugLine 'Making the dependancy file (' || DepFileName || ')'
call DebugIncrement 1
call MakeDirectoryTree _filespec('drive', DepFileName) || _filespec('path',DepFileName)
call ClearDependancyTimeStampCache
call _CheckedLineout DepFileName,DependsOnFmtVer
call _CheckedLineout DepFileName, ''
DepWhatPad=0
do LookIndex=1 to OutputDepCount
call DebugLine 'Add OUTPUT dependancy : ' ||OutputDepFile.LookIndex
OutputFileTs=GetFileDateTimeButDontWarnOnError(OutputDepFile.LookIndex)
call _CheckedLineout DepFileName, 'output   ' || _OutputDepWhatToFile(OutputDepFile.LookIndex) || '   ~' || OutputFileTs || '~'
end
call _CheckedLineout DepFileName, ''
do LookIndex=1 to InputDepCount
call DebugLine 'Add INPUT  dependancy : ' ||InputDepFile.LookIndex
call _CheckedLineout DepFileName, 'input    ' || _OutputDepWhatToFile(InputDepFile.LookIndex) || '   ~' || InputDepStamp.LookIndex || '~'
end
CloseRc=stream(DepFileName, 'c', 'close')
call DebugIncrement-1
return

ProcessDependsOn:
Rest=PerformReplacementsInCmdsParameters(arg(1))
DepType=translate(GetQuotedText(Rest, "DependsOnList"))
if DepType<> 'INPUT' & DepType <> 'OUTPUT' then
CryAndDie('Expected either "INPUT" or "OUTPUT" for dependancy type (not "' || DepType || '")!')
if DependsOnList='' then
CryAndDie('No files supplied on "#DependsOn ' || DepType || '" command!')
do while DependsOnList<> ''
ThisOne=GetQuotedText(DependsOnList, "DependsOnList")
if DepType='OUTPUT' then
Added=AddOutputFileToDependancyList(ThisOne)
else
Added=AddInputFileToDependancyList(ThisOne)
if Added='Y' then
call DebugLine DepType|| ' dependancy : ' ||ThisOne
end
return(0)

DEPENDON_11:
SpellDelChars=d2c(9)|| ',.=:;<>&-%()!/~' || '?#${}[]"'
SpellDictFileCount=0
SpellDelChangeCount=0
SpellingPrompts='N'
SpellShowEachError='N'
SpellingAddFile=''
SpellWordCount=0
SpellMistakeCount=0
SpellingAddCount=0
BadlySpellWordCount=0
CheckSpelling='N';
signal SPELLING_12

PrepareSpellingForThisBuild:
if OptionCompleteAddToToDepFile='Y' then
do
do DictIndex=1 to SpellDictFileCount
call AddInputFileToDependancyList SpellDictFile.DictIndex,SpellDictTime.DictIndex
end
end
Drop ?BADWORDEB.
return

LoadSpellingDictionary:
DictFileS=arg(1)
call DebugLine_SPELLING 'User wants the dictionary "' || DictFileS || '"'
DictFile=FindFile(DictFileS)
if DictFile='' then
CryAndDie('The dictionary file "' || DictFileS || '" does not exist!')
call DebugLine_SPELLING 'Loading "' || DictFile || '"'
SpellDictFileCount=SpellDictFileCount+1
SpellDictFile.SpellDictFileCount=DictFile
SpellDictTime.SpellDictFileCount=GetFileDateTimeButDontWarnOnError(DictFile)
CloseRc=stream(DictFile, 'c', 'close')
do while lines(DictFile)<>0
ThisWord=translate(strip(linein(DictFile)))
if ThisWord='' then
iterate
if left(ThisWord,1)=';' then
iterate
if left(ThisWord,1)<> '$' then
do
SpellWordCount=SpellWordCount+1
call _valueS '?SPELLDICT.?' || c2x(ThisWord), ''
end
else
do
parse var ThisWord DictCmd Rest
select
when DictCmd='$MISTAKE' then
do
parse var Rest SpeltWrong SpeltCorrectly .
SpellMistakeCount=SpellMistakeCount+1
call _valueS '?SPELLERR.?' ||c2x(SpeltWrong),SpeltCorrectly
end
when DictCmd='$DELIMITERS' then
do
call DebugLine_SPELLING 'Dictionary is changing spelling delimiters'
SpellDelChangeCount=SpellDelChangeCount+1
if SpellDelChangeCount>1 then
call OutputWarningToScreen 'SPL9', 'Spell check delimiters already modified!'
call ExecRexxCmd "SpellDelChars = " ||strip(Rest)
end
otherwise
do
SpellWordCount=SpellWordCount+1
call _valueS '?SPELLDICT.?' || c2x(ThisWord), ''
end
end
end
end
CloseRc=stream(DictFile, 'c', 'close')
call DebugLine_SPELLING 'Now have ' || AddCommasToDecimalNumber(SpellWordCount) || ' word(s) in dictionary and ' || AddCommasToDecimalNumber(SpellMistakeCount) || ' common mistakes noted!'
CheckSpelling='Y';
return

SpellCheckOneLine:
SpellLine=space(arg(1))
if 1=1 then
do
RightBit=SpellLine
SpellLine=''
StartPos=pos('<',RightBit)
do while StartPos<>0
EndPos=pos('>',RightBit,StartPos+1)
if EndPos=0 then
EndPos=StartPos
SpellLine=SpellLine||left(RightBit,StartPos-1)|| ' '
RightBit=substr(RightBit,EndPos+1)
StartPos=pos('<',RightBit)
end
SpellLine=SpellLine||RightBit
if SpellLine='' then
return
end
SpellLine=translate(translate(SpellLine), '', SpellDelChars, ' ')
do WordIndex=1 to words(SpellLine)
ThisWord=Word(SpellLine,WordIndex)
if left(ThisWord,1)="'" then
ThisWord=substr(ThisWord,2)
if right(ThisWord,1)="'" then
ThisWord=left(ThisWord,length(ThisWord)-1)
if length(ThisWord)>100 then
do
if OptionDebugOn='Y' then
call DebugLine_SPELLING 'Word too big to safely handle "' || ThisWord || '"'
iterate
end
ThisWordC2X=c2x(ThisWord)
if SpellMistakeCount<>0 then
do
MistakeId='?SPELLERR.?' ||ThisWordC2X
if symbol(MistakeId)='VAR' then
do
if SpellShowEachError='Y' then
ShowThisError='Y'
else
do
DuplicatedId='?BADWORDEB.?' ||ThisWordC2X
if symbol(DuplicatedId)='VAR' then
ShowThisError='N'
else
do
ShowThisError='Y'
call _valueS DuplicatedId, ''
end
end
if ShowThisError='Y' then
do
CorrectWord=_valueG(MistakeId)
if CorrectWord='' then
call OutputWarningToScreen 'SPL0', 'Common Mistake: ' ||ThisWord
else
call OutputWarningToScreen 'SPL0', 'Common Mistake: ' || ThisWord || ' (use "' || CorrectWord || '" instead)'
end
iterate
end
end
if SpellWordCount=0&SpellingPrompts='N' then
iterate
ValidId='?SPELLDICT.?' ||ThisWordC2X
if symbol(ValidId)<> 'VAR' then
do
if datatype(ThisWord)<> 'NUM' then
do
WordWarningId=''
WordWarningMsg=''
if SpellingPrompts<> 'N' then
do
DuplicatedId='?BADWORDPI.?' ||ThisWordC2X
if symbol(DuplicatedId)='VAR' then
do
BadIndex=_valueG(DuplicatedId)
if BadIndex<> '' then
do
WordWarningId='SPL1'
WordWarningMsg='Added "' || ThisWord || '" to "' || SpellingAddFile || '"'
SpellingAddOccurs.BadIndex=SpellingAddOccurs.BadIndex+1
end
end
else
do
DuplicatedIdValue=''
if SpellingAddFile<> '' & SpellingPrompts <> 'N' then
do
if SpellingPrompts='OK' then
UserResp='Y'
else
do
do until UserResp='Y' | UserResp = 'N' | UserResp = 'Q' | UserResp = 'A'
call charout,ThisWord|| ' <- OK (Yes/yes All/No/Quit asking)?'
UserResp=translate(left(linein(),1))
end
end
if UserResp='A' then
do
SpellingPrompts='OK'
UserResp='Y'
end
if UserResp='Y' then
do
SpellingAddCount=SpellingAddCount+1
DuplicatedIdValue=SpellingAddCount
SpellingAddWord.SpellingAddCount=ThisWord
SpellingAddOccurs.SpellingAddCount=1
if SpellingPrompts='OK' then
do
WordWarningId='SPL1'
WordWarningMsg='Added "' || ThisWord || '" to "' || SpellingAddFile || '"'
end
end
else
do
if UserResp='Q' then
SpellingPrompts='N'
end
end
BadlySpellWordCount=BadlySpellWordCount+1
call _valueS DuplicatedId,DuplicatedIdValue
end
end
if SpellShowEachError='Y' then
ShowThisError='Y'
else
do
DuplicatedId='?BADWORDEB.?' ||ThisWordC2X
if symbol(DuplicatedId)='VAR' then
ShowThisError='N'
else
do
ShowThisError='Y'
call _valueS DuplicatedId, ''
end
end
if ShowThisError='Y' then
do
if WordWarningId='' then
do
WordWarningId='SPL1'
WordWarningMsg='Spelling? : ' ||ThisWord
end
call OutputWarningToScreen WordWarningId,WordWarningMsg
end
end
end
end
return

OutputAnySpellingAdditions:
if SpellingAddCount=0 then
return
call DebugLine_SPELLING 'Adding spelling words to file "' || SpellingAddFile || '"'
call DebugIncrement 1
if VariableExists("PPWIZARD_DONT_SORT_ADD_WORDS") = 'N' then
do
call DebugLine_SPELLING 'Sorting ' || SpellingAddCount || ' "bad" word(s) by number of occurences!'
SpellingAddWord.0=SpellingAddCount
SpellingAddOccurs.0=SpellingAddCount
SrtM=1
SrtCount=SpellingAddOccurs.0
do while(9*SrtM+4)<SrtCount
SrtM=SrtM*3+1
end
do while SrtM>0
SrtK=SrtCount-SrtM
do SrtJ=1 to SrtK
SrtIndex1=SrtJ
do while SrtIndex1>0
SrtIndex2=SrtIndex1+SrtM
SrtGreater=SpellingAddOccurs.SrtIndex1>SpellingAddOccurs.SrtIndex2
if SrtGreater then
do
SrtTemp=SpellingAddOccurs.SrtIndex1;SpellingAddOccurs.SrtIndex1=SpellingAddOccurs.SrtIndex2;SpellingAddOccurs.SrtIndex2=SrtTemp;SrtTemp=SpellingAddWord.SrtIndex1;SpellingAddWord.SrtIndex1=SpellingAddWord.SrtIndex2;SpellingAddWord.SrtIndex2=SrtTemp
end
else
leave
SrtIndex1=SrtIndex1-SrtM
end
end
SrtM=SrtM%3
end
call ReverseArray "SpellingAddWord"
call ReverseArray "SpellingAddOccurs"
end
call Stream SpellingAddFile, 'c', 'Close'
if SafeQueryExists(SpellingAddFile)<> "" then
do
call DebugLine_SPELLING 'Deleting existing "' || SpellingAddFile || '"'
call MustDeleteFile SpellingAddFile
end
call DebugLine_SPELLING 'Writing words to file'
call DebugIncrement 1
do WordIndex=1 to SpellingAddCount
call lineout SpellingAddFile,SpellingAddWord.WordIndex
if OptionDebugOn='Y' then
call DebugLine_SPELLING 'The word "' || SpellingAddWord.WordIndex || '" occured ' || SpellingAddOccurs.WordIndex || ' time(s).'
end
call DebugIncrement-1
call DieIfIoErrorOccurred SpellingAddFile
call Stream SpellingAddFile, 'c', 'Close'
call OutputInformationToScreen AddCommasToDecimalNumber(SpellingAddCount)|| ' word(s) added to "' || SpellingAddFile || '"'
call DebugIncrement-1
return

SPELLING_12:
OptionDebugOn='N'
OptionMaxCol=500
if RexWhich='REGINA' then
do
if pos('0.0',RexVerRegina)<>0 then
OptionDebugTime='L'
else
OptionDebugTime='S'
end
else
do
OptionDebugTime='S'
end
call DebugIncrementInit
signal Debug_13

Debug:call TRACE "OFF"

DebugLine:
if OptionDebugOn='N' then
return

DebugLine2:
call _DebugLine1 _DebugPrefix()|| '         >' ||translate(arg(1),DebugNewline,MarksNewLine)
return

_DebugPrefix:
if OptionDebugTime='N' then
return(copies("  ",IncludeLevel+DebugIndent))
else
do
if OptionDebugTime='L' then
return( '[' || left(time('L'),11)               || ']' || copies("  ",IncludeLevel+DebugIndent))
else
return( '[' || (time('S') || substr(time('L'), 9, 3)) - PpwStartSec || ']' || copies("  ",IncludeLevel+DebugIndent))
end

YorN2OnorOff:
if arg(1)='Y' then
return('ON')
else
return('OFF')

DebugShowCurrentLineWithLineNumber:
if OptionDebugOn='Y' then
do
FmtLineNum=IncludeLineNumber
if length(FmtLineNum)<4 then
FmtLineNum=right(FmtLineNum,4, '0')
if arg(2)<> '' then
FmtLineNum=copies(arg(2),length(FmtLineNum))
if IncludeMemHandle='' then
FmtLineNum='{' || DebugCurrentFileNumber || '}' ||FmtLineNum
else
FmtLineNum='[' || DebugCurrentFileNumber || ']' ||FmtLineNum
select
when AsIsModeOn='Y' & AutoTagOn = 'Y' then
DebugSym='> '
when AsIsModeOn='Y' then
DebugSym='} '
when AutoTagOn='Y' then
DebugSym=') '
otherwise
DebugSym=': '
end
if arg(1)=='' then
call _DebugLine1 _DebugPrefix()||FmtLineNum||DebugSym
else
call _DebugLine1 _DebugPrefix()||FmtLineNum||DebugSym||DebugRightArrow||translate(arg(1),DebugNewline,MarksNewLine)||DebugLeftArrow
end
return

DebugShowLineDropped:
if OptionDebugOn='Y' then
do
call _DebugLine1 _DebugPrefix()||left(arg(1),length(FmtLineNum), ' ') || '-'
end
return

DebugGetEnv:
if OptionDebugOn='Y' then
call DebugLine 'GetEnv(): "' || arg(1) || '" = ' ||DebugRightArrow||arg(2)||DebugLeftArrow
return

DebugWarning:
if OptionDebugOn='N' then
return
DbgWarning='!!! ' || arg(1) || ' !!!'
DbgLine=copies('!',length(DbgWarning))
call DebugLine2 ''
call DebugLine2 left('!!!![ DEBUG WARNING ]', length(DbgWarning), '!')
call DebugLine2 DbgWarning
call DebugLine2 left('', length(DbgWarning), '!')
call DebugLine2 ''
return

DebugOutputVariableInfo:
if OptionDebugOn='Y' then
call DebugLine2 '? ' ||translate(arg(1),DebugNewline,MarksNewLine)
return

DebugIndent:call TRACE "OFF"

DebugIncrement:
DebugIndent=DebugIndent+(arg(1)*2)
if DebugIndent<0 then
DebugIndent=0
return

DebugIncrementInit:
DebugIndent=0
return

DebugStateChanged:
if OptionDebugOn='Y' then
do
call DisplayCopyright
if DebugOnStuffOutputted='N' then
do
SourceTime=stream(PpWizardPgmName, 'c', 'query datetime')
call DebugLine 'Debug Header'
call DebugLine '~~~~~~~~~~~~'
call DebugIncrement 1
call DebugLine 'Started@: "' || CompileTime        || '"'
call DebugLine 'Program : "' || PpWizardPgmName    || '" (' || SourceTime || ')'
call DebugLine 'OptionE : "' || OptionsEnvironment || '"'
call DebugLine 'OptionC : "' || OptionsCmdLine     || '"'
call DebugLine 'Src Type: "' || OptionCodeType     || '"'
call DebugLine 'OpSystem: "' || PpWizardOpSys      || '"'
call DebugLine 'Rexx Ver: "' || RexVersionInfo     || '"'
call DebugLine 'Mode    : "' || RexWhich           || '"'
if RexWhich='REGINA' then
call DebugLine 'uname() : "' || uname()        || '"'
if OptionFilterIn<> '' then
call DebugLine 'Filter I: ' || FunctionFilterIn || '(' || InputInterfaceVer || ')'
if OptionFilterOut<> '' then
call DebugLine 'Filter O: "' || OptionFilterOut   || '" (interface version ' || OutputInterfaceVer || ')'
call _DebugLine1 ''
DebugOnStuffOutputted='Y'
call DebugIncrement-1
end
end
call SetEnv "PPWIZARD_DEBUG",OptionDebugOn
return

ProcessHashDebug:
if DebugSwitchUsed='Y' then
call DebugLine 'Command ignored as "/debug" used'
else
do
ReturnRc=SetOnorOffVariable(arg(1), 'OptionDebugOn')
call DebugStateChanged
end
return(0)

DebugShowAsMuchEnvironmentDetailAsPossible:
if OptionDebugOn='N' then
return
call DebugLine 'Dumping Environmental Info'
TmpSetFile=RexGetTmpFileName()
RedirBit=RedirectStdOutAndErr2(TmpSetFile)
call _EnvAddCmd 'set'
if RexSystemOpSys<> "UNIX" then
do
select
when RexSystemOpSys="OS/2"  then VerCmd = 'VER /R'
otherwise VerCmd='VER'
end
call _EnvAddCmd VerCmd
end
if RexSystemOpSys<> "UNIX" then
call _SysFileDelete TmpSetFile
return

_EnvAddCmd:
call AddressCmd arg(1)||RedirBit,TmpSetFile
if RexSystemOpSys="UNIX" then
call _SysFileDelete TmpSetFile
return

_DebugLine1:
z2_Line=arg(1)
if OptionMaxCol=0 then
call Line1 z2_Line
else
do
if length(z2_Line)<=OptionMaxCol then
call Line1 z2_Line
else
call Line1 left(z2_Line,OptionMaxCol)|| ' <-[' || OptionMaxCol || ']'
end
return

_SetDebugChar:
z3_Var=arg(1)
z3_CurValVar=arg(2)
parse value strip(value(z3_Var)) with z3_Val ',' z3_Rest
call value z3_Var,z3_Rest
if z3_Val=-1 then
z3_NewVal=''
else
do
z3_Val=strip(z3_Val)
if z3_Val='' then
z3_NewVal=value(z3_CurValVar)
else
do
if datatype(z3_Val, 'W')then
z3_NewVal=d2c(z3_Val)
else
z3_NewVal=z3_Val
end
end
return(z3_NewVal)

SetDebugChars:
z4_Chars=arg(1)
z4_MakDef=arg(2)
if z4_Chars='' then
do
DebugLeftArrow=_DebugLeftArrow
DebugRightArrow=_DebugRightArrow
DebugNewline=_DebugNewline
end
else
do
DebugRightArrow=_SetDebugChar('z4_Chars', 'DebugRightArrow')
DebugLeftArrow=_SetDebugChar('z4_Chars', 'DebugLeftArrow' )
DebugNewline=_SetDebugChar('z4_Chars', 'DebugNewline' )
end
if z4_MakDef='Y' then
do
_DebugLeftArrow=DebugLeftArrow
_DebugRightArrow=DebugRightArrow
_DebugNewline=DebugNewline
end
call DebugLine 'New debug characters are "LEFT=' || DebugRightArrow || ', RIGHT=' || DebugLeftArrow || ', NL=' || DebugNewline || '"'
return

Debug_13:
AllBitsOff='000000'x
AllBitsOn='FFFFFF'x
UserBitsOn='000003'x
AllBitsOnExceptUser=bitxor(AllBitsOn,UserBitsOn)
DebugLevel=AllBitsOnExceptUser
DebugLevelCnt=0
SeeLevelAll=_SaveDebugLevel("ALL",           "FFFFFF")
DummyUser1=_SaveDebugLevel("USER1",         "000001")
DummyUser2=_SaveDebugLevel("USER2",         "000002")
SeeLevelConditional=_SaveDebugLevel("CONDITIONAL",   "000004")
SeeFoundVar=_SaveDebugLevel("FOUNDVAR",      "000008")
SeeFoundVarParms=_SaveDebugLevel("FOUNDVARPARMS", "000010")
SeeFoundStdVar=_SaveDebugLevel("FOUNDSTDVAR",   "000020")
SeeAfterReplace=_SaveDebugLevel("AFTERREPLACE",  "000040")
SeeOptions=_SaveDebugLevel("OPTIONS",       "000080")
SeeOpSys=_SaveDebugLevel("OPSYS",         "000100")
SeeDefining=_SaveDebugLevel("DEFINING",      "000200")
SeeDefaultOrMacroValue=_SaveDebugLevel("MACROVALORDEF", "000400")
SeeAsIs=_SaveDebugLevel("ASIS",          "000800")
SeeAutoTag=_SaveDebugLevel("AUTOTAG",       "001000")
SeeRexxVar=_SaveDebugLevel("REXXVAR",       "002000")
SeeRexxTrace=_SaveDebugLevel("REXXTRACE",     "004000")
SeeInterpret=_SaveDebugLevel("INTERPRET",     "008000")
SeeEvaluate=_SaveDebugLevel("EVALUATE",      "010000")
SeeImport=_SaveDebugLevel("IMPORT",        "020000")
SeeSpelling=_SaveDebugLevel("SPELLING",      "040000")
SeeQuoting=_SaveDebugLevel("QUOTING",       "080000")
SeeImport=bitand(SeeImport,SeeDefaultOrMacroValue)
signal DebugOpt_14

IsDebugOn:call TRACE "OFF"
ido1=arg(1)
if ido1='' then
return(OptionDebugOn)
else
do
if OptionDebugOn='N' then
return(0)
else
do
idoUBits=bitand(DebugLevel,UserBitsOn)
idoUBits=bitand(idoUBits,x2c(right(ido1,6, '0')))
return(c2d(idoUBits))
end
end

DebugAddressCmdBefore:
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeOpSys)==SeeOpSys then
do
call DebugIncrement 1
call DebugLine 'Executing: ' ||arg(1)
call DebugIncrement-1
end
end
return

DebugAddressCmdOutput:
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeOpSys)==SeeOpSys then
do
call DebugIncrement 2
DbgLineNumber=arg(2)
if datatype(DbgLineNumber, 'W')=0 then
call DebugLine '> ' ||arg(1)
else
do
if DbgLineNumber<999 then
DbgLineNumber=right(DbgLineNumber,3, '0')
call DebugLine '> ' || DbgLineNumber || ': ' ||arg(1)
end
call DebugIncrement-2
end
end
return

DebugAddressCmdAfter:
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeOpSys)==SeeOpSys then
do
call DebugIncrement 2
call DebugLine '  Rc = ' ||arg(1)
call DebugIncrement-2
end
end
return

DebugOutputAfterReplacement:
if OptionDebugOn='N' then
return
if bitand(DebugLevel,SeeAfterReplace)==SeeAfterReplace then
call DebugLine2 arg(2)||DebugRightArrow||translate(arg(1),DebugNewline,MarksNewLine)||DebugLeftArrow
return

DebugLine_DEFINING:
if bitand(DebugLevel,SeeDefining)==SeeDefining then
call DebugLine arg(1)
return

DebugLine_ASIS:
if bitand(DebugLevel,SeeAsIs)==SeeAsIs then
call DebugLine arg(1)
return

DebugLine_REXXVAR:
if bitand(DebugLevel,SeeRexxVar)==SeeRexxVar then
call DebugLine arg(1)
return

DebugLine_INTERPRET:
if bitand(DebugLevel,SeeInterpret)==SeeInterpret then
call DebugLine arg(1)
return

DebugLine_EVALUATE:
if bitand(DebugLevel,SeeEvaluate)==SeeEvaluate then
call DebugLine arg(1)
return

DebugLine_SPELLING:
if bitand(DebugLevel,SeeSpelling)==SeeSpelling then
call DebugLine arg(1)
return

DebugLine_QUOTING:
if bitand(DebugLevel,SeeQuoting)==SeeQuoting then
call DebugLine arg(1)
return

DebugLine_IMPORT:
if bitand(DebugLevel,SeeImport)==SeeImport then
call DebugLine arg(1)
return

DebugLine_AUTOTAG:
if bitand(DebugLevel,SeeAutoTag)==SeeAutoTag then
call DebugLine arg(1)
return

DebugLine_MACROVALORDEF:
if bitand(DebugLevel,SeeDefaultOrMacroValue)==SeeDefaultOrMacroValue then
call DebugLine arg(1)
return

DebugLine_OPTIONS:
if bitand(DebugLevel,SeeOptions)==SeeOptions then
call DebugLine arg(1)
return

DebugLine_CONDITIONAL:
if bitand(DebugLevel,SeeLevelConditional)==SeeLevelConditional then
call DebugLine arg(1)
return

DebugOutputVariableInfo_FOUNDSTDVAR:
if bitand(DebugLevel,SeeFoundStdVar)==SeeFoundStdVar then
call DebugOutputVariableInfo arg(1)
return

DebugOutputVariableInfo_FOUNDVAR:
if bitand(DebugLevel,SeeFoundVar)==SeeFoundVar then
call DebugOutputVariableInfo arg(1)
return

DebugOutputVariableInfo_FOUNDVARPARMS:
if bitand(DebugLevel,SeeFoundVarParms)==SeeFoundVarParms then
call DebugOutputVariableInfo arg(1)
return

DebugOutputVariableInfo_FOUNDSTDVAR:
if bitand(DebugLevel,SeeFoundVar)==SeeFoundVar then
call DebugOutputVariableInfo arg(1)
return

_SaveDebugLevel:
DebugLevelCnt=DebugLevelCnt+1
DebugLevelNme.DebugLevelCnt=translate(arg(1))
DebugLevelVal.DebugLevelCnt=arg(2)
return(x2c(arg(2)))

GetDebugLevel:
WantedName=translate(arg(1))
do DbgIndex=1 to DebugLevelCnt
if WantedName=DebugLevelNme.DbgIndex then
return(DebugLevelVal.DbgIndex)
end
return('')

_WorkOutDebugLevelText:
DbgLvlTxt="ALL"
do DbgIndex=1 to DebugLevelCnt
if bitand(DebugLevel,x2c(DebugLevelVal.DbgIndex))=AllBitsOff then
DbgLvlTxt=DbgLvlTxt|| ',-' ||DebugLevelNme.DbgIndex
end
return(DbgLvlTxt)

DEBUGLEVEL_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'DEBUGLEVEL', 'Debug level (when on) is ' ||_WorkOutDebugLevelText()
return

DEBUGLEVEL_GET:
call DEBUGLEVEL_DEBUG
return(_WorkOutDebugLevelText())

DEBUGLEVEL_SET:
DebugCmdsIn=arg(1)
DebugCmds=DebugCmdsIn
do while DebugCmds<> ''
parse var DebugCmds OneDebugOpt','DebugCmds
OptionAction=left(OneDebugOpt,1)
if OptionAction='+' then
OneDebugOpt=substr(OneDebugOpt,2)
else
do
if OptionAction='-' then
OneDebugOpt=substr(OneDebugOpt,2)
else
OptionAction='+'
end
OptionBinary=x2c(GetDebugLevel(OneDebugOpt))
if OptionBinary='' then
CryAndDie('Invalid debug option of "' || OneDebugOpt || '"')
if OptionAction='+' then
DebugLevel=bitor(DebugLevel,OptionBinary)
else
DebugLevel=bitxor(DebugLevel,OptionBinary)
end
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'DEBUGLEVEL', 'Setting default value of debug level to "' || _WorkOutDebugLevelText() || '"'
Default4_DebugLevel=DebugLevel
return(0)
end
if DebugCmdsIn='' then
DebugLevel=Default4_DebugLevel
call DEBUGLEVEL_DEBUG
return

DebugOpt_14:
OptionCgiModeOn='N'
CgiOutputFile=''
CgiFatalError='N'
signal CGI_15

InitConsoleOutputVarsPass1:
ConsoleFile=''
OutputToConsoleLog='N'
OutputToErrorLog='N'
ConsoleErrorFile='PPWIZARD.ERR'
TruncateDefaultErrorFile='Y'
return

InitConsoleOutputVarsPass2:
call UserIsSpecifyingConsoleFileName GetEnv("PPWIZARD_CONSOLEFILE")
call UserIsSpecifyingErrorFileName GetEnv("PPWIZARD_ERRORFILE")
if ConsoleErrorFile='' then
ConsoleErrorFile='PPWIZARD.ERR'
return

UserIsSpecifyingErrorFileName:
ConsoleErrorFile=arg(1)
if ConsoleErrorFile<> '' then
do
if left(ConsoleErrorFile,1)='+' then
ConsoleErrorFile=substr(ConsoleErrorFile,2)
else
do
call MustDeleteFile ConsoleErrorFile
end
end
TruncateDefaultErrorFile='N'
return

UserIsSpecifyingConsoleFileName:
z5_ConFile=arg(1)
if ConsoleFile<> '' then
do
CloseRc=stream(ConsoleFile, 'c', 'close')
ConsoleFile=''
end
if z5_ConFile<> '' then
do
if left(z5_ConFile,1)='+' then
do
z5_ConFile=substr(z5_ConFile,2)
end
else
do
call MustDeleteFile z5_ConFile
end
end
if z5_ConFile='' then
OutputToConsoleLog='N'
else
do
call MakeDirectoryTree _filespec('Location',z5_ConFile)
OutputToConsoleLog='y'
ConsoleFile=z5_ConFile
end
return

AllFollowingOutputGoesToErrorFile:
if ConsoleErrorFile='' then
return
if TruncateDefaultErrorFile='Y' then
do
TruncateDefaultErrorFile='N'
call MustDeleteFile ConsoleErrorFile
end
call MakeDirectoryTree _filespec('Location',ConsoleErrorFile)
TheTime=NiceDateTime()
if symbol('InputFileFull') <> 'VAR' then
TheFile=''
else
TheFile=InputFileFull
OutputToErrorLog='Y'
call Say2ErrorFile ''
call Say2ErrorFile ''
call Say2ErrorFile copies('*+',38)
if TheFile<> '' then
call Say2ErrorFile copies(' ',(78-length(TheFile))%2)||TheFile
call Say2ErrorFile copies(' ',(78-length(TheTime))%2)||TheTime
call Say2ErrorFile copies('*+',38)
call Say2ErrorFile ''
return

Say2ErrorFile:
if OutputToErrorLog='Y' then
do
z6_L=arg(1)
do until z6_L==''
parse var z6_L z6_Nxt (MarksNewLine) z6_L
call lineout ConsoleErrorFile,z6_Nxt
end
end
return

Char1ToErrorFile:
if OutputToErrorLog='Y' then
call charout ConsoleErrorFile,arg(1)
return

AddConsoleHdr:
OutputToConsoleLog='N' 
TheTime=NiceDateTime()
OutputToConsoleLog='Y' 
call _Lne2CFle ''
call _Lne2CFle ''
call _Lne2CFle copies('*+',38)
call _Lne2CFle copies(' ',(78-length(TheTime))%2)||TheTime
call _Lne2CFle copies('*+',38)
call _Lne2CFle ''
return

_Lne2CFle:
if OutputToConsoleLog<> 'N' then
do
z7_L=arg(1)
do until z7_L==''
parse var z7_L z7_Nxt (MarksNewLine) z7_L
call lineout ConsoleFile,z7_Nxt
end
end
return

_Chr2CFle:
if OutputToConsoleLog<> 'N' then
call charout ConsoleFile,arg(1)
return

Say:call TRACE "OFF"

Line1:
parse arg Lne1S,Lne1L
if Lne1L='' then
Lne1L=Lne1S
if OptionCgiModeOn='N' then
do
say Lne1S
if OutputToErrorLog='Y' then
call Say2ErrorFile Lne1L
if OutputToConsoleLog<> 'N' then
do
if OutputToConsoleLog='y' then
call AddConsoleHdr
call _Lne2CFle Lne1L
end
end
else
do
if CgiOutputFile<> '' then
call lineout CgiOutputFile,Lne1S
if CgiFatalError='Y' then
say _MustSeeAsIsInHtmlViewer(Lne1S)
end
return

Chars:call TRACE "OFF"

Char1:
TheChar1=arg(1)
if OptionCgiModeOn='N' then
do
call charout,TheChar1
if OutputToErrorLog='Y' then
call Char1ToErrorFile TheChar1
if OutputToConsoleLog<> 'N' then
do
if OutputToConsoleLog='y' then
call AddConsoleHdr
call _Chr2CFle TheChar1
end
end
else
do
if CgiOutputFile<> '' then
call charout CgiOutputFile,TheChar1
if CgiFatalError='Y' then
call charout,_MustSeeAsIsInHtmlViewer(TheChar1)
end
return

DieIfCgiModeOn:
if OptionCgiModeOn='Y' then
call CryAndDie "This feature is not allowed in CGI mode"
return

TurnCgiModeOn:
OptionCgiModeOn='Y'
CgiOutputFile=ThisCmdOptions
if pos('?',CgiOutputFile)<>0 then
do
PartSecond=time('Long')
parse var PartSecond .'.'PartSecond
RandomBit=right(time('Seconds'), 5, '0')
RandomBit=RandomBit||left(strip(PartSecond),3)
RandomBit=RandomBit|| '.' || right( date('Days'), 3, '0')
CgiOutputFile=ReplaceString(CgiOutputFile, '?',RandomBit)
end
if CgiOutputFile<> '' then
do
if stream(CgiOutputFile, 'c', 'query exists') <> '' then
do
call Stream CgiOutputFile, 'c', 'Close'
DeleteRc=_SysFileDelete(CgiOutputFile)
if DeleteRc<>0 then
call DebugLine 'Could not delete "' || CgiOutputFile || '" (Rc = ' || DeleteRc || ')'
end
end
call RemoveColorCodes
call RemoveBeepCode
return

CloseCgiFileIfOpen:
if OutputToConsoleLog<> 'N' then
do
CloseRc=stream(ConsoleFile, 'c', 'close')
OutputToConsoleLog='N'
end
if OutputToErrorLog='Y' then
do
CloseRc=stream(ConsoleErrorFile, 'c', 'close')
OutputToErrorLog='N'
end
if CgiOutputFile<> '' then
CloseRc=stream(CgiOutputFile, 'c', 'close')
return

CgiStartFatalError:
if OptionCgiModeOn='N' then
return
CgiDoVar='CGI_FATAL_MY_MESSAGE_ONLY'
if VariableExists(CgiDoVar)='Y' then
do
CgiErrorCodes=GetDefineValueOrUseDefault(CgiDoVar, '')
if CgiErrorCodes='' then
call DebugLine 'We do not want any error indication in user output'
else
call DebugLine 'Displaying user message only (no error details)'
say CgiErrorCodes
return
end
call DebugLine 'Will show user error output as "' || CgiDoVar || '" was not defined'
CgiErrDefault='<P><HR><FONT SIZE=+1 COLOR=RED><CENTER><H1>FATAL ERROR</H1></CENTER><P><PRE>'
CgiErrorCodes=GetDefineValueOrUseDefault("CGI_FATAL_HEADER",CgiErrDefault)
say CgiErrorCodes
CgiErrDefault='</PRE><HR></FONT>'
CgiErrorCodes=GetDefineValueOrUseDefault("CGI_FATAL_TRAILER",CgiErrDefault)
CgiFatalError='Y'
return

CgiEndFatalError:
if OptionCgiModeOn='N' then
return
if CgiFatalError='N' then
return
say CgiErrorCodes
CgiFatalError='N'
return

_MustSeeAsIsInHtmlViewer:
BrowserOk=ReplaceString(arg(1), "<",          "&lt;")
BrowserOk=ReplaceString(BrowserOk, ">",          "&gt;")
return(BrowserOk)

CGI_15:
signal EndLineCrLfXH

CrLfClose:
_CrlfBuffer=''
return(stream(arg(1), 'c', 'close'))

CrLfOpen:
call CrLfClose arg(1)
_CrLfEOL=d2c(13)||d2c(10)
_CrLfEOLLng=2
if arg(2)<> '' then
do
if chars(arg(1))<>0 then
do
_CrLf2Read=arg(2)
if _CrLf2Read<5000 then
_CrLf2Read=5000
_CrlfBuffer=charin(arg(1),,_CrLf2Read)
if pos(_CrLfEOL,_CrlfBuffer)=0 then
do
if pos(d2c(10),_CrlfBuffer)<>0 then
do
_CrLfEOL=d2c(10)
_CrLfEOLLng=1
end
end
end
end
return(0)

CrLfLines:
if _CrlfBuffer<> '' then
return(1)
else
do
if chars(arg(1))=0 then
return(0)
else
return(1)
end

CrLfLineIn:
_CrLfPos=pos(_CrLfEOL,_CrlfBuffer)
do while _CrLfPos=0
if chars(arg(1))=0 then
leave
_CrlfBuffer=_CrlfBuffer||charin(arg(1),,5000)
_CrLfPos=pos(_CrLfEOL,_CrlfBuffer)
end
if _CrLfPos=0 then
do
_CrLfReturn=_CrlfBuffer
_CrlfBuffer=''
end
else
do
_CrLfReturn=left(_CrlfBuffer,_CrLfPos-1)
_CrlfBuffer=substr(_CrlfBuffer,_CrLfPos+_CrLfEOLLng)
end
return(_CrLfReturn)

EndLineCrLfXH:
ReplaceCount=0
CiSelfRef="{*}"
signal EndREPLSTR

ReplaceString:call TRACE "OFF"
parse arg rs?TheString,rs?ChangeFrom
rs?FoundPosn=pos(rs?ChangeFrom,rs?TheString)
if rs?FoundPosn=0 then
return(rs?TheString)
rs?ChangeTo=arg(3)
rs?ChangeFromLength=length(rs?ChangeFrom)
rs?LeftPart=''
do until rs?FoundPosn=0
rs?LeftPart=rs?LeftPart||left(rs?TheString,rs?FoundPosn-1)||rs?ChangeTo
rs?TheString=substr(rs?TheString,rs?FoundPosn+rs?ChangeFromLength)
ReplaceCount=ReplaceCount+1
rs?FoundPosn=pos(rs?ChangeFrom,rs?TheString)
end
return(rs?LeftPart||rs?TheString)

ReplaceStringCi:call TRACE "OFF"
rsi?TheString=arg(1)
rsi?TheStringU=translate(rsi?TheString)
rsi?ChangeFrom=translate(arg(2))
rsi?FoundPosn=pos(rsi?ChangeFrom,rsi?TheStringU)
if rsi?FoundPosn=0 then
return(rsi?TheString)
rsi?ChangeTo=arg(3)
if pos(CiSelfRef,rsi?ChangeTo)=0 then
rsi?Ref='N'
else
rsi?Ref='Y'
rsi?ChangeFromLength=length(rsi?ChangeFrom)
rsi?LeftPart=''
do until rsi?FoundPosn=0
if rsi?Ref='N' then
rsi?SubWith=rsi?ChangeTo
else
do
rsi?SaveCount=ReplaceCount
rsi?SubWith=ReplaceString(rsi?ChangeTo,CiSelfRef,substr(rsi?TheString,rsi?FoundPosn,rsi?ChangeFromLength))
ReplaceCount=rsi?SaveCount
end
rsi?LeftPart=rsi?LeftPart||left(rsi?TheString,rsi?FoundPosn-1)||rsi?SubWith
rsi?TheString=substr(rsi?TheString,rsi?FoundPosn+rsi?ChangeFromLength)
rsi?TheStringU=substr(rsi?TheStringU,rsi?FoundPosn+rsi?ChangeFromLength)
ReplaceCount=ReplaceCount+1
rsi?FoundPosn=pos(rsi?ChangeFrom,rsi?TheStringU)
end
return(rsi?LeftPart||rsi?TheString)

EndREPLSTR:
ReplaceCount=0
signal EndBULK_C2S

BulkChar2String:call TRACE "OFF"
parse arg brRightBit,brArray
brModifyThese=value(brArray)
brPos=verify(brRightBit,brModifyThese, 'M')
if brPos=0 then
return(brRightBit)
brLeftBit=''
brArray=brArray|| '.'
do until brPos=0
brLeftBit=brLeftBit||left(brRightBit,brPos-1)||value(brArray||pos(substr(brRightBit,brPos,1),brModifyThese))
brRightBit=substr(brRightBit,brPos+1)
ReplaceCount=ReplaceCount+1
brPos=verify(brRightBit,brModifyThese, 'M')
end
return(brLeftBit||brRightBit)

BulkChangePrepare:call TRACE "OFF"
parse arg brArray,brChar,brString
if brChar=='' then
call value brArray, ''
else
do
brValue=value(brArray)||BrChar
call value brArray,brValue
call value brArray|| '.' ||length(brValue),brString
end
return

EndBULK_C2S:
_C.0='00000000'x
_C.1='77073096'x
_C.2='EE0E612C'x
_C.3='990951BA'x
_C.4='076DC419'x
_C.5='706AF48F'x
_C.6='E963A535'x
_C.7='9E6495A3'x
_C.8='0EDB8832'x
_C.9='79DCB8A4'x
_C.10='E0D5E91E'x
_C.11='97D2D988'x
_C.12='09B64C2B'x
_C.13='7EB17CBD'x
_C.14='E7B82D07'x
_C.15='90BF1D91'x
_C.16='1DB71064'x
_C.17='6AB020F2'x
_C.18='F3B97148'x
_C.19='84BE41DE'x
_C.20='1ADAD47D'x
_C.21='6DDDE4EB'x
_C.22='F4D4B551'x
_C.23='83D385C7'x
_C.24='136C9856'x
_C.25='646BA8C0'x
_C.26='FD62F97A'x
_C.27='8A65C9EC'x
_C.28='14015C4F'x
_C.29='63066CD9'x
_C.30='FA0F3D63'x
_C.31='8D080DF5'x
_C.32='3B6E20C8'x
_C.33='4C69105E'x
_C.34='D56041E4'x
_C.35='A2677172'x
_C.36='3C03E4D1'x
_C.37='4B04D447'x
_C.38='D20D85FD'x
_C.39='A50AB56B'x
_C.40='35B5A8FA'x
_C.41='42B2986C'x
_C.42='DBBBC9D6'x
_C.43='ACBCF940'x
_C.44='32D86CE3'x
_C.45='45DF5C75'x
_C.46='DCD60DCF'x
_C.47='ABD13D59'x
_C.48='26D930AC'x
_C.49='51DE003A'x
_C.50='C8D75180'x
_C.51='BFD06116'x
_C.52='21B4F4B5'x
_C.53='56B3C423'x
_C.54='CFBA9599'x
_C.55='B8BDA50F'x
_C.56='2802B89E'x
_C.57='5F058808'x
_C.58='C60CD9B2'x
_C.59='B10BE924'x
_C.60='2F6F7C87'x
_C.61='58684C11'x
_C.62='C1611DAB'x
_C.63='B6662D3D'x
_C.64='76DC4190'x
_C.65='01DB7106'x
_C.66='98D220BC'x
_C.67='EFD5102A'x
_C.68='71B18589'x
_C.69='06B6B51F'x
_C.70='9FBFE4A5'x
_C.71='E8B8D433'x
_C.72='7807C9A2'x
_C.73='0F00F934'x
_C.74='9609A88E'x
_C.75='E10E9818'x
_C.76='7F6A0DBB'x
_C.77='086D3D2D'x
_C.78='91646C97'x
_C.79='E6635C01'x
_C.80='6B6B51F4'x
_C.81='1C6C6162'x
_C.82='856530D8'x
_C.83='F262004E'x
_C.84='6C0695ED'x
_C.85='1B01A57B'x
_C.86='8208F4C1'x
_C.87='F50FC457'x
_C.88='65B0D9C6'x
_C.89='12B7E950'x
_C.90='8BBEB8EA'x
_C.91='FCB9887C'x
_C.92='62DD1DDF'x
_C.93='15DA2D49'x
_C.94='8CD37CF3'x
_C.95='FBD44C65'x
_C.96='4DB26158'x
_C.97='3AB551CE'x
_C.98='A3BC0074'x
_C.99='D4BB30E2'x
_C.100='4ADFA541'x
_C.101='3DD895D7'x
_C.102='A4D1C46D'x
_C.103='D3D6F4FB'x
_C.104='4369E96A'x
_C.105='346ED9FC'x
_C.106='AD678846'x
_C.107='DA60B8D0'x
_C.108='44042D73'x
_C.109='33031DE5'x
_C.110='AA0A4C5F'x
_C.111='DD0D7CC9'x
_C.112='5005713C'x
_C.113='270241AA'x
_C.114='BE0B1010'x
_C.115='C90C2086'x
_C.116='5768B525'x
_C.117='206F85B3'x
_C.118='B966D409'x
_C.119='CE61E49F'x
_C.120='5EDEF90E'x
_C.121='29D9C998'x
_C.122='B0D09822'x
_C.123='C7D7A8B4'x
_C.124='59B33D17'x
_C.125='2EB40D81'x
_C.126='B7BD5C3B'x
_C.127='C0BA6CAD'x
_C.128='EDB88320'x
_C.129='9ABFB3B6'x
_C.130='03B6E20C'x
_C.131='74B1D29A'x
_C.132='EAD54739'x
_C.133='9DD277AF'x
_C.134='04DB2615'x
_C.135='73DC1683'x
_C.136='E3630B12'x
_C.137='94643B84'x
_C.138='0D6D6A3E'x
_C.139='7A6A5AA8'x
_C.140='E40ECF0B'x
_C.141='9309FF9D'x
_C.142='0A00AE27'x
_C.143='7D079EB1'x
_C.144='F00F9344'x
_C.145='8708A3D2'x
_C.146='1E01F268'x
_C.147='6906C2FE'x
_C.148='F762575D'x
_C.149='806567CB'x
_C.150='196C3671'x
_C.151='6E6B06E7'x
_C.152='FED41B76'x
_C.153='89D32BE0'x
_C.154='10DA7A5A'x
_C.155='67DD4ACC'x
_C.156='F9B9DF6F'x
_C.157='8EBEEFF9'x
_C.158='17B7BE43'x
_C.159='60B08ED5'x
_C.160='D6D6A3E8'x
_C.161='A1D1937E'x
_C.162='38D8C2C4'x
_C.163='4FDFF252'x
_C.164='D1BB67F1'x
_C.165='A6BC5767'x
_C.166='3FB506DD'x
_C.167='48B2364B'x
_C.168='D80D2BDA'x
_C.169='AF0A1B4C'x
_C.170='36034AF6'x
_C.171='41047A60'x
_C.172='DF60EFC3'x
_C.173='A867DF55'x
_C.174='316E8EEF'x
_C.175='4669BE79'x
_C.176='CB61B38C'x
_C.177='BC66831A'x
_C.178='256FD2A0'x
_C.179='5268E236'x
_C.180='CC0C7795'x
_C.181='BB0B4703'x
_C.182='220216B9'x
_C.183='5505262F'x
_C.184='C5BA3BBE'x
_C.185='B2BD0B28'x
_C.186='2BB45A92'x
_C.187='5CB36A04'x
_C.188='C2D7FFA7'x
_C.189='B5D0CF31'x
_C.190='2CD99E8B'x
_C.191='5BDEAE1D'x
_C.192='9B64C2B0'x
_C.193='EC63F226'x
_C.194='756AA39C'x
_C.195='026D930A'x
_C.196='9C0906A9'x
_C.197='EB0E363F'x
_C.198='72076785'x
_C.199='05005713'x
_C.200='95BF4A82'x
_C.201='E2B87A14'x
_C.202='7BB12BAE'x
_C.203='0CB61B38'x
_C.204='92D28E9B'x
_C.205='E5D5BE0D'x
_C.206='7CDCEFB7'x
_C.207='0BDBDF21'x
_C.208='86D3D2D4'x
_C.209='F1D4E242'x
_C.210='68DDB3F8'x
_C.211='1FDA836E'x
_C.212='81BE16CD'x
_C.213='F6B9265B'x
_C.214='6FB077E1'x
_C.215='18B74777'x
_C.216='88085AE6'x
_C.217='FF0F6A70'x
_C.218='66063BCA'x
_C.219='11010B5C'x
_C.220='8F659EFF'x
_C.221='F862AE69'x
_C.222='616BFFD3'x
_C.223='166CCF45'x
_C.224='A00AE278'x
_C.225='D70DD2EE'x
_C.226='4E048354'x
_C.227='3903B3C2'x
_C.228='A7672661'x
_C.229='D06016F7'x
_C.230='4969474D'x
_C.231='3E6E77DB'x
_C.232='AED16A4A'x
_C.233='D9D65ADC'x
_C.234='40DF0B66'x
_C.235='37D83BF0'x
_C.236='A9BCAE53'x
_C.237='DEBB9EC5'x
_C.238='47B2CF7F'x
_C.239='30B5FFE9'x
_C.240='BDBDF21C'x
_C.241='CABAC28A'x
_C.242='53B39330'x
_C.243='24B4A3A6'x
_C.244='BAD03605'x
_C.245='CDD70693'x
_C.246='54DE5729'x
_C.247='23D967BF'x
_C.248='B3667A2E'x
_C.249='C4614AB8'x
_C.250='5D681B02'x
_C.251='2A6F2B94'x
_C.252='B40BBE37'x
_C.253='C30C8EA1'x
_C.254='5A05DF1B'x
_C.255='2D02EF8D'x
signal CRC32REX_16

Crc32PrePostConditioning:call TRACE "OFF"
if arg(1)='' then
return('FFFFFFFF'x)
else
return(bitxor(arg(1), 'FFFFFFFF'x))

UpdateCrc32:call TRACE "OFF"
z8_Crc=arg(1)
z8_Buffer=arg(2)
z8_BufferLng=length(z8_Buffer)
do while z8_BufferLng<>0
if z8_BufferLng<=2000 then
do
z8_UseSize=z8_BufferLng
z8_PerfBuffer=z8_Buffer
end
else
do
z8_UseSize=2000
z8_PerfBuffer=left(z8_Buffer,z8_UseSize)
z8_Buffer=substr(z8_Buffer,z8_UseSize+1)
end
z8_BufferLng=z8_BufferLng-z8_UseSize
do z8_ThisByte=1 to z8_UseSize
z8_ArrayEl=c2d(right(bitand(bitxor(z8_Crc, '000000'x || substr(z8_PerfBuffer, z8_ThisByte, 1)), '000000FF'x),1))
z8_Crc=Bitxor(bitand('00'x || left(z8_Crc, 3), '00FFFFFF'x),_C.z8_ArrayEl)
end
end
return(z8_Crc)

Crc32InDisplayableForm:call TRACE "OFF"
return(c2x(arg(1)))

CRC32REX_16:
signal PREFIX_17

HASHPREFIX_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'HASHPREFIX', 'Hash prefix is now "' || HashPrefix || '" (' || HashPrefix || 'define etc)'
return

HASHPREFIX_GET:
call HASHPREFIX_DEBUG
return(HashPrefix)

HASHPREFIX_SET:
HashPrefix=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'HASHPREFIX', 'Setting default value of hash Prefix to "' || HashPrefix || '"'
Default4_HashPrefix=HashPrefix
return(0)
end
if HashPrefix=='' then
HashPrefix=Default4_HashPrefix
AfterPrefix=translate(HashPrefix, '',LowerCase)
if AfterPrefix<>HashPrefix then
CryAndDie('A hash prefix should not include lower case characters!')
HashPrefixLng=length(HashPrefix)
call HASHPREFIX_DEBUG
CmdHashAsIs=HashPrefix|| 'ASIS'
CmdHashAutoTag=HashPrefix|| 'AUTOTAG'
CmdHashAutoTagClear=HashPrefix|| 'AUTOTAGCLEAR'
CmdHashAutoTagState=HashPrefix|| 'AUTOTAGSTATE'
CmdHashLoopBreak=HashPrefix|| 'BREAK'
CmdHashLoopContinue=HashPrefix|| 'CONTINUE'
CmdHashDebug=HashPrefix|| 'DEBUG'
CmdHashDefine=HashPrefix|| 'DEFINE'
CmdHashDefinePlus=HashPrefix|| 'DEFINE+'
CmdHashDefineIfReq=HashPrefix|| 'DEFINE?'
CmdHashDefineRexx=HashPrefix|| 'DEFINEREXX'
CmdHashDefineRexxPlus=HashPrefix|| 'DEFINEREXX+'
CmdHashDependsOn=HashPrefix|| 'DEPENDSON'
CmdHashElseifL=HashPrefix|| 'ELSEIF'
CmdHashEndifL=HashPrefix|| 'ENDIF'
CmdHashEof=HashPrefix|| 'EOF'
CmdHashErrorL=HashPrefix|| 'ERROR'
CmdHashEvaluateL=HashPrefix|| 'EVALUATE'
CmdHashEvaluatePlusL=HashPrefix|| 'EVALUATE+'
CmdHashIf=HashPrefix|| 'IF'
CmdHashIfdef=HashPrefix|| 'IFDEF'
CmdHashIfndef=HashPrefix|| 'IFNDEF'
CmdHashImport=HashPrefix|| 'IMPORT'
CmdHashInclude=HashPrefix|| 'INCLUDE'
CmdHashInfo=HashPrefix|| 'INFO'
CmdHashIntercept=HashPrefix|| 'INTERCEPT'
CmdHashMacroSpace=HashPrefix|| 'MACROSPACE'
CmdHashNextId=HashPrefix|| 'NEXTID'
CmdHashOneLine=HashPrefix|| 'ONELINE'
CmdHashOnExit=HashPrefix|| 'ONEXIT'
CmdHashOption=HashPrefix|| 'OPTION'
CmdHashOutput=HashPrefix|| 'OUTPUT'
CmdHashOutputHold=HashPrefix|| 'OUTPUTHOLD'
CmdHashRequire=HashPrefix|| 'REQUIRE'
CmdHashSystem=HashPrefix|| 'SYSTEM'
CmdHashTransform=HashPrefix|| 'TRANSFORM'
CmdHashRexxVar=HashPrefix|| 'REXXVAR'
CmdHashUndefL=HashPrefix|| 'UNDEF'
CmdHashWarningL=HashPrefix|| 'WARNING'
CmdHashLoopS=HashPrefix|| '{'
CmdHashLoopE=HashPrefix|| '}'
CmdHashEvaluateS=HashPrefix|| 'E'
CmdHashEvaluatePlusS=HashPrefix|| 'E+'
CmdHashUndefS=HashPrefix|| 'U'
CmdHashElseifS=HashPrefix|| 'ELSE'
CmdHashEndifS=HashPrefix|| 'END'
CmdHashErrorS=HashPrefix|| '!'
CmdHashWarningS=HashPrefix|| 'W'
return

PREFIX_17:
signal LineCmt_18

LINECOMMENT_DEBUG:
if OptionDebugOn='Y' then
do
if LineComment<>NullChar then
call OptionDebugShow 'LINECOMMENT', 'Lines starting with "' || LineComment || '" are comments ("' || InLineComment || '" for inline comments)'
else
call OptionDebugShow 'LINECOMMENT', 'Comment removal has been turned off'
end
return

LINECOMMENT_GET:
call LINECOMMENT_DEBUG
return(LineCommentSet2)

LINECOMMENT_SET:
LineComment=arg(1)
LineCommentSet2=LineComment
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'LINECOMMENT', 'Setting default value of line comment to "' || LineComment || '"'
Default4_LineComment=LineComment
return(0)
end
if LineComment=='' then
LineComment=Default4_LineComment
if translate(LineComment)='NULL' then
LineComment=NullChar
else
do
if length(LineComment)<>1 then
CryAndDie('A comment char should be one character long')
end
InLineComment=LineComment||LineComment
call LINECOMMENT_DEBUG
return

LineCmt_18:
signal WhiteSpc_19

_WsFmt:
dbgExtra=''
do CharIndex=1 to length(ExtraWhiteSpace)
if CharIndex<>1 then
dbgExtra=dbgExtra|| ', '
dbgExtra=dbgExtra||c2x(substr(ExtraWhiteSpace,CharIndex,1))
end
return(dbgExtra)

WHITESPACE_DEBUG:
if OptionDebugOn='Y' then
do
if ExtraWhiteSpace=='' then
call OptionDebugShow 'WHITESPACE', 'No extra whitespace characters defined'
else
call OptionDebugShow 'WHITESPACE', 'Extra whitespace characters are hexadecimal ' ||_WsFmt()
end
return

WHITESPACE_GET:
call WHITESPACE_DEBUG
return(ExtraWhiteSpace)

WHITESPACE_SET:
ExtraWhiteSpace=arg(1)
if ProcessedCmdLine='N' then
do
Default4_ExtraWhiteSpace=ExtraWhiteSpace
if ExtraWhiteSpace=='' then
call OptionDebugShow 'WHITESPACE', 'Setting default to no extra whitespace'
else
call OptionDebugShow 'WHITESPACE', 'Setting default to extra whitespace characters are hexadecimal ' ||_WsFmt()
return(0)
end
if ExtraWhiteSpace=='NULL' then
ExtraWhiteSpace=Default4_ExtraWhiteSpace
call WHITESPACE_DEBUG
return

WhiteSpc_19:
signal LineCont_20

LINECONTINUATION_DEBUG:
if OptionDebugOn='Y' then
do
if LineContChar=NullChar then
call OptionDebugShow 'LINECONTINUATION', 'Line continuation handling has been turned off'
else
do
call OptionDebugShow 'LINECONTINUATION', 'The line continuation marker is now "' || LineContChar || '"'
if symbol('CodexNewLine') = 'VAR' then
DbgText='"' || CodexNewLine || '"'
else
DbgText="'X' code for newline"
call DebugIncrement 1
call DebugLine '"' || LineContAddNewLine   || '" = Join with    ' ||DbgText
call DebugLine '"' || LineContWithoutSpace || '" = Join without space'
call DebugLine '"' || LineContWithSpace    || '" = Join with    space'
call DebugLine '"' || LineContDefault      || '" = Join with    space'
call DebugIncrement-1
end
end
return

LINECONTINUATION_GET:
call LINECONTINUATION_DEBUG
return(LineContCharList)

LINECONTINUATION_SET:
LineContParm=arg(1)
LineContParmSet2=LineContParm
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'LINECONTINUATION', 'Setting default value of line continuation chars to "' || LineContParm || '"'
Default4_LineContParm=LineContParm
LineContCharList=LineContParm
return(0)
end
if LineContParm=='' then
LineContParm=Default4_LineContParm
if translate(LineContParm)='NULL' then
LineContParm=NullChar
else
do
if length(LineContParm)<>1&length(LineContParm)<>5 then
CryAndDie('Invalid line continuation spec of "' || LineContParm || '"')
end
LineContCharList=overlay(LineContParm,LineContCharList)
LineContChar=substr(LineContCharList,1,1)
LineContAddNewLine=substr(LineContCharList,2,1)||LineContChar
LineContAddNewLineObs=d2c(25)||LineContChar
LineContWithoutSpace=substr(LineContCharList,3,1)||LineContChar
LineContWithSpace=substr(LineContCharList,4,1)||LineContChar
LineContDefault=substr(LineContCharList,5,1)||LineContChar
call LINECONTINUATION_DEBUG
return

LineCont_20:
AsIsCount=0
AsIsUsing=''
signal AsIs_21

AsIsPrepare:call TRACE "OFF"
AsIsParms=space(arg(1))
AsIsUsing=AsIsParms
AsIsCount=0
AsIsIndex=0
AsIsCollecting=''
call DebugLine_ASIS 'AsIsPrepare(): Cleared memory. Processing "' || AsIsUsing || '"'
call DebugIncrement 1
aiOptCnt=0
do while AsIsParms<> ''
call _SetUpAsIsTagging translate(GetQuotedText(AsIsParms, "AsIsParms"))
end
if AsIsCount<>0 then
do
if aiOptCnt=0 then
aiMsg='none'
else
do
if aiOptCnt=AsIsCount then
aiMsg='all'
else
aiMsg=aiOptCnt
end
call DebugLine_ASIS 'Have ' || AsIsCount || ' "as is" tags (' || aiMsg || ' optimised)'
end
call DebugIncrement-1
return(AsIsCount)

ExpandAsIsTags:
if AsIsModeOn='N' then
return(arg(1))

AsIs:call TRACE "OFF"
if AsIsCount=0 then
return(arg(1))
EaiString=arg(1)
AsIsCnt=ReplaceCount
do Tag=1 to AsIsIndex
if AsIsBef.Tag=='' then
EaiString=BulkChar2String(EaiString,AsIsAft.Tag)
else
do
if left(AsIsBef.Tag,2)<>SrTypePre then
EaiString=ReplaceString(EaiString,AsIsBef.Tag,AsIsAft.Tag)
else
do
select
when abbrev(AsIsBef.Tag,SrCaseIns)then
EaiString=ReplaceStringCI(EaiString,substr(AsIsBef.Tag,SrCaseIns_P),AsIsAft.Tag)
when abbrev(AsIsBef.Tag,SrFixed)then
EaiString=CompareReplaceFixed2(EaiString,substr(AsIsBef.Tag,SrFixed_P),AsIsAft.Tag)
otherwise
EaiString=ReplaceString(EaiString,AsIsBef.Tag,AsIsAft.Tag)
end
end
end
end
if OptionDebugOn='Y' then
do
if AsIsCnt<>ReplaceCount then
call DebugOutputAfterReplacement EaiString, 'ASIS'
end
return(EaiString)

ProcessAsIs:
HashCmdParms=PerformReplacementsInCmdsParameters(arg(1))
AsIsCmd=translate(GetQuotedText(HashCmdParms, "AsIsParms"))
if AsIsCmd='SETUP' then
do
AsIsPrepCache='?'
call SetupNamedAsIsStorage GetQuotedText(AsIsParms)
return(0)
end
call SetOnorOffVariable AsIsCmd, 'AsIsModeOn'
if AsIsModeOn='N' then
do
AsIsCount=0
if AsIsParms<> '' then
CryAndDie('Did not expect more than the "OFF" parameter')
call OptionsPop
end
else
do
call OptionsPush
call OptionOnOrOff_SET "KEEPINDENT",      "KeepIndent",      "ON"
call OptionOnOrOff_SET "LEAVEBLANKLINES", "LeaveBlankLines", "ON"
call LINECOMMENT_SET "NULL"
call LINECONTINUATION_SET "NULL"
call AsIsPrepare AsIsParms
end
if OptionDebugOn='Y' then
do
if AsIsCount=0 then
call DebugLine_ASIS 'AsIs mode is ' || YorN2OnorOff(AsIsModeOn) || '.  No tags prepared.'
else
call DebugLine_ASIS 'AsIs mode is ' || YorN2OnorOff(AsIsModeOn) || '.  Have ' || AsIsCount || ' tags from "' || AsIsUsing || '"'
end
return(0)

SetupNamedAsIsStorage:
AsIsNameU=translate(arg(1))
AsIsName='AI_' ||c2x(AsIsNameU)
AsIsAltCnt=arg(2)
AsIsCounter=0
if AsIsAltCnt='' then
do
TagFrom=AutoTagFirst
TagTo=AutoTagLast
end
else
do
TagFrom=1
TagTo=AsIsAltCnt
end
do Tag=TagFrom to TagTo
AsIsCounter=AsIsCounter+1
if AsIsAltCnt='' then
do
AsIsBef.AsIsCounter.AsIsName=AutoTagOnB.Tag
AsIsAft.AsIsCounter.AsIsName=AutoTagOnA.Tag
end
else
do
AsIsBef.AsIsCounter.AsIsName=ImportB.Tag
AsIsAft.AsIsCounter.AsIsName=ImportA.Tag
end
end
call _valueS AsIsName,AsIsCounter
if AsIsAltCnt='' then
call ClearAutoTags 'N'
call DebugLine_ASIS 'Captured ' || AsIsCounter || ' tags as "' || AsIsNameU || '"'
return

_SetUpAsIsTagging:
AsIsNameU=translate(arg(1))
AsIsName='AI_' ||c2x(AsIsNameU)
call DebugLine_ASIS 'Getting tags from storage named "' || AsIsNameU || '"'
call DebugIncrement 1
if symbol(AsIsName)<> 'VAR' then
CryAndDie('#AsIs "SETUP" has not been run for "' || AsIsNameU || '"')
AsIsCopyCount=_valueG(AsIsName)
do Index=1 to AsIsCopyCount
ThisBefore=AsIsBef.Index.AsIsName
ThisAfter=AsIsAft.Index.AsIsName
AsIsCount=AsIsCount+1
call DebugLine_ASIS 'AsIs #' || AsIsCount || ': From=' || DebugRightArrow || ThisBefore || DebugLeftArrow || ',  To=' ||DebugRightArrow||ThisAfter||DebugLeftArrow
if length(ThisBefore)<>1 then
do
AsIsCollecting=''
AsIsIndex=AsIsIndex+1
AsIsBef.AsIsIndex=ThisBefore
AsIsAft.AsIsIndex=ThisAfter
end
else
do
if AsIsCollecting=='' then
do
AsIsCollecting='OptAsIs' ||AsIsIndex
call _valueS AsIsCollecting, ''
AsIsIndex=AsIsIndex+1
AsIsBef.AsIsIndex=''
AsIsAft.AsIsIndex=AsIsCollecting
end
aiOptCnt=aiOptCnt+1
aiOptList=_valueG(AsIsCollecting)||ThisBefore
aiIndex=length(aiOptList)
call _valueS AsIsCollecting,aiOptList
call _valueS AsIsCollecting|| '.' ||aiIndex,ThisAfter
end
end
call DebugLine_ASIS 'Copied ' || AsIsCopyCount || ' tags'
call DebugIncrement-1
return

AsIs_21:
AtChangeType=''
AtChangeTypeDesc="CASESENSITIVE"
signal AutoTag_22

ShowAutoTagStateWhenDebugOn:
if OptionDebugOn='Y' then
do
if AutoTagName='' then
DbgText1=''
else
DbgText1=' (named "' || AutoTagName || '")'
call DebugLine_AUTOTAG 'AutoTagging is ' || YorN2OnorOff(AutoTagOn) || '.  Have ' || ((AutoTagLast - AutoTagFirst) + 1) || ' tags available in state #' ||AutoTagStateCnt||DbgText1
if arg(1)='Y' then
do
call DebugIncrement 1
do Tag=AutoTagFirst to AutoTagLast
call DebugLine_AUTOTAG 'AutoTag #' || Tag || ': From=' || DebugRightArrow || AutoTagOnB.Tag || DebugLeftArrow || ',  To=' ||DebugRightArrow||AutoTagOnA.Tag||DebugLeftArrow
end
call DebugIncrement-1
end
end
return

CompletelyInitializeAutoTagState:
AutoTagOn='N'
call ClearAutoTags 'Y'
return

ClearAutoTags:
if arg(1)='N' then
do
if AutoTagStateCnt=0 then
AutoTagLast=0
else
AutoTagLast=AutoTagState.AutoTagStateCnt.Last
end
else
do
AutoTagLast=0
AutoTagStateCnt=0
AutoTagFirst=1
AutoTagName=''
end
if OptionDebugOn='Y' then
do
if AutoTagStateCnt=0 then
call DebugLine_AUTOTAG 'Cleared ALL autotags (no state information saved - State #0).'
else
call ShowAutoTagStateWhenDebugOn
end
return

AutoTag:call TRACE "OFF"
EatString=arg(1)
if AutoTagFirst>AutoTagLast then
return(EatString)
AtCnt=ReplaceCount
do Tag=AutoTagFirst to AutoTagLast
if left(AutoTagOnB.Tag,2)<>SrTypePre then
EatString=ReplaceString(EatString,AutoTagOnB.Tag,AutoTagOnA.Tag)
else
do
select
when abbrev(AutoTagOnB.Tag,SrCaseIns)then
EatString=ReplaceStringCI(EatString,substr(AutoTagOnB.Tag,SrCaseIns_P),AutoTagOnA.Tag)
when abbrev(AutoTagOnB.Tag,SrFixed)then
EatString=CompareReplaceFixed2(EatString,substr(AutoTagOnB.Tag,SrFixed_P),AutoTagOnA.Tag)
otherwise
EatString=ReplaceString(EatString,AutoTagOnB.Tag,AutoTagOnA.Tag)
end
end
end
if OptionDebugOn='Y' then
do
if AtCnt<>ReplaceCount then
call DebugOutputAfterReplacement EatString, 'ATAG'
end
return(EatString)

ProcessAutoTagClear:
if arg(1)='' then
AtClearAll='N'
else
do
AtParm=GetQuotedText(arg(1))
if translate(AtParm)<> 'ALL' then
CryAndDie('Invalid parameter of "' || AtParm || '" specified!')
AtClearAll='Y'
end
call ClearAutoTags AtClearAll
return(0)

_GetStateIndexForNameOrDie:
gsiName=arg(1)
do NameIndex=1 to AutoTagStateCnt
if gsiName=AutoTagState.NameIndex.Name then
return(NameIndex)
end
CryAndDie('There is no state known as "' || gsiName(1) || '"')

MatchesAutoTagStateIncDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches "#AutoTagState +" at ' || AutoTagState.MatchIndex.AtLine || ')')

ProcessAutoTagState:
Rest=strip(arg(1))
Ats1stParm=left(Rest,1)
if Ats1stParm='+' | Ats1stParm = '-' then
Rest=substr(Rest,2)
else
Ats1stParm=GetQuotedText(arg(1), "Rest")
select
when Ats1stParm='+' then
do
AutoTagStateCnt=AutoTagStateCnt+1
AutoTagState.AutoTagStateCnt.First=AutoTagFirst
AutoTagState.AutoTagStateCnt.Last=AutoTagLast
AutoTagState.AutoTagStateCnt.Name=AutoTagName
AutoTagState.AutoTagStateCnt.AtOnOff=AutoTagOn
AutoTagState.AutoTagStateCnt.AtLine=CurrentSourceLocation()
BeforeFirst=AutoTagFirst
BeforeLast=AutoTagLast
AutoTagFirst=AutoTagLast+1
AutoTagName=''
do while Rest<> ''
StateAlias=translate(GetQuotedText(Rest, "Rest"))
if StateAlias="REMEMBER" then
do
CopyFrom=BeforeFirst
Copyto=BeforeLast
end
else
do
NameIndex=_GetStateIndexForNameOrDie(StateAlias)
CopyFrom=AutoTagState.NameIndex.First
Copyto=AutoTagState.NameIndex.Last
end
do AddTagIndex=CopyFrom to CopyTo
call _AddAutoTag AutoTagOnB.AddTagIndex,AutoTagOnA.AddTagIndex
end
end
if OptionDebugOn='Y' then
call DebugLine_AUTOTAG 'Remembering current #AutoTag state, now in state #' ||AutoTagStateCnt
end
when Ats1stParm='-' then
do
if AutoTagStateCnt<=0 then
CryAndDie('No #autotag states memorised!')
if OptionDebugOn='Y' then
call DebugLine_AUTOTAG 'This restore matches the setup at ' ||AutoTagState.AutoTagStateCnt.AtLine
BeforeFirst=AutoTagFirst
BeforeLast=AutoTagLast
AutoTagFirst=AutoTagState.AutoTagStateCnt.First
AutoTagLast=AutoTagState.AutoTagStateCnt.Last
AutoTagOn=AutoTagState.AutoTagStateCnt.AtOnOff
AutoTagName=AutoTagState.AutoTagStateCnt.Name
AutoTagStateCnt=AutoTagStateCnt-1
if Rest='' then
Remember='N'
else
do
Rest=translate(GetQuotedText(Rest, "Rest"))
if Rest="REMEMBER" then
Remember='Y'
else
CryAndDie('Invalid parameter of "' || Rest || '" specified (expected "REMEMBER")')
end
if Rest='' then
DbgWord='dropping'
else
do
Rest=translate(GetQuotedText(Rest))
if Rest<> "REMEMBER" then
CryAndDie('Invalid parameter of "' || Rest || '" specified (expected "REMEMBER")')
DbgWord='remembering'
AutoTagLast=AutoTagFirst-1
do AddTagIndex=BeforeFirst to BeforeLast
call _AddAutoTag AutoTagOnB.AddTagIndex,AutoTagOnA.AddTagIndex
end
end
if OptionDebugOn='Y' then
call DebugLine_AUTOTAG 'Restoring #AutoTag state #' || AutoTagStateCnt || ', we are ' || DbgWord || ' any new tags you may have defined'
end
otherwise
AutoTagName=translate(Ats1stParm)
if Rest<> '' then
call DieIfExtraUnexpectedParms Rest
if OptionDebugOn='Y' then
call DebugLine_AUTOTAG 'This state is now named "' || AutoTagName || '"'
end
call ShowAutoTagStateWhenDebugOn AutoTagOn
return(0)

_AddAutoTag:
TheTagB=arg(1)
TheTagA=arg(2)
ThePosn=arg(3)
if ThePosn='' then
ThePosn='999999'
ThePosn=(ThePosn+AutoTagFirst)-1
if ThePosn>AutoTagLast then
do
AutoTagLast=AutoTagLast+1
SlotIndex=AutoTagLast
end
else
do
ToIndex=AutoTagLast+2
do MoveIndex=ThePosn to AutoTagLast
ToIndex=ToIndex-1
FromIndex=ToIndex-1
AutoTagOnB.ToIndex=AutoTagOnB.FromIndex
AutoTagOnA.ToIndex=AutoTagOnA.FromIndex
end
SlotIndex=ThePosn
AutoTagLast=AutoTagLast+1
end
AutoTagOnB.SlotIndex=TheTagB
AutoTagOnA.SlotIndex=TheTagA
return

_DeleteAutoTag:
TheTagB=arg(1)
do Tag=AutoTagFirst to AutoTagLast
if TheTagB=AutoTagOnB.Tag then
do
AutoTagLast=AutoTagLast-1
do ToIndex=Tag to AutoTagLast
FromIndex=ToIndex+1
AutoTagOnB.ToIndex=AutoTagOnB.FromIndex
AutoTagOnA.ToIndex=AutoTagOnA.FromIndex
end
return('Y')
end
end
if OptionDebugOn='Y' then
call DebugLine_AUTOTAG 'No need to delete the tag (it does not exist)'
return('N')

ProcessAutoTag:
AtBefore=GetQuotedText(arg(1), "Rest")
if AtBefore='' then
CryAndDie("You did not supply text to be replaced (can't replace empty string)!")
AtDumpList='N'
OnOrOff=IsStringOnOrOffCmd(AtBefore)
if OnOrOff<> '' & Rest = '' then
do
AutoTagOn=OnOrOff
if AutoTagOn='Y' then
AtDumpList='Y'
end
else
do
AtBefore_NoCT=AtBefore
AtBefore=AtChangeType||AtBefore
if Rest='' then
call _DeleteAutoTag AtBefore
else
do
AtAfter=ReplaceString(GetQuotedText(Rest, "Rest"),AutoTagSelf,AtBefore_NoCT)
if ReplacementsAllowed='Y' then
do
do while pos(StartsMacroReplacement,AtAfter)<>0
BeforeCount=ReplaceCount
AtAfterR=_ReplaceAllHashDefinedVariables(AtAfter)
if pos(MarksNewLine,AtAfterR)<>0 then
leave
AtAfter=AtAfterR
if OptionDebugOn='Y' then
do
if BeforeCount<>ReplaceCount then
call DebugOutputAfterReplacement AtAfter, 'VP2O'
end
end
if pos(StartsStdSymbolReplacement,AtAfter)<>0 then
do
if pos(MarksNewLine,AtAfter)=0 then
do
BeforeCount=ReplaceCount
AtAfterR=ReplaceStandardDefinitions(AtAfter)
if BeforeCount<>ReplaceCount then
do
if pos(MarksNewLine,AtAfterR)=0 then
do
AtAfter=AtAfterR
if OptionDebugOn='Y' then
call DebugOutputAfterReplacement AtAfter, 'SP2O'
end
end
end
end
end
AtSlot=''
if Rest<> '' then
do
SlotSpec=word(rest,1)
Rest=subword(rest,2)
if left(SlotSpec,1)<> '#' then
CryAndDie('Invalid slot specification of "' || SlotSpec || '" supplied, must begin with a "#"!')
AtSlot=substr(SlotSpec,2)
end
if OptionDebugOn='Y' then
call DebugLine_AUTOTAG 'Assigning ' || DebugRightArrow || AtBefore_NoCT || DebugLeftArrow || ' = ' || DebugRightArrow || AtAfter || DebugLeftArrow || ' (TYPE=' || AtChangeTypeDesc || ')'
call _AddAutoTag AtBefore,AtAfter,AtSlot
end
end
call ShowAutoTagStateWhenDebugOn AtDumpList
if Rest<> '' then
CryAndDie('Too many parameters!')
return(0)

ATCHANGETYPE_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'ATCHANGETYPE', 'AutoTag change type is "' || AtChangeTypeDesc || '"'
return

ATCHANGETYPE_GET:
call ATCHANGETYPE_DEBUG
return(AtChangeTypeDesc)

ATCHANGETYPE_SET:
AtChangeTypeDesc=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'ATCHANGETYPE', 'Setting default change type to "' || AtChangeTypeDesc || '"'
Default4_ATCHANGETYPEDESC=AtChangeTypeDesc
return(0)
end
if AtChangeTypeDesc=='' then
AtChangeTypeDesc=Default4_ATCHANGETYPEDESC
SelectOn=translate(AtChangeTypeDesc)
select
when SelectOn="CASESENSITIVE" then
AtChangeType=''
when SelectOn="CASEINSENSITIVE" then
AtChangeType=SrCaseIns
when SelectOn="FIXED" then
AtChangeType=SrFixed
otherwise
CryAndDie('Unknown ATCHANGETYPE option of "' || AtChangeTypeDesc || '"')
end
call ATCHANGETYPE_DEBUG
return

AutoTag_22:
OptionCount=0
LongestPpwOptionLng=0
call _OptionsAdd "ALLOWPACK"
call _OptionsAdd "ALLOWSPELL"
call _OptionsAdd "CSREPLACEMENT"
call _OptionsAdd "DEFINEMACROREPLACE"
call _OptionsAdd "KEEPINDENT"
call _OptionsAdd "LEAVEBLANKLINES"
call _OptionsAdd "REPLACE"
call _OptionsAdd "ATCHANGETYPE"
call _OptionsAdd "DEBUGLEVEL"
call _OptionsAdd "EXTRAINDENT"
call _OptionsAdd "EXPANDX"
call _OptionsAdd "HASHPREFIX"
call _OptionsAdd "LINECOMMENT"
call _OptionsAdd "LINECONTINUATION"
call _OptionsAdd "MACROPARMTAGS"
call _OptionsAdd "REPLACEMENTTAGS"
call _OptionsAdd "TABS"
call _OptionsAdd "WARNINGS"
call _OptionsAdd "WHITESPACE"
signal OPTION_23

_OptionsAdd:
OptionCount=OptionCount+1
OptionList.OptionCount=arg(1)
ThisLng=length(arg(1))
if ThisLng>LongestPpwOptionLng then
LongestPpwOptionLng=ThisLng
return

SetUpPpwizardOptionDefaults:
if RexSystemOpSys<> "UNIX" then
DefWhite=d2c(26)||d2c(27)
else
DefWhite=d2c(13)||d2c(26)||d2c(27)
ProcessedCmdLine='N'
call DebugLine_OPTIONS 'Setting PPWIZARD defaults (may be overriden with ' || RexOptionChar || 'option switch)'
call DebugIncrement 1
call OptionOnOrOff_SET "ALLOWPACK",          "AllowPack",           "ON"
call OptionOnOrOff_SET "ALLOWSPELL",         "AllowSpell",          "ON"
call ATCHANGETYPE_SET "CASESENSITIVE"
call OptionOnOrOff_SET "CSREPLACEMENT",      "CsReplacement",       "OFF"
call DEBUGLEVEL_SET 'ALL,-USER1,-USER2'
call OptionOnOrOff_SET "DEFINEMACROREPLACE", "DefineMacroReplace",  "OFF"
call EXPANDX_SET 'LATE'
call EXTRAINDENT_SET 'NULL'
call HASHPREFIX_SET '#'
call OptionOnOrOff_SET "KEEPINDENT",         "KeepIndent",          "OFF"
call OptionOnOrOff_SET "LEAVEBLANKLINES",    "LeaveBlankLines",     "OFF"
call LINECOMMENT_SET ';'
call LINECONTINUATION_SET '\%-+ '
call MACROPARMTAGS_SET '{}$'
call OptionOnOrOff_SET "REPLACE",            "ReplacementsAllowed", "ON"
call REPLACEMENTTAGS_SET '<>$?'
call TABS_SET 'Warnings'
call WARNINGS_SET ''
call WHITESPACE_SET DefWhite
call DebugIncrement-1
return

SetUpOptionsForThisBuild:
ProcessedCmdLine='Y'
call DebugLine_OPTIONS 'Initializing #options for this build of ' ||CurrentOutFile
call DebugIncrement 1
call OptionOnOrOff_SET "ALLOWPACK",          "AllowPack",           ""
call OptionOnOrOff_SET "ALLOWSPELL",         "AllowSpell",          ""
call ATCHANGETYPE_SET ''
call OptionOnOrOff_SET "CSREPLACEMENT",      "CsReplacement",       ""
call DEBUGLEVEL_SET ''
call OptionOnOrOff_SET "DEFINEMACROREPLACE", "DefineMacroReplace",  ""
call EXPANDX_SET ''
call EXTRAINDENT_SET ''
call HASHPREFIX_SET ''
call OptionOnOrOff_SET "KEEPINDENT",         "KeepIndent",          ""
call OptionOnOrOff_SET "LEAVEBLANKLINES",    "LeaveBlankLines",     ""
call LINECOMMENT_SET ''
call LINECONTINUATION_SET ''
call MACROPARMTAGS_SET ''
call OptionOnOrOff_SET "REPLACE",            "ReplacementsAllowed", ""
call REPLACEMENTTAGS_SET ''
call TABS_SET ''
call WARNINGS_SET ''
call WHITESPACE_SET 'NULL'
call DebugIncrement-1
return

MatchesOptionStackPushDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches "#option PUSH" at ' || OptPush.MatchIndex || ')')

OptionsPush:
OptionStackCnt=OptionStackCnt+1
OptPush.OptionStackCnt=CurrentSourceLocation()
PushName='OptPush' ||OptionStackCnt
if OptionDebugOn='Y' then
call DebugLine_OPTIONS 'Saving current options on stack as #' ||OptionStackCnt
call DebugIncrement 1
do OptionIndex=1 to OptionCount
call _valueS PushName|| '.' ||OptionIndex,OptionGetValue(OptionList.OptionIndex)
end
call DebugIncrement-1
return

OptionsPop:
if OptionStackCnt<=0 then
CryAndDie('There are no options on the stack to pop!')
if OptionDebugOn='Y' then
call DebugLine_OPTIONS 'Restoring current options from #' || OptionStackCnt || ' (pushed at ' || OptPush.OptionStackCnt || ')'
call DebugIncrement 1
PushName='OptPush' ||OptionStackCnt
do OptionIndex=1 to OptionCount
call OptionSetValue OptionList.OptionIndex,_valueG(PushName|| '.' ||OptionIndex)
end
call DebugIncrement-1
OptionStackCnt=OptionStackCnt-1
return

ProcessOption:
Options=arg(1)
if ProcessedCmdLine='Y' then
Options=PerformReplacementsInCmdsParameters(Options)
if Options='' then
CryAndDie('No options specified!')
do while Options<> ''
parse var Options Word1' 'RestOptions
Word1=translate(word1)
select
when Word1="PUSH" | Word1 = "+" then
do
Options=RestOptions
call OptionsPush
end
when Word1="POP" | Word1 = "-" then
do
Options=RestOptions
call OptionsPop
end
otherwise
do
if pos('=',Options)=0 then
CryAndDie('Could not find an "=" sign in "' || Options || '"')
parse var Options ThisOption'='Options
ThisOption=translate(strip(ThisOption))
ThisValue=GetQuotedText(Options, "Options")
call OptionSetValue ThisOption,ThisValue
end
end
end
return(0)

OptionDebugShow:
if OptionDebugOn='Y' then
call DebugLine_OPTIONS left(arg(1),LongestPpwOptionLng)|| ': ' ||arg(2)
return

OptionOnOrOff_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow arg(1), 'Currently set to ' ||YorN2OnorOff(_valueG(arg(2)))
return

OptionOnOrOff_SET:
parse arg OptionName,OnOffVar2Set,OnOffValue
if ProcessedCmdLine='N' then
do
call OptionDebugShow OptionName, 'Setting default to "' || OnOffValue || '"'
call _valueS "Default4_" ||OnOffVar2Set,OnOffValue
return(0)
end
if OnOffValue=='' then
OnOffValue=_valueG("Default4_" ||OnOffVar2Set)
OnOrOff=IsStringOnOrOffCmd(OnOffValue)
if OnOrOff='' then
CryAndDie('Tried to set "' || OnOffVar2Set || '" to an invalid value of "' || OnOffValue || '"')
call _valueS OnOffVar2Set,OnOrOff
call OptionOnOrOff_DEBUG OptionName,OnOffVar2Set
return(0)

OptionOnOrOff_GET:
parse arg OptionName,OnOffVar2Get
VarState=YorN2OnorOff(_valueG(OnOffVar2Get))
call OptionOnOrOff_DEBUG OptionName,OnOffVar2Get
return(VarState)

OptionSetValue:
parse arg sOption,sValue
select
when sOption="ALLOWPACK" then
call OptionOnOrOff_SET "ALLOWPACK", "AllowPack",sValue
when sOption="ALLOWSPELL" then
call OptionOnOrOff_SET "ALLOWSPELL", "AllowSpell",sValue
when sOption="ATCHANGETYPE" then
call ATCHANGETYPE_SET sValue,sOption
when sOption="CSREPLACEMENT" then
call OptionOnOrOff_SET "CSREPLACEMENT", "CsReplacement",sValue
when sOption="DEBUGLEVEL" then
call DEBUGLEVEL_SET sValue,sOption
when sOption="DEFINEMACROREPLACE" then
call OptionOnOrOff_SET "DEFINEMACROREPLACE", "DefineMacroReplace",sValue
when sOption="EXPANDX" then
call EXPANDX_SET sValue,sOption
when sOption="EXTRAINDENT" then
call EXTRAINDENT_SET sValue,sOption
when sOption="HASHPREFIX" then
call HASHPREFIX_SET sValue,sOption
when sOption="KEEPINDENT" then
call OptionOnOrOff_SET "KEEPINDENT", "KeepIndent",sValue
when sOption="LEAVEBLANKLINES" then
call OptionOnOrOff_SET "LEAVEBLANKLINES", "LeaveBlankLines",sValue
when sOption="LINECOMMENT" then
call LINECOMMENT_SET sValue,sOption
when sOption="LINECONTINUATION" then
call LINECONTINUATION_SET sValue,sOption
when sOption="MACROPARMTAGS" then
call MACROPARMTAGS_SET sValue,sOption
when sOption="REPLACE" then
call OptionOnOrOff_SET "REPLACE", "ReplacementsAllowed",sValue
when sOption="REPLACEMENTTAGS" then
call REPLACEMENTTAGS_SET sValue,sOption
when sOption="TABS" then
call TABS_SET sValue,sOption
when sOption="WARNINGS" then
call WARNINGS_SET sValue,sOption
when sOption="WHITESPACE" then
call WHITESPACE_SET sValue,sOption
otherwise
CryAndDie("Can't set '" || sOption || "' as this option is unknown")
end
return

OptionGetValue:
parse arg gOption
select
when gOption="ALLOWPACK" then
return(OptionOnOrOff_GET("ALLOWPACK", "AllowPack"))
when gOption="ALLOWSPELL" then
return(OptionOnOrOff_GET("ALLOWSPELL", "AllowSpell"))
when gOption="ATCHANGETYPE" then
return(ATCHANGETYPE_GET(gOption))
when gOption="CSREPLACEMENT" then
return(OptionOnOrOff_GET("CSREPLACEMENT", "CsReplacement"))
when gOption="DEBUGLEVEL" then
return(DEBUGLEVEL_GET(gOption))
when gOption="DEFINEMACROREPLACE" then
return(OptionOnOrOff_GET("DEFINEMACROREPLACE", "DefineMacroReplace"))
when gOption="EXPANDX" then
return(EXPANDX_GET(gOption))
when gOption="EXTRAINDENT" then
return(EXTRAINDENT_GET(gOption))
when gOption="HASHPREFIX" then
return(HASHPREFIX_GET(gOption))
when gOption="KEEPINDENT" then
return(OptionOnOrOff_GET("KEEPINDENT", "KeepIndent"))
when gOption="LEAVEBLANKLINES" then
return(OptionOnOrOff_GET("LEAVEBLANKLINES", "LeaveBlankLines"))
when gOption="LINECOMMENT" then
return(LINECOMMENT_GET(gOption))
when gOption="LINECONTINUATION" then
return(LINECONTINUATION_GET(gOption))
when gOption="MACROPARMTAGS" then
return(MACROPARMTAGS_GET(gOption))
when gOption="REPLACE" then
return(OptionOnOrOff_GET("REPLACE", "ReplacementsAllowed"))
when gOption="REPLACEMENTTAGS" then
return(REPLACEMENTTAGS_GET(gOption))
when gOption="TABS" then
return(TABS_GET(gOption))
when gOption="WARNINGS" then
return(WARNINGS_GET(gOption))
when gOption="WHITESPACE" then
return(WHITESPACE_GET(gOption))
otherwise
CryAndDie("Can't get '" || gOption || "' as this option is unknown")
end
return

OPTION_23:
DefRexxSpecialSepTag='<' || '?xRexxEos>'
call SetDollarTraceState 'N'
call InitializeDefineRexx
signal Def_Rexx_24

SetDollarTraceState:
DefRexxDolTrace=arg(1)
return

InitializeDefineRexx:
DefRexxVar=''
DefRexxAddType=''
DefRexxCode=''
DefRexxStartLoc=''
DefRexxPack='Y'
DefRexxTraceNext='N'
DefRexxLineCnt=0
DefRexxTraceAll=DefRexxDolTrace
DefRexxNumTrace=0
DefRexxTraceAllowed='Y'
return

ProcessDefineRexx:
if arg(1)='' then
do
if DefRexxVar='' then
CryAndDie("Not currently defining rexx code!", 'To execute you need to specify a parameter of ""')
if DefRexxNumTrace<>0 then
do
if OptionDebugOn='Y' then
do
if DefRexxVar<> '?JustExec?';then
EndCmt='@Finished@ (Executing rexx from macro "' || DefRexxVar || '")'
else
EndCmt="@Finished@"
call DefRexxAddLine "call RexxTrace '" || EndCmt || "','?'"
DefRexxNumTrace=DefRexxNumTrace+1
end
call DebugLine_DEFINING DefRexxNumTrace|| ' $trace statements inserted'
end
if DefineMacroReplace='Y' then
DefRexxCode=PerformReplacementsInCmdsParameters(DefRexxCode)
if DefRexxVar<> '?JustExec?';then
do
call AddHashDefine DefRexxVar,DefRexxCode,DefRexxAddType
end
else
do
if OptionDebugOn='Y' then
call DebugLine_DEFINING 'Rexx code will be immediately executed but not saved'
DefRexxCode=PerformReplacementsInCmdsParameters(DefRexxCode)
call ExecRexxCmd DefRexxCode
end
call InitializeDefineRexx
end
else
do
if DefRexxVar<> '' then
CryAndDie("Already in rexx code block started at " ||DefRexxStartLoc)
call InitializeDefineRexx
DefRexxStartLoc=CurrentSourceLocation()
DefRexxAddType=arg(2)
DefRexxVar=GetQuotedText(PerformReplacementsInCmdsParameters(arg(1)), "Rest")
if DefRexxVar='' then
DefRexxVar='?JustExec?';
if Rest<> '' then
do
Rest=translate(Rest)
do until Rest=''
DefSpec=GetQuotedText(Rest, "Rest")
select
when DefSpec='NOPACK' then
DefRexxPack='N'
when DefSpec='$TRACE' then
DefRexxTraceAll='Y'
when DefSpec='$TRACE_OFF' then
DefRexxTraceAll='N'
otherwise
CryAndDie('Invalid option of "' || DefSpec || '" used')
end
end
end
if OptionDebugOn='Y' then
do
if DefRexxPack='Y' then
call DebugLine_DEFINING "AllowPack option is currently " ||YorN2OnorOff(AllowPack)
if DefRexxTraceAll='Y' then
call DebugLine_DEFINING '$Trace statements for each line are being inserted!'
else
call DebugLine_DEFINING '$Trace statements for each line are NOT being inserted!'
if DefRexxVar<> '?JustExec?';then
StrCmt='@Starting@ (Executing rexx from macro "' || DefRexxVar || '")'
else
StrCmt="@Starting@"
call DefRexxAddLine "call RexxTrace '" || StrCmt || "','?'"
DefRexxNumTrace=DefRexxNumTrace+1
end
end
return(0)

AddDefineRexxLine:
NewRexxLine=strip(arg(1))
DefRexxLineCnt=DefRexxLineCnt+1
if right(NewRexxLine,2)=RexxCmtEnd then
do
StartCmtPos=lastpos(RexxCmtStart,NewRexxLine)
if StartCmtPos<>0 then
do
if StartCmtPos=0 then
NewRexxLine=''
else
NewRexxLine=strip(left(NewRexxLine,StartCmtPos-1), 'T')
end
end
do while right(NewRexxLine,1)=';'
NewRexxLine=strip(left(NewRexxLine,length(NewRexxLine)-1), 'T')
end
if NewRexxLine='' then
return
UnpackedLine=space(NewRexxLine)
if DefRexxPack='Y' then
do
if AllowPack='Y' then
NewRexxLine=CompressRexxLine(NewRexxLine)
end
DropLine='N'
if translate(word(NewRexxLine,1))="$TRACE" then
do
Rest=translate(subword(NewRexxLine,2))
select
when Rest="ON" then
do
DefRexxTraceAllowed='Y'
DropLine='Y'
end
when Rest="OFF" then
do
DefRexxTraceAllowed='N'
DropLine='Y'
end
otherwise
do
DropLine='Y'
if OptionDebugOn='Y' then
do
UserTraceCmt=subword(NewRexxLine,2)
if UserTraceCmt='' then
DefRexxTraceNext="Y"
else
do
call DebugLine_DEFINING '$tracing comment: ' ||UserTraceCmt
DefRexxTraceNext="N"
UserTraceCmt=ReplaceString(UserTraceCmt, "'", "''")
NewRexxLine="call RexxTrace '" || UserTraceCmt || "','?'"
call DefRexxAddLine NewRexxLine
DefRexxNumTrace=DefRexxNumTrace+1
end
end
end
end
end
if DropLine='Y' then
DropLine='N'
else
do
if DefRexxTraceNext="Y" then
TraceThis='Y'
else
do
if DefRexxTraceAll='N' then
TraceThis='N'
else
do
if pos('/' || translate(NewRexxLine) || '/', "/THEN/DO/ELSE/")=0 then
TraceThis='Y'
else
TraceThis='N'
end
end
if TraceThis='Y' then
do
DefRexxTraceNext="N"
if OptionDebugOn='Y' then
do
if DefRexxTraceAllowed='Y' then
do
call DebugLine_DEFINING '$tracing: ' ||UnpackedLine
TraceThis=ReplaceString(UnpackedLine, "'", "''")
NewRexxLine="call RexxTrace '@" || DefRexxLineCnt || " -> " || TraceThis || "',,'Y'" ||DefRexxSpecialSepTag||NewRexxLine
DefRexxNumTrace=DefRexxNumTrace+1
end
end
end
call DefRexxAddLine NewRexxLine
end
return

DefRexxAddLine:
if DefRexxCode='' then
DefRexxCode=arg(1)
else
DefRexxCode=DefRexxCode||DefRexxSpecialSepTag||arg(1)
return

Def_Rexx_24:
NameOfOs2ReginaRexxInterpreter=""
signal Rexx_25

_GetNameOfMacroSpaceExe:
if Symbol('MacroSpaceExe') <> 'VAR' then
do
MacroSpaceExeBase='MacroSpc.EXE'
MacroSpaceExe=_filespec('drive', PpWizardPgmName) || _filespec('Path',PpWizardPgmName)||MacroSpaceExeBase
if SafeQueryExists(MacroSpaceExe)='' then
do
MacroSpaceExe=FindFileInPath(MacroSpaceExeBase, '*PATH')
if MacroSpaceExe="" then
MacroSpaceExe=FindFileInPath(MacroSpaceExeBase, '*DPATH')
end
call DebugLine 'Macro Space Pgm: ' ||MacroSpaceExe
end
return(MacroSpaceExe)

_GetNameOfOs2ReginaExe:
if Symbol('Os2ReginaExe') <> 'VAR' then
do
Os2ReginaExeBase='ROS2REXX.EXE'
Os2ReginaExe=_filespec('drive', PpWizardPgmName) || _filespec('Path',PpWizardPgmName)||Os2ReginaExeBase
if SafeQueryExists(Os2ReginaExe)='' then
do
Os2ReginaExe=FindFileInPath(Os2ReginaExeBase, '*PATH')
end
end
return(Os2ReginaExe)

DoMacroSpaceOperation:
parse arg MsCommand,MsFile,MsFunction,MsQuiet
CallersLine=SIGL
call DebugLine 'Trying to macrospace "' || MsCommand || '" "' || MsFile || '" alias (' || MsFunction || ')'
TmpFile=RexGetTmpFileName()
CheckPgm=_GetNameOfMacroSpaceExe()
if CheckPgm='' then
do
if MsQuiet="QUIET" then
return
else
CryAndDie("Can't perform macro space command as " || MacroSpaceExeBase || ' is unavailable.')
end
FailMsg='MACRO SPACE COMMAND FAILED'
call AddressCmd CheckPgm|| ' ' || MsCommand || ' ' || MsFile || ' ' || MsFunction || ' >' || TmpFile || ' 2>&1'
if MsQuiet="QUIET" then
return
else
signal CheckMacroSpaceRc

CheckRexxModuleForSyntaxErrors:
call DebugLine 'CheckRexxModuleForSyntaxErrors()'
if RexWhich='REGINA' then
do
call CallStubInGeneratedCodeToCheckSyntax
return
end
CallersLine=SIGL
TmpFile=RexGetTmpFileName()
CheckPgm=_GetNameOfMacroSpaceExe()
if CheckPgm='' then
do
call DebugLine "Can't use normal validation method on the rexx syntax - " || MacroSpaceExeBase || ' file not found!'
call CallStubInGeneratedCodeToCheckSyntax
return
end
FailMsg='INVALID SYNTAX'
call AddressCmd CheckPgm|| ' CheckSyntax ' || Output.1.File || ' >' || NameOfNulDevice() || ' 2>' ||TmpFile

CheckMacroSpaceRc:
CheckRc=Rc
if CheckRc=0 then
do
DosDelRc=_SysFileDelete(TmpFile)
call UseOs2ReginaToDoubleCheckSyntax
return
end
call Line1 ''
call Char1 ErrorColor
call Line1 FailMsg
call Line1 copies('~',length(FailMsg))
do while lines(TmpFile)<>0
call Line1 linein(TmpFile)
end
call Char1 Reset|| ''
CloseRc=stream(TmpFile, 'c', 'close')
DosDelRc=_SysFileDelete(TmpFile)
AbnormalExit(CallersLine, "Syntax Error in generated rexx code")

CallStubInGeneratedCodeToCheckSyntax:
CheckingFile=Output.1.File
call DebugIncrement 1
call DebugLine 'Calling stub in generated code'
signal ON SYNTAX NAME SyntaxErrorInGeneratedCode
CheckRc='*?*'
interpret 'CheckRc =  "' || CheckingFile || '"("' || SyntaxOkText || '")'
if CheckRc<>SyntaxOkRc then
CryAndDie('Probably Syntax Error, got unexpected RC of "' || CheckRc || '"')
call DebugIncrement-1
return

SyntaxErrorInGeneratedCode:
CryAndDie('Faulty syntax in generated "' || CheckingFile || '"!')

UseOs2ReginaToDoubleCheckSyntax:
if RexWhich='REGINA' then
return
if NameOfOs2ReginaRexxInterpreter='-' then
return
call DebugLine 'OS/2 rexx already passed code, can we double check using OS/2 regina?'
UseExe=NameOfOs2ReginaRexxInterpreter
if UseExe='' then
UseExe=_GetNameOfOs2ReginaExe()
if UseExe='' then
return
CheckingFile=Output.1.File
call DebugIncrement 1
call DebugLine 'Checking using "' || UseExe || '"'
call AddressCmd UseExe|| ' ' || CheckingFile || ' ' ||SyntaxOkText
if Rc<>SyntaxOkRc&Rc<>255 then
CryAndDie('Probably syntax error in "' || Output.1.File || '"', 'Got unexpected RC of "' || Rc || '" from ' ||UseExe)
call DebugIncrement-1
return

Rexx_25:
InfiniteLoopDetected='N'
InfiniteLoopWhen=0
InfiniteIncludeLoopWhen=0
RexxSkipCounter=0
ArePositionalChars='"' || "'="
MarksPhpXml='<' || '?'
signal Define_26

InitCondNlCount:
CondNlCount=0
return

_RXQuote:
parse arg z9_Right,z9_Quote,z9_OpQuote
z9_Break=z9_Quote|| '||,' ||DefRexxSpecialSepTag||z9_Quote
z9_DQuote=z9_Quote||z9_Quote
z9_Left=''
do while length(z9_Right)>100
if z9_Left=='' then
z9_Left=ReplaceString(left(z9_Right,100),z9_Quote,z9_DQuote)
else
z9_Left=z9_Left||z9_Break||ReplaceString(left(z9_Right,100),z9_Quote,z9_DQuote)
z9_Right=substr(z9_Right,100+1)
end
return(z9_Left||ReplaceString(z9_Right,z9_Quote,z9_DQuote))

_MacroBitNotFoundText:
if CsReplacement='N' then
return('')
else
return('Macro names & parameters are case sensitive (check case)')

InitializeHashDefinesForThisCompile:
call DebugLine_DEFINING 'Initializing all #defines, got ' || OptionDefineCount || ' /define definitions to load up.'
drop MACRO?.
call AddHashDefine '_PPWIZARD_', ''
if OptionDefineCount<>0 then
do
do Index=1 to OptionDefineCount
call AddHashDefine OptionDefine.Index.Var,OptionDefine.Index.Cont
end
end
call _GetUserOptionsViaDefineSwitch
return

_GetUserOptionsViaDefineSwitch:
call DebugLine_MACROVALORDEF 'Getting some lesser options (not worth specific commands)'
call DebugIncrement 1
if RexSystemOpSys="UNIX" then
PathDelimiterChar=':'
else
PathDelimiterChar=';'
PathDelimiterChar=GetDefineValueOrUseDefault("PATH_DELIMITER_CHAR",PathDelimiterChar)
if length(PathDelimiterChar)<>1 then
CryAndDie("Invalid path delimiter (expected 1 only character)")
RexxLocalVar=GetDefineValueOrUseDefault("REXX_MAKE_LOCAL_VAR", '@' || '@')
InfiniteLoopWhen=GetDefineValueOrUseDefault("INFINITE_MACRO_LOOP_WHEN",20)
InfiniteIncludeLoopWhen=GetDefineValueOrUseDefault("INFINITE_INCLUDE_LOOP_WHEN",20)
call DebugIncrement-1
return

REPLACEMENTTAGS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'REPLACEMENTTAGS', 'Replace tags now look like "' || StartsMacroReplacement || 'MacroVar' || EndsMacroReplacement || '" and "' || StartsStdSymbolReplacement || 'StandardMacroVar' || EndsMacroReplacement || '"'
return

REPLACEMENTTAGS_SET:
Tags=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'REPLACEMENTTAGS', 'Setting default value of replacement tags to "' || Tags || '"'
Default4_ReplacementTags=Tags
return(0)
end
if Tags=='' then
Tags=Default4_ReplacementTags
if length(Tags)<>4 then
CryAndDie('Tried to set invalid replace tags of "' || Tags || '"')
StartsMacroReplacement=substr(Tags,1,1)||substr(Tags,3,1)
StdSymbolReplacementChar=substr(Tags,4,1)
StartsStdSymbolReplacement=substr(Tags,1,1)||StdSymbolReplacementChar
EndsMacroReplacement=substr(Tags,2,1)
EndsVar=' ' ||EndsMacroReplacement
StartsStdSymbolReplacement_x=StartsStdSymbolReplacement|| 'x'
CodexNewLine=StartsStdSymbolReplacement|| "NewLine" ||EndsMacroReplacement
CodexHexNewLine=StartsStdSymbolReplacement_x|| "0A" ||EndsMacroReplacement
CodexHexSpace=StartsStdSymbolReplacement_x|| "20" ||EndsMacroReplacement
CodexHexHash=StartsStdSymbolReplacement_x|| "23" ||EndsMacroReplacement
CodexHexDollar=StartsStdSymbolReplacement_x|| "24" ||EndsMacroReplacement
CodexHexQuestionMark=StartsStdSymbolReplacement_x|| "3F" ||EndsMacroReplacement
CodexHexLessThan=StartsStdSymbolReplacement_x|| "3C" ||EndsMacroReplacement
call REPLACEMENTTAGS_DEBUG
return

REPLACEMENTTAGS_GET:
call REPLACEMENTTAGS_DEBUG
return(substr(StartsMacroReplacement,1,1)||EndsMacroReplacement||substr(StartsMacroReplacement,2,1)||substr(StartsStdSymbolReplacement,2,1))

MACROPARMTAGS_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'MACROPARMTAGS', 'Macro parameters now look like "' || StartsMacroParm || 'MacroParameter' || EndsMacroParm || '"'
return

MACROPARMTAGS_SET:
Tags=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'MACROPARMTAGS', 'Setting default value of macro parameter tags to "' || Tags || '"'
Default4_MacroParameterTags=Tags
return(0)
end
if Tags=='' then
Tags=Default4_MacroParameterTags
if length(Tags)<>3 then
CryAndDie('Tried to set invalid macro parameter tags of "' || Tags || '"')
StartsMacroParm=substr(Tags,1,1)||substr(Tags,3,1)
EndsMacroParm=substr(Tags,2,1)
HidesMacroParm=substr(Tags,1,1)|| '_' ||substr(Tags,3,1)
AutoTagSelf=StartsMacroParm|| 'AT' ||EndsMacroParm
call MACROPARMTAGS_DEBUG
return

MACROPARMTAGS_GET:
call MACROPARMTAGS_DEBUG
return(substr(StartsMacroParm,1,1)||EndsMacroParm||substr(StartsMacroParm,2,1))

ProcessDefine:
Rest=arg(1)
if DefineMacroReplace='Y' then
Rest=PerformReplacementsInCmdsParameters(Rest)
if pos(MarksNewLineInHashDefine,Rest)<>0 then
do
Rest=ReplaceString(arg(1),MarksNewLineInHashDefine2,MarksNewLine)
Rest=ReplaceString(Rest,MarksNewLineInHashDefine,MarksNewLine)
end
parse var Rest HashDefineV HashDefineC
return(AddHashDefine(HashDefineV,strip(HashDefineC),arg(2)))

ProcessEvaluate:
Rest=PerformReplacementsInCmdsParameters(arg(1))
HashDefineAnswerName=GetQuotedText(Rest, "Rest")
if Rest='' then
CryAndDie('Evaluate what command?')
CmdToEvaluate=GetQuotedRest(Rest)
HashDefineRc=0
if HashDefineAnswerName='' then
call ExecRexxCmd CmdToEvaluate
else
do
CmdToEvaluate='EvaluateAnswer = ' ||CmdToEvaluate
call ExecRexxCmd CmdToEvaluate
HashDefineRc=AddHashDefine(HashDefineAnswerName,EvaluateAnswer,arg(2))
end
return(HashDefineRc)

VariableExists:
if CsReplacement='N' then
VarNme=c2x(translate(arg(1)))
else
VarNme=c2x(arg(1))
if symbol('MACRO?.M?' || VarNme) = 'VAR' then
return('Y')
else
return('N')

HandleUndefCommand:
UndefVar=PerformReplacementsInCmdsParameters(arg(1))
if verify(UndefVar,EndsVar, 'M') <> 0 then CryAndDie('The macro name "' || UndefVar || '" is invalid (Any of "' || EndsVar || '" are invalid)')
if CsReplacement='N' then
UndefVar=c2x(translate(UndefVar))
else
UndefVar=c2x(UndefVar)
SavedAs='MACRO?.M?' ||UndefVar
if symbol(SavedAs)='VAR' then
drop(SavedAs)
return(0)

MacroSet:call TRACE "OFF"

AddHashDefine:
parse arg HashDefineU,HashDefineC,DefineMode
if verify(HashDefineU,EndsVar, 'M') <> 0 then CryAndDie('The macro name "' || HashDefineU || '" is invalid (Any of "' || EndsVar || '" are invalid)')
if CsReplacement='N' then
HashDefineV=c2x(translate(HashDefineU))
else
HashDefineV=c2x(HashDefineU)
if OptionDebugOn='Y' then
do
call DebugLine_DEFINING 'Defining "' || HashDefineU || '" as ' ||DebugRightArrow||HashDefineC||DebugLeftArrow
call DebugIncrement 1
end
SavedAs='MACRO?.M?' ||HashDefineV
if symbol(SavedAs)='VAR' then
do
select
when DefineMode='Y' then
do
if OptionDebugOn='Y' then
call DebugLine_DEFINING 'User said OK to redefine so no warning'
end
when DefineMode='' then
do
call OutputWarningToScreen 'R000', 'Redefine of "' || HashDefineU || '".'
end
when DefineMode='?' then
do
if OptionDebugOn='Y' then
do
call DebugLine_DEFINING 'Macro already defined, conditional definition aborted!'
call DebugIncrement-1
end
return(0)
end
otherwise
CryAndDie('Unknown define mode of "' || DefineMode || '"')
end
end
call _valueS SavedAs,HashDefineC
if OptionDebugOn='Y' then
call DebugIncrement-1
return(0)

PerformReplacementsInCmdsParameters:
cpParms=ReplaceHashAndStandardDefines(arg(1), "PRM")
if ExpandXCmd='Y' then
do
if pos(StartsStdSymbolReplacement_x,cpParms)<>0 then
cpParms=ReplaceTheXCodesWeKnowExist(cpParms)
end
if pos(MarksNewLine,cpParms)<>0 then
do
Line1='The commands parameters expanded a macro that generated multiple lines!'
Line2='The parameters are now:'
Line3=copies(' ',8)||translate(cpParms,DebugNewline,MarksNewLine)
CryAndDie(Line1,Line2,Line3)
end
return(cpParms)

ReplaceMacros:call TRACE "OFF"
signal _ReplaceMacros

ReplaceHashAndStandardDefines:
if ReplacementsAllowed='N' then
return(arg(1))

_ReplaceMacros:
parse arg HashDefineString,HashDefPrefix,HashDefRecord
ReplLoop=0
do while pos(StartsMacroReplacement,HashDefineString)<>0
BeforeCount=ReplaceCount
HashDefineString=_ReplaceAllHashDefinedVariables(HashDefineString)
if HashDefRecord='Y' then
LastLineAfterMacroRep=HashDefineString
if OptionDebugOn='Y' then
do
if BeforeCount<>ReplaceCount then
do
if HashDefPrefix='' then
call DebugOutputAfterReplacement HashDefineString, 'VCMD'
else
call DebugOutputAfterReplacement HashDefineString, 'V' ||HashDefPrefix
end
end
if pos(MarksNewLine,HashDefineString)<>0 then
leave
if ReplLoop>=InfiniteLoopWhen then
do
if InfiniteLoopWhen<>0 then
do
InfiniteLoopDetected='Y'
if ReplLoop=InfiniteLoopWhen then
do
OptionDebugOn='Y'
call DebugLine 'Infinite loop detected, debug forced on for a few loops'
call DebugIncrement 1
call DebugLine InfiniteLoopWhen|| ' loops detected, possible actions:'
call DebugIncrement 1
call DebugLine 'Have have you forgotten to use "#option DefineMacroReplace=ON" somewhere?'
call DebugLine 'Use "/define:INFINITE_MACRO_LOOP_WHEN=0"    to turn off detection'
call DebugLine 'Use "/define:INFINITE_MACRO_LOOP_WHEN=1000" to increase detection threshold'
call DebugIncrement-2
say ''
call DebugStateChanged
end
say ''
if ReplLoop>InfiniteLoopWhen+50 then
CryAndDie("Infinite loop detected (debug turned on above), current line now:", "",HashDefineString)
end
end
ReplLoop=ReplLoop+1
end
if InfiniteLoopDetected='Y' then
CryAndDie("Increase your loop detection value from " || InfiniteLoopWhen || ' with "/define:INFINITE_MACRO_LOOP_WHEN=Value"', "Increase to at least " || ReplLoop || '!')
if pos(StartsStdSymbolReplacement,HashDefineString)<>0 then
do
BeforeCount=ReplaceCount
HashDefineString=ReplaceStandardDefinitions(HashDefineString)
if HashDefRecord='Y' then
LastLineAfterMacroRep=HashDefineString
if OptionDebugOn='Y' then
do
if BeforeCount<>ReplaceCount then
do
if HashDefPrefix='' then
call DebugOutputAfterReplacement HashDefineString, 'SCMD'
else
call DebugOutputAfterReplacement HashDefineString, 'S' ||HashDefPrefix
end
end
end
return(HashDefineString)

_UnknownStandardSymbol:
call CryAndDie 'The standard symbol "' || StartsStdSymbolReplacement || SymbolName || EndsMacroReplacement || '" is unknown!'

ReplaceStandardDefinitions:
RightBit=arg(1)
if pos(MarksNewLine,RightBit)<>0 then
return(RightBit)
LeftBit=''
StartPos=pos(StartsStdSymbolReplacement,RightBit)
do while StartPos<>0
if StartsStdSymbolReplacement==MarksPhpXml then
do
Left4=substr(RightBit,StartPos+2,3)
if Left4='xml' then
do
LeftBit=LeftBit|| '<' ||CodexHexQuestionMark
RightBit=substr(RightBit,3)
StartPos=pos(StartsStdSymbolReplacement,RightBit)
iterate
end
if Left4='php' then
do
StartPos=pos(StartsStdSymbolReplacement,RightBit,StartPos+2)
iterate
end
if left(Left4,1)=' ' then
do
StartPos=pos(StartsStdSymbolReplacement,RightBit,StartPos+2)
iterate
end
end
EndPos=pos(EndsMacroReplacement,RightBit,StartPos+1)
if EndPos=0 then
CryAndDie('Could not find the "' || EndsMacroReplacement || '" end of variable started at: ' ||substr(RightBit,StartPos))
LeftBit=LeftBit||left(RightBit,StartPos-1)
SymbolNameC=substr(RightBit,StartPos+2,(EndPos-StartPos)-2)
RightBit=substr(RightBit,EndPos+1)
if left(SymbolNameC,1)='x' then
do
ReplaceCount=ReplaceCount-1
SymbolValue=StartsStdSymbolReplacement||SymbolNameC||EndsMacroReplacement
end
else
do
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDSTDVAR 'Found : ' ||StartsStdSymbolReplacement||SymbolNameC||EndsMacroReplacement
SymbolName=translate(SymbolNameC)
Left1=left(SymbolName,1)
if Left1='=' then
DdCodes=''
else
do
SpcPos=pos(' ',SymbolName)
if SpcPos=0 then
DdCodes=''
else
do
DdCodes=substr(SymbolName,SpcPos+1)
SymbolName=left(SymbolName,SpcPos-1)
end
end
select
when Left1='?' then
do
SymbolName=substr(SymbolName,2)
if symbol(SymbolName)<> 'VAR' then
do
call DumpVarsIfCompoundVariable SymbolName
call CryAndDie 'The rexx variable "' || SymbolName || '" is unknown!'
end
SymbolValue=_valueG(SymbolName)
end
when Left1='I' then
do
select
when SymbolName="INPUTFILE" then
SymbolValue=InputFileFull
when SymbolName="INPUTCOMPONENT" then
SymbolValue=IncludeFileName
when SymbolName="INPUTCOMPONENTLINE" then
SymbolValue=IncludeLineNumber
when SymbolName="INCLUDELEVEL" then
SymbolValue=IncludeLevel
otherwise
call _UnknownStandardSymbol
end
end
when Left1='S' then
do
select
when SymbolName="SPACE" then
SymbolValue=CodexHexSpace
when SymbolName="SEMICOLON" then
SymbolValue=';'
otherwise
call _UnknownStandardSymbol
end
end
when Left1='O' then
do
select
when SymbolName="OUTPUTLINE" then
SymbolValue=CurrentOutLine+1
when SymbolName="OUTPUTLEVEL" then
SymbolValue=OutputLevel
when SymbolName="OPSYS" then
SymbolValue=PpWizardOpSys
when SymbolName="OUTPUTFILE" then
do
CloseRc=stream(CurrentOutFile, 'c', 'close')
SymbolValue=SafeQueryExists(CurrentOutFile)
if SymbolValue='' then
CryAndDie('Could not obtain file name information for the "' || StartsStdSymbolReplacement || 'OutputFile>" variable!')
end
otherwise
call _UnknownStandardSymbol
end
end
when Left1='P' then
do
select
when SymbolName='PROCESSINGMODE' then
SymbolValue=OptionCodeType
when SymbolName='PROTECTFROMPPWSTART' then
SymbolValue=MarksNewLine||HashPrefix||ProtectFromPpwS||MarksNewLine
when SymbolName='PROTECTFROMPPWEND' then
SymbolValue=MarksNewLine||ProtectFromPpwE||MarksNewLine
when SymbolName='PPWIZARDAUTHORHOMEPAGE' then
SymbolValue=PgmAuthorHomePage
when SymbolName='PPWIZARDAUTHOR' then
SymbolValue=PgmAuthor
when SymbolName='PPWIZARDAUTHOREMAIL' then
SymbolValue=PgmAuthorEmail
when SymbolName='PPWIZARDPGM' then
SymbolValue=PpWizardPgmName
when SymbolName='PPWIZARDHOMEPAGE' then
SymbolValue=PgmHomePage
when SymbolName='PPWIZARDGENERATORMETATAGS' then
SymbolValue=PgmDefaultHtmlMetaTags
otherwise
call _UnknownStandardSymbol
end
end
when Left1='D' then
do
select
when SymbolName='DEBUGON' then
SymbolValue=OptionDebugOn
when SymbolName='DOLLAR' then
SymbolValue=CodexHexDollar
when SymbolName='DIRSLASH' then
SymbolValue=RexDirChar
otherwise
call _UnknownStandardSymbol
end
end
when SymbolName='NEWLINE' then
SymbolValue=CodexHexNewLine
when SymbolName='NEWLINE?' then
do
CondNlCount=CondNlCount+1
SymbolValue="{?WaNtNl?}"
end
when SymbolName='/' then
SymbolValue=OptionXSlash
when SymbolName='COMPILETIME' then
SymbolValue=CompileTime
when SymbolName='CMDLINETOTAL' then
SymbolValue=CmdLineTotal
when SymbolName='VERSION' then
SymbolValue=PgmVersion
when SymbolName='HASH' then
SymbolValue=CodexHexHash
when SymbolName='HASHPREFIX' then
SymbolValue=HashPrefix
when SymbolName='RESTARTLINE' then
SymbolValue=MarksNewLine
when SymbolName='TOTALOUTPUTLINES' then
SymbolValue=GeneratedLines+1
when SymbolName='NEWESTFILEDATETIME' then
SymbolValue=NewestSourcefile
when SymbolName='LESSTHAN' then
SymbolValue=CodexHexLessThan
when SymbolName='QUESTIONMARK' then
SymbolValue=CodexHexQuestionMark
when SymbolName='UNIQUE' then
do
PPwizardUnique=PPwizardUnique+1
SymbolValue=PPwizardUnique
end
when SymbolName='TEMPLATEDATAFILE' then
SymbolValue=TemplateDataFile
when SymbolName='CGISTART' then
SymbolValue='Content-type: text/html' ||CodexHexNewLine||CodexHexNewLine
when SymbolName='REXXSKIP' then
do
RexxSkipCounter=RexxSkipCounter+1
RexxLbl=_filespec("WITHOUTEXTN", _filespec("NAME", IncludeFileName)) || '_' ||RexxSkipCounter
SymbolValue=MarksNewLine||HashPrefix|| 'RexxVar "RexxSkipLbl" = "' || RexxLbl || '"' ||MarksNewLine
SymbolValue=SymbolValue|| 'signal ' || RexxLbl || ';' ||MarksNewLine
SymbolValue=SymbolValue||MarksNewLine||HashPrefix|| 'RexxVar "RexxSkipLbl" PUSH' ||MarksNewLine
end
when SymbolName='REXXSKIPTO' then
do
SymbolValue=MarksNewLine||HashPrefix|| 'RexxVar "RexxSkipLbl" POP' ||MarksNewLine
SymbolValue=SymbolValue||RexxSkipLbl|| ':' ||MarksNewLine
end
when Left1='=' then
do
if OptionDebugOn='Y' then
call DebugIncrement 1
call ExecRexxCmd 'SymbolValue = ' ||substr(SymbolName,2)
if OptionDebugOn='Y' then
call DebugIncrement-1
end
otherwise
call _UnknownStandardSymbol
end
if DdCodes<> '' then
do
do until DdCodes=''
parse var DdCodes DdCode DdCodes
if OptionDebugOn='Y' then
do
call DebugOutputVariableInfo_FOUNDSTDVAR '$$Bef : ' ||SymbolValue
call DebugOutputVariableInfo_FOUNDSTDVAR '$$Cmd : ' ||DdCode
end
select

when DdCode='$$DSQ' then
do
QChar=QuoteIt(SymbolValue,TryQuoteListDs)
SymbolValue=QChar||SymbolValue||QChar
end

when DdCode='$$SDQ' then
do
QChar=QuoteIt(SymbolValue,TryQuoteListSd)
SymbolValue=QChar||SymbolValue||QChar
end

when DdCode='$$AQ' then
do
QChar=QuoteIt(SymbolValue,TryQuoteListAny)
SymbolValue=QChar||SymbolValue||QChar
end

when DdCode='$$UPPER' then
SymbolValue=translate(SymbolValue)

when DdCode='$$LOWER' then
SymbolValue=ToLowerCase(SymbolValue)

when DdCode='$$ADDCOMMA' then
SymbolValue=AddCommasToDecimalNumber(SymbolValue)

when DdCode='$$HTMLQ' then
SymbolValue=ReplaceString(SymbolValue, '"', '&quot;')

when DdCode='$$SQX2' then
SymbolValue=ReplaceString(SymbolValue, "'" , "''")

when DdCode="$$RX'" then
SymbolValue=_RXQuote(SymbolValue, "'")

when DdCode='$$RX"' then
SymbolValue=_RXQuote(SymbolValue, '"')

when DdCode='$$SPCPLUS' then
do
if SymbolValue\=='' then
SymbolValue=' ' ||SymbolValue
end

otherwise
do
UserRexx=GetDefineValueOrUseDefault("REXX_" || DdCode, '')
if UserRexx='' then
CryAndDie('The $$ replacement command of "' || DdCode || '" is unknown!')
TheMacro=""
TheName=SymbolName
TheValue=SymbolValue
call ExecRexxCmd UserRexx
if OptionDebugOn='Y' then
do
if SymbolValue=TheValue then
do
call DebugIncrement 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'The user rexx code did not modify the "TheValue" variable'
call DebugIncrement-1
end
end
SymbolValue=TheValue
end
end
end
end
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDSTDVAR 'Value : ' ||DebugRightArrow||SymbolValue||DebugLeftArrow
end
LeftBit=LeftBit||SymbolValue
ReplaceCount=ReplaceCount+1
if pos(MarksNewLine,SymbolValue)<>0 then
leave
StartPos=pos(StartsStdSymbolReplacement,RightBit)
end
return(LeftBit||RightBit)

GetDefineContents:
if CsReplacement='N' then
VarNme=c2x(translate(arg(1)))
else
VarNme=c2x(arg(1))
SavedAs='MACRO?.M?' ||VarNme
if symbol(SavedAs)='VAR' then
return(_valueG(SavedAs))
call DebugLine 'The unknown symbols ALIAS is "' || VarNme || '"'
CryAndDie('Macro named "' || arg(1) || '" does not exist!',_MacroBitNotFoundText())

ReplaceDefinitionsParameters:
do ParmIndex=1 to ParmCount
ParmUsed.ParmIndex='N'
end
DefaultCnt=0
ParmLeftBit=''
ParmRightBit=VariableCont
ParmPos=pos(StartsMacroParm,ParmRightBit)
do while ParmPos<>0
ParmLeftBit=ParmLeftBit||left(ParmRightBit,ParmPos-1)
ParmRightBit=substr(ParmRightBit,ParmPos+2)
EqualPos=pos('=',ParmRightBit)
MaybeEndPos=pos(EndsMacroParm,ParmRightBit)
if MaybeEndPos=0 then
CryAndDie('Incorrect use of macro parameter, no matching "' || EndsMacroParm || '" for "' || StartsMacroParm || '"')
if EqualPos<>0&EqualPos<MaybeEndPos then
do
if CsReplacement='N' then
ThisParmName=translate(strip(left(ParmRightBit,EqualPos-1)))
else
ThisParmName=strip(left(ParmRightBit,EqualPos-1))
ParmRightBit=substr(ParmRightBit,EqualPos+1)
ParmDefault=GetQuotedText(ParmRightBit, "ParmRightBit",EndsMacroParm)
HaveDefault='Y'
CurlyPos=pos(EndsMacroParm,ParmRightBit)
if CurlyPos=0 then
CryAndDie("Expected to find '" || EndsMacroParm || "' " || 'after the parameter default of "' || ParmDefault || '"!')
ParmCmds=left(ParmRightBit,CurlyPos-1)
ParmRightBit=substr(ParmRightBit,CurlyPos+1)
FoundIndex=0
do DefaultIndex=1 to DefaultCnt
if ThisParmName=PrmDefaultName.DefaultIndex then
do
FoundIndex=DefaultIndex
leave
end
end
if FoundIndex=0 then
do
DefaultCnt=DefaultCnt+1
FoundIndex=DefaultCnt
end
PrmDefaultName.FoundIndex=ThisParmName
PrmDefaultValue.FoundIndex=ParmDefault
end
else
do
HaveDefault='N'
if CsReplacement='N' then
ThisParmName=translate(strip(left(ParmRightBit,MaybeEndPos-1)))
else
ThisParmName=strip(left(ParmRightBit,MaybeEndPos-1))
SpcPos=pos(' ',ThisParmName)
if SpcPos=0 then
ParmCmds=''
else
do
ParmCmds=substr(ThisParmName,SpcPos+1)
ThisParmName=left(ThisParmName,SpcPos-1)
end
ParmRightBit=substr(ParmRightBit,MaybeEndPos+1)
end
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDVARPARMS 'Parm : ' ||ThisParmName
FndVarIndex=0
do ParmIndex=1 to ParmCount
if ParmName.ParmIndex<> '' then
do
if ThisParmName=ParmName.ParmIndex then
do
ParmUsed.ParmIndex='Y'
FndVarIndex=ParmIndex
end
end
end
if FndVarIndex<>0 then
ReplaceParmWith=ParmValue.FndVarIndex
else
do
if HaveDefault='Y' then
ReplaceParmWith=ParmDefault
else
do
if OptionDebugOn='Y' then
do
call DebugIncrement 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'Parameter not supplied. No default given. Default value stored?'
end
do DefaultIndex=1 to DefaultCnt
if ThisParmName=PrmDefaultName.DefaultIndex then
do
ReplaceParmWith=PrmDefaultValue.DefaultIndex
HaveDefault='Y'
leave
end
end
if OptionDebugOn='Y' then
do
if HaveDefault='N' then
Ans='Oops - not user defined!'
else
Ans='Lucky!'
call DebugOutputVariableInfo_FOUNDVARPARMS Ans
call DebugIncrement-1
end
if HaveDefault='N' then
do
ReginaBugWorkAround='N'
select
when ThisParmName='?' then
do
ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDVARPARMS 'This is a special variable, value is all unused parms'
ReplaceParmWith=''
do ParmIndex=1 to ParmCount
if ParmName.ParmIndex<> '' then
do
if ParmUsed.ParmIndex='N' then
do
if ReplaceParmWith=='' then
LSPC=''
else
LSPC=' '
if ParmValueT.ParmIndex='NV' then
ReplaceParmWith=ReplaceParmWith||LSPC||ParmNameC.ParmIndex
else
do
if ParmCmds='' then
do
QChar=QuoteIt(ParmValue.ParmIndex)
ReplaceParmWith=ReplaceParmWith||LSPC||ParmNameC.ParmIndex|| '=' ||QChar||ParmValue.ParmIndex||QChar
end
else
do
ReplaceParmWith=ReplaceParmWith||LSPC||StartsMacroParm||ParmNameC.ParmIndex|| ' ' ||ParmCmds||EndsMacroParm
end
end
ParmUsed.ParmIndex='Y'
end
end
end
ParmCmds=''
end
when ThisParmName='??' then
do
ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDVARPARMS 'This is a special variable, value is all parms as rexx array'
RepWith=''
ArrayCnt=0
do ParmIndex=1 to ParmCount
if ParmName.ParmIndex<> '' then
do
ArrayCnt=ArrayCnt+1
RepWith=RepWith|| 'MP.' || ArrayCnt || ".MPNAME = " ||QuoteAsRexxLit(ParmName.ParmIndex)||DefRexxSpecialSepTag
RepWith=RepWith|| 'MP.' || ArrayCnt || ".MPVALU = " ||QuoteAsRexxLit(ParmValue.ParmIndex)||DefRexxSpecialSepTag
RepWith=RepWith|| 'MP.' || ArrayCnt || ".MPUSED = '" ||ParmUsed.ParmIndex||DefRexxSpecialSepTag
RepWith=RepWith|| 'MP.' || ArrayCnt || ".MPTYPE = '" ||ParmValueT.ParmIndex||DefRexxSpecialSepTag
end
end
ReplaceParmWith=RepWith|| 'MP.0 = ' ||ArrayCnt||DefRexxSpecialSepTag
ParmCmds=''
end
when translate(ThisParmName)='?MACNAME' then
do
ReginaBugWorkAround='Y'
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDVARPARMS 'This is a special variable, value is the name of macro being expanded'
ReplaceParmWith=VariableName
end
otherwise
do
if ReginaBugWorkAround='N' then
CryAndDie('The "' || StartsMacroParm || ThisParmName || EndsMacroParm || '" parameter was not supplied (and there is no default value)', '', 'Did you mean to use "' || HidesMacroParm || ThisParmName || EndsMacroParm || '" to hide the reference?',_MacroBitNotFoundText())
end
end
end
end
end
if ParmCmds<> '' then
do
ParmCmds=translate(strip(ParmCmds))
do until ParmCmds=''
parse var ParmCmds ParmCmd ParmCmds
if OptionDebugOn='Y' then
do
call DebugIncrement 1
call DebugOutputVariableInfo_FOUNDVARPARMS '$Bef: ' ||ReplaceParmWith
call DebugOutputVariableInfo_FOUNDVARPARMS '$Cmd: ' ||ParmCmd
call DebugIncrement-1
end
select
when ParmCmd='$$PASSAQ' then
do
QChar=QuoteIt(ReplaceParmWith,TryQuoteListAny)
ReplaceParmWith=ThisParmName|| '=' ||QChar||ReplaceParmWith||QChar
end
when ParmCmd='$$PASSDSQ' then
do
QChar=QuoteIt(ReplaceParmWith,TryQuoteListDs)
ReplaceParmWith=ThisParmName|| '=' ||QChar||ReplaceParmWith||QChar
end
when ParmCmd='$$IGNORE' then
ReplaceParmWith=''

when ParmCmd='$$DSQ' then
do
QChar=QuoteIt(ReplaceParmWith,TryQuoteListDs)
ReplaceParmWith=QChar||ReplaceParmWith||QChar
end

when ParmCmd='$$SDQ' then
do
QChar=QuoteIt(ReplaceParmWith,TryQuoteListSd)
ReplaceParmWith=QChar||ReplaceParmWith||QChar
end

when ParmCmd='$$AQ' then
do
QChar=QuoteIt(ReplaceParmWith,TryQuoteListAny)
ReplaceParmWith=QChar||ReplaceParmWith||QChar
end

when ParmCmd='$$UPPER' then
ReplaceParmWith=translate(ReplaceParmWith)

when ParmCmd='$$LOWER' then
ReplaceParmWith=ToLowerCase(ReplaceParmWith)

when ParmCmd='$$ADDCOMMA' then
ReplaceParmWith=AddCommasToDecimalNumber(ReplaceParmWith)

when ParmCmd='$$HTMLQ' then
ReplaceParmWith=ReplaceString(ReplaceParmWith, '"', '&quot;')

when ParmCmd='$$SQX2' then
ReplaceParmWith=ReplaceString(ReplaceParmWith, "'" , "''")

when ParmCmd="$$RX'" then
ReplaceParmWith=_RXQuote(ReplaceParmWith, "'")

when ParmCmd='$$RX"' then
ReplaceParmWith=_RXQuote(ReplaceParmWith, '"')

when ParmCmd='$$SPCPLUS' then
do
if ReplaceParmWith\=='' then
ReplaceParmWith=' ' ||ReplaceParmWith
end

otherwise
do
UserRexx=GetDefineValueOrUseDefault("REXX_" || ParmCmd, '')
if UserRexx='' then
CryAndDie('The $$ replacement command of "' || ParmCmd || '" is unknown!')
TheMacro=VariableName
TheName=ThisParmName
TheValue=ReplaceParmWith
call ExecRexxCmd UserRexx
if OptionDebugOn='Y' then
do
if ReplaceParmWith=TheValue then
do
call DebugIncrement 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'The user rexx code did not modify the "TheValue" variable'
call DebugIncrement-1
end
end
ReplaceParmWith=TheValue
end
end
end
end
if OptionDebugOn='Y' then
do
call DebugIncrement 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'Use : ' ||ReplaceParmWith
call DebugIncrement-1
end
ParmRightBit=ReplaceParmWith||ParmRightBit
ParmPos=pos(StartsMacroParm,ParmRightBit)
end
ParmLeftBit=ParmLeftBit||ParmRightBit
if OptionDebugOn='Y' then
do
do ParmIndex=1 to ParmCount
if ParmUsed.ParmIndex='N' then
call DebugOutputVariableInfo_FOUNDVARPARMS 'The "' || ParmName.ParmIndex  || '" parameter was not referred to by the "' || VariableName || '" macro (either invalid or referenced only in unused default value of another parameter).'
end
end
if pos('{',ParmLeftBit)<>0 then
do
if pos(StartsMacroParm,ParmLeftBit)<>0 then
CryAndDie('Not all "' || VariableName || '" parameters replaced!')
ParmLeftBit=ReplaceString(ParmLeftBit,HidesMacroParm,StartsMacroParm)
end
return(ParmLeftBit)

_ReplaceAllHashDefinedVariables:
RightBit=arg(1)
LeftBit=''
ChangesMade='N'
VarPos=pos(StartsMacroReplacement,RightBit)
do while VarPos<>0
LeftBit=LeftBit||left(RightBit,VarPos-1)
RightBit=substr(RightBit,VarPos+2)
DelPos=verify(RightBit,EndsVar, 'M')
if DelPos=0 then
CryAndDie("Can't find the end of the macro reference at " ||DebugRightArrow||StartsMacroReplacement||RightBit||DebugLeftArrow)
VariableName=left(RightBit,DelPos-1)
MacroBeingExpanded=VariableName
RightBit=strip(substr(RightBit,DelPos), 'L')
if OptionDebugOn='Y' then
do
call DebugOutputVariableInfo_FOUNDVAR 'Found : ' || StartsMacroReplacement || VariableName || ' ...' ||EndsMacroReplacement
call DebugIncrement 1
end
DefnAsIs='N'
VariableCont=GetDefineContents(VariableName)
if OptionDebugOn='Y' then
do
call DebugOutputVariableInfo_FOUNDVAR 'Value : ' ||DebugRightArrow||VariableCont||DebugLeftArrow
call DebugIncrement 1
end
ParmCount=0
PositionalParmCount=0
EndParmDelimiters=EndsMacroReplacement|| '= '
Left1=left(RightBit,1)
do while Left1<>EndsMacroReplacement
if pos(Left1,ArePositionalChars)<>0 then
do
PositionalParmCount=PositionalParmCount+1
ThisParmNameC='#' ||PositionalParmCount
if CsReplacement='N' then
ThisParmName=translate(ThisParmNameC)
else
ThisParmName=ThisParmNameC
ThisParmValType='V'
if Left1='=' then
ThisParmVal=GetQuotedText(substr(RightBit,2), "RightBit",EndsMacroReplacement)
else
ThisParmVal=GetQuotedText(RightBit, "RightBit",EndsMacroReplacement)
end
else
do
DelPos=verify(RightBit,EndParmDelimiters, 'M')
if DelPos=0 then
CryAndDie('Macro reference incorrectly formatted, missing "' || EndsMacroReplacement || '"?')
ThisParmNameC=strip(left(RightBit,DelPos-1))
if CsReplacement='N' then
ThisParmName=translate(ThisParmNameC)
else
ThisParmName=ThisParmNameC
DelChar=substr(RightBit,DelPos,1)
if DelChar='=' then
do
ThisParmVal=GetQuotedText(substr(RightBit,DelPos+1), "RightBit",EndsMacroReplacement)
ThisParmValType='V'
end
else
do
RightBit=strip(substr(RightBit,DelPos), 'L')
if left(ThisParmName,2)<> '$$' then
do
ThisParmVal=ThisParmName
ThisParmValType='NV'
end
else
do
if OptionDebugOn='Y' then
call DebugOutputVariableInfo_FOUNDVARPARMS '$$Cmd: ' ||ThisParmName
select
when ThisParmName='$$ASIS' then
DefnAsIs='Y'

when ThisParmName='$$DSQ' then
do
QChar=QuoteIt(VariableCont,TryQuoteListDs)
VariableCont=QChar||VariableCont||QChar
end

when ThisParmName='$$SDQ' then
do
QChar=QuoteIt(VariableCont,TryQuoteListSd)
VariableCont=QChar||VariableCont||QChar
end

when ThisParmName='$$AQ' then
do
QChar=QuoteIt(VariableCont,TryQuoteListAny)
VariableCont=QChar||VariableCont||QChar
end

when ThisParmName='$$UPPER' then
VariableCont=translate(VariableCont)

when ThisParmName='$$LOWER' then
VariableCont=ToLowerCase(VariableCont)

when ThisParmName='$$ADDCOMMA' then
VariableCont=AddCommasToDecimalNumber(VariableCont)

when ThisParmName='$$HTMLQ' then
VariableCont=ReplaceString(VariableCont, '"', '&quot;')

when ThisParmName='$$SQX2' then
VariableCont=ReplaceString(VariableCont, "'" , "''")

when ThisParmName="$$RX'" then
VariableCont=_RXQuote(VariableCont, "'")

when ThisParmName='$$RX"' then
VariableCont=_RXQuote(VariableCont, '"')

when ThisParmName='$$SPCPLUS' then
do
if VariableCont\=='' then
VariableCont=' ' ||VariableCont
end

otherwise
do
UserRexx=GetDefineValueOrUseDefault("REXX_" || ThisParmName, '')
if UserRexx='' then
CryAndDie('The $$ replacement command of "' || ThisParmName || '" is unknown!')
TheMacro=""
TheName=VariableName
TheValue=VariableCont
call ExecRexxCmd UserRexx
if OptionDebugOn='Y' then
do
if VariableCont=TheValue then
do
call DebugIncrement 1
call DebugOutputVariableInfo_FOUNDVARPARMS 'The user rexx code did not modify the "TheValue" variable'
call DebugIncrement-1
end
end
VariableCont=TheValue
end
end
Left1=left(RightBit,1)
iterate
end
end
end
do ChkIndex=1 to ParmCount
if ThisParmName=ParmName.ChkIndex then
CryAndDie('The macro parameter "' || ThisParmName || '" was specified more than once!')
end
ParmCount=ParmCount+1
ParmName.ParmCount=ThisParmName
ParmNameC.ParmCount=ThisParmNameC
ParmValue.ParmCount=ThisParmVal
ParmValueT.ParmCount=ThisParmValType
Left1=left(RightBit,1)
end
if DefnAsIs='Y' then
do
if ParmCount<>0 then
CryAndDie('You wanted "' || VariableName || '" subsituted ASIS but then specified parameters!')
end
else
do
if ParmCount<>0 then
VariableCont=ReplaceDefinitionsParameters()
else
do
if pos(StartsMacroParm,VariableCont)<>0 then
VariableCont=ReplaceDefinitionsParameters()
else
VariableCont=ReplaceString(VariableCont,HidesMacroParm,StartsMacroParm)
end
end
if OptionDebugOn='Y' then
call DebugIncrement-2
RightBit=substr(RightBit,2)
LeftBit=LeftBit||VariableCont
ReplaceCount=ReplaceCount+1
if pos(MarksNewLine,LeftBit)<>0 then
leave
VarPos=pos(StartsMacroReplacement,RightBit)
end
MacroBeingExpanded=''
TheString=LeftBit||RightBit
return(TheString)

GetDefineValueOrUseDefault:
DefVar=arg(1)
if VariableExists(DefVar)='N' then
do
DefValue=arg(2)
DefDbgWrd='not'
end
else
do
DefValue=GetDefineContents(DefVar)
DefDbgWrd='was'
end
if OptionDebugOn='Y' then
call DebugLine_MACROVALORDEF 'Option(Macro) "' || DefVar || '" ' || DefDbgWrd || ' found. Using ' ||DebugRightArrow||DefValue||DebugLeftArrow
return(DefValue)

Define_26:
RexxTokens='|=+-/%*<>\,;:()&'
signal LineOut_27

GenerateOneLine:
if CondNlCount=0 then
call GenerateOneLineAsIs arg(1)
else
do
if OptionDebugOn='Y' then
call DebugLine 'Looking for Conditional newline codes'
BefCodeCount=ReplaceCount
Line2Gen=ReplaceString(arg(1), "{?WaNtNl?}",MarksNewLine)
if BefCodeCount<>ReplaceCount then
do
if OptionDebugOn='Y' then
call DebugLine 'Found ' ReplaceCount - BefCodeCount || ' conditional newline codes'
CondNlCount=CondNlCount-(ReplaceCount-BefCodeCount)
do until BefCodeCount=ReplaceCount
BefCodeCount=ReplaceCount
Line2Gen=ReplaceString(Line2Gen,MarksNewLine||MarksNewLine,MarksNewLine)
end
if Line2Gen\=='' then
do
if left(Line2Gen,1)=MarksNewLine then
Line2Gen=substr(Line2Gen,2)
if Line2Gen\=='' then
do
if right(Line2Gen,1)=MarksNewLine then
Line2Gen=left(Line2Gen,length(Line2Gen)-1)
end
end
end
do until Line2Gen==''
parse var Line2Gen This1 (MarksNewLine) Line2Gen
call GenerateOneLineAsIs This1
end
end
return

GenerateOneLineAsIs:
Line2Gen2=arg(1)
if CheckSpelling='Y';then
do
if AllowSpell='Y' & Line2Gen2 <> '' then
call SpellCheckOneLine Line2Gen2
end
if OptionFilterOut='' then
do
if HoldingOutput='N' then
call DirectToOutputFile Line2Gen2||NewLineChars
else
HeldOutput=HeldOutput||Line2Gen2||NewLineChars
GeneratedLines=GeneratedLines+1
CurrentOutLine=CurrentOutLine+1
end
else
do
FilterRc=HtmlFilterOut("O",Line2Gen2,CurrentOutFile,CurrentOutLine,GeneratedLines,NewLineChars)
if Left(FilterRc,3)<> "OK:" then
CryAndDie(FilterRc)
else
do
NumWritten=substr(FilterRc,4)
GeneratedLines=GeneratedLines+NumWritten
CurrentOutLine=CurrentOutLine+NumWritten
end
end
return

DirectToOutputFile:
if 0=charout(CurrentOutFile,arg(1))then
return
IoReason=stream(CurrentOutFile, 'Description')
CryAndDie('Write to "' || CurrentOutFile || '" failed (' || IoReason || ')!')

OutputRexxLine:
RexxLine=arg(1)
if right(RexxLine,1)=';' then
RexxLine=left(RexxLine,length(RexxLine)-1)
if OptionPack='Y' & KeepIndent = 'N' then
do
if AllowPack='Y' then
RexxLine=CompressRexxLine(RexxLine)
else
do
if OptionDebugOn='Y' then
call DebugLine 'Not allowed to pack this line'
end
end
ElPos=pos(':',RexxLine)
if ElPos<>0 then
do
PossLabel=strip(left(RexxLine,ElPos-1))
if datatype(PossLabel, 'S')=1 then
call GenerateOneLine ''
end
if pos(NotEqualInC,RexxLine)<>0 then
call OutputInformationToScreen '"' || NotEqualInC || '" found.  Did you mean to use "<>" or "\="?'
call GenerateOneLine RexxLine
return

CompressRexxLine:
RexxLine=arg(1)
Spos=lastpos("'",RexxLine)
Dpos=lastpos('"',RexxLine)
EndPos=max(Spos,Dpos)
if EndPos=0 then
return(_CompressRexx(RexxLine))
else
do
Spos=pos("'",RexxLine)
Dpos=pos('"',RexxLine)
StartPos=min(Spos,Dpos)
if StartPos=0 then
StartPos=max(Spos,Dpos)
LeftBit=left(RexxLine,StartPos-1)
RightBit=substr(RexxLine,EndPos+1)
if right(LeftBit,1, "*") == ' ' then
LeftSpace=' '
else
LeftSpace=''
if left(RightBit,1, "*") == ' ' then
RightSpace=' '
else
RightSpace=''
LeftBit=_CompressRexx(LeftBit)
RightBit=_CompressRexx(RightBit)
if LeftSpace==' ' then
do
if right(LeftBit,1)='=' then
LeftSpace=''
end
LeftBit=_CompressRexx(LeftBit)
RightBit=_CompressRexx(RightBit)
return(LeftBit||LeftSpace||substr(RexxLine,StartPos,(EndPos-StartPos)+1)||RightSpace||RightBit)
end

_CompressRexx:
ToCompress=space(arg(1))
Compressed=''
TokenPos=verify(ToCompress,RexxTokens, 'M')
do while TokenPos<>0
Compressed=Compressed||strip(left(ToCompress,TokenPos-1), 'T')||substr(ToCompress,TokenPos,1)
ToCompress=strip(substr(ToCompress,TokenPos+1), 'L')
TokenPos=verify(ToCompress,RexxTokens, 'M')
end
return(Compressed||ToCompress)

LineOut_27:
call InitializeOneLine
signal OneLine_28

InitializeOneLine:
OneLineOn='N'
OneLineCount=0
OneLineBuffer=''
OneLineSeperator=''
OneLineStartLoc=''
OneLineStopper=''
OneLineStopperL=0
OneLineNonPpwCnt=0
return

AddToOneLine:
_OneLineBit=arg(1)
_Word1=word(_OneLineBit,1)
if strip(_OneLineBit)<>OneLineStopper then
do
OneLineCount=OneLineCount+1
if OneLineCount=1 then
do
if translate(left(_Word1,length(CmdHashDefine)))=CmdHashDefine then
do
PpwCmdDivider2=MarksNewLineInHashDefine
OneLineBuffer=_OneLineBit|| ' '
end
else
do
PpwCmdDivider2=MarksNewLine
OneLineNonPpwCnt=OneLineNonPpwCnt+1
OneLineBuffer=_OneLineBit
end
end
else
do
if left(_Word1,HashPrefixLng)<>HashPrefix then
do
if OneLineNonPpwCnt=0 then
OneLineBuffer=OneLineBuffer||_OneLineBit
else
OneLineBuffer=OneLineBuffer||OneLineSeperator||_OneLineBit
OneLineNonPpwCnt=OneLineNonPpwCnt+1
end
else
do
parse var _OneLineBit _ppwCmd _ppwCmdParm
_OneLineBit=_ppwCmd|| ' ' ||strip(_ppwCmdParm)
OneLineBuffer=OneLineBuffer||PpwCmdDivider2||_OneLineBit||PpwCmdDivider2
end
end
return('')
end
_OneLineBit=OneLineBuffer
if OptionDebugOn='Y' then
call DebugLine 'End of #OneLine block - ' || OneLineCount || ' line(s)'
call InitializeOneLine
return(_OneLineBit)

ProcessOneLine:
OneLineOn='Y'
OneLineStartLoc=CurrentSourceLocation()
Rest=PerformReplacementsInCmdsParameters(arg(1))
if Rest='' then
OneLineSeperator=' '
else
do
OneLineSeperator=GetQuotedText(Rest, "Rest")
end
if Rest='' then
OneLineStopper=HashPrefix|| 'OneLineEnd'
else
OneLineStopper=GetQuotedText(Rest)
OneLineStopperL=length(OneLineStopper)
if OptionDebugOn='Y' then
do
call DebugLine 'Line seperator      = ' ||DebugRightArrow||OneLineSeperator||DebugLeftArrow
call DebugLine 'End of block marker = ' || DebugRightArrow || OneLineStopper   || DebugLeftArrow || ' (case sensitive!)'
end
return(0)

OneLine_28:
UserHashCmds=''
signal CMDNFND_29

LookForUnknownCmdHandler:
UserHashCmds=GetDefineValueOrUseDefault("UNKNOWN_HASH_COMMANDS", '')
return

ProcessUnknownHashCommand:
parse arg HashCmd,HashParms
CmdGenerates=''
call ExecRexxCmd UserHashCmds
if CmdGenerates\=='' then
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=CmdGenerates
else
IncludeMemBufferNextLine=CmdGenerates||MarksNewLine||IncludeMemBufferNextLine
end
return(0)

CMDNFND_29:
signal CmdLine_30

InitCommandLineOptions:
OptionsCmdLine=strip(arg(1))
OptionDebugOn='N'
OptionMaxCol=500
InputMasksAllowed='Y'
OptionPrjExtn='DEF_*'
CgiOutputFile=''
OptionCgiModeOn='N'
OptionCodeType=''
PpwOnOK=''
PpwOnERROR=''
OptionValidation=''
OptionValidationRc=''
OptionWantInfoMsgs='Y'
OptionHashInclude=''
OptionIncludePathCnt=0
OptionTemplate=''
OptionDependsOn=''
OptionOutput=''
OptionSummary='Y'
OptionPack='N'
OptionTranslateFileNames='N'
OptionFilterIn=''
OptionFilterOut=''
OptionDefineCount=0
OptionKeepRexxCmts='N'
OptionCompleteAddToToDepFile='Y'
OptionAtEndCommand=''
OptionAtEndCommandOkTest=''
HaveGeneratorTags='N'
OptionHtmlGeneratorTags=''
OptionNoDepFileOnWarnings='Y'
OptionHideCmdS=''
OptionHideCmdE=''
OptionHideCmdS_L=0
OptionHideCmdE_L=0
OptionXSlash=''
return

QuickCheckForDebugSwitch:
OptionsEnvironment=GetEnv('PPWIZARD_OPTIONS')
UpperTheCmdLine=translate(OptionsEnvironment|| ' ' ||OptionsCmdLine)
LookFor=RexOptionChar|| 'DEBUG '
if pos(LookFor,UpperTheCmdLine|| ' ')<>0 then
do
OptionDebugOn='Y'
OptionWantInfoMsgs='Y'
call DebugStateChanged
end
return

ProcessCommandLine:
call SetUpPpwizardOptionDefaults
call InitializeCharCodes
PpwDoing='Starting to processing parameters (from command line + Environment)'
call DebugLine PpwDoing
call DebugLine 'Switches start with "' || RexOptionChar || '"'
InputMaskCount=0
DebugSwitchUsed='N'
OptionWantCopyright='Y'
CmdLineTotal=''
call ProcessCommandLineBit "environment",OptionsEnvironment
PpwDefaultProject=FindProjectFile('ppwizard')
if PpwDefaultProject<> '' then
call ProcessCommandLineBit PpwDefaultProject,RexOptionChar|| 'LIST:' || ReplaceString(PpwDefaultProject, ' ', '{x20}')
call ProcessCommandLineBit "command line",OptionsCmdLine
call DebugLine 'Finished Processing : ' ||CmdLineTotal
PpwDoing=''
return

AddToSwitchList:
zb_ThisParm=ReplaceString(ThisParm, ' ', '{x20}')
if CmdLineTotal='' then
CmdLineTotal=zb_ThisParm
else
CmdLineTotal=CmdLineTotal|| ' ' ||zb_ThisParm
return

ProcessCommandLineBit:
parse arg zc_What,zc_CmdLine
call DebugIncrement 1
call DebugLine 'Processing switches - ' ||zc_What
call DebugIncrement 1
do while zc_CmdLine<> ''
zc_CmdLine=strip(zc_CmdLine)
if left(zc_CmdLine,1)='"' then
do
BeforeParse=zc_CmdLine
parse value substr(zc_CmdLine,2)with ThisParm'"'zc_CmdLine
if zc_CmdLine<> '' then
do
if left(zc_CmdLine,1)\==' ' then
CryAndDie('Invalid quoted parameter at ==> ' ||BeforeParse)
end
end
else
do
parse var zc_CmdLine ThisParm zc_CmdLine
end
ParmType=left(ThisParm,1)
select
when ParmType=RexOptionChar then
ThisParmT='Switch'
when ParmType='@' then
ThisParmT='Project'
otherwise
do
ThisParmT='FileMask'
ParmType=''
end
end
call DebugLine ThisParmT|| ' <- "' || ThisParm || '"'
call DebugIncrement 1
ThisParm=ReplaceCurlyHexCodes(ThisParm)
PpwDoing='Processing command line: ' ||ThisParm
if ParmType='@' then
do
PrjFile=substr(ThisParm,2)
PrjFileF=FindProjectFile(PrjFile)
if PrjFileF='' then
CryAndDie('The specified project "' || PrjFile || '" does not exist')
ThisParm=RexOptionChar|| 'LIST:' || ReplaceString(PrjFileF, ' ', '{x20}')
zc_CmdLine=ThisParm|| ' ' ||zc_CmdLine
iterate
end
if ParmType='' then
do
if InputMasksAllowed='N' then
CryAndDie('Sorry but no more input masks can be accepted', 'Input mask "' || ThisParm || '" specified in:', '    ' ||zc_What)
call AddToSwitchList
InputMaskCount=InputMaskCount+1
InputMask.InputMaskCount=MakeAbsolute(ThisParm)
call DebugIncrement-1
iterate
end
ParmPos=verify(ThisParm, ':=', 'M')
if ParmPos=0 then
do
ThisCmd=ThisParm
ThisCmdOptions=''
end
else
do
ThisCmd=left(ThisParm,ParmPos-1)
ThisCmdOptions=substr(ThisParm,ParmPos+1)
end
ThisCmd=translate(substr(ThisCmd,2))
RecordSwitch='Y'
select
when ThisCmd='PACK' then
OptionPack=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='CRLF' then
do
if SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y') = 'Y' then
NewLineChars=CrLf
else
NewLineChars=MarksNewLine
end
when ThisCmd='OTHER' then
OptionCodeType='OTHER'
when ThisCmd='HTML' then
OptionCodeType='HTML'
when ThisCmd='REXX' then
do
call SwitchMustNotHaveOptions ThisCmd,ThisCmdOptions
OptionCodeType='REXX'
end
when ThisCmd='DEPENDSON' then
do
OptionDependsOn=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
if left(OptionDependsOn,1)<> '-' then
OptionSeeDependsProgress='Y'
else
do
OptionSeeDependsProgress='N'
OptionDependsOn=substr(OptionDependsOn,2)
end
end
when ThisCmd='DEPENDSONCOMPLETE' then
OptionCompleteAddToToDepFile=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='OUTPUT' then
OptionOutput=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
when ThisCmd='TEMPLATE' then
OptionTemplate=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
when ThisCmd='COLOR' | ThisCmd = 'COLOUR' then
do
WantColor=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
if WantColor='N' then
call RemoveColorCodes
else
do
call NotAvailableUnderNtYet ThisCmd
call SetColorCodes
end
end
when ThisCmd='BEEP' then
do
WantBeep=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
if WantBeep='N' then
call RemoveBeepCode
else
call SetBeepCode
end
when ThisCmd='WARNINGSRC' then
do
if ThisCmdOptions='' then
WantedWarningRc=1
else
do
WantedWarningRc=GetQuotedText(ThisCmdOptions)
if datatype(WantedWarningRc, 'W')=0 then
CryAndDie('Invalid warning return code of "' || WantedWarningRc || '" supplied!')
end
end
when ThisCmd='FILENAMES' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
OptionTranslateFileNames=translate(strip(ThisCmdOptions))
if OptionTranslateFileNames<> "LOWER" & OptionTranslateFileNames <> "UPPER" then
UserSyntaxError('Expected "UPPER" or "LOWER" on the "' || TheCmd || '" command, not "' || ThisCmdOptions || '"!')
end
when ThisCmd='DEFINE' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
parse var ThisCmdOptions DefineVar'='DefineContents
OptionDefineCount=OptionDefineCount+1
OptionDefine.OptionDefineCount.Var=DefineVar
OptionDefine.OptionDefineCount.Cont=strip(DefineContents)
end
when ThisCmd='OPTION' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
call ProcessOption ThisCmdOptions
end
when ThisCmd='FILTERINPUT' then
do
call NotAvailableUnderNtYet ThisCmd
OptionFilterIn=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
call DoMacroSpaceOperation "ADD", OptionFilterIn, "HtmlFilterIn"
end
when ThisCmd='FILTEROUTPUT' then
do
call NotAvailableUnderNtYet ThisCmd
OptionFilterOut=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
call DoMacroSpaceOperation "ADD", OptionFilterOut, "HtmlFilterOut"
end
when ThisCmd='SPELLSHOWALL' then
SpellShowEachError=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='SPELLCHECK' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
call LoadSpellingDictionary ThisCmdOptions
end
when ThisCmd='SPELLADDWORD' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
SpellingAddFile=ThisCmdOptions
if left(SpellingAddFile,1)<> '-' then
SpellingPrompts='Y'
else
do
SpellingPrompts='OK'
SpellingAddFile=substr(SpellingAddFile,2)
end
end
when ThisCmd='**/' then
OptionKeepRexxCmts=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='INFO' then
OptionWantInfoMsgs=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='#INCLUDE' then
OptionHashInclude=ThisCmdOptions
when ThisCmd='INCLUDEPATH' then
do
if ThisCmdOptions='' then
OptionIncludePathCnt=0
else
do
OptionIncludePathCnt=OptionIncludePathCnt+1
OptionIncludePath.OptionIncludePathCnt=ThisCmdOptions
end
end
when ThisCmd='CGI' then
call TurnCgiModeOn ThisCmdOptions
when ThisCmd='HTMLGENERATOR' then
do
HaveGeneratorTags='Y'
OptionHtmlGeneratorTags=ThisCmdOptions
end
when ThisCmd='EXCLUDE' then
do
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
ExcludeList.0=0
TmpMask=ThisCmdOptions
call DebugLine 'Looking for files matching "' || TmpMask || '"'
if left(TmpMask,1)<> '+' then
FollowDirs='N'
else
do
FollowDirs='Y'
TmpMask=substr(TmpMask,2)
end
call GetListOfFiles TmpMask, 'ExcludeList',FollowDirs
call DebugIncrement 1
call DebugLine 'Found ' || ExcludeList.0 || ' files(s) to exclude'
call DebugIncrement 1
do InputIndex=1 to ExcludeList.0
TheFile=ExcludeList.InputIndex
call DebugLine TheFile
call _valueS "_EXCLUDE_._EXF_" || c2x(TheFile), 'you used "' || RexOptionChar || ThisCmd || ':' || ThisCmdOptions || '"'
end
call DebugIncrement-2
end
when ThisCmd='INC2CACHE' then
IncludeIntoMemory=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='$TRACE' then
call SetDollarTraceState SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='DEBUGTIME' then
OptionDebugTime=left(SwitchOptionsValidateAgainstList(ThisCmd,ThisCmdOptions, "N,NO,L,LONG,S,SHORT"),1)
when ThisCmd='DEBUGCHARS' then
call SetDebugChars ThisCmdOptions
when ThisCmd='HOOK' then
call RexxHookSet ThisCmd,ThisCmdOptions
when ThisCmd='REGSYNTAX' then
do
if RexWhich='REGINA' then
call DebugLine "/RegSyntax has no effect under Regina!"
NameOfOs2ReginaRexxInterpreter=ThisCmdOptions
end
when ThisCmd='REDIRMETHOD' then
RedirMethod=ThisCmdOptions
when ThisCmd='DEBUG' then
do
call RemoveBeepCode
call RemoveColorCodes
call SwitchMustNotHaveOptions ThisCmd,ThisCmdOptions
DebugSwitchUsed='Y'
OptionDebugOn='Y'
OptionWantInfoMsgs='Y'
call DebugStateChanged
end
when ThisCmd='COPYRIGHT' then
OptionWantCopyright=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='XSLASH' then
do
YesOrNo=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
if YesOrNo='N' then
OptionXSlash=''
else
OptionXSlash=' /'
end
when ThisCmd='GETENV' then
do
FromEnv=GetEnv(ThisCmdOptions)
if FromEnv='' then
CryAndDie('The environment variable "' || ThisCmdOptions || '" does not exist.')
call DebugLine 'Contained: ' ||FromEnv
zc_CmdLine=FromEnv|| ' ' ||zc_CmdLine
end
when ThisCmd='LIST' then
do
RecordSwitch='N'
ListFile=SafeQueryExists(ThisCmdOptions)
if ListFile='' then
CryAndDie('The list file "' || ThisCmdOptions || '" does not exist')
call DebugLine 'Processing: "' || ListFile || '"'
call DebugIncrement 1
CloseRc=stream(ListFile, 'c', 'close')
LCmt=';' || ';'
LineNum=0
SpecList=''
do while lines(ListFile)<>0
OneSpec=strip(linein(ListFile))
CmtPos=lastpos(LCmt,OneSpec)
LineNum=LineNum+1
if CmtPos<>0 then
OneSpec=strip(left(OneSpec,CmtPos-1), 'T')
if OneSpec='' | left(OneSpec, 1) = ';' then
iterate
OneSpec=ReplaceString(OneSpec, ' ', '{' || 'x20}')
call DebugLine 'Line #' || LineNum || ': ' ||OneSpec
SpecList=SpecList|| ' ' ||OneSpec
end
call DebugIncrement-1
zc_CmdLine=strip(SpecList)|| ' ' ||zc_CmdLine
call DieIfIoErrorOccurred ListFile
CloseRc=stream(ListFile, 'c', 'close')
end
when ThisCmd='DEPENDSONWARNINGS' then
OptionNoDepFileOnWarnings=SwitchWantsYesOrNo(ThisCmd,ThisCmdOptions, 'Y')
when ThisCmd='@EXTN' then
OptionPrjExtn=ThisCmdOptions
when ThisCmd='CONSOLEFILE' then
call UserIsSpecifyingConsoleFileName ThisCmdOptions
when ThisCmd='ERRORFILE' then
call UserIsSpecifyingErrorFileName ThisCmdOptions
when ThisCmd='DEBUGCOLS' then
do
TheValue=SwitchMustHaveOptions(ThisCmd,ThisCmdOptions)
OptValid='N'
if datatype(TheValue, 'W')=1 then
do
if TheValue>=0 then
OptValid='Y'
end
if OptValid='N' then
UserSyntaxError('Invalid /DebugCols value of "' || TheValue || '" supplied!')
OptionMaxCol=TheValue
end
when ThisCmd='DROPFILES' then
do
call DebugLine 'Dropping all stored input file masks'
InputMaskCount=0
call SwitchMustNotHaveOptions ThisCmd,ThisCmdOptions
end
when ThisCmd='ONOK' then
PpwOnOK=ThisCmdOptions
when ThisCmd='ONERROR' then
do
PpwOnERROR=ThisCmdOptions
if SleepSwitch='N' then
OnExitSleepForError=0
end
when ThisCmd='HIDECMD' then
do
if translate(ThisCmdOptions)='HTML[]' then
ThisCmdOptions='<!--[{?}]-->'
parse var ThisCmdOptions OptionHideCmdS '{?}' OptionHideCmdE
OptionHideCmdS_L=length(OptionHideCmdS)
OptionHideCmdE_L=length(OptionHideCmdE)
if OptionHideCmdS_L=0|OptionHideCmdE_L=0 then
CryAndDie('Your hide template must include "{?}" to indicate where the', 'command would be and must not start or end the template')
end
when ThisCmd='EXEC' then
do
call SplitOffRcTest
call RunExecOrValidateCmd ThisCmd,ExecRcTest,ExecCmd
end
when ThisCmd='VALIDATE' then
do
call SplitOffRcTest
OptionValidationRc=ExecRcTest
OptionValidation=ExecCmd
end
when ThisCmd='SLEEP' then
do
SleepSwitch='Y'
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
parse var ThisCmdOptions OnExitSleepForOK ',' OnExitSleepForError
if OnExitSleepForError='' then
OnExitSleepForError=2
end
when ThisCmd='?' then
UserSyntaxError('?')
otherwise
UserSyntaxError('Unknown switch of "' || RexOptionChar || ThisCmd || '" specified')
end
call DebugIncrement-1
if RecordSwitch='Y' then
call AddToSwitchList
end
call DebugIncrement-3
return

UserSyntaxError:
call AllFollowingOutputGoesToErrorFile
call CgiStartFatalError
call DisplayCopyright
if arg(1)='?' then
Title='SYNTAX'
else
do
call Line1 ErrorColor|| "SYNTAX ERROR"
call Line1 "~~~~~~~~~~~~"
call Line1 '    ' ||arg(1)
Title='CORRECT SYNTAX'
end
call CgiEndFatalError
call Line1 ''
call Line1 Title
call Line1 copies('~',length(Title))
call Line1 '    PPWIZARD[.CMD] InputMask [Option1 ...]'
call Line1 ''
call Line1 'SOME COMMON OPTIONS'
call Line1 '~~~~~~~~~~~~~~~~~~~'
call Line1 RexOptionChar|| 'Output:Mask     = Call output what?  Place it where? (example "out\*.html")'
call Line1 RexOptionChar|| 'Rexx            = Using as a rexx preprocessor (not HTML!)'
call Line1 RexOptionChar|| 'DependsOn:Mask  = Generate/Check dependencies (makefile type functionality)'
call Line1 RexOptionChar|| 'Debug           = Generate debug comments in generated output'
call Line1 ''
call Line1 "Please see PPWIZARD's documentation for more details (and more options)." ||Beep||Beep||Reset
if arg(1)<> '?' then
AbnormalExit(MyLineNumber(), "Invalid Command Line - " ||arg(1))
else
do
parse version RegVer
call Line1 ''
call Line1 'ENVIRONMENTAL INFORMATION'
call Line1 '~~~~~~~~~~~~~~~~~~~~~~~~~'
call Line1 'Regina Version: ' ||RegVer
call Line1 'Operating Syst: ' ||uname()
call Line1 'PPWIZARD      : ' ||PgmVersion
call Line1 '              : "' || PpWizardPgmName || '"'
AbnormalExit(MyLineNumber(), "User just wanted version number information")
end

SwitchMustHaveOptions:
parse arg TheCmd,TheOptions
if TheOptions='' then
UserSyntaxError('You must supply parameters on the "' || RexOptionChar || TheCmd || '" switch!')
return(TheOptions)

SwitchMustNotHaveOptions:
parse arg TheCmd,TheOptions,Value2Set
if TheOptions<> '' then
UserSyntaxError('No parameters are expected for the "' || RexOptionChar || TheCmd || '" switch!')
return(Value2Set)

SwitchOptionsValidateAgainstList:
TheCmd=arg(1)
TheOption=translate(arg(2))
ValidList=',' || translate(arg(3)) || ','
if pos(',' || TheOption || ',',ValidList)<>0 then
return(TheOption)
UserSyntaxError('An invalid parameter of "' || TheOption || '" was specified on the "' || RexOptionChar || TheCmd || '" switch!')

SwitchWantsYesOrNo:
TheCmd=arg(1)
TheOption=translate(arg(2))
Default=arg(3)
if TheOption='' then
return(Default)
else
return(left(SwitchOptionsValidateAgainstList(TheCmd,TheOption, "Y,N,YES,NO"),1))

NotAvailableUnderNtYet:
TheCmd=arg(1)
if RexWhich='REGINA' then
UserSyntaxError('"' || RexOptionChar || TheCmd || '" can not be performed under Windows (or regina).... Yet...')
return

FindProjectFile:
zd_PrjFile=arg(1)
if pos('.',zd_PrjFile)=0 then
zd_PrjFile=zd_PrjFile|| '.ppw'
if OptionDebugOn='Y' then
do
call DebugIncrement 1
call DebugLine 'Looking for the project file "' || zd_PrjFile || '"'
call DebugIncrement 1
end
zd_Full=FindFile(zd_PrjFile)
if OptionDebugOn='Y' then
do
call DebugIncrement 1
if zd_Full='' then
call DebugLine 'Project file not found.'
else
call DebugLine 'Found project file "' || zd_Full || '"'
call DebugIncrement-3
end
return(zd_Full)

SplitOffRcTest:
call SwitchMustHaveOptions ThisCmd,ThisCmdOptions
if left(ThisCmdOptions,1)='{' then
parse var ThisCmdOptions '{' ExecRcTest '}' ExecCmd
else
do
ExecCmd=ThisCmdOptions
ExecRcTest=''
end
return

RunExecOrValidateCmd:
parse arg ze_Switch,ze_CmdRc,ze_Cmd
if OptionDebugOn='Y' then
call DebugLine 'Performing ' || RexOptionChar || ze_Switch || ' command'
ze_Exec=ReplaceString(ze_Cmd, "{?}",CurrentOutFile)
if left(ze_Exec,1)<> '!' then
ze_Redirect='Y'
else
do
ze_Redirect='N'
ze_Exec=substr(ze_Exec,2)
end
if ze_Redirect='N' then
do
call AddressCmd ze_Exec
CmdRc=Rc
end
else
do
TmpFile=RexGetTmpFileName()
call AddressCmd ze_Exec||RedirectStdOutAndErr2(TmpFile),TmpFile
CmdRc=Rc
call _SysFileDelete TmpFile
end
if ze_CmdRc<> '' then
do
call DebugIncrement 1
ze_ExecOk=0
ze_ExecThis='ze_ExecOk = ' || '(' || ze_CmdRc || ')'
if ProcessedCmdLine='Y' then
call ExecRexxCmd ze_ExecThis
else
do
call DebugLine 'Interpreting: ' ||ze_ExecThis
interpret ze_ExecThis
end
call DebugIncrement-1
if\ze_ExecOk then
CryAndDie('User command failed (CmdRc was ' || CmdRc || '):', '     ' || ze_Exec, 'Test was:', '     ' ||ze_CmdRc)
end
return

CmdLine_30:
DoingImport=''
signal IMPORT_31

ProcessImport:
if DoingImport<> '' then
CryAndDie("Can't nest #import (started at " || DoingImport || ')')
else
DoingImport=CurrentSourceLocation()
ImportParms=PerformReplacementsInCmdsParameters(arg(1))
if AsIsModeOn='Y' then
CryAndDie("Please turn off #AsIs mode before importing.")
call _InitImportAsIsMemories
ImportFileName=GetQuotedText(ImportParms, "ImportParms")
if ImportFileName='' then
CryAndDie('#import has no parameters!')
CloseRc=stream(ImportFileName, 'c', 'close')
FullImportName=stream(ImportFileName, 'c', 'query exists')
if FullImportName='' then
CryAndDie('The #import file "' || ImportFileName || '" does not exist!')
call OutputProcessingFileStringToScreen FullImportName
call AddInputFileToDependancyList FullImportName
if ImportParms='' then
CryAndDie('#import is missing import type (parm #2)!')
ImportFileType=translate(GetQuotedText(ImportParms, "ImportParms"))
if substr(ImportFileType,4)<> '-' then
DropLine=0
else
do
ImportFileType=left(ImportFileType,3)
DropLine=1
end
FirstChar=left(ImportFileType,1)
DelimiterSpec=FirstChar||FirstChar||FirstChar
CustomDelimiter='NO'
if(ImportFileType==DelimiterSpec)|(ImportFileType==DelimiterSpec|| '-')then
do
CustomDelimiter=FirstChar
TmpFilePart=''
end
else
do
TmpFilePart=ImportFileType
if pos('*' || ImportFileType || '*', '*TAB*CMA*FIX*WRAP*T2H*ML*')=0 then
CryAndDie('Invalid #import type of "' || ImportFileType || '" specified!')
end
ToInclude=RexGetTmpFileName('I_' || left(TmpFilePart, 4, '_') || '??.???')
call MustDeleteFile ToInclude
if ImportParms='' then
CryAndDie('#import is missing macro name (parm #3)!')
MacroName=GetQuotedText(ImportParms, "ImportParms")
if MacroName='' then
do
select
when ImportFileType='WRAP' then
MacroName='WRAP'
when ImportFileType='T2H' then
MacroName='T2H'
when ImportFileType='ML' then
MacroName='ML'
otherwise
MacroName='IMPORT'
end
end
call AsIsPrepare ''
if OptionDebugOn='Y' then
call DebugLine_IMPORT 'Generating "' || ToInclude || '" for later inclusion (#include).'
ReplaceNewLineChar=''
ReplaceTabChar=''
DisplayingFields=''
ReplaceNewLineChar=''
ReplaceTabChar=''
select
when ImportFileType='WRAP' then
ImpLinCnt=HandleLineWrapping()
when ImportFileType='T2H' then
ImpLinCnt=HandleTextToHtmlImport()
otherwise
do
call ImportTablePreparation
select
when ImportFileType='ML' then
ImpLinCnt=HandleMultiLineImport()
when CustomDelimiter<> 'NO' then
ImpLinCnt=HandleSimpleCharDelimitedFile(CustomDelimiter)
when ImportFileType='TAB' then
ImpLinCnt=HandleSimpleCharDelimitedFile(TabChar)
when ImportFileType='CMA' then
ImpLinCnt=HandleSimpleCharDelimitedFile(',')
when ImportFileType='FIX' then
ImpLinCnt=HandleFixedFieldFile()
otherwise
CryAndDie('Unknown import type of "' || ImportFileType || '"')
end
call ImportTableTermination
end
end
CloseRc=stream(FullImportName, 'c', 'close')
if OptionDebugOn='Y' then
call DebugLine_IMPORT 'Imported ' || AddCommasToDecimalNumber(ImpLinCnt) || ' line(s) in "' || ImportFileType || '" mode.'
CloseRc=stream(ToInclude, 'c', 'close')
call AsIsPrepare ''
if OptionDebugOn='Y' then
call DebugLine_IMPORT 'Now #include the generated temporary file ("' || ToInclude || '").'
call RecursiveIncludeSave
call ProcessInputFile ToInclude,, 'N', 'N'
call RecursiveIncludeRestore
call OutputProcessingFileStringToScreen
if OptionDebugOn='N' then
DeleteRc=_SysFileDelete(ToInclude)
DoingImport=''
return(0)

_ImportValueSpacer:
if OptionDebugOn='Y' then
do
call DebugLine_MACROVALORDEF ''
if arg(1)<> '' then
call DebugLine_MACROVALORDEF arg(1)
end
return

ImportValueExists:
ImportVar=MacroName|| '_' ||arg(1)
iveAnswer=VariableExists(ImportVar)
if OptionDebugOn='Y' then
call DebugLine_MACROVALORDEF 'Option(Macro) "' || ImportVar || '" Exists? : ' ||iveAnswer
return(iveAnswer)

GetImportValue:
ImportVar=MacroName|| '_' ||arg(1)
if VariableExists(ImportVar)='N' then
do
ImportMask=arg(2)
DebugWord='not'
end
else
do
ImportMask=GetDefineContents(ImportVar)
DebugWord='was'
end
if OptionDebugOn='Y' then
call DebugLine_MACROVALORDEF 'Option(Macro) "' || ImportVar || '" ' || DebugWord || ' found. Using ' ||DebugRightArrow||ImportMask||DebugLeftArrow
if ImportFileType<> "WRAP" & ImportFileType <> "T2H" then
ImportMask=ReplaceString(ImportMask,StartsMacroParm|| 'Columns' ||EndsMacroParm,DisplayingFields)
return(ImportMask)

GetImportValue_Tabs:
ReplaceTabChar=GetImportValue('TAB_CHAR', '')
return

GetImportValue_RecordFilter:
return(GetImportValue('RECORD_FILTER', ''))

GetImportValue_Comments:
call _ImportValueSpacer 'Get comment options'
call DebugIncrement 1
ImportLineCmtChars=GetImportValue( 'LINECMT_CHARS',arg(1))
ImportInlineCmtChars=GetImportValue('INLINECMT_CHARS',arg(2))
call DebugIncrement-1
return

IsCmtLine:
if ImportLineCmtChars='' then
return(0)
else
return(abbrev(arg(1),ImportLineCmtChars))

ImportOneLine:
if arg(1)='Y' then
FileLine=CrLflinein(FullImportName)
else
FileLine=linein(FullImportName)
if ImportInlineCmtChars<> '' then
do
ilcPos=pos(ImportInlineCmtChars,FileLine)
if ilcPos<>0 then
FileLine=strip(left(FileLine,ilcPos-1), 'Trailing')
end
if arg(2)='Y' then
FileLine=AsIs(translate(FileLine, '',EofChar))
else
FileLine=translate(FileLine, '',EofChar)
if ReplaceNewLineChar\=='' then
FileLine=ReplaceString(FileLine,MarksNewLine,ReplaceNewLineChar)
if ReplaceTabChar\=='' then
FileLine=ReplaceString(FileLine,TabChar,ReplaceTabChar)
return(FileLine)

PpwLineout:
parse arg gFile,gLine
do until gLine==''
parse var gLine This1 (MarksNewLine) gLine
if 0<>charout(gFile,This1||NewLineChars)then
do
IoReason=stream(gFile, 'Description')
CryAndDie('Write to "' || gFile || '" failed (' || IoReason || ')!')
end
end
return

GenerateTagsIfNonEmpty:
OptionalTags=GetImportValue(arg(1),arg(2))
if OptionalTags\=='' then
call PpwLineout ToInclude,OptionalTags
return

GenerateProtectStartTags:
call GenerateTagsIfNonEmpty 'PROTECT_START', StartsStdSymbolReplacement || 'ProtectFromPpwStart' ||EndsMacroReplacement
return

GenerateProtectEndTags:
call GenerateTagsIfNonEmpty 'PROTECT_END',   StartsStdSymbolReplacement || 'ProtectFromPpwEnd' ||EndsMacroReplacement
return

GenerateBeforeTags:
call GenerateTagsIfNonEmpty 'BEFORE',arg(1)
return

GenerateAfterTags:
call GenerateTagsIfNonEmpty 'AFTER',arg(1)
return

HandleImportAsIsOptions:
call _ImportValueSpacer 'Prepare "AS IS" tagging'
call DebugIncrement 1
ImportAsIsMemory=GetImportValue('ASIS_TAGGING',arg(1))
call DebugIncrement 1
call AsIsPrepare ImportAsIsMemory
call DebugIncrement-2
return

_InitImportAsIsMemories:
if symbol('ImpMemInit') = 'VAR' then
return
ImpMemInit='Y'
call DebugLine_IMPORT 'Initializing named #AsIs tags for HTML Importing'
call DebugIncrement 1
call _ClearTempMemory
call _AddToTempMemory '&', '&amp;'
call _AddToTempMemory '<', '&lt;'
call _AddToTempMemory '>', '&gt;'
call SetupNamedAsIsStorage 'IMPORT_HTML_BASIC',TmpAtCount
call _ClearTempMemory
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '-'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '|'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '-'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '|'
call _AddToTempMemory '', '+'
call _AddToTempMemory '', '+'
call SetupNamedAsIsStorage 'IMPORT_HTML_BOXGRAPHIC_TO_BOXTEXT',TmpAtCount
call DebugIncrement-1
return

_ClearTempMemory:
TmpAtCount=0
return

_AddToTempMemory:
TmpAtCount=TmpAtCount+1
ImportB.TmpAtCount=arg(1)
ImportA.TmpAtCount=arg(2)
return

WriteLineToTmpImportFile:call TRACE "OFF"
call PpwLineout ToInclude,arg(1)
return

IMPORT_31:
signal IMPORTT_32

ImportTablePreparation:
if ImportParms='' then
CryAndDie('#import is missing field names (parm #4 onwards)!')
NumberOfFields=0
DisplayingFields=0
do while ImportParms<> ''
NumberOfFields=NumberOfFields+1
HeadingInfo=GetQuotedText(ImportParms, "ImportParms")
ColumnNumber=DisplayingFields+1
ExtraInfo=''
if left(HeadingInfo,1)='{' then
do
EndPosn=pos('}',HeadingInfo)
if EndPosn=0 then
CryAndDie('Leading field codes on heading "' || HeadingInfo || '" invalid (expected "}")')
HeadingCodes=substr(HeadingInfo,2,EndPosn-2)
HeadingInfo=substr(HeadingInfo,EndPosn+1)
parse var HeadingCodes MaybeColumnNumber','ExtraInfo
if MaybeColumnNumber<> '' & MaybeColumnNumber <> '*' then
ColumnNumber=MaybeColumnNumber
end
FieldHeading.NumberOfFields=HeadingInfo
FieldExtra.NumberOfFields=ExtraInfo
if HeadingInfo<> '' then
do
FieldColumn.NumberOfFields=ColumnNumber
DisplayingFields=DisplayingFields+1
end
end
call _ImportValueSpacer 'Assorted options'
call DebugIncrement 1
DropBlankLines=translate(GetImportValue('DROP_BLANK_LINES',  'Y'))
DropLine=GetImportValue('DROP_LINE_COUNT',DropLine)
ReplaceNewLineChar=GetImportValue('NEWLINE_CHAR', '<BR>')
call GetImportValue_Tabs
RecordFilter=GetImportValue_RecordFilter()
call DebugIncrement-1
call _ImportValueSpacer 'What happens to blank fields?'
call DebugIncrement 1
ReplaceBlankFields=GetImportValue('BLANK_FIELD',  '')
do Index=1 to DisplayingFields
RepBlankCol.Index=GetImportValue('BLANK_COLUMN_' ||Index,ReplaceBlankFields)
end
call DebugIncrement-1
call _ImportValueSpacer 'What do we do with column titles?'
call DebugIncrement 1
if ImportValueExists('HEADER') = 'Y' then
ForHeader=GetImportValue('HEADER', '!BUG!')
else
do
DefaultColFormatting=GetImportValue('HEADING_COLUMNS',     'ALIGN=CENTER')
DefaultBeforeData=GetImportValue('HEADING_BEFORE_DATA', '')
DefaultAfterData=GetImportValue('HEADING_AFTER_DATA',  '')
ForHeader='<TR>'
do Index=1 to DisplayingFields
ThisColFormatting=GetImportValue('HEADING_COLUMN_' ||Index,DefaultColFormatting)
ThisBeforeData=GetImportValue('HEADING_BEFORE_DATA_' ||Index,DefaultBeforeData)
ThisAfterData=GetImportValue('HEADING_AFTER_DATA_' ||Index,DefaultAfterData)
ForHeader=ForHeader|| '<TH ' || ThisColFormatting || '>' || ThisBeforeData || StartsMacroParm || 'Column' || Index || EndsMacroParm || ThisAfterData || '</TH>'
end
ForHeader=ForHeader|| '</TR>'
end
call DebugIncrement-1
call _ImportValueSpacer 'Working out what table data row looks like'
call DebugIncrement 1
if ImportValueExists('RECORD') = 'Y' then
ForEachRecord=GetImportValue('RECORD', '!BUG!')
else
do
DefaultColFormatting=GetImportValue('RECORD_COLUMNS',     'ALIGN=CENTER')
DefaultBeforeData=GetImportValue('RECORD_BEFORE_DATA', '')
DefaultAfterData=GetImportValue('RECORD_AFTER_DATA',  '')
ForEachRecord='<TR>'
do Index=1 to DisplayingFields
ThisColFormatting=GetImportValue('RECORD_COLUMN_' ||Index,DefaultColFormatting)
ThisBeforeData=GetImportValue('RECORD_BEFORE_DATA_' ||Index,DefaultBeforeData)
ThisAfterData=GetImportValue('RECORD_AFTER_DATA_' ||Index,DefaultAfterData)
ForEachRecord=ForEachRecord|| '<TD ' || ThisColFormatting || '>' || ThisBeforeData || StartsMacroParm || 'Column' || Index || EndsMacroParm  || ThisAfterData || '</TD>'
end
ForEachRecord=ForEachRecord|| '</TR>'
end
call DebugIncrement-1
call _ImportValueSpacer 'Start output'
call DebugIncrement 1
call GenerateProtectStartTags
TableAttribs=GetImportValue('TABLE_ATTRIBS', 'BORDER=5 CELLSPACING=5')
if TableAttribs<> '' then
TableAttribs=' ' ||strip(TableAttribs)
BeforeRecordsDefault='<TABLE' || TableAttribs || '>'
call GenerateBeforeTags BeforeRecordsDefault
call DebugLine_IMPORT 'Outputting heading fields'
call DebugIncrement 1
call _NewRecord 'H'
do FieldIndex=1 to NumberOfFields
call _AddField2Record FieldHeading.FieldIndex
end
call GenerateRecordFromFields
call DebugIncrement-2
call GetImportValue_Comments ';', ';' || ';'
if OptionCodeType='HTML' then
call HandleImportAsIsOptions "IMPORT_HTML_BASIC"
return

ImportTableTermination:
call GenerateAfterTags '</TABLE>'
call GenerateProtectEndTags
return

HandleFixedFieldFile:
if OptionDebugOn='Y' then
call DebugLine_IMPORT 'Importing fixed field file'
do FieldIndex=1 to NumberOfFields
parse var FieldExtra.FieldIndex StartCol'-'EndCol
if EndCol='' | EndCol = '*' then
FieldLength=''
else
FieldLength=(EndCol-StartCol)+1
FieldStartCol.FieldIndex=StartCol
FieldLength.FieldIndex=FieldLength
end
ImportFileLine=0
call DebugLine_IMPORT 'Reading "' || FullImportName || '"...'
do while lines(FullImportName)<>0
CurrentRecord=ImportOneLine('N', 'Y')
ImportFileLine=ImportFileLine+1
if CurrentRecord='' then
iterate
if ImportFileLine<=DropLine then
iterate
if IsCmtLine(ImportFileLine)then
iterate
call _NewRecord
do FieldIndex=1 to NumberOfFields
if FieldLength.FieldIndex='' then
ThisField=substr(CurrentRecord,FieldStartCol.FieldIndex)
else
ThisField=substr(CurrentRecord,FieldStartCol.FieldIndex,FieldLength.FieldIndex)
call _AddField2Record strip(ThisField)
end
if GenerateRecordFromFields()then
leave
end
return(ImportFileLine)

HandleSimpleCharDelimitedFile:
FieldDelimiter=arg(1)
FieldQuote='"'
FieldQuote2=FieldQuote||FieldQuote
if OptionDebugOn='Y' then
do
DelimiterText=c2d(FieldDelimiter)
if DelimiterText> '32' then
DelimiterText=DelimiterText|| ' ("' || FieldDelimiter || '")'
call DebugLine_IMPORT 'Importing simple delimited file - delimiter = ASCII ' ||DelimiterText
end
UseCrLfRoutines=GetImportValue('HANDLE_IMBEDDED_NEWLINES', 'N')
if UseCrLfRoutines='N' then
call DebugLine_IMPORT 'Special imbedded newline detecting code is not being used'
else
do
UseCrLfRoutines='Y'
call DebugLine_IMPORT 'We are using special imbedded newline detecting code'
end
call DebugLine_IMPORT 'Reading "' || FullImportName || '"...'
if UseCrLfRoutines='Y' then
OpenRc=CrlfOpen(FullImportName,10000)
ImportFileLine=0
do forever
if UseCrLfRoutines='Y' then
EofIf0=CrLflines(FullImportName)
else
EofIf0=lines(FullImportName)
if EofIf0=0 then
leave
CurrentRecord=ImportOneLine(UseCrLfRoutines, 'Y')
ImportFileLine=ImportFileLine+1
if CurrentRecord='' then
do
if DropBlankLines='Y' then
iterate
end
if ImportFileLine<=DropLine then
iterate
if IsCmtLine(CurrentRecord)then
iterate
call _NewRecord
do while CurrentRecord<> ''
if left(CurrentRecord,1)<>FieldQuote then
do
DelPos=pos(FieldDelimiter,CurrentRecord)
if DelPos<>0 then
do
call _AddField2Record left(CurrentRecord,DelPos-1)
CurrentRecord=substr(CurrentRecord,DelPos+1)
end
else
do
call _AddField2Record CurrentRecord
CurrentRecord=''
end
end
else
do
LookFrom=2
do forever
QuotePos=pos(FieldQuote,CurrentRecord,LookFrom)
if QuotePos=0 then
CryAndDie('No ending quote on field #' || FieldCounter+1 || ' of line #' || ImportFileLine || ', Failed at ' ||DebugRightArrow||CurrentRecord||DebugLeftArrow)
if substr(CurrentRecord,QuotePos+1,1)=FieldQuote then
LookFrom=QuotePos+2
else
leave
end
call _AddField2Record ReplaceString(substr(CurrentRecord,2,QuotePos-2),FieldQuote2,FieldQuote)
CurrentRecord=substr(CurrentRecord,QuotePos+1)
if CurrentRecord<> '' then
do
if left(CurrentRecord,1)<>FieldDelimiter then
CryAndDie('Expected delimiter after field #' || FieldCounter || ' of line #' || ImportFileLine || ', Failed at ' ||DebugRightArrow||CurrentRecord||DebugLeftArrow)
CurrentRecord=substr(CurrentRecord,2)
end
end
if FieldCounter>=NumberOfFields then
leave
end
if FieldCounter<NumberOfFields then
do
do while FieldCounter<NumberOfFields
call _AddField2Record ''
end
end
if GenerateRecordFromFields()then
leave
end
if UseCrLfRoutines='Y' then
CloseRc=CrlfClose(FullImportName)
return(ImportFileLine)

_NewRecord:
RecordType=arg(1)
if RecordType='H' then
ThisRecordsCodes=ForHeader
else
ThisRecordsCodes=ForEachRecord
FieldCounter=0
ColumnCounter=0
DroppedCounter=0
NonBlankFieldCounter=0
return

_AddField2Record:
FieldCounter=FieldCounter+1
if FieldHeading.FieldCounter='' then
do
DroppedCounter=DroppedCounter+1
Dropped.DroppedCounter=arg(1)
end
else
do
ColumnCounter=ColumnCounter+1
NewValue=arg(1)
if NewValue='' then
NewValue=RepBlankCol.ColumnCounter
else
NonBlankFieldCounter=NonBlankFieldCounter+1
SaveAsIndex=FieldColumn.FieldCounter
Column.SaveAsIndex=NewValue
end
return

GenerateRecordFromFields:
call DebugIncrement 1
if DropBlankLines='Y' then
do
if NonBlankFieldCounter=0 then
do
call DebugLine_IMPORT 'Dropping record as all fields were blank'
call DebugIncrement-1
return(0)
end
end
if RecordFilter<> '' then
do
if RecordType<> 'H' then
do
Column.0=ColumnCounter
Dropped.0=DroppedCounter
call DebugLine_IMPORT 'Calling specified filter'
call DebugIncrement 1
Remove=''
call ExecRexxCmd RecordFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DebugLine_IMPORT 'This Record and all following dropped ==> ' ||Remove
call DebugIncrement-2
return(1)
end
else
do
call DebugLine_IMPORT 'Record dropped ==> ' ||Remove
call DebugIncrement-2
return(0)
end
end
call DebugIncrement-1
end
end
do ThisOne=1 to ColumnCounter
ThisRecordsCodes=ReplaceString(ThisRecordsCodes,StartsMacroParm|| 'Column' ||ThisOne||EndsMacroParm,Column.ThisOne)
end
call DebugLine_IMPORT 'Generating: ' ||ThisRecordsCodes
call PpwLineout ToInclude,ThisRecordsCodes
call DebugIncrement-1
return(0)

IMPORTT_32:
signal IMPORTTX_33

HandleTextToHtmlImport:
if OptionCodeType<> 'HTML' then
CryAndDie("Text to html file importing is only allowed when generating HTML")
if ImportParms<> '' then
CryAndDie('There are too many parameters on the T2H #import!')
UrlNameVar=StartsMacroParm|| 'Url' ||EndsMacroParm
UrlTypeVar=StartsMacroParm|| 'UrlType' ||EndsMacroParm
HeadingVar=StartsMacroParm|| 'Heading' ||EndsMacroParm
call GenerateProtectStartTags
call GenerateBeforeTags '<PRE><FONT SIZE=-1>'
T2hFilter=GetImportValue_RecordFilter()
call GetImportValue_Tabs
BlankLinesTo=GetImportValue('BLANK_LINES_TO', '')
HttpLink=GetImportValue('HTTP_LINK',   '<A HREF="' || UrlTypeVar || UrlNameVar || '" TARGET=_top>' || UrlTypeVar || UrlNameVar || '</A>')
FtpLink=GetImportValue('FTP_LINK',    '<A HREF="' || UrlTypeVar || UrlNameVar || '">' || UrlTypeVar || UrlNameVar || '</A>')
MailLink=GetImportValue('MAILTO_LINK', '<A HREF="mailto:' || UrlNameVar || '">' || UrlNameVar || '</A>')
DefaultAllStd=UpperCase||LowerCase||DecimalDigits
AlwaysOkInUrl=GetImportValue('ALWAYS_OK_IN_URL_CHARS',DefaultAllStd)
if AlwaysOkInUrl\=='' then
DefaultAllStd=''
ExtraValidHttpChar=GetImportValue('EXTRA_VALID_HTTP_CHARS',         DefaultAllStd || './?%+:~_')
ExtraValidFtpChar=GetImportValue('EXTRA_VALID_FTP_CHARS',ExtraValidHttpChar)
ExtraValidEmailName=GetImportValue('EXTRA_VALID_EMAIL_NAME_CHARS',   DefaultAllStd || '_.')
ExtraValidEmailSvr=GetImportValue('EXTRA_VALID_EMAIL_SVR_CHARS',    DefaultAllStd || '_.')
ValidEmailDelimiters=GetImportValue('EXTRA_VALID_EMAIL_DELIMITERS',   " '" || '",;')
ValidInHttpUrl=AlwaysOkInUrl||ExtraValidHttpChar
ValidInFtpUrl=AlwaysOkInUrl||ExtraValidFtpChar
ValidInEmailL=AlwaysOkInUrl||ExtraValidEmailName
ValidInEmailR=AlwaysOkInUrl||ExtraValidEmailSvr
call GetImportValue_Comments '', ''
if OptionCodeType='HTML' then
call HandleImportAsIsOptions "IMPORT_HTML_BASIC IMPORT_HTML_BOXGRAPHIC_TO_BOXTEXT"
T2hLineNumber=0
call DebugLine_IMPORT 'Reading "' || FullImportName || '"...'
do while lines(FullImportName)<>0
T2hFileLine=ImportOneLine('N', 'Y')
T2hLineNumber=T2hLineNumber+1
if IsCmtLine(T2hFileLine)then
iterate
if T2hFileLine='' then
do
if BlankLinesTo\=='' then
T2hNewLine=BlankLinesTo
else
T2hNewLine=''
end
else
do
T2hNewLine=T2hFileLine
if MailLink\=='' then
T2hNewLine=_MakeTextImportEmailChanges(T2hNewLine,ValidInEmailL,ValidInEmailR,ValidEmailDelimiters,MailLink)
if HttpLink\=='' then
T2hNewLine=_MakeTextImportLinkChanges(T2hNewLine, 'http:',ValidInHttpUrl,HttpLink)
if FtpLink\=='' then
T2hNewLine=_MakeTextImportLinkChanges(T2hNewLine, 'ftp:',ValidInFtpUrl,FtpLink)
end
if T2hFilter<> '' then
do
call DebugLine_IMPORT 'Calling specified filter'
call DebugIncrement 1
Remove=''
call ExecRexxCmd T2hFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DebugLine_IMPORT 'This Record and all following dropped ==> ' ||Remove
call DebugIncrement-1
leave
end
else
do
call DebugLine_IMPORT 'Record dropped ==> ' ||Remove
call DebugIncrement-1
iterate
end
end
call DebugIncrement-1
end
call PpwLineout ToInclude,T2hNewLine
end
call GenerateAfterTags '</FONT></PRE>'
call GenerateProtectEndTags
return(T2hLineNumber)

_MakeTextImportLinkChanges:
parse arg RightBit,UrlType,tlOkInUrl,tlTransformSpec
LeftBit=''
UrlPos=pos(UrlType,RightBit)
lUrlType=length(UrlType)
do while UrlPos<>0
LeftBit=LeftBit||left(RightBit,UrlPos-1)
RightBit=substr(RightBit,UrlPos+lUrlType)
NotUrlCharPos=verify(RightBit,tlOkInUrl)
if NotUrlCharPos=0 then
do
TheUrl=RightBit
RightBit=''
end
else
do
TheUrl=left(RightBit,NotUrlCharPos-1)
RightBit=substr(RightBit,NotUrlCharPos)
end
UrlBit=ReplaceString(tlTransformSpec,UrlTypeVar,UrlType)
UrlBit=ReplaceString(UrlBit,UrlNameVar,TheUrl)
LeftBit=LeftBit||UrlBit
UrlPos=pos(UrlType,RightBit)
end
return(LeftBit||RightBit)

_MakeTextImportEmailChanges:
parse arg RightBit,tlOkInEmailName,tlOkInEmailSvr,tlDelimiters,tlTransformSpec
LeftBit=''
SnailPos=pos('@',RightBit)
do while SnailPos<>0
lRightBit=length(RightBit)
if SnailPos=1|SnailPos=lRightBit then
do
LeftBit=LeftBit||left(RightBit,SnailPos)
RightBit=substr(RightBit,SnailPos+1)
end
else
do
LeftPos=SnailPos-1
do until LeftPos=0
OneChar=substr(RightBit,LeftPos,1)
if pos(OneChar,tlDelimiters)<>0 then
do
LeftPos=LeftPos+1
leave
end
LeftPos=LeftPos-1
end
if LeftPos=0 then
LeftPos=LeftPos+1
EmailLeftBit=substr(RightBit,LeftPos,SnailPos-LeftPos)
RightPos=SnailPos+1
do until RightPos>lRightBit
OneChar=substr(RightBit,RightPos,1)
if pos(OneChar,tlDelimiters)<>0 then
do
RightPos=RightPos-1
leave
end
RightPos=RightPos+1
end
if RightPos>lRightBit then
RightPos=lRightBit
if substr(RightBit,RightPos,1)='.' then
RightPos=RightPos-1
EmailRightBit=substr(RightBit,SnailPos+1,RightPos-SnailPos)
if verify(EmailLeftBit,tlOkInEmailName)<>0|verify(EmailRightBit,tlOkInEmailSvr)<>0|pos('.',EmailRightBit)=0 then
do
LeftBit=LeftBit||left(RightBit,SnailPos)
RightBit=substr(RightBit,SnailPos+1)
end
else
do
EmailBit=ReplaceString(tlTransformSpec,UrlTypeVar, 'mailto:')
EmailBit=ReplaceString(EmailBit,UrlNameVar,EmailLeftBit|| '@' ||EmailRightBit)
LeftBit=LeftBit||left(RightBit,LeftPos-1)||EmailBit
RightBit=substr(RightBit,RightPos+1)
end
end
SnailPos=pos('@',RightBit)
end
return(LeftBit||RightBit)

IMPORTTX_33:
signal IMPORTWR_34

HandleLineWrapping:
if ImportParms<> '' then
CryAndDie('There are too many parameters on the WRAP #import!')
DropBlankLines=translate(GetImportValue('DROP_BLANK_LINES',  'Y'))
call GetImportValue_Tabs
WrapFilter=GetImportValue_RecordFilter()
call GetImportValue_Comments ';', ';' || ';'
if OptionCodeType='HTML' then
call HandleImportAsIsOptions ""
WrapLineNumber=0
NewDoubleQuote='" || d2c(34) || "'
call DebugLine_IMPORT 'Reading "' || FullImportName || '"...'
do while lines(FullImportName)<>0
WrapLine=ImportOneLine('N', 'Y')
WrapLineNumber=WrapLineNumber+1
if WrapLine='' then
do
if DropBlankLines='Y' then
iterate
end
if IsCmtLine(WrapLine)then
iterate
if WrapFilter='' then
do
RebuildCmd='"' || ReplaceString(WrapLine, '"', NewDoubleQuote) || '"'
SafeQuote=QuoteIt(RebuildCmd,TryQuoteListAny)
call PpwLineout ToInclude,StartsMacroReplacement||MacroName|| ' Line=' ||SafeQuote||RebuildCmd||SafeQuote||EndsMacroReplacement
end
else
do
call DebugLine_IMPORT 'Calling filter for line #' ||WrapLineNumber
call DebugIncrement 1
Remove=''
call ExecRexxCmd WrapFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DebugLine_IMPORT 'This Record and all following dropped ==> ' ||Remove
call DebugIncrement-1
leave
end
else
do
call DebugLine_IMPORT 'Line dropped ==> ' ||Remove
call DebugIncrement-1
iterate
end
end
call DebugIncrement-1
call PpwLineout ToInclude,WrapLine
end
end
return(WrapLineNumber)

IMPORTWR_34:
MultiLineImportInProgress='N'
signal I_ML_35

HandleMultiLineImport:
if OptionDebugOn='Y' then
call DebugLine_IMPORT 'Importing multi line record file'
mlDelimiter=GetImportValue('DELIMITER',         '=')
mlLineSep=GetImportValue('SEPARATOR',         ' ')
mlLineCmtChar=GetImportValue('LINE_COMMENT_CHAR',LineComment)
if mlLineCmtChar='' then
mlLineCmtChar=' '
LineFilter=GetImportValue('LINE_FILTER', '')
drop mlFIndex?.
do FieldIndex=1 to NumberOfFields
parse value translate(FieldExtra.FieldIndex)with FieldName ',' FieldOptions
if FieldName='' then
CryAndDie('No {field name} supplied for field #' ||FieldIndex)
call _valueS 'mlFIndex?.mli?' ||c2x(FieldName),FieldOptions
MlFieldName.FieldIndex=FieldName
end
MultiLineImportInProgress='Y'
LastMlStoredAs=''
ImportFileLine=0
LastCommentLine=''
call DebugLine_IMPORT 'Reading "' || FullImportName || '"...'
call _MlNewRecord
do while lines(FullImportName)<>0
MultiLine=strip(ImportOneLine('N', 'N'))
ImportFileLine=ImportFileLine+1
if MultiLine='' then
do
if MlFieldCnt<>0 then
do
call _MlGenerateRecord
call _MlNewRecord
end
end
else
do
if left(MultiLine,1)=LineComment then
iterate
if LineFilter<> '' then
do
call DebugLine_IMPORT 'Calling specified multi line filter'
call DebugIncrement 1
Remove=''
call ExecRexxCmd LineFilter
if Remove<> '' then
do
if abbrev(Remove, "EOF:")then
do
call DebugLine_IMPORT 'Line #' || ImportFileLine || ' to EOF dropped ==> ' ||Remove
call DebugIncrement-1
leave
end
else
do
call DebugLine_IMPORT 'Line #' || ImportFileLine || ' dropped ==> ' ||Remove
call DebugIncrement-1
iterate
end
end
call DebugIncrement-1
end
parse var MultiLine MultiVar (mlDelimiter) MultiValue
if MultiVar<> '' then
call _MlRememberFieldsValue strip(MultiVar, 'T'), strip(MultiValue, 'L')
else
do
if LastMlStoredAs='' then
CryAndDie('Line #' || ImportFileLine || ': No field to continue!')
mlNew=_valueG(LastMlStoredAs)||mlLineSep||strip(MultiValue, 'L')
call _valueS LastMlStoredAs,mlNew
end
end
end
CloseRc=stream(FullImportName, 'c', 'close')
if MlFieldCnt<>0 then
call _MlGenerateRecord
MultiLineImportInProgress='N'
return(ImportFileLine)

_MlNewRecord:
call _NewRecord
MlFieldCnt=0
drop mlFValues?.
return

_MlRememberFieldsValue:
parse arg FieldN,FieldV
UFieldN=translate(FieldN)
StoredAs='mlFIndex?.mli?' ||c2x(UFieldN)
if symbol(StoredAs)<> 'VAR' then
CryAndDie('Line #' || ImportFileLine || ' - Unknown field name of "' || FieldN || '"')
FieldOptions=_valueG(StoredAs)
StoredAs='mlFValues?.mlv?' ||c2x(UFieldN)
LastMlStoredAs=StoredAs
if symbol(StoredAs)='VAR' then
CryAndDie('Line #' || ImportFileLine || ' - Field name of "' || FieldN || '" specified more than once')
if FieldV='' then
do
if pos('NONBLANK',FieldOptions)<>0 then
CryAndDie('Line #' || ImportFileLine || ' - Field "' || FieldN || '" contains a blank value')
end
if pos('NOASIS',FieldOptions)=0 then
call _valueS StoredAs,AsIs(FieldV)
else
call _valueS StoredAs,FieldV
MlFieldCnt=MlFieldCnt+1
return

_MlGenerateRecord:
do FieldIndex=1 to NumberOfFields
FieldName=MlFieldName.FieldIndex
StoredAs='mlFValues?.mlv?' ||c2x(FieldName)
if symbol(StoredAs)='VAR' then
call _AddField2Record _valueG(StoredAs)
else
do
FieldOptions=_valueG('mlFIndex?.mli?' ||c2x(FieldName))
if pos('REQUIRED',FieldOptions)<>0 then
CryAndDie('Line #' || ImportFileLine || ' - Required field "' || FieldName || '" was not specified')
call _AddField2Record ''
end
end
call GenerateRecordFromFields
LastMlStoredAs=''
return

GetMlField:call TRACE "OFF"
if MultiLineImportInProgress<> 'Y' then
CryAndDie('GetMlField(): Multi line import is not in progress!')
FieldName=translate(arg(1))
StoredAs='mlFValues?.mlv?' ||c2x(FieldName)
if symbol(StoredAs)='VAR' then
return(_valueG(StoredAs))
CryAndDie('Line #' || ImportFileLine || ' - GetMlField(): Field "' || FieldName || '" is unknown!')

I_ML_35:
call LoopInit
signal LOOP_36

LoopInit:
InLoop='N'
LoopCount=0
LoopLine=1
LoopFirstLineNumber=-1
LoopIfNesting=-1
LoopLinesFromFile=-1
return

LoopPush:
SavedAs=arg(1)
SFI_InLoop.SavedAs=InLoop
SFI_LoopCount.SavedAs=LoopCount
SFI_LoopLine.SavedAs=LoopLine
SFI_LoopLinesFromFile.SavedAs=LoopLinesFromFile
SFI_LoopFirstLineNumber.SavedAs=LoopFirstLineNumber
SFI_LoopIfNesting.SavedAs=LoopIfNesting
do SaveIndex=1 to LoopCount
SavedPpwLoop.SaveIndex.SavedAs=PpwLoop.SaveIndex
end
call LoopInit
return

LoopPop:
SavedAs=arg(1)
InLoop=SFI_InLoop.SavedAs
LoopCount=SFI_LoopCount.SavedAs
LoopLine=SFI_LoopLine.SavedAs
LoopLinesFromFile=SFI_LoopLinesFromFile.SavedAs
LoopFirstLineNumber=SFI_LoopFirstLineNumber.SavedAs
LoopIfNesting=SFI_LoopIfNesting.SavedAs
do SaveIndex=1 to LoopCount
PpwLoop.SaveIndex=SavedPpwLoop.SaveIndex.SavedAs
end
return

ProcessLoopStart:
if InLoop='Y' then
CryAndDie("Can't nest loops")
InLoop='Y'
LoopCount=0
LoopLine=1
LoopFirstLineNumber=IncludeLineNumber
LoopIfNesting=IfNesting
if IncludeMemBufferNextLine=='' then
LoopLinesFromFile=1
else
LoopLinesFromFile=0
LengthEndCmd=length(CmdHashLoopE)
FoundEnd='N'
do while IncludeFileLines()<>0
LoopCount=LoopCount+1
if LoopLinesFromFile=1 then
do
PpwLoop.LoopCount=IncludeFileLineIn()
InputLines=InputLines+1
end
else
do
if IncludeMemBufferNextLine=='' then
leave
parse var IncludeMemBufferNextLine PpwLoop.LoopCount (MarksNewLine) IncludeMemBufferNextLine
end
MaybeEndCmd=left(strip(PpwLoop.LoopCount, 'L'),LengthEndCmd)
if MaybeEndCmd=CmdHashLoopE then
do
FoundEnd='Y'
LoopCount=LoopCount-1
if LoopCount=0 then
CryAndDie("No commands found in body of loop!")
leave
end
end
if FoundEnd='N' then
do
if LoopLinesFromFile then
eLoop='EOF'
else
eLoop='end of macro'
CryAndDie('Could not find "' || CmdHashLoopE || '" before ' ||eLoop)
end
call DebugLine 'Loop is ' || LoopCount || ' line(s) long and ends on line ' ||AddCommasToDecimalNumber(IncludeLineNumber)
return(0)

GetLoopLineIntoFileLine:
FileLine=PpwLoop.LoopLine
if LoopLinesFromFile then
IncludeLineNumber=LoopFirstLineNumber+LoopLine
LoopLine=LoopLine+1
if LoopLine>LoopCount then
LoopLine=1
return(FileLine)

ProcessLoopBreak:
call DebugLine 'Exiting loop'
InLoop='N'
IfNesting=LoopIfNesting
if LoopLinesFromFile then
IncludeLineNumber=LoopFirstLineNumber+LoopCount+1
return(0)

ProcessLoopContinue:
call DebugLine 'Back to start of loop'
LoopLine=1
IfNesting=LoopIfNesting
return(0)

LOOP_36:
_RestrictKeyMinimum=xrange('A', 'Z') || xrange('a', 'z') || xrange('0', '9')
_giCounter=0
signal GetId_37

GetIdPrepare:call TRACE "OFF"
giHandle=arg(1)
giUniqueId=translate(arg(2))
interpret 'drop GI?'  || giHandle || '.'
call _valueS 'GI?'  || giHandle || '.GI?UID',giUniqueId
return

SetId:call TRACE "OFF"
giHandle=arg(1)
giName=arg(2)
giId=arg(3)
giSaveAsPrefix='GI?'  || giHandle || '.GI?'
if giName\=='' then
do
if _valueG(giSaveAsPrefix|| 'UID') = 'Y' then
CryAndDie("You have asked for UNIQUE ID's to be generated. Don't use SetId()!!!")
giKeySavedAs=giSaveAsPrefix|| 'KEY_' ||c2x(giName)
if symbol(giKeySavedAs)='VAR' then
CryAndDie('SetId(): The KEY of "' || giName || '" has already been used')
call _valueS giKeySavedAs,giId
end
IdSavedAs=giSaveAsPrefix|| 'ID_' ||c2x(giId)
if symbol(IdSavedAs)='VAR' then
CryAndDie('SetId(): The ID of "' || giId || '" has already been used')
call _valueS IdSavedAs, ''
return('')

GetId:call TRACE "OFF"
giHandle=arg(1)
giType=translate(arg(2))
giName=arg(3)
giSaveAsPrefix='GI?'  || giHandle || '.GI?'
giUniqueId=_valueG(giSaveAsPrefix|| 'UID')
if giUniqueId<> 'Y' then
do
giKeySavedAs=giSaveAsPrefix|| 'KEY_' ||c2x(giName)
if symbol(giKeySavedAs)='VAR' then
return(_valueG(giKeySavedAs))
end
GiMaxLength=''
select
when giType="MAXCHARS" then
do
CanBeDuplicated='Y'
GiMaxLength=arg(5)
if GiMaxLength='' then
GiMaxLength=8
giId=_Id_2_(giName,arg(4))
if length(giId)>GiMaxLength then
giId=left(giId,GiMaxLength)
end
when giType="C2X" then
do
CanBeDuplicated='N'
giId=_Id_c2x(giName,arg(4))
end
when giType="2_" then
do
CanBeDuplicated='Y'
giId=_Id_2_(giName,arg(4))
end
otherwise
CryAndDie('GetId(): Invalid type of "' || giType || '" specified')
end
if CanBeDuplicated='Y' then
do
IdSavedAs=giSaveAsPrefix|| 'ID_' ||c2x(giId)
if symbol(IdSavedAs)='VAR' then
do
GiIndex=1
do forever
if GiMaxLength='' then
giTryId=giId||GiIndex
else
do
giChopLength=GiMaxLength-length(GiIndex)
if length(giId)>giChopLength then
giTryId=left(giId,giChopLength)||GiIndex
else
giTryId=giId||GiIndex
end
GiIndex=GiIndex+1
IdSavedAs=giSaveAsPrefix|| 'ID_' ||c2x(giTryId)
if symbol(IdSavedAs)<> 'VAR' then
do
giId=giTryId
leave
end
end
end
call _valueS IdSavedAs, ''
end
if giUniqueId<> 'Y' then
call _valueS giKeySavedAs,giId
return(giId)

_Id_2_:
parse arg KeyR,RestrictTo
RestrictTo=_RestrictKeyMinimum||RestrictTo
KeyL=''
InvPos=verify(KeyR,RestrictTo)
do while InvPos<>0
KeyL=KeyL||left(KeyR,InvPos-1)|| '_'
KeyR=substr(KeyR,InvPos+1)
InvPos=verify(KeyR,RestrictTo)
end
KeyL=strip(KeyL||KeyR,, '_')
do until BeforeCount=ReplaceCount
BeforeCount=ReplaceCount
KeyL=ReplaceString(KeyL, "__", "_")
end
if KeyL='' then
return('_')
else
return(KeyL)

_Id_c2x:
parse arg KeyR,RestrictTo
RestrictTo=_RestrictKeyMinimum||RestrictTo
KeyL=''
InvPos=verify(KeyR,RestrictTo)
do while InvPos<>0
KeyL=KeyL||left(KeyR,InvPos-1)|| 'x' ||c2x(substr(KeyR,InvPos,1))
KeyR=substr(KeyR,InvPos+1)
InvPos=verify(KeyR,RestrictTo)
end
return(KeyL||KeyR)

GetId_37:
call GetIdPrepare "IMAGEHW"
signal Evaluate_38

_ScaleSide:
parse arg SideBefore,SideScale
PercentPos=pos('%',SideScale)
if PercentPos=0 then
return(SideScale)
else
return((SideBefore*left(SideScale,PercentPos-1))%100)

_GetSizeTags:
if OptionDebugOn='Y' then
do
call DebugIncrement 1
call DebugLine_EVALUATE 'Real size = ' || ImageWidth || 'x' ||ImageHeight
call DebugIncrement-1
end
ImgScaleW=ImageScaleW
ImgScaleH=ImageScaleH
if ImgScaleW='?' | ImgScaleH = '?' then
do
if ImgScaleW='?' then
do
NewHeight=_ScaleSide(ImageHeight,ImgScaleH)
ImgScaleW=(NewHeight*100)%ImageHeight|| '%'
NewWidth=_ScaleSide(ImageWidth,ImgScaleW)
end
else
do
NewWidth=_ScaleSide(ImageWidth,ImgScaleW)
ImgScaleH=(NewWidth*100)%ImageWidth|| '%'
NewHeight=_ScaleSide(ImageHeight,ImgScaleH)
end
end
else
do
NewWidth=_ScaleSide(ImageWidth,ImgScaleW)
NewHeight=_ScaleSide(ImageHeight,ImgScaleH)
end
if ImageOldFormat='Y' then
ImageReturn='WIDTH='  || NewWidth || ' HEIGHT=' ||NewHeight
else
ImageReturn='WIDTH="' || NewWidth || '" HEIGHT="' || NewHeight || '"'
if ImageCacheKey<> '' then
call value ImageCacheKey,ImageReturn
return(ImageReturn)

CheckFileInfo:
parse arg iFile,iType,iId,iExpected
if iId==iExpected then
return
CloseRc=stream(iFile, 'c', 'close')
Line1='"' || iFile || '" does not appear to be a "' || iType || '" file.'
Line2='It is ' || stream(iFile, 'c', 'query size') || ' bytes long. '
if iId=='' then
Line2=Line2|| 'This appears to be too short.'
else
Line2=Line2|| 'The ID is "x' || c2x(iId) || '" (expected "x' || c2x(iExpected) || '")'
CryAndDie(Line1,Line2)

_GetGifSize:
GifFormatId=left(charin(ImageFile,1,6),3)
call CheckFileInfo ImageFile, 'GIF', GifFormatId, 'GIF'
WidthLow=charin(ImageFile,,1)
WidthHigh=charin(ImageFile,,1)
ImageWidth=c2d(WidthHigh||WidthLow)
HeightLow=charin(ImageFile,,1)
HeightHigh=charin(ImageFile,,1)
ImageHeight=c2d(HeightHigh||HeightLow)
CloseRc=stream(ImageFile, 'c', 'close')
return(_GetSizeTags())

_GetPngSize:
PngFormatId=charin(ImageFile,1,8)
call CheckFileInfo ImageFile, 'PNG', PngFormatId, '89'x || 'PNG' || '0D 0A 1A 0A'x
PngFormatId=charin(ImageFile,,4)
PngFormatId=charin(ImageFile,,4)
call CheckFileInfo ImageFile, 'PNG', PngFormatId, 'IHDR'
ImageWidth=c2d(charin(ImageFile,,4))
ImageHeight=c2d(charin(ImageFile,,4))
CloseRc=stream(ImageFile, 'c', 'close')
return(_GetSizeTags())

_GetJpgSize:
FileType=c2x(Charin(ImageFile,1,2))
call CheckFileInfo ImageFile, 'JPEG', FileType, "FFD8"
NxtSeg=3
ImageHeight="IMAGEHEIGHT"
Type=''
do while(Type<> "D9") & (NxtSeg <> -1) & (Imageheight = "IMAGEHEIGHT")
NxtSeg=_ReadJpgSegment(NxtSeg)
end
CloseRc=stream(ImageFile, 'c', 'close')
return(_GetSizeTags())

_ReadJpgSegment:
SegPos=arg(1)
Marker=c2x(charIn(ImageFile,SegPos))
if Marker<> "FF" then
return(-1)
Type=c2x(charIn(ImageFile))
Res=SegPos+2
select
when Type="01" | Type >= "D0" & Type <= "D9" then
SegmentLength=0
otherwise
SegmentLength=c2d(CharIn(ImageFile,,2))
End
Res=Res+SegmentLength
if Type="C0" | Type = "C2" then
do
Imagebps=c2d(CharIn(ImageFile))
ImageHeight=c2d(CharIn(ImageFile,,2))
ImageWidth=c2d(CharIn(ImageFile,,2))
end
return(Res)

GetImageHeightWidth:call TRACE "OFF"
parse arg ImageFile,ImageScaleW,ImageScaleH,ImageOldFormat,ImageNoCache
if ImageScaleW='' then
ImageScaleW='100%'
if ImageScaleH='' then
ImageScaleH='?'
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'GetImageHeightWidth("' || ImageFile || '", "' || ImageScaleW || '", "' || ImageScaleH || '")'
if ImageNoCache='Y' then
ImageCacheKey=''
else
do
ImageCacheKey='I_' || ImageFile || '_w' || c2x(ImageScaleW) || '_h' || c2x(ImageScaleH) || '_f' ||ImageOldFormat
ImageCacheKey=GetId("IMAGEHW", 'MAXCHARS',ImageCacheKey,,200)
if symbol(ImageCacheKey)='VAR' then
do
if OptionDebugOn='N' then
return(value(ImageCacheKey))
else
do
SizeString=value(ImageCacheKey)
call DebugLine_EVALUATE 'Returning "' || SizeString || '" (from cache)'
return(SizeString)
end
end
end
DotPos=lastpos('.',ImageFile)
if DotPos=0 then
CryAndDie('Unknown graphic file type on "' || ImageFile || '".')
ImageExtn=translate(substr(ImageFile,DotPos+1))
if SafeQueryExists(ImageFile)='' then
do
CryAndDie('Graphic file "' || ImageFile || '" does not exist.')
return('')
end
call DebugIncrement 1
select
when ImageExtn='GIF' then
SizeString=_GetGifSize()
when ImageExtn='PNG' then
SizeString=_GetPngSize()
when ImageExtn='JPG' | ImageExtn = 'JPEG' then
SizeString=_GetJpgSize()
otherwise
CryAndDie('Currently only support "GIF", "JPEG" & "PNG" files.')
end
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Returning "' || SizeString || '"'
call DebugIncrement-1
return(SizeString)

ToLowerCase:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'ToLowerCase()'
return(translate(arg(1),LowerCase,UpperCase))

EnsureFileHasCorrectCase:call TRACE "OFF"
cFileI=arg(1)
if OptionTranslateFileNames='N' then
return(cFileI)
if OptionTranslateFileNames='UPPER' then
cFileO=translate(cFileI)
else
cFileO=ToLowerCase(cFileI)
if OptionDebugOn='Y' then
do
if cFileI<>cFileO then
do
call DebugLine_EVALUATE 'A files case was adjusted'
call DebugIncrement 1
call DebugLine_EVALUATE 'FROM: "' || cFileI || '"'
call DebugLine_EVALUATE '  TO: "' || cFileO || '"'
call DebugIncrement-1
end
end
return(cFileO)

MakeDirectoryTree:call TRACE "OFF"
WholeDirectory=arg(1)
if right(WholeDirectory,1)=RexDirChar then
WholeDirectory=left(WholeDirectory,length(WholeDirectory)-1)
if WholeDirectory='' then
return(0)
if OptionDebugOn='Y' then
do
call DebugLine 'MakeDirectoryTree("' || WholeDirectory || '")'
call DebugIncrement 1
end
if RexWhich='REGINA' then
do
if stream(WholeDirectory|| '\.', 'c', 'query exists') <> '' then
do
if OptionDebugOn='Y' then
do
call DebugLine 'Directory already exists (no need to make)'
call DebugIncrement-1
end
return(0)
end
end
else
do
if OptionDebugOn='Y' then
call DebugLine "Under OS/2 rexx we can't easily tell if directory already exists"
end
if RexSystemOpSys="UNIX" then
MakeDirCmd='mkdir '
else
MakeDirCmd='md '
SearchFromPosn=1
do until SlashPosn=0
SlashPosn=pos(RexDirChar,WholeDirectory,SearchFromPosn)
if SlashPosn<>1 then
do
if SlashPosn=0 then
MakeDir=WholeDirectory
else
MakeDir=left(WholeDirectory,SlashPosn-1)
DirBit=filespec('name',MakeDir)
if right(MakeDir,1)<> ':' & DirBit <> '.' & DirBit <> '..' then
do
if OptionDebugOn='N' then
call AddressCmd MakeDirCmd||MakeDir||AllCmdOutput2Nul()
else
do
TmpMkDirFile=RexGetTmpFileName()
call AddressCmd MakeDirCmd||MakeDir||RedirectStdOutAndErr2(TmpMkDirFile),TmpMkDirFile
if Rc=0 then
call DebugLine 'Made Directory "' || MakeDir || '"'
call _SysFileDelete TmpMkDirFile
end
end
end
SearchFromPosn=SlashPosn+1
end
if OptionDebugOn='Y' then
call DebugIncrement-1
return(0)

GetAmPmTime:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'GetAmPmTime()'
CivilTime=time('C');  if length(CivilTime)  = 6 then CivilTime=' 'CivilTime
TheTime=time();NumSeconds=':'substr(TheTime,7,2)
return(insert(NumSeconds,CivilTime,5))

GetAmPmTimeFromHhMmSs:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'GetAmPmTimeFromHhMmSs()'
parse value arg(1) with HH ':' MM ':' SS
if HH>=12 then
AmPm='pm'
else
AmPm='am'
if HH>12 then
HH=HH-12
HH=HH+0
MM=right(MM,2, '0')
AmPmTime=HH|| ':' ||MM
if arg(2)<> 'N' then
AmPmTime=AmPmTime|| ':' || right(SS, 2, '0')
AmPmTime=AmPmTime||AmPm
return(AmPmTime)

AddCommasToDecimalNumber:procedure;call TRACE "OFF"
NoComma=strip(arg(1))
if pos(',',NoComma)<>0 then
return(NoComma)
DotPos=pos('.',NoComma)
if DotPos=0 then
AfterDecimal=''
else
do
if DotPos=1 then
return("0" ||NoComma)
AfterDecimal=substr(NoComma,DotPos+1)
NoComma=left(NoComma,DotPos-1)
end
NoComma=reverse(NoComma)
ResultWithCommas=""
do while length(NoComma)>3
ResultWithCommas=ResultWithCommas||left(NoComma,3)|| ','
NoComma=substr(NoComma,4)
end
ResultWithCommas=ResultWithCommas||NoComma
ResultWithCommas=reverse(ResultWithCommas)
if AfterDecimal<> '' then
ResultWithCommas=ResultWithCommas|| '.' ||AfterDecimal
return(ResultWithCommas)

PadString:procedure;call TRACE "OFF"
parse arg TheString,TheMaxSize,PadType
StringSize=length(TheString)
if StringSize>=TheMaxSize then
return(TheString)
SpacesRequired=TheMaxSize-StringSize
if PadType='R' then
return(copies(' ',SpacesRequired)||TheString)
else
do
if PadType<> 'C' then
return(TheString||copies(' ',SpacesRequired))
else
do
SpacesOnLeft=SpacesRequired%2
return(copies(' ', SpacesOnLeft) || TheString || copies(' ',SpacesRequired-SpacesOnLeft))
end
end

BreakAt:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'BreakAt()'
parse arg baMaxSize,baString,baChars,baBreakWith
if baChars=='' then
baChars='./:#'
if baBreakWith='' then
baBreakWith='<BR>'
baPos=pos('-',baMaxSize)
if baPos=0 then
baMinSize=baMaxSize%3
else
parse var baMaxSize baMinSize'-'baMaxSize
baReturn=''
do while length(baString)>baMaxSize
baLeftBit=left(baString,baMaxSize)
baString=substr(baString,baMaxSize+1)
baBestPos=0
baCharList=baChars
do while baCharList\==''
baThisChar=left(baCharList,1)
baCharList=substr(baCharList,2)
baThisPos=lastpos(baThisChar,baLeftBit)
if baThisPos>baBestPos then
do
baBestPos=baThisPos
end
end
if baReturn<> '' then
baReturn=baReturn||baBreakWith
if baBestPos=0 then
baReturn=baReturn||baLeftBit
else
do
baReturn=baReturn||left(baLeftBit,baBestPos)
baString=substr(baLeftBit,baBestPos+1)||baString
end
end
if baReturn<> '' then
return(baReturn||baBreakWith||baString)
else
return(baReturn||baString)

MacroGet:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'MacroGet()'
GotValue=GetDefineContents(arg(1))
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'MacroGet("' || arg(1) || '") = ' ||DebugRightArrow||GotValue||DebugLeftArrow
return(GotValue)

Defined:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Defined()'
DefinedAnswer=VariableExists(arg(1))
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Defined("' || arg(1) || '") = "' || DefinedAnswer || '"'
return(DefinedAnswer)

DataSave:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'DataSave()'
parse arg StoreApp,StoreKey,StoreData
call _valueS "AP?" || c2x(StoreApp) || '.KY?' ||c2x(StoreKey),StoreData
return

DataGet:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'DataGet()'
parse arg StoreApp,StoreKey,StoreDefault
DataVarName="AP?" || c2x(StoreApp) || '.KY' ||c2x(StoreKey)
if symbol(DataVarName)<> 'VAR' then
return(StoreDefault)
else
return(_valueG(DataVarName))

UrlEncode:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'UrlEncode()'
UrlIn=arg(1)
ueCmd=translate(arg(2))
SpaceToPlus='N'
select
when ueCmd='TO%' then
do
UrlBadChars=arg(3)
if UrlBadChars=='' then
UrlBadChars='+<>%"/?# '
end
when ueCmd='ENCODEALL' then
UrlBadChars=xrange('00'x, 'FF'x)
otherwise
CryAndDie('Invalid UrlEncode() command of "' || ueCmd || '"')
end
UrlOut=''
UrlCount=length(UrlIn)
do CharPosn=1 to UrlCount
ThisChar=substr(UrlIn,CharPosn,1)
if pos(ThisChar,UrlBadChars)=0 then
UrlOut=UrlOut||ThisChar
else
do
if ThisChar==' ' & SpaceToPlus = 'Y' then
UrlOut=UrlOut|| '+'
else
UrlOut=UrlOut|| '%' || right(c2x(ThisChar), 2, '0')
end
end
return(UrlOut)

UrlDecode:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'UrlDecode()'
parse arg UrlIn,udCmd
UrlPlusIsSpace='Y'
if udCmd<> '' then
do
if translate(udCmd)='LEAVE+' then
UrlPlusIsSpace='N'
else
CryAndDie('Invalid UrlDecode() command of "' || udCmd || '"')
end
UrlOut=''
CharPosn=1
UrlCount=length(UrlIn)
do while CharPosn<=UrlCount
ThisChar=substr(UrlIn,CharPosn,1)
CharPosn=CharPosn+1
if UrlPlusIsSpace<> 'N' & ThisChar = '+' then
ThisChar=' '
else
do
if ThisChar='%' then
do
ThisChar=substr(UrlIn,CharPosn,2)
CharPosn=CharPosn+2
if CharPosn>(UrlCount+1)then
CryAndDie('Invalid URL encoding of "%' || strip(ThisChar) || '" at end of URL')
ThisChar=x2c(ThisChar)
end
end
UrlOut=UrlOut||ThisChar
end
return(UrlOut)

QuoteIt:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'QuoteIt()'
parse arg Quote4,TryQuotes
if TryQuotes='' then
TryQuotes='"' || "'"
TryQuoteLng=length(TryQuotes)
do QuoteIndex=1 to TryQuoteLng
PossibleQuote=substr(TryQuotes,QuoteIndex,1)
if pos(PossibleQuote,Quote4)=0 then
return(PossibleQuote)
end
CryAndDie('QuoteIt(): Could not find safe quote for ' ||DebugRightArrow||Quote4||DebugLeftArrow)

QuoteAsRexxLit:call TRACE "OFF"
return( "'" || ReplaceString(arg(1), "'", "''") || "'" )

GetFileTimeStamp:call TRACE "OFF"
FileName=arg(1)
if OptionDebugOn='Y' then
do
call DebugLine_EVALUATE 'GetFileTimeStamp("' || FileName || '")'
call DebugIncrement 1
end
SortableTime=FileInMemoryTimeStamp(FileName)
if SortableTime='' then
do
FileTime=stream(FileName, 'c', 'query datetime')
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Is time stamped : "' || FileTime || '"'
if FileTime='' then
do
call OutputWarningToScreen 'TS00', '"' || FileName || '" does not exist.'
if OptionDebugOn='Y' then
call DebugIncrement-1
return(-1)
end
FileTime=space(FileTime)
parse var FileTime Month'-'Day'-'Year' 'Hour':'Minute':'Second
if Year<80 then
Year=100+Year
Year=1900+Year
SortableTime=Year||Month||Day||Hour||Minute||Second
end
if OptionDebugOn='Y' then
do
call DebugLine_EVALUATE 'Returning       : "' || SortableTime || '"'
call DebugIncrement-1
end
return(SortableTime)

BaseDate:Procedure;call TRACE "OFF"
TheDate=translate(arg(1), ' ', '/-')
if TheDate='' then
TheDate=date('Sorted')
parse var TheDate Year MM DD
if length(Year)>=8 then
do
DD=substr(Year,7,2)
MM=substr(Year,5,2)
Year=left(Year,4)
end
DaysInMonth='31  28  31  30  31  30  31  31  30  31  30  31'
if datatype(Year, 'WholeNumber')<>1 then
return(-10)
if datatype(MM, 'WholeNumber')<>1 then
return(-20)
if datatype(DD, 'WholeNumber')<>1 then
return(-30)
if MM<0|MM>12 then
return(-21)
DaysThisMonth=word(DaysInMonth,MM)
if MM=2 then
DaysThisMonth=DaysThisMonth+1
if DD<0|DD>DaysThisMonth then
return(-31)
if length(strip(Year))=2 then
do
if Year>=80 then
Year='19' ||Year
else
Year='20' ||Year
end
y=Year-0001
b=y*365
b=b+y%4
b=b-y%100
b=b+y%400
m=mm-01
do i=1 to m
b=b+word(DaysInMonth,i)
end
if mm>2 then
do
if 0=Year//4 then
do
if 0=Year//100 then
do
if 0=Year//400 then
b=b+1
end
else
b=b+1
end
end
d=dd-01
b=b+d
return(b)

ReverseArray:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'ReverseArray()'
riArray=translate(arg(1))|| '.'
riCount=_valueG(riArray||0)
riHalfWay=riCount%2
do riFrom=1 to riHalfWay
riTo=(riCount-riFrom)+1
riTemp=_valueG(riArray||riFrom)
call _valueS riArray||riFrom,_valueG(riArray||riTo)
call _valueS riArray||riTo,riTemp
end
return(riCount)

Warning:call TRACE "OFF"
call OutputWarningToScreen arg(1),arg(2)
return(0)

Error:call TRACE "OFF"
call CryAndDie 'Rexx code called Error()', '------------------------',arg(1),arg(2),arg(3),arg(4),arg(5),arg(6),arg(7),arg(8),arg(9),arg(10)
return(0)

Info:call TRACE "OFF"
call OutputInformationToScreen arg(1)
return(0)

DieIfIoErrorOccurred:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'DieIfIoErrorOccurred("' || arg(1) || '")'
FileState=stream(arg(1), 'State')
if FileState='READY' then
return
IoReason=stream(arg(1), 'Description')
if IoReason\=='NOTREADY:EOF' then
do
if RexWhich='REGINA' & IoReason = '' then
do
if OptionDebugOn='Y' then
do
call DebugLine 'DieIfIoErrorOccurred(): Bug first reported to Mark Hessling 3/10/99 for 0.08h beta'
call DebugIncrement 1
call DebugLine 'I/O failure on "' || arg(1) || '" (' || IoReason || ').'
call DebugIncrement-1
end
return
end
call CryAndDie 'I/O failure on "' || arg(1) || '" (' || IoReason || ').'
end
return

_ValidateIcLevel:
icLevel=arg(1)
if icLevel='' then
icLevel=IncludeLevel
if datatype(icLevel, 'WholeNumber')<>1 then
return(0)
if icLevel<1|icLevel>IncludeLevel then
return(0)
return(icLevel)

InputComponentLevel:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'InputComponentLevel()'
icLevel=_ValidateIcLevel(arg(1))
if icLevel=0 then
return('')
else
return(IncludeFileName.icLevel)

InputComponentLineLevel:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'InputComponentLineLevel()'
icLevel=_ValidateIcLevel(arg(1))
if icLevel=0 then
return('')
else
do
if icLevel=IncludeLevel then
return(IncludeLineNumber)
else
return(_IncludeLineNumber.icLevel)
end

GenerateFileName:call TRACE "OFF"
parse arg SrcFile,ConversionSpec,RelPathAllowed
if OptionDebugOn='Y' then
do
call DebugLine 'GenerateFileName(' || SrcFile || ') using "' || ConversionSpec || '"'
call DebugIncrement 1
call DebugLine 'Current directory is "' || GetCurrentDirectory() || '"'
end
ShortName=_filespec('name',SrcFile)
InputPath=_filespec('drive', SrcFile) || _filespec('path',SrcFile)
ExtnPos=lastpos('.',ShortName)
if ExtnPos<>0 then
ShortName=left(ShortName,ExtnPos-1)
FullFileName=ReplaceString(ConversionSpec, "?",InputPath)
FullFileName=ReplaceString(FullFileName, "*",ShortName)
FullFileName=ReplaceString(FullFileName, "{$PATH}",InputPath)
FullFileName=ReplaceString(FullFileName, "{$BASE}",ShortName)
if pos('{$path}',FullFileName)<>0 then
do
call DebugIncrement 1
if RelPathAllowed<> 'Y' then
CryAndDie('"{$path}" found, you are only allowed to use this on cmd line...')
call DebugLine '{$path} found, original mask was "' || MaskUsedForCurrentInputFile || '"'
MaskPath=_filespec('Location',MaskUsedForCurrentInputFile)
MaskPathLng=length(MaskPath)
InputFilePath=_filespec('Location',SrcFile)
StartInpPath=left(InputFilePath,MaskPathLng)
if translate(StartInpPath)<>translate(MaskPath)then
CryAndDie("Can't handle '{$path}' (maybe mask not absolute)")
DollarPath=substr(InputFilePath,MaskPathLng+1)
call DebugLine '{$path} = "' || DollarPath || '"'
FullFileName=ReplaceString(FullFileName, "{$path}",DollarPath)
call DebugIncrement-1
end
FullFileName=ReplaceString(FullFileName,RexDirChar||RexDirChar,RexDirChar)
FullFileName=EnsureFileHasCorrectCase(FullFileName)
if OptionDebugOn='Y' then
call DebugLine 'Generated Name = "' || FullFileName || '"'
if OptionDebugOn='Y' then
call DebugIncrement 1
call MakeDirectoryTree _filespec('drive', FullFileName) || _filespec('path',FullFileName)
if OptionDebugOn='Y' then
call DebugIncrement-2
return(FullFileName)

ProcessNext:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'ProcessNext()'
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=arg(1)
else
IncludeMemBufferNextLine=arg(1)||MarksNewLine||IncludeMemBufferNextLine
return

Tabs2Spaces:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Tabs2Spaces()'

ExpandTabs:
parse arg t2sRightBit,t2sTabWidth
if pos('09'x,t2sRightBit)=0 then
return(t2sRightBit)
t2sLeftBit=''
t2sLeftBitL=0
t2sTabPos=pos('09'x,t2sRightBit)
if t2sTabWidth='' then
t2sTabWidth=8
do while t2sTabPos<>0
t2sLeftBit=t2sLeftBit||left(t2sRightBit,t2sTabPos-1)
t2sLeftBitL=t2sLeftBitL+(t2sTabPos-1)
Spaces4Tab=t2sTabWidth-((t2sLeftBitL+1)//t2sTabWidth)
t2sLeftBit=t2sLeftBit||copies(' ',Spaces4Tab)
t2sLeftBitL=t2sLeftBitL+Spaces4Tab
t2sRightBit=substr(t2sRightBit,t2sTabPos+1)
t2sTabPos=pos('09'x,t2sRightBit)
end
return(t2sLeftBit||t2sRightBit)

RexxVarDefined:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'RexxVarDefined()'
vsValue=symbol(arg(1))
if vsValue='BAD' then
do
vsLength=length(arg(1))
if symbol(copies('A', vsLength)) <> 'BAD' then
Reason=''
else
Reason='A symbol length of "' || vsLength || ' bytes seems to be too long for your rexx interpreter!'
CryAndDie('RexxVarDefined()', 'Invalid symbol of "' || arg(1) || '" passed.',Reason)
end
if vsValue='VAR' then
return(1)
else
return(0)

ReplaceCurlyHexCodes:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'ReplaceCurlyHexCodes()'
Before=arg(1)
RightBit=Before
LeftBit=''
StartPos=pos('{x',RightBit)
do while StartPos<>0
Codes2=substr(RightBit,StartPos+2,2)
if datatype(Codes2, 'X') <> 1 | substr(RightBit, StartPos+4, 1) <> '}' then
do
LeftBit=LeftBit||left(RightBit,StartPos+1)
RightBit=substr(RightBit,StartPos+2)
end
else
do
LeftBit=LeftBit||left(RightBit,StartPos-1)||x2c(Codes2)
RightBit=substr(RightBit,StartPos+5)
end
StartPos=pos('{x',RightBit)
end
LeftBit=LeftBit||RightBit
if OptionDebugOn='Y' then
do
if Before<>LeftBit then
call DebugOutputAfterReplacement LeftBit, '{xXX}'
end
return(LeftBit)

RandomString:call TRACE "OFF"
parse arg RsString,RsPickFrom
if RsPickFrom='' then
RsPickFrom=DecimalDigits||UpperCase
RsMax=length(RsPickFrom)
QPos=pos('?',RsString)
do while QPos<>0
RsString=left(RsString,QPos-1)||substr(RsPickFrom,random(1,RsMax),1)||substr(RsString,QPos+1)
QPos=pos('?',RsString)
end
return(RsString)

SortArray:call TRACE "OFF"
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'SortArray()'
parse arg bsArray,bsStartCol,bsEndCol,bsStrict
bsArray=translate(bsArray)|| '.'
if bsStartCol='' then
bsStartCol=0
else
do
if bsEndCol='' then
bsLength=0
else
bsLength=bsEndCol-bsStartCol
end
bsM=1
bsCount=_valueG(bsArray||0)
do while(9*bsM+4)<bsCount
bsM=bsM*3+1
end
do while bsM>0
bsK=bsCount-bsM
do bsJ=1 to bsK
bsIndex1=bsJ
do while bsIndex1>0
bsIndex2=bsIndex1+bsM
if bsStartCol=0 then
do
bsVal1=_valueG(bsArray||BSINDEX1)
bsVal2=_valueG(bsArray||BSINDEX2)
end
else
do
if bsLength=0 then
do
bsVal1=substr(_valueG(bsArray||BSINDEX1),bsStartCol)
bsVal2=substr(_valueG(bsArray||BSINDEX2),bsStartCol)
end
else
do
bsVal1=substr(_valueG(bsArray||BSINDEX1),bsStartCol,bsLength)
bsVal2=substr(_valueG(bsArray||BSINDEX2),bsStartCol,bsLength)
end
end
if bsStrict='Y' then
bsGreater=bsVal1>>bsVal2
else
bsGreater=bsVal1>bsVal2
if bsGreater then
do
bsTemp=_valueG(bsArray||BSINDEX1)
call _valueS bsArray||BSINDEX1,_valueG(bsArray||BSINDEX2)
call _valueS bsArray||BSINDEX2,bsTemp
end
else
leave
bsIndex1=bsIndex1-bsM
end
end
bsM=bsM%3
end
return(bsCount)

_FindFileInPathList:
parse arg zf_Look4,zf_PathList
call DebugIncrement 1
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Searching for "' || zf_Look4 || '" in "' || zf_PathList || '"'
if RexSystemOpSys="UNIX" then
zf_SepChar=':'
else
zf_SepChar=';'
zf_Found=''
do while zf_PathList<> ''
parse var zf_PathList zf_Path (zf_SepChar) zf_PathList
if right(zf_Path,1)<>RexDirChar then
zf_Path=zf_Path||RexDirChar
zf_Found=RexQueryExists(zf_Path||zf_Look4)
if zf_Found<> '' then
leave
end
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Found "' || zf_Found || '"'
call DebugIncrement-1
return(zf_Found)

FindFileInPath:call TRACE "OFF"
parse arg zg_Look4,zg_LookIn
if RexSystemOpSys="UNIX" then
zg_SepChar=':'
else
zg_SepChar=';'
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'FindFileInPath(): Looking for "' || zg_Look4 || '" in "' || zg_LookIn || '"'
call DebugIncrement 1
zg_Searched=''
do while zg_LookIn<> ''
parse var zg_LookIn zg_ThisBit (zg_SepChar) zg_LookIn
if zg_ThisBit='' then
iterate
zg_Left1=left(zg_ThisBit,1)
select
when zg_Left1='*' then
do
zg_LookIn=GetEnv(substr(zg_ThisBit,2))||zg_SepChar||zg_LookIn
end
when zg_Left1='+' then
do
zg_List.0=0
zg_Mask=substr(zg_ThisBit,2)||RexDirChar|| '*.*'
call _SysFileTree zg_Mask, 'zg_List', 'DOS'
zg_Comb=''
do zg_Index=1 to zg_List.0
if zg_Index=1 then
zg_Comb=zg_List.zg_Index
else
zg_Comb=zg_Comb||zg_SepChar||zg_List.zg_Index
end
zg_LookIn=zg_Comb||zg_SepChar||zg_LookIn
end
otherwise
do
if zg_Searched='' then
zg_Searched=zg_ThisBit
else
zg_Searched=zg_Searched||zg_SepChar||zg_ThisBit
end
end
end
zg_Found=_FindFileInPathList(zg_Look4,zg_Searched)
if zg_Found<> '' then
zg_Found=stream(zg_Found, 'c', 'query exists')
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Result: "' || zg_Found || '"'
call DebugIncrement-1
return(zg_Found)

FindFile:call TRACE "OFF"
zh_Look4=arg(1)
zh_Found=''
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'FindFile(): Looking for "' || zh_Look4 || '"'
call DebugIncrement 1
if zh_Found='' then
zh_Found=SafeQueryExists(zh_Look4)
if zh_Found='' then
do
do zh_Index=1 to OptionIncludePathCnt until zh_Found<> ''
zh_Found=FindFileInPath(zh_Look4,OptionIncludePath.zh_Index)
end
end
if zh_Found='' then
zh_Found=FindFileInPath(zh_Look4, '*PPWIZARD_INCLUDE')
if zh_Found='' then
zh_Found=FindFileInPath(zh_Look4, '*INCLUDE')
if zh_Found='' then
do
parse source . . zh_Found
zh_Found=_filespec('Location',zh_Found)||zh_Look4
if SafeQueryExists(zh_Found)='' then
zh_Found=''
end
if zh_Found<> '' then
zh_Found=stream(zh_Found, 'c', 'query exists')
if OptionDebugOn='Y' then
call DebugLine_EVALUATE 'Result: "' || zh_Found || '"'
call DebugIncrement-1
return(zh_Found)

_SysSearchPath:call TRACE "OFF"
return(FindFileInPath(arg(2), '*' ||arg(1)))

Evaluate_38:
TraceBpListsLoaded=''
TraceAutoAliasCnt=0
TraceAutoAliasMax=0
signal ExecCmd_39

ExecRexxCmd:
InterpretThisC=arg(1)
if RexWhich='REGINA' then
UseEos=MarksNewLine
else
UseEos=';'
InterpretThisC=ReplaceEos(InterpretThisC)
InterpretThis=InterpretThisC
TraceBreakPoint=''
PrevTracedLine=''
if OptionDebugOn='Y' then
do
call DebugLine_INTERPRET 'Interpreting ' ||DebugRightArrow||InterpretThisC||DebugLeftArrow
call DebugLine_INTERPRET 'Rexx code is ' || AddCommasToDecimalNumber(length(InterpretThisC)) || ' bytes long'
if bitand(DebugLevel,SeeRexxTrace)==SeeRexxTrace then
do
if RexWhich='REGINA' then
TrcDef='OFF'
else
TrcDef='INTERMEDIATES'
TraceLevel4Rexx=translate(GetDefineValueOrUseDefault('REXXTRACE',TrcDef))
if TraceLevel4Rexx<> 'OFF' then
InterpretThis='TRACE ' || TraceLevel4Rexx || ';' || InterpretThisC || ';call TRACE "OFF";'
TraceBreakPoint=strip(GetDefineValueOrUseDefault('REXX_BP', ''))
if TraceBreakPoint='' then
TraceBpList=''
else
do
if length(TraceBreakPoint)>1&left(TraceBreakPoint,1)='=' then
do
TraceBreakPoint='=' ||MacroGet(strip(substr(TraceBreakPoint,2)))
TraceBreakPoint=ReplaceEos(PerformReplacementsInCmdsParameters(TraceBreakPoint))
end
if TraceAutoAliasMax=0 then
do
TraceAutoAliasMax=GetDefineValueOrUseDefault('REXX_BP_MAX_AUTO_CMD',22)
if datatype(TraceAutoAliasMax, 'W')=0 then
TraceAutoAliasMax=22
if TraceAutoAliasMax<10 then
TraceAutoAliasMax=22
end
TraceBpList=GetDefineValueOrUseDefault('REXX_BP_ALIAS', '')
if TraceBpList<>TraceBpListsLoaded then
TraceBpListsLoaded=''
end
call Line1 ''
call Line1 '---------- REXX TRACE - START(' || TraceLevel4Rexx || ') ----------'
end
end
signal ON SYNTAX NAME _SyntaxErrorDuringInterpret
signal ON NOVALUE NAME _UnknownVariableDuringInterpret
interpret InterpretThis
TraceBreakPoint=''
if OptionDebugOn='Y' then
do
if bitand(DebugLevel,SeeRexxTrace)==SeeRexxTrace then
do
call Line1 '---------- REXX TRACE - END(' || TraceLevel4Rexx || ') ----------'
call Line1 ''
end
end
return

_UnknownVariableDuringInterpret:
TrappingLine=SIGL
call TRACE "OFF"
call CommonTrapHandler TrappingLine, 'NoValue Abort!', 'Unknown Variable', condition('D'),space(InterpretThisC),TraceBreakPoint

_SyntaxErrorDuringInterpret:
TrappingLine=SIGL
call TRACE "OFF"
call CommonTrapHandler TrappingLine, 'Syntax Error!', 'Reason',errortext(Rc),space(InterpretThisC),TraceBreakPoint

ReplaceEos:
return(ReplaceString(arg(1),DefRexxSpecialSepTag,UseEos))

AddToBpSearch:
RtSearchText=RtSearchText|| '{SOL}' || space(arg(1)) || '{EOL}'
return

RexxTrace:call TRACE "OFF"
if OptionDebugOn='N' then
return
if bitand(DebugLevel,SeeRexxTrace)\==SeeRexxTrace then
return
signal on NOVALUE name RexxTrapUninitializedVariable
signal on SYNTAX name RexxTrapSyntaxError
parse arg rtText,rtDumpList,rtDbgCmd,rtDbgTrapped
rtSay='$TRACE: ' ||rtText
call Line1 PpwRexxTraceColor||rtSay||Reset
RtSearchText=''
call AddToBpSearch rtText
if rtDbgTrapped<> 'Y' then
do
rtThis=''
if rtDbgCmd='Y' then
do
rtThis=PrevTracedLine|| ' ' ||rtText
PrevTracedLine=rtText
end
else
rtThis=rtDumpList
if rtThis<> '' then
do
if rtThis<> '?' then
call DumpVarsInExpression rtThis, '', '', 'TraceVarSay'
else
do
call Line1 'ALL KNOWN VARIABLES'
call Line1 '~~~~~~~~~~~~~~~~~~~'
call DumpVarsInExpression InterpretThisC, '', '', 'TraceVarSay'
end
end
end
call Line1 ''
if rtDbgTrapped='Y' then
rtStop='Y'
else
do
if TraceBreakPoint='' then
rtStop='N'
else
do
select
when TraceBreakPoint='?' then
rtStop='Y'
when left(TraceBreakPoint,1)='=' then
do
rtStop='N'
call ExecuteUsersTraceCmd substr(TraceBreakPoint,2)
end
otherwise
do
if pos(TraceBreakPoint,RtSearchText)<>0 then
rtStop='Y'
else
rtStop='N'
end
end
end
end
if rtStop='N' then
return
call LoadBpLists
do forever
call charout,InfoColor|| '<' || '$TRACE, ' || BpAliasCnt || ' aliases> ' ||Reset
rtCmd=strip(linein())
if rtCmd='' then
return
rtCmdU=translate(rtCmd)
select
when left(rtCmd,1)='/' then
do
EqPos=pos('=',rtCmd)
if EqPos<>0 then
do
call AddBpAlias rtCmd, "user"
STo=SaveBpAliasFile()
if STo='' then
STxt='Done (not permanently saved)!'
else
STxt='Done, saved to "' || STo || '".'
call Line1 HighlightColor||STxt||Reset
end
else
do
rtAlias=strip(substr(rtCmd,2))
if left(rtAlias,1)='#' | datatype(rtAlias, 'W')then
do
if left(rtAlias,1)='#' then
rtAliasI=strip(substr(rtAlias,2))
else
rtAliasI=rtAlias
if rtAliasI>TraceAutoAliasCnt then
do
call Line1 ErrorColor|| '#Alias "#' || rtAliasI || '" does not exist!' ||Reset||Beep
iterate
end
rtAliasI=(TraceAutoAliasCnt-rtAliasI)+1
rtCmd=Aalias.rtAliasI
end
else
do
rtCmd=FindBpAlias(rtAlias)
if rtCmd='' then
do
call Line1 ErrorColor|| 'Alias "' || rtAlias || '" not found!' ||Reset||Beep
iterate
end
end
call Line1 HighlightColor||rtCmd||Reset
call ExecuteUsersTraceCmd rtCmd
end
end
when left(rtCmd,1)='?' then
do
rtCmdU=substr(rtCmdU,2)
call Char1 PpwRexxTraceColor
select
when rtCmdU='' then
do
call Line1 PpwRexxTraceColor||rtText||Reset
end
when abbrev('VARIABLES',rtCmdU)then
do
call Line1 'ALL KNOWN VARIABLES'
call Line1 '~~~~~~~~~~~~~~~~~~~'
call DumpVarsInExpression InterpretThisC, '', '', 'TraceVarSay'
end
when abbrev('ALIASES',rtCmdU)then
do
call Line1 'ALL ALIASES'
call Line1 '~~~~~~~~~~~'
do Index=1 to BpAliasCnt
call Line1 left(BpAlias.Index.BpAName,BpLongestAlias)|| ' = ' ||BpAlias.Index.BpAValue
end
end
when abbrev('#ALIASES',rtCmdU)then
do
if TraceAutoAliasCnt=0 then
call Line1 ErrorColor|| 'No commands have been remembered yet!' ||Reset||Beep
else
do
MaxLng=length(TraceAutoAliasCnt)
call Line1 'ALL # ALIASES'
call Line1 '~~~~~~~~~~~~~'
do Index=1 to TraceAutoAliasCnt
IndexR=(TraceAutoAliasCnt-Index)+1
call Line1 '/#' || left(IndexR, MaxLng)  || ' = ' ||Aalias.Index
end
end
end
otherwise
call Line1 ErrorColor|| 'Unknown ? command of "' || rtCmd || '"!' ||Reset||Beep
end
call Char1 Reset
end
when rtCmdU='BP' then
do
call charout,InfoColor|| "New Breakpoint (blank = none) => " ||Reset
TraceBreakPoint=strip(linein())
end
otherwise
do
if ExecuteUsersTraceCmd(rtCmd)=0 then
do
if AddAutoAlias(rtCmd)<>0 then
call SaveBpAliasFile
end
end
end
end
return

TraceVarSay:
call Line1 PpwRexxTraceColor|| "      | " ||arg(1)||Reset
call AddToBpSearch arg(1)
return

ExecuteUsersTraceCmd:
signal ON SYNTAX NAME _SyntaxErrorDuringExecuteUsersTraceCmd
signal ON NOVALUE NAME _UnknownVariableDuringExecuteUsersTraceCmd
interpret arg(1)
return(0)

_SyntaxErrorDuringExecuteUsersTraceCmd:
call Line1 ErrorColor|| 'SYNTAX ERROR: ' ||errortext(Rc)||Reset
call Line1 Beep
return(1)

_UnknownVariableDuringExecuteUsersTraceCmd:
call Line1 ErrorColor|| 'NOVALUE ERROR: VAR=' || condition('D')||Reset
call Line1 Beep
return(1)

LoadBpLists:
if TraceBpListsLoaded<> '' then
return
BpSaveTo=''
BpList=TraceBpList
BpAliasCnt=0
BpFileNumb=0
do while BpList<> ''
parse var BpList BpList1';'BpList
BpFileNumb=BpFileNumb+1
if BpFileNumb=1 then
BpSaveTo=BpList1
if BpList1='' then
iterate
BpList1=FindFile(BpList1)
if BpList1='' then
iterate
CloseRc=stream(BpList1, 'c', 'close')
BpListLine=0
BpLongestAlias=0
do while lines(BpList1)<>0
CurrentLine=strip(linein(BpList1))
BpListLine=BpListLine+1
if CurrentLine='' | left(CurrentLine, 1) = ';' then
iterate
AliasSource='line #' || BpListLine || ' of ' ||BpList1
call AddBpAlias CurrentLine,AliasSource,BpFileNumb
end
CloseRc=stream(BpList1, 'c', 'close')
end
TraceBpListsLoaded=TraceBpList
return

AddBpAlias:
parse arg AliasCmd,AliasSrc,FromFile
parse var AliasCmd '/'BpAliasName'='BpAliasValue
if BpAliasValue='' then
do
call DebugLine 'Alias Command from ' || AliasSrc || ' incorrectly formatted!'
return
end
BpAliasName=translate(BpAliasName)
if left(BpAliasName,1)=='#' then
do
call AddAutoAlias BpAliasValue
return
end
if length(BpAliasName)>BpLongestAlias then
BpLongestAlias=length(BpAliasName)
FoundIndex=0
do Index=1 to BpAliasCnt
if BpAliasName=BpAlias.Index.BpAName then
do
FoundIndex=Index
leave
end
end
if FoundIndex<>0 then
do
if FromFile<> '' then
return
end
else
do
BpAliasCnt=BpAliasCnt+1
FoundIndex=BpAliasCnt
end
BpAlias.FoundIndex.BpAName=BpAliasName
BpAlias.FoundIndex.BpAValue=BpAliasValue
BpAlias.FoundIndex.BpFNumb=FromFile
return

FindBpAlias:
BpAliasName=translate(strip(arg(1)))
do Index=1 to BpAliasCnt
if BpAliasName=BpAlias.Index.BpAName then
return(BpAlias.Index.BpAValue)
end
return('')

SaveBpAliasFile:
if BpSaveTo='' then
return('')
call MustDeleteFile BpSaveTo
call lineout BpSaveTo, ';***'
call lineout BpSaveTo, ';*** Automatically saved at: ' ||NiceDateTime()
call lineout BpSaveTo, ';***'
call lineout BpSaveTo, ''
FoundF='N'
do Index=1 to BpAliasCnt
if BpAlias.Index.BpFNumb=1 then
do
if FoundF='N' then
call lineout BpSaveTo, ';--- Loaded From File ---'
FoundF='Y'
call lineout BpSaveTo, '/' || BpAlias.Index.BpAName || '=' ||BpAlias.Index.BpAValue
end
end
CloseRc=stream(BpSaveTo, 'c', 'close')
FoundU='N'
do Index=1 to BpAliasCnt
if BpAlias.Index.BpFNumb=''then
do
if FoundU='N' then
do
if FoundF='Y' then
call lineout BpSaveTo, ''
call lineout BpSaveTo, ';--- User Modified This Session ---'
end
FoundU='Y'
call lineout BpSaveTo, '/' || BpAlias.Index.BpAName || '=' ||BpAlias.Index.BpAValue
end
end
CloseRc=stream(BpSaveTo, 'c', 'close')
if TraceAutoAliasCnt<>0 then
do
call lineout BpSaveTo, ''
call lineout BpSaveTo, ';--- Last Few Commands Used ---'
do Index=1 to TraceAutoAliasCnt
IndexN=(TraceAutoAliasCnt-Index)+1
call lineout BpSaveTo, '/#' || IndexN  || '=' ||Aalias.Index
end
end
CloseRc=stream(BpSaveTo, 'c', 'close')
return(BpSaveTo)

FindAutoAlias:
FindWhat=arg(1)
do FndIndex=1 to TraceAutoAliasCnt
if FindWhat=Aalias.FndIndex then
return(FndIndex)
end
return(0)

DeleteAutoAlias:
DelIndex=arg(1)
do DelIndexT=DelIndex to TraceAutoAliasCnt-1
DelIndexF=DelIndexT+1
Aalias.DelIndexT=Aalias.DelIndexF
end
TraceAutoAliasCnt=TraceAutoAliasCnt-1
return

AddAutoAlias:
SaveWhat=strip(arg(1))
if SaveWhat='' then
return(0)
FoundAt=FindAutoAlias(SaveWhat)
if FoundAt<>0 then
call DeleteAutoAlias FoundAt
if TraceAutoAliasCnt>=TraceAutoAliasMax then
call DeleteAutoAlias 1
TraceAutoAliasCnt=TraceAutoAliasCnt+1
Aalias.TraceAutoAliasCnt=SaveWhat
return(TraceAutoAliasCnt)

ExecCmd_39:
ExpandXEarly='N'
ExpandXLate='N'
ExpandXCmd='N'
signal EndExpandX

EXPANDX_DEBUG:
if OptionDebugOn='Y' then
do
if ExpandX='NONE' then
call OptionDebugShow 'EXPANDX', 'X codes are never expanded'
else
call OptionDebugShow 'EXPANDX', 'X codes are expanded "' || ExpandX || '"'
end
return

EXPANDX_GET:
call EXPANDX_DEBUG
return(ExpandX)

EXPANDX_SET:
ExpandX=translate(arg(1))
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'EXPANDX', 'Setting default value of "X" var expansion to "' || EXPANDX || '"'
Default4_EXPANDX=ExpandX
return(0)
end
if ExpandX=='' then
ExpandX=Default4_EXPANDX
ExpandXEarly='N'
ExpandXLate='N'
ExpandXCmd='N'
if ExpandX<> 'NONE' then
do
TmpList=translate(ExpandX)
do while TmpList<> ''
parse var TmpList ThisItem','TmpList
select
when ThisItem='COMMAND' then
ExpandXCmd='Y'
when ThisItem='EARLY' then
ExpandXEarly='Y'
when ThisItem='LATE' then
ExpandXLate='Y'
otherwise
CryAndDie('Unknown EXPANDX option of "' || ThisItem || '"')
end
end
end
call EXPANDX_DEBUG
return

InitializeCharCodes:
call DebugLine_DEFINING 'Initializing <' || '?x00-FF> codes + <' || '?xRexxEos> + some others'
do CharCode=0 to 255
call _valueS 'XVAR?.X?' ||c2x(translate(d2x(CharCode,2))),d2c(CharCode)
end
call _valueS 'XVAR?.X?'  || c2x(translate("RexxEos")),d2c(10)
Val='<' || '?xml version="1.0" encoding="UTF-8"?>' ||MarksNewLine
Val=Val|| '<' || '!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "DTD/xhtml1-strict.dtd">' ||MarksNewLine
Val=Val|| '<html xmlns="http://www.w3.org/1999/xhtm" xml:lang="en" lang="en">' ||MarksNewLine
call _valueS 'XVAR?.X?'  || c2x(translate("HTML10")),Val
return

ExpandXCodes:call TRACE "OFF"

ReplaceXCodesIfNotDisabled:
if pos(StartsStdSymbolReplacement_x,arg(1))=0 then
return(arg(1))

ReplaceTheXCodesWeKnowExist:
LeftBit=''
RightBit=arg(1)
StartPos=pos(StartsStdSymbolReplacement_x,RightBit)
do while StartPos<>0
ReplaceCount=ReplaceCount+1
EndPos=pos(EndsMacroReplacement,RightBit,StartPos+1)
XVarName='XVAR?.X?' ||c2x(translate(substr(RightBit,StartPos+3,(EndPos-StartPos)-3)))
if symbol(XVarName)='VAR' then
LeftBit=LeftBit||left(RightBit,StartPos-1)||_valueG(XVarName)
else
do
CryAndDie(StartsStdSymbolReplacement_x||substr(RightBit,StartPos+3,(EndPos-StartPos)-3)||EndsMacroReplacement|| ' is not defined (use "#RexxVar =x=" command)!')
end
RightBit=substr(RightBit,EndPos+1)
StartPos=pos(StartsStdSymbolReplacement_x,RightBit)
end
if OptionDebugOn='Y' then
call DebugOutputAfterReplacement LeftBit||RightBit, '?xXX'
return(LeftBit||RightBit)

EndExpandX:
signal OnExit_40

SetUpOnExitProcessingIfEndOfMainFile:
if IncludeLevel=1 then
do
if DoOnExit<> '' then
do
call DebugLine ''
call DebugLine '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
call DebugLine '!!! "#OnExit" processing follows !!!'
call DebugLine '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
call DebugLine ''
IncludeMemBufferNextLine=DoOnExit
DoOnExit=''
return('Y')
end
end
return('N')

ProcessOnExit:
Rest=strip(arg(1))
if Rest='' then
return
call DebugLine 'OnExit we will process ' ||DebugRightArrow||Rest||DebugLeftArrow
if DoOnExit='' then
DoOnExit=Rest
else
DoOnExit=DoOnExit||MarksNewLine||Rest
return(0)

OnExit_40:
IncludeIntoMemory=''
signal Include_41

RecursiveIncludeSave:
call LoopPush IncludeLevel
_DebugCurrentFileNumber.IncludeLevel=DebugCurrentFileNumber
_IncludeMemHandle.IncludeLevel=IncludeMemHandle
_IncludeEofLine.IncludeLevel=IncludeEofLine
_IncludeFragmentText.IncludeLevel=IncludeFragmentText
_IncludeLineNumber.IncludeLevel=IncludeLineNumber
_IncludeMemBufferNextLine.IncludeLevel=IncludeMemBufferNextLine
_EofForced.IncludeLevel=EofForced
EofForced=''
return

RecursiveIncludeRestore:
DebugCurrentFileNumber=_DebugCurrentFileNumber.IncludeLevel
IncludeMemHandle=_IncludeMemHandle.IncludeLevel
IncludeEofLine=_IncludeEofLine.IncludeLevel
IncludeFragmentText=_IncludeFragmentText.IncludeLevel
IncludeLineNumber=_IncludeLineNumber.IncludeLevel
IncludeMemBufferNextLine=_IncludeMemBufferNextLine.IncludeLevel
EofForced=_EofForced.IncludeLevel
IncludeFileName=IncludeFileName.IncludeLevel
call LoopPop IncludeLevel
return

FileInMemoryTimeStamp:
fimFullFileName=arg(1)
if RexSystemOpSys="UNIX" then
ifHandle='_IF_' || c2x(fimFullFileName) || '.'
else
ifHandle='_IF_' || c2x(translate(fimFullFileName)) || '.'
if symbol(ifHandle|| '!TS') <> 'VAR' then
return('')
else
do
Ts=_valueG(ifHandle|| '!TS')
if OptionDebugOn='Y' then
call DebugLine 'Cached Timestamp: "' || Ts || '"'
return(Ts)
end

IncludeFileOpen:
ifFullFileName=arg(1)
ifLoad2Mem=arg(2)
if RexSystemOpSys="UNIX" then
ifHandle='_IF_' || c2x(ifFullFileName) || '.'
else
ifHandle='_IF_' || c2x(translate(ifFullFileName)) || '.'
if symbol(ifHandle|| '0') = 'VAR' then
do
if OptionDebugOn='Y' then
call DebugLine '"' || ifFullFileName || '" will be read from memory cache'
return(_valueG(ifHandle|| '0') || ';' ||ifHandle)
end
CloseRc=stream(ifFullFileName, 'c', 'close')
OpenRc=stream(ifFullFileName, 'c', 'open read')
if ifLoad2Mem='' then
ifLoad2Mem=IncludeIntoMemory
if ifLoad2Mem='N' then
do
if OptionDebugOn='Y' then
call DebugLine 'Will read "' || ifFullFileName || '" directly from file'
return('')
end
if OptionDebugOn='Y' then
call DebugLine 'Will read "' || ifFullFileName || '" into memory cache'
Ts=GetFileTimeStamp(ifFullFileName)
call _valueS ifHandle|| '!TS',Ts
ifLineNum=0
do while lines(ifFullFileName)<>0
ifLineNum=ifLineNum+1
ifLineTxt=linein(ifFullFileName)
call _valueS ifHandle||ifLineNum,ifLineTxt
end
call _valueS ifHandle|| '0',ifLineNum
call DieIfIoErrorOccurred ifFullFileName, 'Y'
CloseRc=stream(ifFullFileName, 'c', 'close')
if OptionDebugOn='Y' then
do
call DebugIncrement 1
call DebugLine 'Read ' || AddCommasToDecimalNumber(ifLineNum) || ' lines'
call DebugIncrement-1
end
return(ifLineNum|| ';' ||ifHandle)

IncludeFileClose:
if IncludeMemHandle='' then
do
call DieIfIoErrorOccurred IncludeFileName, 'Y'
CloseRc=stream(IncludeFileName, 'c', 'close')
end
return

IncludeFileLines:
if IncludeMemHandle='' then
return(lines(IncludeFileName))
else
return(IncludeLineNumber<IncludeEofLine)

IncludeFileLineIn:
IncludeLineNumber=IncludeLineNumber+1
if IncludeMemHandle='' then
ifLineTxt=linein(IncludeFileName)
else
ifLineTxt=_valueG(IncludeMemHandle||IncludeLineNumber)
if ExtraWhiteSpace=='' then
return(ifLineTxt)
else
return(translate(ifLineTxt, '', ExtraWhiteSpace, ' '))

Include_41:
SummaryUserAllBldCount=0
SummaryUserOverallCount=0
SummaryUserThisBldCount=0
signal Summary_42

Summary:call TRACE "OFF"
parse arg SummaryLeft,SummaryRight,SummaryMode
SummaryLeft=strip(SummaryLeft)
SummaryMode1=translate(left(SummaryMode,1))
select
when SummaryMode1='D' then
do
call DebugLine "Don't" || ' want "' || SummaryLeft || '" in any summaries'
call _valueS '!SUMMDROP.!' ||c2x(SummaryLeft),CurrentSourceLocation()
end
when SummaryMode1='O' then
do
SummaryUserOverallCount=SummaryUserOverallCount+1
SummaryUserOverallL.SummaryUserOverallCount=SummaryLeft
SummaryUserOverallR.SummaryUserOverallCount=SummaryRight
end
when SummaryMode1='A' then
do
SummaryUserAllBldCount=SummaryUserAllBldCount+1
SummaryUserAllBldL.SummaryUserAllBldCount=SummaryLeft
SummaryUserAllBldR.SummaryUserAllBldCount=SummaryRight
end
otherwise
do
SummaryUserThisBldCount=SummaryUserThisBldCount+1
SummaryUserThisBldL.SummaryUserThisBldCount=SummaryLeft
SummaryUserThisBldR.SummaryUserThisBldCount=SummaryRight
end
end
return

GenerateUserSummaryThisBuild:
do SummLine=1 to SummaryUserThisBldCount
call AddSummaryLine SummaryUserThisBldL.SummLine,SummaryUserThisBldR.SummLine
end
SummaryUserThisBldCount=0
return

GenerateUserSummaryAllBuilds:
do SummLine=1 to SummaryUserAllBldCount
call AddSummaryLine SummaryUserAllBldL.SummLine,SummaryUserAllBldR.SummLine
end
return

GenerateUserSummaryOverall:
do SummLine=1 to SummaryUserOverallCount
call AddSummaryLine SummaryUserOverallL.SummLine,SummaryUserOverallR.SummLine
end
return

AboutToGenerateSummary:
MaxSummaryLeft=0
SummaryLines=0
call Line1 ''
if arg(1)<> 'N' then
do
TitleText='Summary'
call Line1 TitleColor
call Line1 TitleText
call Line1 copies('~',length(TitleText))||Reset
end
return

AddSummaryLine:
parse arg SummaryLeft,SummaryRight
SummaryLeft=strip(SummaryLeft)
DropSym='!SUMMDROP.!' ||c2x(SummaryLeft)
if symbol(DropSym)='VAR' then
do
call DebugLine 'Summary line for "' || SummaryLeft || '" unwanted (dropped at ' || _valueG(DropSym) || ')'
return
end
if length(SummaryLeft)>MaxSummaryLeft then
MaxSummaryLeft=length(SummaryLeft)
SummaryLines=SummaryLines+1
SummaryL.SummaryLines=SummaryLeft
SummaryR.SummaryLines=SummaryRight
return

GenerateSummaryLines:
do SummLine=1 to SummaryLines
call Line1 "   " || left(SummaryL.SummLine, MaxSummaryLeft) || ': ' ||SummaryR.SummLine
end
return

Summary_42:
numeric digits 14
trace off
CompileTime=NiceDateTime()
LineSourceBeingProcessed='?'
NullChar=d2c(0)
TabChar=d2c(9)
CrLf=d2c(13)||d2c(10)
MarksNewLine=d2c(10)
if RexSystemOpSys="UNIX" then
NewLineChars=MarksNewLine
else
NewLineChars=CrLf
MarksNewLineInHashDefine='<{nl}>'
MarksNewLineInHashDefine2=MarksNewLineInHashDefine||MarksNewLineInHashDefine
Ignore=0
LowerCase="abcdefghijklmnopqrstuvwxyz"
UpperCase="ABCDEFGHIJKLMNOPQRSTUVWXYZ"
DecimalDigits="0123456789"
DebugOnStuffOutputted='N'
WantedWarningRc=1
NotEqualInC='!' || '='
EofChar=d2c(26)
RexxCmtStart='/' || '*'
RexxCmtEnd='*' || '/'
TagSvNewLine='<' || '?NewLine>'
if RexSystemOpSys="OS/2" then
do
call SetColorCodes
call SetBeepCode
end
else
do
call RemoveColorCodes
call SetBeepCode
end
InputInterfaceVer="98.131"
OutputInterfaceVer="98.132"
call SetEnv "PPWIZARD_VER_II",InputInterfaceVer
call SetEnv "PPWIZARD_VER_OI",OutputInterfaceVer
ProtectPrefix='{PROTECT_' || time('Seconds') || '}'
ProtectFromPpwS="option PUSH LeaveBlankLines=YES KeepIndent=YES linecomment='NULL' LineContinuation='NULL' HashPrefix='" || ProtectPrefix || "'"
ProtectFromPpwE=ProtectPrefix|| 'option POP'
call QuickCheckForDebugSwitch
signal on NOVALUE name RexxTrapUninitializedVariable
signal on SYNTAX name RexxTrapSyntaxError
signal on HALT name RexxCtrlC
TrapHandler='FULL'
call ProcessCommandLine
call CheckRexxInterpreter 'Y'
call DebugShowAsMuchEnvironmentDetailAsPossible
PpwUserDescription='PPWIZARD version ' || PgmVersion || ' on ' || PpWizardOpSys ||  ', FREE tool for Windows, OS/2, DOS and UNIX by ' || PgmAuthor || ' (' || PgmHomePage || ')'
PgmDefaultHtmlMetaTags='<meta name="GENERATOR" content="' || PpwUserDescription || '"' || OptionXSlash || '>'
if HaveGeneratorTags='N' then
OptionHtmlGeneratorTags=PgmDefaultHtmlMetaTags
InputMasksAllowed='N'
InpFileCount=0
InpFileCountActuallyMade=0
AllSameExtn=''
do SpecIndex=1 to InputMaskCount
InputList.0=0
TmpMask=InputMask.SpecIndex
call DebugLine 'Looking for files matching "' || TmpMask || '"'
if left(TmpMask,1)<> '+' then
FollowDirs='N'
else
do
FollowDirs='Y'
TmpMask=substr(TmpMask,2)
end
call GetListOfFiles TmpMask, 'InputList',FollowDirs
call DebugIncrement 1
call DebugLine 'Found ' || InputList.0 || ' files(s)'
call DebugIncrement 1
if InputList.0=0 then
do
call CheckForNotBeingAbleToExecAnything
WeWantToDie='Y'
if LookLikeASingleFile(TmpMask)='Y' then
do
if OptionDebugOn='N' then
do
call RemoveBeepCode
call RemoveColorCodes
OptionDebugOn='Y'
OptionWantInfoMsgs='Y'
call DebugStateChanged
call DebugLine 'Debug forced on as we seem to have a file find problem!'
call DebugIncrement 1
call DebugLine 'We could not find "' || TmpMask || '", yet it seems to exist! We will solder on!'
call DebugLine 'Please send redirected output to "' || PgmAuthor || '" (' || PgmAuthorEmail || ')'
call DebugLine 'You could easily use a "GetFileList" ' || RexOptionChar || 'Hook to workaround this.'
call DebugIncrement 1
call GetListOfFiles TmpMask, 'InputList',FollowDirs
call DebugIncrement-2
call DebugLine 'Turning off debug again'
OptionDebugOn='N'
call DebugStateChanged
end
InputList.0=1
InputList.1=TmpMask
WeWantToDie='N'
end
if WeWantToDie='Y' then
do
Left1=left(InputMask.SpecIndex,1)
if Left1<> '-' & Left1 <> '/' then
Extra=''
else
Extra=' (all switches under ' || PpWizardOpSys || ' must start with "' || RexOptionChar || '")'
UserSyntaxError('No input files matched "' || InputMask.SpecIndex || '"' ||Extra)
end
end
do InputIndex=1 to InputList.0
TheFile=InputList.InputIndex
call DebugLine TheFile
InpFileCount=InpFileCount+1
InpFile.InpFileCount=TheFile
InpFileMaskIndex.InpFileCount=SpecIndex
DotPos=lastpos('.',TheFile)
if DotPos<>0 then
do
FileExtn=translate(substr(TheFile,DotPos+1))
if InpFileCount=1 then
AllSameExtn=FileExtn
if AllSameExtn<>FileExtn then
AllSameExtn=''
end
end
call DebugIncrement-2
end
if AllSameExtn<> '' then
do
call DebugLine 'All input files end in the same extension (".' || AllSameExtn || '")'
call DebugIncrement 1
if OptionPrjExtn='' then
call DebugLine 'User has turned off Extensions based project files'
else
do
ExtnFile=ReplaceString(OptionPrjExtn, '*',AllSameExtn)
ExtnFile=FindProjectFile(ExtnFile)
if ExtnFile<> '' then
call ProcessCommandLineBit ExtnFile,RexOptionChar|| 'LIST:' || ReplaceString(ExtnFile, ' ', '{x20}')
end
call DebugIncrement-1
end
if OptionCodeType='' then
do
call DebugLine 'User did not specify what mode we are processing with, will default'
select
when AllSameExtn='X' then
OptionCodeType='REXX'
otherwise
OptionCodeType='HTML'
end
end
call DebugLine 'Processing input files in "' || OptionCodeType || '" mode'
if NewLineChars==CrLf then
LinesEndWith="CR followed by LF"
else
LinesEndWith="LF only"
call DebugLine 'Output lines are terminated with ' ||LinesEndWith
if OptionCodeType='HTML' then
OptionDefaultInputName="DEFAULT.IT"
else
OptionDefaultInputName=""
if OptionDependsOn<> '' & OptionCgiModeOn = 'Y' then
UserSyntaxError("Can't do dependancy checking in CGI mode!")
if OptionCodeType<> 'HTML' & OptionCgiModeOn = 'Y' then
UserSyntaxError("Must stay in HTML mode when /CGI switch used!")
if OptionCodeType='HTML' then
call DebugLine 'HTML Generator Tags are ' ||DebugRightArrow||OptionHtmlGeneratorTags||DebugLeftArrow
else
OptionHtmlGeneratorTags=''
if OptionOutput='' then
do
if OptionCodeType='REXX' then
do
if RexSystemOpSys="OS/2" then
OptionOutput='*.cmd'
else
OptionOutput='*.rex'
end
else
OptionOutput='*.htm'
end
if OptionWantCopyright='Y' then
call DisplayCopyright
call DebugStateChanged
if InputMaskCount=0 then
do
call DebugLine 'No input masks were specified...'
if OptionDefaultInputName='' then
UserSyntaxError('No input files were specified!')
if stream(OptionDefaultInputName, 'c', 'query exists') = '' then
UserSyntaxError('No input files were specified and "' || OptionDefaultInputName || '" not found!')
InputMask.1=OptionDefaultInputName
InpFileCount=1
InpFile.InpFileCount=OptionDefaultInputName
InpFileMaskIndex.InpFileCount=1
end
if IncludeIntoMemory='' then
do
if InpFileCount=1 then
IncludeIntoMemory='N'
else
IncludeIntoMemory='Y'
end
call DebugLine 'Will read files into memory cache: ' ||IncludeIntoMemory
PpwExitRc=0
ActuallyProcessed=0
FailedProcessingWarning=0
do InputIndex=1 to InpFileCount
ThisFile=InpFile.InputIndex
if symbol("_EXCLUDE_._EXF_" || c2x(ThisFile)) = 'VAR' then
do
call DebugLine ThisFile|| ' excluded - ' || _valueG("_EXCLUDE_._EXF_" ||c2x(ThisFile))
iterate
end
ActuallyProcessed=ActuallyProcessed+1
call _valueS "_EXCLUDE_._EXF_" || c2x(ThisFile), "Already processed"
SpecIndex=InpFileMaskIndex.InputIndex
MaskUsedForCurrentInputFile=InputMask.SpecIndex
if left(MaskUsedForCurrentInputFile,1)='+' then
MaskUsedForCurrentInputFile=substr(MaskUsedForCurrentInputFile,2)
if OptionTemplate='' then
GenerateRc=GenerateOutput(ThisFile, '')
else
GenerateRc=GenerateOutput(OptionTemplate,ThisFile)
if GenerateRc>PpwExitRc then
PpwExitRc=GenerateRc
if OptionDebugOn='Y' then
call DebugLine 'The Exit Rc is currently "' || PpwExitRc || '"'
end
if ActuallyProcessed=0 then
UserSyntaxError('All input files were excluded by you!')
call OutputAnySpellingAdditions
if OptionSummary='Y' then
do
if InpFileCount>1 then
do
call AboutToGenerateSummary
call GenerateUserSummaryOverall
call AddSummaryLine 'Operating Syst' ,PpWizardOpSys
call AddSummaryLine 'Rexx Version' ,RexVersionInfo
if InpFileCount=InpFileCountActuallyMade then
call AddSummaryLine '# files' ,InpFileCount
else
call AddSummaryLine '# files made' ,InpFileCountActuallyMade || ' out of ' ||InpFileCount
call AddSummaryLine 'Exit Code' ,PpwExitRc
if FailedProcessingWarning<>0 then
call AddSummaryLine '# Warnings' ,FailedProcessingWarning
call AddSummaryLine 'Elapsed Time'     ,trunc(time('Elapsed'), 2) || ' seconds'
call GenerateSummaryLines
end
end
ThatsAllFolks(PpwExitRc)

SetColorCodes:
EscapeChar=d2c(27)
Reset=EscapeChar|| '[0m'
HighlightColor=EscapeChar|| '[1;35m'
TitleColor=EscapeChar|| '[0;32m'
PpwRexxTraceColor=EscapeChar|| '[0;32m'
ErrorColor=EscapeChar|| '[1;31m'
WarningColor=EscapeChar|| '[0;33m'
InfoColor=EscapeChar|| '[0;1m'
return

RemoveColorCodes:
Reset=''
HighlightColor=''
TitleColor=''
ErrorColor=''
WarningColor=''
InfoColor=''
PpwRexxTraceColor=''
return

SetBeepCode:
Beep=''
return

RemoveBeepCode:
Beep=''
return

GetSourceFileDateTimeDieOnError:
DateTimeRc=GetFileDateTimeButDontWarnOnError(arg(1))
if DateTimeRc=-1 then
CryAndDie('Could not get date/time stamp of "' || arg(1) || '".')
return(DateTimeRc)

GenerateOutput:
InputFile=arg(1)
TemplateDataFile=arg(2)
if OptionTemplate='' then
do
call DebugLine 'Main file is not a template, no point loading into memory'
InFile=InputFile
ForceBaseFile2Mem='N'
end
else
do
call DebugLine 'Main file is a template'
InFile=TemplateDataFile
ForceBaseFile2Mem=''
end
CurrentOutFile=GenerateFileName(InFile,OptionOutput, 'Y')
call ClearDependancyTimeStampCache
if NeedToRemake(InFile)='N' then
return(0)
InpFileCountActuallyMade=InpFileCountActuallyMade+1
TitleText='Making - ' || _filespec('name',CurrentOutFile)
call Line1 TitleColor||TitleText
call Line1 copies('~',length(TitleText))||Reset
if OptionTemplate='' then
TmpTemplate=''
else
TmpTemplate=TemplateDataFile
call RexxHookSetBuildingParms InFile,CurrentOutFile,TmpTemplate
if RexxHookBefore<> '' then
call CallHook "BEFORE"
call SetUpOptionsForThisBuild
Dummy=time('Reset')
call DebugIncrementInit
call CompletelyInitializeAutoTagState
call InitTransformationCode
call InitOutputHold
call InitializeCharCodes
call InitializeDefineRexx
call InitializeOneLine
call InitCondNlCount
DebugIncludeNumber=0
Warnings=0
LineSourceBeingProcessed='?'
GeneratedLines=0
InputLines=0
PartialLine=''
IncludeLevel=0
EofForced=''
LineQueued=''
PPwizardUnique=0
StackCnt=0
OptionStackCnt=0
HtmlGeneratorTags=OptionHtmlGeneratorTags
AsIsModeOn='N'
if OptionCompleteAddToToDepFile='Y' then
call AddInputFileToDependancyList PpWizardPgmName
call PrepareSpellingForThisBuild
NewestSourcefile=GetSourceFileDateTimeDieOnError(PpWizardPgmName)
call InitializeHashDefinesForThisCompile
OutputLevel=0
call HaveNewOutputFile CurrentOutFile,,'N',OptionCodeType
IfNesting=0
IfState.WantLines.0='Y'
IfState.IfTrue.0='Y'
IfState.InTrue.0='Y'
WantLineCache='Y'
call OutputHeaderIfWantedOrRequired
GenerateRc=0
call CheckRexxInterpreter
IncludeList=OptionHashInclude
do while IncludeList<> ''
parse var IncludeList ThisInclude (PathDelimiterChar) IncludeList
call DebugLine '/#Include "' ||ThisInclude
GenerateRc=GenerateRc+ProcessInputFile(ThisInclude)
end
InputFileFull=SafeQueryExists(InputFile)
GenerateRc=GenerateRc+ProcessInputFile(InputFile,,,ForceBaseFile2Mem)
if GenerateRc=0 then
do
if OptionDebugOn='Y' then
call DebugLine 'Generation successful so far, look for nesting and other errors'
select
when IfNesting<>0 then
do
do Index=1 to IfNesting
NestingLevel=(IfNesting-Index)+1
call DebugLine 'Missing #endif at EOF - Nesting Level #' ||NestingLevel||MatchesIfDebugText(NestingLevel)
end
CryAndDie('Missing #endif at EOF' ||MatchesIfDebugText(IfNesting))
end
when StackCnt<>0 then
do
do Index=1 to StackCnt
NestingLevel=(StackCnt-Index)+1
call DebugLine 'Missing #RexxVar pop at EOF - Nesting Level #' ||NestingLevel||MatchesStackPushDebugText(NestingLevel)
end
CryAndDie('Incorrect #RexxVar push/pop nesting at EOF' ||MatchesStackPushDebugText(StackCnt))
end
when OptionStackCnt<>0 then
do
do Index=1 to OptionStackCnt
NestingLevel=(OptionStackCnt-Index)+1
call DebugLine 'Missing pop() at EOF - Nesting Level #' ||NestingLevel||MatchesOptionStackPushDebugText(NestingLevel)
end
CryAndDie('Missing #Option pop at EOF' ||MatchesOptionStackPushDebugText(OptionStackCnt))
end
when AutoTagStateCnt<>0 then
do
do Index=1 to AutoTagStateCnt
NestingLevel=(AutoTagStateCnt-Index)+1
call DebugLine 'Missing #AutoTagState- at EOF - Nesting Level #' ||NestingLevel||MatchesAutoTagStateIncDebugText(NestingLevel)
end
CryAndDie('Missing #AutoTagState- at EOF' ||MatchesAutoTagStateIncDebugText(AutoTagStateCnt))
end
when DefRexxVar<> '' then
CryAndDie('Missing #DefineRexx[+] at EOF', 'Block started at ' ||DefRexxStartLoc)
when TransformCode<> '' then
CryAndDie('Missing #transform (end) at EOF', 'Block started at ' ||TransformStartLoc)
when OneLineOn='Y' then
CryAndDie('#OneLine block did not end, started at ' || OneLineStartLoc, 'Could not find "' || OneLineStopper || '" (case sensitive!)')
when OutputLevel>1 then
CryAndDie('Missing ' || OutputLevel - 1 || ' #output command(s) at EOF')
when OutputHoldLvl<>0 then
CryAndDie('Missing #OutputHold (end) at EOF', 'LAST Block started at ' ||OutHold_.OutputHoldLvl.!OutpHoldStartLoc)
otherwise
call DieIfHoldingOutput
end
if GeneratedLines=0 then
call OutputWarningToScreen 'GEN0', 'No output lines generated'
if OptionDebugOn='Y' then
call DebugLine 'No fatal errors detected so far'
end
call Stream CurrentOutFile, 'c', 'Close'
if RexxHookAfter<> '' then
call CallHook "AFTER"
if GenerateRc=0 then
do
if OptionDebugOn='Y' then
call DebugLine 'Looks OK so far, look for even more errors'
if PartialLine<> '' then
CryAndDie('A line continued to EOF')
if OptionCodeType='REXX' then
call CheckRexxModuleForSyntaxErrors
if OptionValidation<> '' then
do
ToExec=ReplaceHashAndStandardDefines(OptionValidation)
call RunExecOrValidateCmd 'VALIDATE',OptionValidationRc,ToExec
end
if Warnings<>0 then
do
FailedProcessingWarning=FailedProcessingWarning+1
GenerateRc=WantedWarningRc
end
if OptionNoDepFileOnWarnings='Y' &Warnings<>0 then
call DebugLine 'Dependancy file not created as warnings exist'
else
call CreateDependancyFileFromLists
if OptionSummary='Y' then
do
if InpFileCount=1 then
call AboutToGenerateSummary
else
call AboutToGenerateSummary 'N'
call GenerateUserSummaryThisBuild
call GenerateUserSummaryAllBuilds
if InpFileCount=1 then
call GenerateUserSummaryOverall
if Warnings<>0 then
call AddSummaryLine 'Warnings'        ,'YES (' || AddCommasToDecimalNumber(Warnings) || ')'
if InpFileCount=1 then
do
call AddSummaryLine 'Operating Syst' ,PpWizardOpSys
call AddSummaryLine 'Rexx Version' ,RexVersionInfo
end
call AddSummaryLine 'Return Code' ,GenerateRc
call AddSummaryLine 'Elapsed Time'        ,trunc(time('Elapsed'), 2) || ' seconds'
call GenerateSummaryLines
end
end
call Line1 ''
call RexxHookSetBuildingParms
return(GenerateRc)

MyLineNumber:
return(SIGL)

OutputHeaderIfWantedOrRequired:
CommentStart=''
if OptionCodeType='REXX' then
do
CommentStart=RexxCmtStart
CommentEnd=RexxCmtEnd
end
else
do
end
if CommentStart<> '' then
do
call GenerateOneLine CommentStart
call GenerateOneLine ' * Generator   : PPWIZARD version ' ||PgmVersion
call GenerateOneLine ' *             : FREE tool for Windows, OS/2, DOS and UNIX by ' || PgmAuthor  || ' (' || PgmAuthorEmail || ')'
call GenerateOneLine ' *             : ' ||PgmHomePage
call GenerateOneLine " * Time        : " ||space(CompileTime)
call GenerateOneLine " * Input File  : " ||InputFile
do Index=1 to OutputLevel
call GenerateOneLine " * Output File : " ||Output.OutputLevel.File
end
call GenerateOneLine ' ' ||CommentEnd
call GenerateOneLine ''
if OptionCodeType='REXX' then
do
call GenerateOneLine 'if arg(1)="' || SyntaxOkText || '" then exit(' || SyntaxOkRc || ')'
call GenerateOneLine ''
end
end
return

ProcessInputFile:
RequestedFile=arg(1)
IncludeFragmentText=arg(2)
AddToDepFile=arg(3)
ForceLoadingIntoMemory=arg(4)
IncludeLineNumber=0
IncludeMemBufferNextLine=''
DebugIncludeNumber=DebugIncludeNumber+1
DebugCurrentFileNumber=DebugIncludeNumber
IncludeFileName=FindFile(RequestedFile)
if IncludeFileName='' then
do
call RecursiveIncludeRestore
CryAndDie('File "' || RequestedFile || '" does not exist!')
end
IncludeLevel=IncludeLevel+1
IncludeFileName.IncludeLevel=IncludeFileName
if IncludeLevel>=InfiniteIncludeLoopWhen then
do
if InfiniteIncludeLoopWhen<>0 then
do
say 'Infinite #include loop detected, at level #' ||IncludeLevel
say 'Use "/define:INFINITE_INCLUDE_LOOP_WHEN=0"   to turn off detection'
say 'Use "/define:INFINITE_INCLUDE_LOOP_WHEN=100" to increase detection threshold etc'
IncludeLevel=IncludeLevel-1
call RecursiveIncludeRestore
CryAndDie("We seem to be in an infinite #include loop!")
end
end
MemUpdateIndex=0
do IncIndex=1 to IncludeLevel-1
if RexSystemOpSys="UNIX" then
IncSame=(IncludeFileName=IncludeFileName.IncIndex)
else
IncSame=(translate(IncludeFileName)=translate(IncludeFileName.IncIndex))
if IncSame=1 then
do
if _IncludeMemHandle.IncIndex<> '' then
call DebugLine 'File already being processed, already reading from memory cache!'
else
do
call DebugLine 'File already being processed, forcing use from memory cache'
CloseRc=stream(IncludeFileName, 'c', 'close')
MemUpdateIndex=IncIndex
ForceLoadingIntoMemory='Y'
end
leave
end
end
if AddToDepFile<> 'N' then
call AddInputFileToDependancyList(IncludeFileName)
call OutputProcessingFileStringToScreen '',IncludeFragmentText
ThisDateTime=GetSourceFileDateTimeDieOnError(IncludeFileName)
if ThisDateTime>NewestSourcefile then
NewestSourcefile=ThisDateTime
parse value IncludeFileOpen(IncludeFileName,ForceLoadingIntoMemory)with IncludeEofLine ';' IncludeMemHandle
if MemUpdateIndex<>0 then
do
_IncludeMemHandle.MemUpdateIndex=IncludeMemHandle
_IncludeEofLine.MemUpdateIndex=IncludeEofLine
end
if IncludeFragmentText<> '' then
do
call DebugLine 'Looking for the start of the fragment'
do while IncludeFileLines()<>0
InputLines=InputLines+1
FileLine=IncludeFileLineIn()
if pos(IncludeFragmentText,FileLine)<>0 then
leave
end
if IncludeFileLines()=0 then
do
FT=IncludeFragmentText
LP=IncludeLineNumber
IncludeLevel=IncludeLevel-1
call RecursiveIncludeRestore
CryAndDie('Did not find the START of the code fragment "' || FT || '" (processed ' || AddCommasToDecimalNumber(LP) || ' lines)')
end
end
do forever
LastLineAfterMacroRep=''
select
when IncludeMemBufferNextLine\=='' then
do
if InLoop='Y' &LoopLinesFromFile=0 then
FileLine=GetLoopLineIntoFileLine()
else
do
parse var IncludeMemBufferNextLine FileLine (MarksNewLine) IncludeMemBufferNextLine
end
LastLine=FileLine
LineSrc='M'
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine, '#'
end
when LineQueued\=='' then
do
call FlushQueuedOutput
iterate
end
when InLoop='Y' |IncludeFileLines()<>0 then
do
if EofForced<> '' then
do
if OptionDebugOn='Y' then
call DebugLine '#EOF (at ' || EofForced || ') told us to stop processing this file any further'
if SetUpOnExitProcessingIfEndOfMainFile()='Y' then
iterate
leave
end
if InLoop='Y' then
FileLine=GetLoopLineIntoFileLine()
else
do
InputLines=InputLines+1
FileLine=IncludeFileLineIn()
end
LastFileLine=FileLine
LastLine=FileLine
LineSrc='F'
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine
if IncludeFragmentText<> '' then
do
if pos(IncludeFragmentText,FileLine)<>0 then
do
call DebugLine 'Found the end of the fragment'
IncludeFragmentText=''
leave
end
end
if OptionFilterIn<> '' then
do
FileLine=HtmlFilterIn("I",FileLine,IncludeFileName,IncludeLineNumber,InputLines,MarksNewLine)
if pos(MarksNewLine,FileLine)<>0 then
do
IncludeMemBufferNextLine=FileLine
iterate
end
if left(FileLine,1)=NullChar then
do
if FileLine=NullChar then
iterate
else
CryAndDie(substr(FileLine,2))
end
end
end
otherwise
do
if SetUpOnExitProcessingIfEndOfMainFile()='Y' then
iterate
leave
end
end
if LineSrc<> 'F' then
do
LineContinued='N'
Word1=word(FileLine,1)
end
else
do
if InterceptCode<> '' then
do
if FileLine=InterceptOffMarker then
do
if OptionDebugOn='Y' then
call DebugLine 'Intercepted line looks like end of block, not processed'
end
else
do
BeforeLine=FileLine
call ExecRexxCmd InterceptCode
if OptionDebugOn='Y' then
do
if BeforeLine==FileLine then
call DebugLine 'Intercepted line was not changed'
else
call DebugLine 'Intercepted Line changed to ' ||DebugRightArrow||FileLine||DebugLeftArrow
end
if BeforeLine\==FileLine then
do
if pos(MarksNewLine,FileLine)<>0 then
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=FileLine
else
IncludeMemBufferNextLine=FileLine||MarksNewLine||IncludeMemBufferNextLine
iterate
end
end
end
end
if NextIdStr<> '' then
FileLine=ReplaceString(FileLine,NextIdMarker,NextIdStr)
if AsIsModeOn='Y' then
FileLine=ExpandAsIsTags(FileLine)
if AutoTagOn='Y' then
FileLine=AutoTag(FileLine)
if pos(TabChar,FileLine)<>0 then
do
if OptionDebugOn='Y' then
call DebugLine 'Tab(s) found'
select
when OptionTabs='W' then
do
call OutputWarningToScreen 'T000', 'There are TABS in the source (converted to spaces)!'
FileLine=translate(FileLine, ' ',TabChar)
end
when OptionTabs='T' then
do
FileLine=translate(FileLine, ' ',TabChar)
end
when OptionTabs='E' then
do
FileLine=ExpandTabs(FileLine,WidthOfTab)
end
otherwise
do
end
end
end
if OptionHideCmdS_L<>0 then
do
PosS=pos(OptionHideCmdS,FileLine)
if PosS<>0 then
do
if OptionDebugOn='Y' then
do
call DebugLine 'At least one hidden command'
call DebugIncrement 1
end
RightBit=FileLine
LeftBit=''
do while PosS<>0
PosE=pos(OptionHideCmdE,RightBit,PosS)
if PosE=0 then
CryAndDie('Found start of hidden command ("' || OptionHideCmd || '"), but not the end!')
Hidden=strip(substr(RightBit,PosS+OptionHideCmdS_L,(PosE-PosS)-OptionHideCmdS_L))
if OptionDebugOn='Y' then
call DebugLine 'Found: ' ||DebugRightArrow||Hidden||DebugLeftArrow
LeftBit=LeftBit||left(RightBit,PosS-1)||Hidden
RightBit=substr(RightBit,PosE+OptionHideCmdE_L)
PosS=pos(OptionHideCmdS,RightBit)
end
FileLine=LeftBit||RightBit
if OptionDebugOn='Y' then
do
call DebugLine 'NewLine: ' ||DebugRightArrow||FileLine||DebugLeftArrow
call DebugIncrement-1
end
end
end
FileLine=strip(FileLine, 'T')
CmtPos=lastpos(InLineComment,FileLine)
if CmtPos<>0 then
do
AddToEnd=''
if right(FileLine,1)=LineContChar then
do
Right2=right(FileLine,2)
if Right2=LineContAddNewLine|Right2=LineContAddNewLineObs|Right2=LineContWithoutSpace|Right2=LineContWithSpace|Right2=LineContDefault then
do
AddToEnd=' ' ||Right2
end
end
FileLine=strip(left(FileLine,CmtPos-1), 'T')||AddToEnd
end
if OptionCodeType='REXX' then
do
if OptionDebugOn='N' then
do
if OptionKeepRexxCmts='N' &right(FileLine,2)=RexxCmtEnd then
do
StartCmtPos=lastpos(RexxCmtStart,FileLine)
if StartCmtPos<>0 then
do
if StartCmtPos=0 then
FileLine=''
else
FileLine=strip(left(FileLine,StartCmtPos-1), 'T')
if FileLine='' then
iterate
end
end
end
end
if LineContChar=NullChar then
LineContinued='N'
else
do
if right(FileLine,1)<>LineContChar then
LineContinued='N'
else
do
Right2=right(FileLine,2)
MainBit=strip(left(FileLine,length(FileLine)-2), 'T')
select
when Right2=LineContWithoutSpace then
do
LineContinued='Y'
FileLine=MainBit
end
when Right2=LineContWithSpace|Right2=LineContDefault then
do
FileLine=MainBit
LineContinued='YS'
end
when Right2=LineContAddNewLine then
do
LineContinued='Y'
FileLine=MainBit||CodexNewLine
end
when Right2=LineContAddNewLineObs then
do
call WarnAboutDepreciatedFeature 'Line continuation using downarrow.  Replace with -> "%\"'
LineContinued='Y'
FileLine=MainBit||CodexNewLine
end
otherwise
LineContinued='N'
end
end
end
if FileLine='' then
do
if LeaveBlankLines='N' then
do
if OptionDebugOn='Y' then
call DebugShowLineDropped "Blank Line"
if LineContinued='N' & PartialLine \== '' then
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=PartialLine
else
IncludeMemBufferNextLine=PartialLine||MarksNewLine||IncludeMemBufferNextLine
PartialLine=''
end
iterate
end
end
Word1=word(FileLine,1)
if left(Word1,1)=LineComment then
do
if LineContinued='N' & PartialLine \== '' then
do
if OptionDebugOn='Y' then
call DebugWarning 'Line continuation ends with a comment line'
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=PartialLine
else
IncludeMemBufferNextLine=PartialLine||MarksNewLine||IncludeMemBufferNextLine
PartialLine=''
end
iterate
end
if LineSrc='F' then
do
if KeepIndent='N' then
FileLine=strip(FileLine, 'L')
else
FileLine=LeftIndent||FileLine
end
if PartialLine<> '' then
do
if left(Word1,HashPrefixLng)<>HashPrefix then
do
PartialLine=PartialLine||FileLine
end
else
do
parse var FileLine TheHashCmd TheRest
TheRest=strip(TheRest)
FileLine=TheHashCmd|| ' ' ||TheRest
PartialLine=PartialLine||PpwCmdDivider1||FileLine||PpwCmdDivider1
if LineContinued='YS' then
LineContinued='Y'
end
end
if LineContinued='N' then
do
if PartialLine\=='' then
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=PartialLine
else
IncludeMemBufferNextLine=PartialLine||MarksNewLine||IncludeMemBufferNextLine
PartialLine=''
iterate
end
end
else
do
if PartialLine=='' then
do
PartialLine=FileLine
if translate(left(Word1,length(CmdHashDefine)))=CmdHashDefine then
PpwCmdDivider1=MarksNewLineInHashDefine
else
PpwCmdDivider1=MarksNewLine
end
if LineContinued='YS' then
PartialLine=PartialLine|| ' '
iterate
end
end
if OneLineOn='Y' then
do
FileLine=AddToOneLine(FileLine)
if FileLine=='' then
iterate
else
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=FileLine
else
IncludeMemBufferNextLine=FileLine||MarksNewLine||IncludeMemBufferNextLine
iterate
end
end
if left(Word1,HashPrefixLng)=HashPrefix then
do
parse var FileLine HashCmd SecondWordEtc
HashCmd=translate(HashCmd)
HashRc='?'
select
when HashCmd=CmdHashIf then
do
HashRc=ProcessHashIfTest(FileLine)
end
when HashCmd=CmdHashIfDef then
do
HashRc=ProcessHashIfTest(FileLine)
end
when HashCmd=CmdHashIfnDef then
do
HashRc=ProcessHashIfTest(FileLine)
end
when HashCmd=CmdHashElseifL|HashCmd=CmdHashElseifS then
HashRc=ProcessHashElse(SecondWordEtc)
when HashCmd=CmdHashEndifL|HashCmd=CmdHashEndifS then
HashRc=ProcessHashEndif(SecondWordEtc)
otherwise
end
if HashRc<> '?' then
do
if HashRc<> 'OK' then
call CryAndDie 'Hash command failed, Rc = ' ||HashRc
else
do
WantLineCache=WantLine()
iterate
end
end
end
if WantLineCache='N' then
do
if OptionDebugOn='Y' then
call DebugShowLineDropped "False"
iterate
end
if left(Word1,HashPrefixLng)=HashPrefix then
do
call ProcessHashCommand FileLine
end
else
do
if DefRexxVar<> '' then
do
call AddDefineRexxLine FileLine
iterate
end
if ReplacementsAllowed='Y' then
do
NowCount=ReplaceCount
FileLine=ReplaceHashAndStandardDefines(FileLine,, 'Y')
if HtmlGeneratorTags<> '' then
do
FileLineU=translate(FileLine)
InsertTags=''
LookFor="<HEAD>"
TagPos=pos(LookFor,FileLineU)
if TagPos<>0 then
do
InsertTags=TagSvNewLine||HtmlGeneratorTags||TagSvNewLine
InsertAt=TagPos+length(LookFor)
end
else
do
LookFor="<BODY"
TagPos=pos(LookFor,FileLineU)
if TagPos<>0 then
do
InsertTags='<head>' || TagSvNewLine || '  ' || HtmlGeneratorTags || TagSvNewLine || '</head>' ||TagSvNewLine
InsertAt=TagPos
end
end
if InsertTags\=='' then
do
call DebugLine 'Found "' || LookFor || '" so inserted HTML generator tags'
FileLine=insert(InsertTags,FileLine,InsertAt-1)
FileLine=ReplaceHashAndStandardDefines(FileLine,, 'Y')
HtmlGeneratorTags=''
end
end
if ExpandXEarly='Y' then
do
if pos(StartsStdSymbolReplacement_x,FileLine)<>0 then
FileLine=ReplaceTheXCodesWeKnowExist(FileLine)
end
if NowCount<>ReplaceCount then
do
if pos(MarksNewLine,FileLine)<>0 then
do
if IncludeMemBufferNextLine=='' then
IncludeMemBufferNextLine=FileLine
else
IncludeMemBufferNextLine=FileLine||MarksNewLine||IncludeMemBufferNextLine
iterate
end
end
if ExpandXLate='Y' then
do
if pos(StartsStdSymbolReplacement_x,FileLine)<>0 then
FileLine=ReplaceTheXCodesWeKnowExist(FileLine)
end
end
if TransformCode<> '' then
do
BeforeLine=FileLine
FileRest=FileLine
FileAfter=''
AppendWith=''
do until FileRest==''
parse var FileRest FileLine (MarksNewLine) FileRest
call ExecRexxCmd TransformCode
FileAfter=FileAfter||AppendWith||FileLine
AppendWith=MarksNewLine
end
FileLine=FileAfter
if OptionDebugOn='Y' then
do
if BeforeLine==FileLine then
call DebugLine 'Line was not transformed'
else
call DebugLine 'Line transformed to ' ||DebugRightArrow||FileLine||DebugLeftArrow
end
end
if LineSrc='M' then
do
LineQueued=LineQueued||FileLine
iterate
end
do until FileLine == ''; parse var FileLine This1 (MarksNewLine) FileLine; if  OptionCodeType  = 'REXX' then call OutputRexxLine This1; else do; if  OptionCodeType <> 'HTML' then call GenerateOneLine This1; else do; call GenerateOneLine This1; end; end; end
end
end
EofForced=''
call IncludeFileClose
if IncludeFragmentText<> '' then
CryAndDie('Did not find the END of the code fragment "' || IncludeFragmentText || '"!')
IncludeLevel=IncludeLevel-1
if OptionDebugOn='Y' then
call DebugLine 'Finished processing the input file'
return(0)

OutputProcessingFileStringToScreen:
parse arg ProcessingWhat,ProcessingFrag
if ProcessingWhat='' then
ProcessingWhat=IncludeFileName
if ProcessingFrag<> '' then
ProcessingFrag='(' || ProcessingFrag || ')'
call Line1 copies("  ", IncludeLevel) || ' * Processing: ' ||ProcessingWhat||ProcessingFrag
return

FlushQueuedOutput:
if LineQueued=='' then
return
LineSrc='Q'
FileLine=LineQueued
LineQueued=''
if OptionDebugOn='Y' then
call DebugShowCurrentLineWithLineNumber FileLine, '+'
do until FileLine == ''; parse var FileLine This1 (MarksNewLine) FileLine; if  OptionCodeType  = 'REXX' then call OutputRexxLine This1; else do; if  OptionCodeType <> 'HTML' then call GenerateOneLine This1; else do; call GenerateOneLine This1; end; end; end
return

OutputInformationToScreen:
if OptionWantInfoMsgs='Y' then
do
InfoText=arg(1)
if IncludeLevel=0 then
LineText=''
else
LineText='(@' || AddCommasToDecimalNumber(IncludeLineNumber) || ')'
call Line1 copies("  ", IncludeLevel) || InfoColor || '   ' || LineText || 'INFO: ' ||InfoText||Reset
end
return

ProcessHashCommand:
HashCmdMc=word(arg(1),1)
HashCmd=translate(HashCmdMc)
HashCmdParms=subword(arg(1),2)
select
when HashCmd=CmdHashDefine then
return(ProcessDefine(HashCmdParms))
when HashCmd=CmdHashDefinePlus then
return(ProcessDefine(HashCmdParms, 'Y'))
when HashCmd=CmdHashRexxVar then
return(ProcessRexxVar(HashCmdParms))
when HashCmd=CmdHashEvaluateL|HashCmd=CmdHashEvaluateS then
return(ProcessEvaluate(HashCmdParms))
when HashCmd=CmdHashEvaluatePlusL|HashCmd=CmdHashEvaluatePlusS then
return(ProcessEvaluate(HashCmdParms, 'Y'))
when HashCmd=CmdHashAutoTag then
do
ProcessRc=ProcessAutoTag(HashCmdParms)
return(ProcessRc)
end
when HashCmd=CmdHashUndefL|HashCmd=CmdHashUndefS then
return(HandleUndefCommand(HashCmdParms))
when HashCmd=CmdHashOption then
return(ProcessOption(HashCmdParms))
when HashCmd=CmdHashLoopS then
return(ProcessLoopStart(HashCmdParms))
when HashCmd=CmdHashLoopBreak then
return(ProcessLoopBreak(HashCmdParms))
when HashCmd=CmdHashLoopContinue then
return(ProcessLoopContinue(HashCmdParms))
when HashCmd=CmdHashInclude then
do
IncludeParms=strip(PerformReplacementsInCmdsParameters(HashCmdParms))
if IncludeParms="" then
return(CryAndDie("No filename specified on #include line!"))
QuoteChar=left(IncludeParms,1)
if QuoteChar<> '"' & QuoteChar <> "'" & QuoteChar <> "<" then
do
parse var IncludeParms IncludeName Fragment
end
else
do
if QuoteChar="<" then
QuoteChar='>'
IncludeParms=substr(IncludeParms,2)
QuotePos=pos(QuoteChar,IncludeParms)
if QuotePos=0 then
CryAndDie('Could not find the ending quote for the included filename')
IncludeName=left(IncludeParms,QuotePos-1)
Fragment=substr(IncludeParms,QuotePos+1)
end
if Fragment<> '' then
Fragment=GetQuotedText(Fragment)
call RecursiveIncludeSave
call ProcessInputFile IncludeName,Fragment
call RecursiveIncludeRestore
call OutputProcessingFileStringToScreen '',IncludeFragmentText
return(0)
end
when HashCmd=CmdHashImport then
return(ProcessImport(HashCmdParms))
when HashCmd=CmdHashOutput then
return(ProcessHashOutput(HashCmdParms))
when HashCmd=CmdHashOutputHold then
return(ProcessHashOutputHold(HashCmdParms))
when HashCmd=CmdHashOneLine then
return(ProcessOneLine(HashCmdParms))
when HashCmd=CmdHashDefineRexx then
return(ProcessDefineRexx(HashCmdParms))
when HashCmd=CmdHashDefineRexxPlus then
return(ProcessDefineRexx(HashCmdParms, 'Y'))
when HashCmd=CmdHashDefineIfReq then
return(ProcessDefine(HashCmdParms, '?'))
when HashCmd=CmdHashMacroSpace then
do
call NotAvailableUnderNtYet HashCmd
Rest=PerformReplacementsInCmdsParameters(HashCmdParms)
MsCommand=translate(GetQuotedText(Rest, "Rest"))
MsFile=GetQuotedText(Rest, "Rest")
if Rest='' then
MsFunction=''
else
MsFunction=GetQuotedText(Rest)
if MsCommand<> 'ADD' & MsCommand <> 'DROP' then
CryAndDie('The macro space command "' || MsCommand || '" is unknown!')
if SafeQueryExists(MsFile)='' then
CryAndDie('The rexx file "' || MsFile || '" does not exist!')
call DoMacroSpaceOperation MsCommand,MsFile,MsFunction
return(0)
end
when HashCmd=CmdHashAsIs then
return(ProcessAsIs(HashCmdParms))
when HashCmd=CmdHashWarningL|HashCmd=CmdHashWarningS then
return(ProcessHashWarning(HashCmdParms))
when HashCmd=CmdHashInfo then
do
InfoMsg=PerformReplacementsInCmdsParameters(HashCmdParms)
InfoMsg=GetQuotedRest(InfoMsg)
call OutputInformationToScreen InfoMsg
return(0)
end
when HashCmd=CmdHashAutoTagState then
return(ProcessAutoTagState(HashCmdParms))
when HashCmd=CmdHashAutoTagClear then
return(ProcessAutoTagClear(HashCmdParms))
when HashCmd=CmdHashDependsOn then
return(ProcessDependsOn(HashCmdParms))
when HashCmd=CmdHashOnExit then
return(ProcessOnExit(HashCmdParms))
when HashCmd=CmdHashEof then
do
if HashCmdParms<> '' then
do
EndifCounter=GetQuotedText(HashCmdParms)
EndifCounter=PerformReplacementsInCmdsParameters(EndifCounter)
if datatype(EndifCounter, 'W')=0 then
CryAndDie('Invalid #endif simulate count of "' || EndifCounter || '" supplied!')
do EndifIndex=1 to EndifCounter
call ProcessHashEndif
end
end
EofForced=CurrentSourceLocation()
return(0)
end
when HashCmd=CmdHashTransform then
return(ProcessTransform(HashCmdParms))
when HashCmd=CmdHashIntercept then
return(ProcessIntercept(HashCmdParms,HashCmdMc))
when HashCmd=CmdHashSystem then
return(ProcessSystem(HashCmdParms))
when HashCmd=CmdHashDebug then
return(ProcessHashDebug(HashCmdParms))
when HashCmd=CmdHashRequire then
return(ProcessRequire(HashCmdParms))
when HashCmd=CmdHashNextId then
return(ProcessNextId(HashCmdParms))
when HashCmd=CmdHashErrorL|HashCmd=CmdHashErrorS then
call ProcessHashError HashCmdParms
otherwise
do
if UserHashCmds='' then
call LookForUnknownCmdHandler
if UserHashCmds<> '' then
return(ProcessUnknownHashCommand(HashCmd,HashCmdParms))
if HashCmd=CmdHashLoopE then
CryAndDie('Missing "' || CmdHashLoopS || '" command')
else
CryAndDie("Invalid '#' command line of: " ||HashCmd)
end
end
return(0)

ProcessHashError:
ErrorMsg=GetQuotedRest(PerformReplacementsInCmdsParameters(arg(1)))
CryAndDie(ErrorMsg)

IsStringOnOrOffCmd:
OoCmd=translate(arg(1))
if OoCmd='+' | OoCmd = 'YES' |  OoCmd = 'ON' then
return('Y')
else
do
if OoCmd='-' | OoCmd = 'NO' |  OoCmd = 'OFF' then
return('N')
end
return('')

SetOnorOffVariable:
parse arg OnOffSrc,VarName
OnOrOffText=translate(GetQuotedText(OnOffSrc))
OnOrOff=IsStringOnOrOffCmd(OnOrOffText)
if OnOrOff='' then
CryAndDie(HashCmd|| ' command does not specify a correct value value (ON/OFF)!')
call _valueS VarName,OnOrOff
return(0)

DisplayCopyright:
if CopyrightDisplayed='N' then
do
call Char1 HighlightColor
call Line1 '[]---------------------------------------------------------[]'
call Line1 '| PPWIZARD.CMD: Version ' || PgmVersion || ' (' || PgmAuthorEmail || ')   |'
call Line1 '| ' || PgmAuthorHomePage || '            |'
call Line1 '| (C)opyright ' || PgmAuthor || ' 1997-2000. ALL RIGHTS RESERVED. |'
call Line1 '[]---------------------------------------------------------[]'
call Line1 Reset
CopyrightDisplayed='Y'
end
return

CheckRexxInterpreter:
if RexWhich='REGINA' then
do
if pos(RexVerRegina,SupportedReginaVersions)<>0 then
return(0)
criText="The Regina " || RexVerRegina || " interpreter is unsupported, use " || SupportedReginaVersions || ' instead! I recommend "' || RecommendedReginaVersions || '"'
if arg(1)='Y' then
call DebugLine criText
else
call OutputWarningToScreen 'URI0',criText
return(1)
end
return(0)

GetCurrentDirectory:
if RexWhich='STANDARD_OS/2' then
cwDir=directory()
else
do
cwDir=stream('.', 'c', 'query exists')
cwDirRegina=cwDir
cwLength=length(cwDir)
if lastpos(RexDirChar,cwDir)=cwLength then
do
if RexSystemOpSys="UNIX" then
do
if cwDir<>RexDirChar then
cwDir=left(cwDir,cwLength-1)
end
else
do
cwColonPos=pos(':',cwDir)
if cwColonPos+1<>cwLength then
cwDir=left(cwDir,cwLength-1)
end
end
if cwDirRegina<>cwDir then
call DebugLine 'Regina returned "' || cwDirRegina || '" for current directory'
end
if OptionDebugOn='Y' then
call DebugLine 'Current Directory = "' || cwDir || '"'
return(cwDir)

MakeAbsolute:
maFileOrig=arg(1)
if left(maFileOrig,1)<> '+' then
maFileOrigP=''
else
do
maFileOrig=substr(maFileOrig,2)
maFileOrigP='+'
end
maFile=maFileOrig
if left(maFile,1)='.' |pos(RexDirChar,maFile)=0 then
do
DotSlash='.' ||RexDirChar
DotDotSlash='.' ||DotSlash
maDir=GetCurrentDirectory()
if OptionDebugOn='Y' then
do
call DebugLine 'Converting relative "' || maFile || '"'
call DebugIncrement 1
end
if pos(RexDirChar,maFile)<>0 then
do
do forever
select
when left(maFile,2)==DotSlash then
do
maFile=substr(maFile,3)
end
when left(maFile,3)==DotDotSlash then
do
LastChar=right(maDir,1)
SlashPos=lastpos(RexDirChar,maDir)
if SlashPos=0|LastChar=RexDirChar|LastChar=':' then
CryAndDie('The spec "' || maFileOrig || '" can not be converted to absolute', 'from the current directory "' || GetCurrentDirectory() || '"')
maDir=left(maDir,SlashPos-1)
maFile=substr(maFile,4)
end
otherwise
leave
end
end
end
if right(maDir,1)=RexDirChar then
maFile=maDir||maFile
else
maFile=maDir||RexDirChar||maFile
if OptionDebugOn='Y' then
do
call DebugLine 'To Absolute "' || maFile || '"'
call DebugIncrement-1
end
end
return(maFileOrigP||maFile)

SafeQueryExists:
zi_File=arg(1)
if zi_File='' then
CryAndDie('The filename "" is invalid!')
else
return(RexQueryExists(zi_File))

MustDeleteFile:
zj_File=arg(1)
CloseRc=stream(zj_File, 'c', 'close')
if SafeQueryExists(zj_File)<> '' then
do
CloseRc=stream(zj_File, 'c', 'close')
DeleteRc=_SysFileDelete(zj_File)
if SafeQueryExists(zj_File)<> "" then
CryAndDie('Could not delete "' || zj_File || '", it must be in use (DosRc=' || DeleteRc || ')...')
end
return

GetListOfFiles:
parse arg glfMask,glfStem,glfFollowDirs
call DebugLine 'GetListOfFiles("' || glfMask || '"): Follow Directories = "' || glfFollowDirs || '"'
call DebugIncrement 1
call _valueS glfStem|| '.0',0
if RexxHookGetFileList='' then
do
if glfFollowDirs='N' then
glfFollowDirs=''
else
glfFollowDirs='S'
call DebugLine 'Using "_SysFileTree()" as "GetFileList" hook not used'
call _SysFileTree glfMask,glfStem, 'FO' ||glfFollowDirs
end
else
do
call DebugLine 'Not using "_SysFileTree()" as user specified use of "' || RexxHookGetFileList || '"'
glfTmpFile=RexGetTmpFileName()
call MustDeleteFile glfTmpFile
glfLocn=_filespec('Location',glfMask)
glfName=_filespec('Name',glfMask)
call CallHook "GETFILELIST",,glfLocn,glfName,glfFollowDirs,glfTmpFile
if SafeQueryExists(glfTmpFile)='' then
CryAndDie('"' || RexxHookGetFileList || '" did not create the file list!')
glfLine=0
glfCount=0
do while lines(glfTmpFile)<>0
CurrentLine=linein(glfTmpFile)
glfLine=glfLine+1
if CurrentLine<> '' then
do
FullFile=SafeQueryExists(CurrentLine)
if FullFile='' then
CryAndDie('"' || RexxHookGetFileList || '" specified an invalid file of "' || CurrentLine || '" on line #' ||glfLine)
glfCount=glfCount+1
call _valueS glfStem|| '.' ||glfCount,CurrentLine
end
end
CloseRc=stream(glfTmpFile, 'c', 'close')
call _valueS glfStem|| '.0',glfCount
if OptionDebugOn='N' then
call MustDeleteFile glfTmpFile
end
call DebugIncrement-1
return

NiceDateTime:
return(date('Weekday') || ', ' || date() || ' ' ||GetAmPmTime())

GetInputFileNameAndLine:call TRACE "OFF"

CurrentSourceLocation:
if IncludeLevel<>0 then
return('line ' || AddCommasToDecimalNumber(IncludeLineNumber) || ' of "' || IncludeFileName || '"')
else
do
if arg(1, 'E')then
return(arg(1))
else
return("unknown")
end

GetLineBeingProcessed:call TRACE "OFF"
return(strip(LastLine))

GetFileLineBeingProcessed:call TRACE "OFF"
return(strip(LastFileLine))

DumpVarsIfCompoundVariable:
if pos('.',arg(1))<>0 then
ExpressionKilledUs=arg(1)
return

CheckForNotBeingAbleToExecAnything:
if RexWhich='REGINA' then
do
if RexSystemOpSys="UNIX" then
Exe=''
else
Exe='.exe'
RexxExe="rexx" ||Exe
ReginaExe="regina" ||Exe
DoWhat='Test for use of buggy regina "' || ReginaExe || '" rather than "' || RexxExe || '" executable'
call DebugLine DoWhat
TmpFile=RexGetTmpFileName()
call AddressCmd 'echo ' ||DoWhat||RedirectStdOutAndErr2(TmpFile),TmpFile
if stream(TmpFile, 'c', 'query exists') = '' then
do
Line1="Can't execute shell functions!"
if RexSystemOpSys<> "UNIX" then
do
Line3='It''s possible that your "TMP" or "TEMP" environment variables'
Line4='are corrupt.'
end
else
do
Line3='If you used regina''s "' || ReginaExe || '" executable then try the "' || RexxExe || '"'
Line4='one instead!'
end
Line5='Could not create "' || TmpFile || '"'
Line7='Please report the problem to "' || PgmAuthorEmail || '" (please attach'
Line8='zipped output with "' || RexOptionChar  || 'debug" switch used)!'
CryAndDie(Line1, '', Line3, Line4, Line5, '',Line7,Line8)
end
call _SysFileDelete TmpFile
call DebugLine 'Looks OK to me!'
end
return

LookLikeASingleFile:
FileName=arg(1)
call DebugLine 'No files matched "' || FileName || '", does it look like a single file?'
if verify(FileName, '*?', 'M')<>0 then
NormalFile='N'
else
do
if stream(FileName, 'c', 'query exists') = '' then
NormalFile='N'
else
NormalFile='Y'
end
call DebugIncrement 1
call DebugLine 'Normal File: ' ||NormalFile
call DebugIncrement-1
return(NormalFile)

CryAndDie:
SynErrLine=SIGL
SynErrLineC=AddCommasToDecimalNumber(SynErrLine)
call DebugIncrementInit
call DebugLine 'Fatal Error Detected (at line ' || SynErrLineC || ' of ppwizard)'
call DebugIncrement 1
PpwSize=stream(PpWizardPgmName, 'c', 'query size')
if PpwSize<> '' then
PpwSize=AddCommasToDecimalNumber(PpwSize)
PpwDateTime=GetFileTimeStamp(PpWizardPgmName)
call AllFollowingOutputGoesToErrorFile
call Char1 ErrorColor
call Line1 ''
call Line1 copies('!!',38)
call Line1 copies('!!', 15) || '[ Fatal  Error ]' || copies('!!',15)
call Line1 copies('!!',38)
call CgiStartFatalError
if IncludeLevel<>0 then
do
LastFileLine=strip(LastFileLine)
LastLine=strip(LastLine)
call Line1 'Location  : ' ||CurrentSourceLocation()
call Line1 'File Line : ' ||LastFileLine
if LastLine<>LastFileLine then
call Line1 'Fail Line : ' ||LastLine
if LastLineAfterMacroRep<> '' &LastLine<>LastLineAfterMacroRep&LastFileLine<>LastLineAfterMacroRep then
call Line1 'After Repl: ' ||LastLineAfterMacroRep
if MacroBeingExpanded<> '' then
call Line1 'Expanding : ' || StartsMacroReplacement || MacroBeingExpanded || ' ...' ||EndsMacroReplacement
end
else
do
if PpwDoing<> '' then
call Line1 'Doing What: ' ||PpwDoing
end
call Line1 'Detected @: Line ' || SynErrLineC || ' of ' || _filespec('name', PpWizardPgmName) || ' (v' || PgmVersion || ')'
call Line1 'PPWIZARD  : Length ' || PpwSize || ' bytes.  TimeStamped ' ||PpwDateTime
call Line1 'Running In: ' || PpWizardOpSys || ', ' ||RexVersionInfo
call Line1 'Reason'
call Line1 '~~~~~~'
LastArg=1
do LineIndex=1 to arg()
if arg(LineIndex)<> '' then
LastArg=LineIndex
end
do LineIndex=1 to LastArg
call Line1 arg(LineIndex)
end
if ExpressionKilledUs<> '' then
call DumpVarsInExpression ExpressionKilledUs,, "KNOWN VARIABLES"
call CgiEndFatalError
call Line1 copies('!!',38)
call Line1 ''
call Line1 ''
call Char1 Beep||Reset
if RexxHookError<> '' then
do
do LineIndex=1 to LastArg
call SetEnv "PPWH_ERROR" ||LineIndex,arg(LineIndex)
end
call CallHook "ERROR",,LastArg
do LineIndex=1 to LastArg
call SetEnv "PPWH_ERROR" || LineIndex, ''
end
end
AbnormalExit(SynErrLine)

RexSystemFailure:
FailedAt=SIGL
if TrapHandler='FULL' then
call DebugLine 'RexSystemFailure(REXSYSTM.XH routine failed)'
call DisplayCopyright
call RexDumpSystemInfo
say ''
if TrapHandler='FULL' then
CryAndDie(arg(1))
say 'ERROR'
say '~~~~~'
say arg(1)
call CallErrorHookForSimpleOneLiner arg(1)
ExitNowCallingAnyHandlers(FailedAt)

CallErrorHookForSimpleOneLiner:
if RexxHookError<> '' then
do
call SetEnv "PPWH_ERROR1",arg(1)
call CallHook "ERROR",,1
call SetEnv "PPWH_ERROR1", ''
end
return

AbnormalExit:
call DebugLine 'AbnormalExit(' || arg(1) || ') called.'
if arg(2)<> '' then
call CallErrorHookForSimpleOneLiner arg(2)
ThatsAllFolks(arg(1))

ThatsAllFolks:
zk_Rc=arg(1)
call DebugLine 'ThatsAllFolks() called to exit program.'
if CurrentOutFile<> '' then
CloseRc=stream(CurrentOutFile, 'c', 'close')
if IncludeLevel<>0 then
do
do FileIndex=1 to IncludeLevel
CloseRc=stream(IncludeFileName.FileIndex, 'c', 'close')
end
end
call CloseCgiFileIfOpen
if OptionFilterIn<> '' then
call DoMacroSpaceOperation "DROP", OptionFilterIn,  "HtmlFilterIn",  "QUIET"
if OptionFilterOut<> '' then
call DoMacroSpaceOperation "DROP", OptionFilterOut, "HtmlFilterOut", "QUIET"
call DebugLine 'Exiting with a return code of ' ||zk_Rc
if OptionCgiModeOn='N' then
do
if zk_Rc<=1 then
OnExitSleepFor=OnExitSleepForOk
else
OnExitSleepFor=OnExitSleepForError
if OnExitSleepFor<>0 then
do
call DebugLine 'Sleeping for ' || OnExitSleepFor || ' second(s)'
call _SysSleep OnExitSleepFor
end
end
ExitNowCallingAnyHandlers(zk_Rc)

ExitNowCallingAnyHandlers:
zl_Rc=arg(1)
if zl_Rc=0|zl_Rc=1 then
call _CallExitHandler PpwOnOK, "success"
else
call _CallExitHandler PpwOnERROR, "failure"
exit(zl_Rc)

_CallExitHandler:
zm_Handler=arg(1)
zm_Type=arg(2)
if zm_Handler<> '' then
do
call DebugLine 'A ' || zm_Type || ' exit handler exists...'
call DebugIncrement 1
zm_Handler=_ReplaceConsoleHandlers(zm_Handler, 'ConsoleFile',ConsoleFile)
zm_Handler=_ReplaceConsoleHandlers(zm_Handler, 'ErrorFile',ConsoleErrorFile)
if zm_Handler<> '' then
call AddressCmd zm_Handler
call DebugIncrement-1
end
return

_ReplaceConsoleHandlers:
parse arg zm_Val,zm_Bef,zm_Aft
zm_Before='{' || zm_Bef || '}'
if pos(zm_Before,zm_Val)<>0 then
do
if zm_Aft='' then
do
call Line1 'No value known for "' || zm_Before || '"' ||d2c(7)
call Sleep 3
return('')
end
zm_Val=ReplaceString(zm_Val,zm_Before,zm_Aft)
end
return(zm_Val)
signal INDENT_43

EXTRAINDENT_DEBUG:
if OptionDebugOn='Y' then
call OptionDebugShow 'EXTRAINDENT', 'Extra left indent is now "' || LeftIndent || '"'
return

EXTRAINDENT_GET:
call EXTRAINDENT_DEBUG
return(LeftIndentSet2)

EXTRAINDENT_SET:
LeftIndentSet2=arg(1)
if ProcessedCmdLine='N' then
do
call OptionDebugShow 'EXTRAINDENT', 'Setting default value of extra left indent to "' || LeftIndentSet2 || '"'
Default4_LeftIndent=LeftIndentSet2
return(0)
end
if LeftIndentSet2=='' then
LeftIndentCmd=Default4_LeftIndent
else
LeftIndentCmd=LeftIndentSet2
if translate(LeftIndentCmd)='NULL' then
LeftIndent=''
else
call ExecRexxCmd "LeftIndent = " ||LeftIndentCmd
call EXTRAINDENT_DEBUG
return

INDENT_43:

_DieAsNoTextConditionSupplied:
CryAndDie('No test condition supplied on "#if" command')

_PerformSimpleHashIfTest:
SimpleTest=arg(1)
if left(SimpleTest,1)<> '[' | right(SimpleTest, 1) <> ']' then
CryAndDie('Incorrectly bracketed simple #if command.')
SimpleTest=substr(SimpleTest,2,length(SimpleTest)-2)
if SimpleTest='' then
call _DieAsNoTextConditionSupplied
Parm1=GetSimpleRexxValue(SimpleTest, "SimpleTest")
parse var SimpleTest FastOperator SimpleTest
if SimpleTest='' then
CryAndDie('#if [] has too few parameters (you must put spaces around operator!)')
Parm3=GetSimpleRexxValue(SimpleTest, "SimpleTest")
if SimpleTest<> '' then
CryAndDie('#if [] has too many parameters, expected 3!')
select
when FastOperator='==' then
return(Parm1==Parm3)
when FastOperator='<>' then
return(Parm1<>Parm3)
when FastOperator='=' then
return(Parm1=Parm3)
when FastOperator='<' then
return(Parm1<Parm3)
when FastOperator='>' then
return(Parm1>Parm3)
when FastOperator='<=' then
return(Parm1<=Parm3)
when FastOperator='>=' then
return(Parm1>=Parm3)
otherwise
CryAndDie("Unsupported operator of '" || FastOperator || "' used on simple " || HashCmd, '', 'ONLY "==, <>, =, <, >, <=, >=" are supported!')
end
CryAndDie('BUG: Did not expect to get here!')

MatchesIfDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches #if at ' || IfState.IfAtLine.MatchIndex || ')')

WantLine:
if IfState.WantLines.IfNesting='N' then
return('N')
else
do
if IfState.IfTrue.IfNesting=IfState.InTrue.IfNesting then
return('Y')
else
return('N')
end

ProcessHashIfTest:
if OptionDebugOn='Y' then
do
call DebugLine_CONDITIONAL '#If? at nesting level ' ||IfNesting+1
call DebugIncrement 1
end
WantTheLines=WantLine()
if WantTheLines='N' then
IfResult='N'
else
do
if OptionDebugOn='Y' then
call DebugIncrement 1
parse value PerformReplacementsInCmdsParameters(arg(1))with HashCmd TestCondition
TestCondition=strip(TestCondition)
if translate(HashCmd)=CmdHashIf then
do
if left(TestCondition,1)<> '[' then
do
if TestCondition='' then
call _DieAsNoTextConditionSupplied
call ExecRexxCmd 'IfResult = (' || TestCondition || ')'
end
else
do
IfResult=_PerformSimpleHashIfTest(TestCondition)
end
if IfResult then
IfResult='Y'
else
IfResult='N'
end
else
do
if TestCondition='' then
CryAndDie(HashCmd|| ' command does not specify the variable name!')
IfResult=VariableExists(TestCondition)
if translate(HashCmd)=CmdHashIfndef then
IfResult=translate(IfResult, 'YN', 'NY')
end
if OptionDebugOn='Y' then
do
call DebugIncrement-1
if IfResult='N' then
Tf='FALSE'
else
Tf='TRUE'
if OptionDebugOn='Y' then
call DebugLine_CONDITIONAL 'Answer is ' ||Tf
end
end
IfNesting=IfNesting+1
IfState.WantLines.IfNesting=WantTheLines
IfState.InTrue.IfNesting='Y'
IfState.IfTrue.IfNesting=IfResult
IfState.IfAtLine.IfNesting=CurrentSourceLocation()
if OptionDebugOn='Y' then
call DebugIncrement-1
return('OK')

ProcessHashElse:
if OptionDebugOn='Y' then
call DebugLine_CONDITIONAL '#elseif at level #' ||IfNesting||MatchesIfDebugText(IfNesting)
if IfNesting=0 then
CryAndDie("Found #elseif without matching #if")
if IfState.InTrue.IfNesting='N' then
CryAndDie("Found unexpected #elseif - duplicated #elseif?" ||MatchesIfDebugText(IfNesting))
if arg(1)<> '' then
CryAndDie('The #elseif command does not take parameters')
IfState.InTrue.IfNesting='N'
return('OK')

ProcessHashEndif:
if OptionDebugOn='Y' then
call DebugLine_CONDITIONAL 'Endif at level #' ||IfNesting||MatchesIfDebugText(IfNesting)
if IfNesting=0 then
CryAndDie("Found #endif without matching #if")
IfNesting=IfNesting-1
return('OK')

_ReportCurrentOutputFile:
call DebugLine 'Current Output file = "' || CurrentOutFile || '" (level ' || OutputLevel || ')'
return

HaveNewOutputFile:
hnofAppend=arg(3)
hnofNOCTYPE=arg(4)
if OutputLevel<>0 then
CloseRc=stream(CurrentOutFile, 'c', 'close')
if OptionCgiModeOn='Y' then
do
CurrentOutFile=RexStdoutStream
call DebugLine 'In CGI mode, will output to "' || CurrentOutFile || '" (standard output)'
end
else
do
if arg(2)<> '' then
CurrentOutFile=GenerateFileName(arg(1),arg(2), 'Y')
else
do
CurrentOutFile=arg(1)
call MakeDirectoryTree _filespec('drive', CurrentOutFile) || _filespec('path',CurrentOutFile)
end
end
CurrentOutLine=0
do ChkIndex=1 to OutputLevel
if Output.ChkIndex.File=CurrentOutFile then
do
if hnofAppend='Y' then
call OutputWarningToScreen 'OFO0', 'Appending to currently opened file ("' || CurrentOutFile || '")!'
else
do
WhereOpened=Output.ChkIndex.!Locn
if WhereOpened='' then
Extra='Check "/Output" mask for correctness'
else
Extra='File opened at ' ||WhereOpened
CryAndDie('Already have "' || CurrentOutFile || '" open for output!',Extra)
end
end
end
OutputLevel=OutputLevel+1
Output.OutputLevel.File=CurrentOutFile
Output.OutputLevel.Line=CurrentOutLine
Output.OutputLevel.!Locn=CurrentSourceLocation('')
Output.OutputLevel.OCTYPE=OptionCodeType
if OptionCodeType<>hnofNOCTYPE then
do
call DebugLine 'Processing mode for "' || CurrentOutFile || '" is "' || hnofNOCTYPE || '" (changed from "' || OptionCodeType || '")'
OptionCodeType=hnofNOCTYPE
end
if OptionCgiModeOn='N' then
do
if SafeQueryExists(CurrentOutFile)<> "" then
do
if hnofAppend='Y' then
call DebugLine 'Appending to "' || CurrentOutFile || '"'
else
do
call DebugLine 'Deleting "' || CurrentOutFile || '"'
call MustDeleteFile CurrentOutFile
end
end
end
call AddOutputFileToDependancyList CurrentOutFile
call charout CurrentOutFile, ""
CloseRc=stream(CurrentOutFile, 'c', 'close')
call _ReportCurrentOutputFile
return

_BackToPreviousOutput:
CloseRc=stream(CurrentOutFile, 'c', 'close')
call DebugLine 'Closed the Output file = "' || CurrentOutFile || '" (wrote ' || CurrentOutLine || ' line(s))'
if OutputLevel<=1 then
CryAndDie('No output files on stack!')
else
do
OutputLevel=OutputLevel-1
CurrentOutFile=Output.OutputLevel.File
CurrentOutLine=Output.OutputLevel.Line
if OptionCodeType<>Output.OutputLevel.OCTYPE then
do
OptionCodeType=Output.OutputLevel.OCTYPE
call DebugLine 'Restoring mode for "' || CurrentOutFile || '" to "' || OptionCodeType || '"'
end
call DieIfHoldingOutput
call OutputHoldPop
end
call _ReportCurrentOutputFile
return

ProcessHashOutput:
call DieIfCgiModeOn
if LineQueued\=='' then
do
if OptionDebugOn='Y' then
do
call DebugLine 'Need to flush queued data'
call DebugIncrement 3
end
call FlushQueuedOutput
if OptionDebugOn='Y' then
call DebugIncrement-3
end
OutputParms=PerformReplacementsInCmdsParameters(arg(1))
if OutputParms='' then
call _BackToPreviousOutput
else
do
NewOutFile=GetQuotedText(OutputParms, "OutputParms")
OutputParms=translate(OutputParms)
NewOutAsIs='N'
NewOutAppend='N'
NewOCTYPE=OptionCodeType
do while OutputParms<> ''
ThisParm=GetQuotedText(OutputParms, "OutputParms")
select
when ThisParm="ASIS" then
NewOutAsIs='Y'
when ThisParm="APPEND" then
NewOutAppend='Y'
when ThisParm="HTML" | ThisParm = "REXX" | ThisParm = "OTHER" then
NewOCTYPE=ThisParm
otherwise
CryAndDie('The parameter "' || ThisParm || '" is unknown!')
end
end
call OutputHoldPushAndClear
if NewOutAsIs='N' then
call HaveNewOutputFile NewOutFile,OptionOutput,NewOutAppend,NewOCTYPE
else
call HaveNewOutputFile NewOutFile,,NewOutAppend,NewOCTYPE
end
return(0)

GetQuotedText:
parse arg TheString,RestVarName,QuoteDel
TheString=strip(TheString, 'L')
QuoteDel=' ' ||QuoteDel
if OptionDebugOn='Y' then
do
call DebugLine_QUOTING 'GetQuotedText(): ' ||DebugRightArrow||TheString||DebugLeftArrow
call DebugIncrement 1
end
if TheString='' then
call _ErrorNoQuotedParm
QuoteChar=left(TheString,1)
if datatype(QuoteChar, 'Alphanumeric')then
do
if OptionDebugOn='Y' then
call DebugLine_QUOTING 'Text is unquoted'
DelPos=verify(TheString,QuoteDel, 'M')
if DelPos=0 then
do
QuotedString=TheString
TheRest=''
end
else
do
QuotedString=substr(TheString,1,DelPos-1)
TheRest=substr(TheString,DelPos)
end
end
else
do
if OptionDebugOn='Y' then
call DebugLine_QUOTING 'Text is quoted with ' ||DebugRightArrow||QuoteChar||DebugLeftArrow
SecondQuotePosn=pos(QuoteChar,TheString,2)
if SecondQuotePosn=0 then
call _ErrorNoEndQuote
QuotedString=substr(TheString,2,SecondQuotePosn-2)
TheRest=substr(TheString,SecondQuotePosn+1)
end
if TheRest<> '' then
do
if QuoteDel<> 'Y' then
do
if pos(left(TheRest,1),QuoteDel)=0 then
do
Line1='There is no whitespace after the 2nd quote char of "' || QuoteChar || '" (did not expect to find "' || left(TheRest, 1) || '")'
Line2='The rest of the line:'
Line3=copies(' ',8)||DebugRightArrow||TheRest||DebugLeftArrow
CryAndDie(Line1,Line2,Line3)
end
end
end
TheRest=strip(TheRest, 'L')
if RestVarName<> '' then
call _valueS RestVarName,TheRest
else
do
if TheRest<> '' then
call DieIfExtraUnexpectedParms TheRest
end
if OptionDebugOn='Y' then
do
call DebugLine_QUOTING 'Text is  ' ||DebugRightArrow||QuotedString||DebugLeftArrow
call DebugIncrement-1
end
return(QuotedString)

GetQuotedRest:
TheString=strip(arg(1))
if OptionDebugOn='Y' then
do
call DebugIncrement 1
call DebugLine_QUOTING 'GetQuotedRest(): ' ||DebugRightArrow||TheString||DebugLeftArrow
end
if TheString='' then
call _ErrorNoQuotedParm
QuoteChar=left(TheString,1)
if datatype(QuoteChar, 'Alphanumeric')then
do
QuotedString=TheString
if OptionDebugOn='Y' then
call DebugLine_QUOTING 'Text is unquoted'
end
else
do
if OptionDebugOn='Y' then
call DebugLine_QUOTING 'Text is quoted with '||DebugRightArrow||QuoteChar||DebugLeftArrow
SecondQuotePosn=length(TheString)
if SecondQuotePosn<2|substr(TheString,SecondQuotePosn,1)<>QuoteChar then
call _ErrorNoEndQuote
QuotedString=substr(TheString,2,SecondQuotePosn-2)
end
if OptionDebugOn='Y' then
do
call DebugLine_QUOTING 'Text is  ' ||DebugRightArrow||QuotedString||DebugLeftArrow
call DebugIncrement-1
end
return(QuotedString)

DieIfExtraUnexpectedParms:
if arg(1)='' then
return
CryAndDie('Unexpected parameter(s) of "' || strip(arg(1)) || '" found!')

_ErrorNoQuotedParm:
CryAndDie('Expect a quoted string, not enough parameters available!')

_ErrorNoEndQuote:
Line1='Could not find a matching end quote character of "' || QuoteChar || '"!'
Line2='Processing:'
Line3=copies(' ',8)||DebugRightArrow||TheString||DebugLeftArrow
CryAndDie(Line1,Line2,Line3)

GetRexxVarValueOrDie:
grvVar=arg(1)
if symbol(grvVar)='VAR' then
return(_valueG(grvVar))
else
do
if symbol(grvVar)='BAD' then
Reason="contains invalid character(s)"
else
Reason="is unknown"
call DumpVarsIfCompoundVariable grvVar
CryAndDie('The rexx variable "' || grvVar || '" ' || Reason || '!')
end

ProcessRexxVar:
ResultVar=GetQuotedText(PerformReplacementsInCmdsParameters(arg(1)), "Rest")
XVarName=''
ResultVarU=translate(ResultVar)
if ResultVarU="PUSH" then
do
do while Rest<> ''
ResultVar=GetQuotedText(Rest, "Rest")
call _StackPush GetRexxVarValueOrDie(ResultVar)
end
return(0)
end
if ResultVarU="POP" then
do
TmpVarCnt=0
do while Rest<> ''
ResultVar=GetQuotedText(Rest, "Rest")
TmpVarCnt=TmpVarCnt+1
TmpVar.TmpVarCnt=ResultVar
end
do while TmpVarCnt<>0
call _valueS TmpVar.TmpVarCnt,_StackPop()
TmpVarCnt=TmpVarCnt-1
end
return(0)
end
parse var Rest FastOperator Rest
if FastOperator<> '=' then
do
FastOperator=translate(FastOperator)
if left(FastOperator,1)='=' then
do
if FastOperator='=X=' then
do
XVarName=ResultVar
ResultVar='XVAR?.X?' ||c2x(translate(XVarName))
end
else
do
Rest=strip(Rest)
if symbol(Rest)='VAR' then
ResultValue=GetRexxVarValueOrDie(Rest)
else
ResultValue=GetQuotedRest(Rest)
select
when FastOperator='=ASIS=' then
do
RestVar=AsIs(ResultValue)
end
otherwise
CryAndDie('Unsupported "=?=" operator of "' || FastOperator || '" used on ' ||HashCmd)
end
Rest='RestVar'
end
FastOperator='='
end
end
select
when FastOperator='=' then
do
Rest=strip(Rest)
if symbol(Rest)='VAR' then
ResultValue=GetRexxVarValueOrDie(Rest)
else
ResultValue=GetQuotedRest(Rest)
end
when FastOperator='PUSH' then
do
call DieIfExtraUnexpectedParms Rest
call _StackPush GetRexxVarValueOrDie(ResultVar)
return(0)
end
when FastOperator='POP' then
do
call DieIfExtraUnexpectedParms Rest
ResultValue=_StackPop()
end
otherwise
do
AfterOperator=GetSimpleRexxValue(Rest, "Rest")
if Rest<> '' then
SourceValue=GetSimpleRexxValue(Rest)
else
SourceValue=GetRexxVarValueOrDie(ResultVar)
if OptionDebugOn='Y' then
call DebugLine_REXXVAR 'Evaluating: ' || SourceValue || ' ' || FastOperator || ' ' ||AfterOperator
select
when FastOperator='+' then
ResultValue=SourceValue+AfterOperator
when FastOperator='-' then
ResultValue=SourceValue-AfterOperator
when FastOperator='||' then
ResultValue=SourceValue||AfterOperator
when FastOperator='*' then
ResultValue=SourceValue*AfterOperator
when FastOperator='/' then
ResultValue=SourceValue/AfterOperator
when FastOperator='//' then
ResultValue=SourceValue//AfterOperator
when FastOperator='%' then
ResultValue=SourceValue%AfterOperator
otherwise
CryAndDie("Unsupported operator of '" || FastOperator || "' used on " ||HashCmd)
end
end
end
call _valueS ResultVar,ResultValue
if OptionDebugOn='Y' then
do
call DebugIncrement 1
if XVarName='' then
DbgPrefix=ResultVar
else
DbgPrefix='"X" Variable ' ||XVarName
call DebugLine_REXXVAR DbgPrefix|| ' = ' ||DebugRightArrow||ResultValue||DebugLeftArrow
call DebugIncrement-1
end
return(0)

GetSimpleRexxValue:
sParm=strip(arg(1), 'L')
sRestVar=arg(2)
sQuote=left(sParm,1)
if sQuote="'" | sQuote = '"' then
do
sEndPos=pos(sQuote,sParm,2)
if sEndPos=0 then
CryAndDie('Incorrectly quoted rexx literal (could not find ending quote)')
sValue=substr(sParm,2,sEndPos-2)
sRest=substr(sParm,sEndPos+1)
end
else
do
parse var sParm sValue sRest
if datatype(sValue, 'Number')=0 then
sValue=GetRexxVarValueOrDie(sValue)
end
if sRestVar<> '' then
call _valueS sRestVar,sRest
else
do
if sRestVar<> '' then
CryAndDie('Extra unexpected parameters of "' || sRestVar || '" found')
end
return(sValue)

_StackPush:
StackCnt=StackCnt+1
Stack.StackCnt.StackData=arg(1)
Stack.StackCnt.StackPosn=CurrentSourceLocation()
if OptionDebugOn='Y' then
call DebugLine_REXXVAR 'Stack Push(#' || StackCnt || ') = ' ||DebugRightArrow||arg(1)||DebugLeftArrow
return

_StackPop:
if StackCnt<=0 then
CryAndDie('There is nothing on the stack!')
spData=Stack.StackCnt.StackData
if OptionDebugOn='Y' then
do
call DebugLine_REXXVAR 'Stack pop(#' || StackCnt || ') = ' ||DebugRightArrow||spData||DebugLeftArrow
call DebugLine_REXXVAR 'matched push() at ' ||Stack.StackCnt.StackPosn
end
StackCnt=StackCnt-1
return(spData)

MatchesStackPushDebugText:
MatchIndex=arg(1)
if MatchIndex<=0 then
return('')
else
return(' (matches "#RexxVar PUSH" at ' || Stack.MatchIndex.StackPosn || ')')

_EnsureVersionY2KSafe:
TheVer=ReplaceString(translate(arg(1)), '2K', '00')
if datatype(TheVer, 'Number')=0|(length(TheVer)<>6&length(TheVer)<>8)then
CryAndDie('The version number "' || TheVer || '" is not valid')
if TheVer<100 then
do
if TheVer>98 then
TheVer='19' ||TheVer
else
TheVer='20' ||TheVer
end
return(TheVer)

ProcessRequire:
zn_Rest=PerformReplacementsInCmdsParameters(arg(1))
zn_MinVer=_EnsureVersionY2KSafe(GetQuotedText(zn_Rest, 'zn_Rest'))
if zn_Rest='' then
zn_MaxVer='9999.99'
else
do
zn_MaxVer=_EnsureVersionY2KSafe(GetQuotedText(zn_Rest))
zn_Rest='"' || zn_MaxVer || '"'
end
zn_ThisVer=_EnsureVersionY2KSafe(PgmVersion)
if OptionDebugOn='Y' then
do
call DebugLine 'You require "' || zn_MinVer || '" - ' ||zn_Rest
call DebugLine 'You have    "' || zn_ThisVer || '"'
end
if zn_ThisVer<zn_MinVer then
CryAndDie('You required at least PPWIZARD version "' || zn_MinVer || '", you are using version "' || zn_ThisVer || '"')
if zn_ThisVer>zn_MaxVer then
CryAndDie('You need a PPWIZARD version EARLIER than "' || zn_MaxVer || '", you are using version "' || zn_ThisVer || '"')
return(0)

RexxCtrlC:
LineCtrlC=SIGL
TRACE OFF
call AllFollowingOutputGoesToErrorFile
call Line1 ''
call Line1 HighlightColor||copies('=+',39)||ErrorColor
call CgiStartFatalError
call Line1 "Come on, you pressed Ctrl+C or Break didn't you!"
call CgiEndFatalError
call Line1 HighlightColor||copies('=+',39)||Reset
AbnormalExit(LineCtrlC, "CTRL+C Pressed")

QuickSourceLine:
LineNum=arg(1)
slKey='PPWSL!.' ||LineNum
if symbol(slKey)='VAR' then
return(_valueG(slKey))
SrcLine=sourceline(LineNum)
call _valueS slKey,SrcLine
return(SrcLine)

_FindLastLabel:
FailedOnLine=arg(1)
TryLine=FailedOnLine
do while TryLine>1
TryLine=TryLine-1
TheLine=QuickSourceLine(TryLine)
ColonPos=pos(':',TheLine)
if ColonPos<>0 then
do
MaybeLabel=strip(left(TheLine,ColonPos-1))
if symbol(MaybeLabel)<> 'BAD' then
do
FoundLabelOnLine=TryLine
return(MaybeLabel|| ':  (line #' || AddCommasToDecimalNumber(TryLine) || ')')
end
end
end
FoundLabelOnLine=0
return('')

CommonTrapHandler:
signal on NOVALUE name SimpleRexxTrapUninitializedVariable
signal on SYNTAX name SimpleRexxTrapSyntaxError
FailingLine=arg(1)
TrapHeading=arg(2)
TextDescription=arg(3)
Text=arg(4)
CmdBeingEvaluated=arg(5)
UserBreakPoint=arg(6)
HaveCapturedTrapDetails='Y'
call AllFollowingOutputGoesToErrorFile
call Line1 ''
call Line1 HighlightColor||copies('=+',39)||ErrorColor
call CgiStartFatalError
call Line1 TrapHeading
call Line1 copies('~',length(TrapHeading))
call Line1 substr(TextDescription,1,16)|| ': ' ||Text
BetterErrorText=Condition('D')
if BetterErrorText<> '' &BetterErrorText<>Text then
call Line1 copies(' ',18)||BetterErrorText
if IncludeLevel<>0 then
do
call Line1 'Processing locn : ' ||CurrentSourceLocation()
LastFileLine=strip(LastFileLine)
LastLine=strip(LastLine)
call Line1 'Line from file  : ' ||LastFileLine
if LastLine<>LastFileLine then
call Line1 'Failing line    : ' ||LastLine
if LastLineAfterMacroRep<> '' &LastLine<>LastLineAfterMacroRep&LastFileLine<>LastLineAfterMacroRep then
call Line1 'After Replace   : ' ||LastLineAfterMacroRep
if MacroBeingExpanded<> '' then
call Line1 'Expanding Macro : ' || StartsMacroReplacement || MacroBeingExpanded || ' ...' ||EndsMacroReplacement
end
else
do
if PpwDoing<> '' then
call Line1 'PPWIZARD was    : ' ||PpwDoing
end
if CmdBeingEvaluated<> '' then
do
EvPrefix='Evaluating This : '
CmdSepL=d2c(10)||copies(' ',length(EvPrefix))
ShowThisS=CmdBeingEvaluated
if length(CmdBeingEvaluated)<=300 then
ShowThisS=CmdBeingEvaluated
else
ShowThisS=left(ShowThisS,300)|| ' ...(Too much to show all)'
ShowThisS=EvPrefix||translate(ShowThisS, ';',MarksNewLine)
ShowThisL=EvPrefix||ReplaceString(CmdBeingEvaluated,MarksNewLine,CmdSepL)
call Line1 ShowThisS,ShowThisL
end
if RexWhich='REGINA' then
ReginaUname=' (' || uname() || ')'
else
ReginaUname=''
FailingLineText=AddCommasToDecimalNumber(FailingLine)
call Line1 'Operating System: ' ||RexSystemOpSys||ReginaUname
call Line1 'Rexx Version    : ' ||RexVersionInfo
if CmdBeingEvaluated='' then
DumpSource='Y'
else
do
DumpSource='N'
call DumpVarsInExpression CmdBeingEvaluated,, 'KNOWN VARIABLES', 'Line1'
end
if DumpSource='Y' then
do
call Line1 'Failing Module  : ' || PpWizardPgmName || ' (' || PgmVersion || ')'
call Line1 'Failing Line #  : ' ||FailingLineText
InRoutine=_FindLastLabel(FailingLine)
StartAt=FailingLine-7
if FoundLabelOnLine<>0 then
do
if FoundLabelOnLine>StartAt then
StartAt=FoundLabelOnLine
else
do
if FoundLabelOnLine<>0 then
do
if(FailingLine-FoundLabelOnLine)<10 then
StartAt=FoundLabelOnLine
else
call Line1 'After label     : ' ||InRoutine
end
end
end
call Line1 'SOURCE'
call Line1 '~~~~~~'
vlist.0=0
do ShowLine=StartAt to FailingLine
FailingSrcLineTxt=strip(QuickSourceLine(ShowLine))
call Line1 left(AddCommasToDecimalNumber(ShowLine),length(FailingLineText))|| ' : ' ||FailingSrcLineTxt
call DumpVarsInExpression FailingSrcLineTxt, 'vlist'
end
call DumpVarsInExpressionNow 'vlist', 'KNOWN VARIABLES', 'Line1'
end
HookText=TrapHeading|| ' at line ' || FailingLineText || '. ' || TextDescription || ': ' ||Text
call CgiEndFatalError
call Line1 HighlightColor||copies('=+',39)||Reset
call Line1 ''
if UserBreakPoint<> '' then
do
call RexxTrace HookText,,,'Y'
end
AbnormalExit(FailingLine,HookText)

RexxTrapUninitializedVariable:
TrappingLine=SIGL
call CommonTrapHandler TrappingLine, 'NoValue Abort!', 'Unknown Variable', condition('D')

RexxTrapSyntaxError:
TrappingLine=SIGL
call CommonTrapHandler TrappingLine, 'Syntax Error!', 'Reason',errortext(Rc)

SimpleCommonTrapHandler:
if HaveCapturedTrapDetails='N' then
do
FailingLine=arg(1)
TrapHeading=arg(2)
TextDescription=arg(3)
Text=arg(4)
end
FailingLineText=AddCommasToDecimalNumber(FailingLine)
say ''
say copies('*-',39)
say TrapHeading
say copies('~',length(TrapHeading))
if HaveCapturedTrapDetails='Y' then
say 'Trap within Trap: Original trap details saved and displayed below!'
say substr(TextDescription,1,16)|| ': ' ||Text
BetterErrorText=Condition('D')
if BetterErrorText<> '' &BetterErrorText<>Text then
call Line1 copies(' ',18)||BetterErrorText
parse source . . PpWizardPgmName
parse version VersionOfRexx
FailingSrcLineTxt=strip(QuickSourceLine(FailingLine))
say 'Failed at       : ' || PpWizardPgmName || ' (line ' || FailingLineText || ', version ' || PgmVersion || ')'
say 'Source Code     : ' ||FailingSrcLineTxt
say 'Rexx Version    : ' ||VersionOfRexx
call DumpVarsInExpression FailingSrcLineTxt, '', 'KNOWN VARIABLES'
HookText=TrapHeading|| ' at line ' || FailingLineText || '. ' || TextDescription || ': ' ||Text
if HaveCapturedTrapDetails='Y' then
do
FailingLine=arg(1)
TrapHeading=arg(2)
TextDescription=arg(3)
Text=arg(4)
say ''
say 'Reason for secondary trap'
say '~~~~~~~~~~~~~~~~~~~~~~~~~'
say substr(TextDescription,1,16)|| ': ' ||Text
say 'Failed at       : ' || PpWizardPgmName || ' (line ' || FailingLineText || ', version ' || PgmVersion || ')'
say 'Source Code     : ' ||strip(QuickSourceLine(FailingLine))
end
say copies('*-',39)
call CallErrorHookForSimpleOneLiner HookText
ExitNowCallingAnyHandlers(FailingLine)

SimpleRexxTrapUninitializedVariable:
TrappingLine=SIGL
call SimpleCommonTrapHandler TrappingLine, 'NoValue Abort!', 'Unknown Variable', condition('D')

SimpleRexxTrapSyntaxError:
TrappingLine=SIGL
call SimpleCommonTrapHandler TrappingLine, 'Syntax Error!', 'Reason',errortext(Rc)
