/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;

public class BasicListUI
extends ListUI {
    protected JList list = null;
    protected CellRendererPane rendererPane;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    protected ListSelectionListener listSelectionListener;
    protected ListDataListener listDataListener;
    protected PropertyChangeListener propertyChangeListener;
    protected int[] cellHeights = null;
    protected int cellHeight = -1;
    protected int cellWidth = -1;
    protected int updateLayoutStateNeeded = 1;
    protected static final int modelChanged = 1;
    protected static final int selectionModelChanged = 2;
    protected static final int fontChanged = 4;
    protected static final int fixedCellWidthChanged = 8;
    protected static final int fixedCellHeightChanged = 16;
    protected static final int prototypeCellValueChanged = 32;
    protected static final int cellRendererChanged = 64;
    private static final int CHANGE_LEAD = 0;
    private static final int CHANGE_SELECTION = 1;
    private static final int EXTEND_SELECTION = 2;

    protected int convertRowToY(int n) {
        int n2 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (n < 0 || n >= n2) {
            return -1;
        }
        if (this.cellHeights == null) {
            return insets.top + this.cellHeight * n;
        }
        if (n >= this.cellHeights.length) {
            return -1;
        }
        int n3 = insets.top;
        int n4 = 0;
        while (n4 < n) {
            n3 += this.cellHeights[n4];
            ++n4;
        }
        return n3;
    }

    protected int convertYToRow(int n) {
        int n2 = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        if (this.cellHeights == null) {
            int n3 = this.cellHeight == 0 ? 0 : (n - insets.top) / this.cellHeight;
            return n3 < 0 || n3 >= n2 ? -1 : n3;
        }
        if (n2 > this.cellHeights.length) {
            return -1;
        }
        int n4 = insets.top;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n2) {
            if (n >= n4 && n < n4 + this.cellHeights[n6]) {
                return n5;
            }
            n4 += this.cellHeights[n6];
            ++n5;
            ++n6;
        }
        return -1;
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ListSelectionListener createListSelectionListener() {
        return new ListSelectionHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicListUI();
    }

    public Rectangle getCellBounds(JList jList, int n, int n2) {
        this.maybeUpdateLayoutState();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        int n5 = this.convertRowToY(n3);
        int n6 = this.convertRowToY(n4);
        if (n5 == -1 || n6 == -1) {
            return null;
        }
        Insets insets = jList.getInsets();
        int n7 = insets.left;
        int n8 = n5;
        int n9 = jList.getWidth() - (insets.left + insets.right);
        int n10 = n6 + this.getRowHeight(n4) - n5;
        return new Rectangle(n7, n8, n9, n10);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.maybeUpdateLayoutState();
        int n = this.list.getModel().getSize() - 1;
        if (n < 0) {
            return new Dimension(0, 0);
        }
        Insets insets = this.list.getInsets();
        int n2 = this.cellWidth + insets.left + insets.right;
        int n3 = this.convertRowToY(n) + this.getRowHeight(n) + insets.bottom;
        return new Dimension(n2, n3);
    }

    protected int getRowHeight(int n) {
        if (n < 0 || n >= this.list.getModel().getSize()) {
            return -1;
        }
        return this.cellHeights == null ? this.cellHeight : (n < this.cellHeights.length ? this.cellHeights[n] : -1);
    }

    public Point indexToLocation(JList jList, int n) {
        this.maybeUpdateLayoutState();
        return new Point(0, this.convertRowToY(n));
    }

    protected void installDefaults() {
        Color color;
        Color color2;
        this.list.setLayout(null);
        LookAndFeel.installBorder(this.list, "List.border");
        LookAndFeel.installColorsAndFont(this.list, "List.background", "List.foreground", "List.font");
        if (this.list.getCellRenderer() == null) {
            this.list.setCellRenderer((ListCellRenderer)UIManager.get("List.cellRenderer"));
        }
        if ((color2 = this.list.getSelectionBackground()) == null || color2 instanceof UIResource) {
            this.list.setSelectionBackground(UIManager.getColor("List.selectionBackground"));
        }
        if ((color = this.list.getSelectionForeground()) == null || color instanceof UIResource) {
            this.list.setSelectionForeground(UIManager.getColor("List.selectionForeground"));
        }
    }

    protected void installKeyboardActions() {
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("SelectPreviousRow", 1, -1), KeyStroke.getKeyStroke(38, 0), 0);
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("SelectPreviousRow", 1, -1), KeyStroke.getKeyStroke("KP_UP"), 0);
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("ExtendSelectPreviousRow", 2, -1), KeyStroke.getKeyStroke(38, 1), 0);
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("ExtendSelectPreviousRow", 2, -1), KeyStroke.getKeyStroke("shift KP_UP"), 0);
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("SelectNextRow", 1, 1), KeyStroke.getKeyStroke(40, 0), 0);
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("SelectNextRow", 1, 1), KeyStroke.getKeyStroke("KP_DOWN"), 0);
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("ExtendSelectPreviousRow", 2, 1), KeyStroke.getKeyStroke(40, 1), 0);
        this.list.registerKeyboardAction(new IncrementLeadSelectionAction("ExtendSelectPreviousRow", 2, 1), KeyStroke.getKeyStroke("shift KP_DOWN"), 0);
        this.list.registerKeyboardAction(new HomeAction("SelectHome", 1), KeyStroke.getKeyStroke(36, 0), 0);
        this.list.registerKeyboardAction(new HomeAction("ExtendSelectHome", 2), KeyStroke.getKeyStroke(36, 1), 0);
        this.list.registerKeyboardAction(new EndAction("SelectEnd", 1), KeyStroke.getKeyStroke(35, 0), 0);
        this.list.registerKeyboardAction(new EndAction("ExtendSelectEnd", 2), KeyStroke.getKeyStroke(35, 1), 0);
        this.list.registerKeyboardAction(new PageUpAction("SelectPageUp", 1), KeyStroke.getKeyStroke(33, 0), 0);
        this.list.registerKeyboardAction(new PageUpAction("ExtendSelectPageUp", 2), KeyStroke.getKeyStroke(33, 1), 0);
        this.list.registerKeyboardAction(new PageDownAction("SelectPageDown", 1), KeyStroke.getKeyStroke(34, 0), 0);
        this.list.registerKeyboardAction(new PageDownAction("ExtendSelectPageDown", 2), KeyStroke.getKeyStroke(34, 1), 0);
        class Javax_swing_plaf_basic_BasicListUI$1 {
            /* synthetic */ Javax_swing_plaf_basic_BasicListUI$1() {
            }
        }
        SelectAllAction selectAllAction = new SelectAllAction(null, "SelectAll");
        this.list.registerKeyboardAction(selectAllAction, KeyStroke.getKeyStroke(65, 2), 0);
        this.list.registerKeyboardAction(selectAllAction, KeyStroke.getKeyStroke(47, 2), 0);
        this.list.registerKeyboardAction(new ClearSelectionAction(null, "ClearSelection"), KeyStroke.getKeyStroke(92, 2), 0);
    }

    protected void installListeners() {
        ListSelectionModel listSelectionModel;
        this.focusListener = this.createFocusListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.listSelectionListener = this.createListSelectionListener();
        this.listDataListener = this.createListDataListener();
        this.list.addFocusListener(this.focusListener);
        this.list.addMouseListener(this.mouseInputListener);
        this.list.addMouseMotionListener(this.mouseInputListener);
        this.list.addPropertyChangeListener(this.propertyChangeListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.addListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.addListSelectionListener(this.listSelectionListener);
        }
    }

    public void installUI(JComponent jComponent) {
        this.list = (JList)jComponent;
        this.rendererPane = new CellRendererPane();
        this.list.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public int locationToIndex(JList jList, Point point) {
        this.maybeUpdateLayoutState();
        return this.convertYToRow(point.y);
    }

    protected void maybeUpdateLayoutState() {
        if (this.updateLayoutStateNeeded != 0) {
            this.updateLayoutState();
            this.updateLayoutStateNeeded = 0;
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        this.maybeUpdateLayoutState();
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        ListModel listModel = this.list.getModel();
        ListSelectionModel listSelectionModel = this.list.getSelectionModel();
        if (listCellRenderer == null || listModel.getSize() == 0) {
            return;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        int n = this.convertYToRow(rectangle2.y);
        int n2 = this.convertYToRow(rectangle2.y + rectangle2.height - 1);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = listModel.getSize() - 1;
        }
        if ((rectangle = this.getCellBounds(this.list, n, n)) == null) {
            return;
        }
        int n3 = this.list.getLeadSelectionIndex();
        int n4 = n;
        while (n4 <= n2) {
            rectangle.height = this.getRowHeight(n4);
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            this.paintCell(graphics, n4, rectangle, listCellRenderer, listModel, listSelectionModel, n3);
            rectangle.y += rectangle.height;
            ++n4;
        }
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n, bl2, bl);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n6, true);
    }

    private void redrawList() {
        this.list.revalidate();
        this.list.repaint();
    }

    protected void selectNextIndex() {
        int n = this.list.getSelectedIndex();
        if (n + 1 < this.list.getModel().getSize()) {
            this.list.setSelectedIndex(++n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void selectPreviousIndex() {
        int n = this.list.getSelectedIndex();
        if (n > 0) {
            this.list.setSelectedIndex(--n);
            this.list.ensureIndexIsVisible(n);
        }
    }

    protected void uninstallDefaults() {
        if (this.list.getCellRenderer() instanceof UIResource) {
            this.list.setCellRenderer(null);
        }
    }

    protected void uninstallKeyboardActions() {
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_UP"));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 1));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke("shift KP_UP"));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke("KP_DOWN"));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 1));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke("shift KP_DOWN"));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(36, 0));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(36, 1));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(35, 0));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(35, 1));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 0));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(33, 1));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 0));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(34, 1));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(65, 2));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(47, 2));
        this.list.unregisterKeyboardAction(KeyStroke.getKeyStroke(92, 2));
    }

    protected void uninstallListeners() {
        ListSelectionModel listSelectionModel;
        this.list.removeFocusListener(this.focusListener);
        this.list.removeMouseListener(this.mouseInputListener);
        this.list.removeMouseMotionListener(this.mouseInputListener);
        this.list.removePropertyChangeListener(this.propertyChangeListener);
        ListModel listModel = this.list.getModel();
        if (listModel != null) {
            listModel.removeListDataListener(this.listDataListener);
        }
        if ((listSelectionModel = this.list.getSelectionModel()) != null) {
            listSelectionModel.removeListSelectionListener(this.listSelectionListener);
        }
        this.focusListener = null;
        this.mouseInputListener = null;
        this.listSelectionListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.cellHeight = -1;
        this.cellWidth = -1;
        this.cellHeights = null;
        this.list.remove(this.rendererPane);
        this.rendererPane = null;
        this.list = null;
    }

    protected void updateLayoutState() {
        int n = this.list.getFixedCellHeight();
        int n2 = this.list.getFixedCellWidth();
        int n3 = this.cellWidth = n2 != -1 ? n2 : -1;
        if (n != -1) {
            this.cellHeight = n;
            this.cellHeights = null;
        } else {
            this.cellHeight = -1;
            this.cellHeights = new int[this.list.getModel().getSize()];
        }
        if (n2 == -1 || n == -1) {
            ListModel listModel = this.list.getModel();
            int n4 = listModel.getSize();
            ListCellRenderer listCellRenderer = this.list.getCellRenderer();
            if (listCellRenderer != null) {
                int n5 = 0;
                while (n5 < n4) {
                    Object object = listModel.getElementAt(n5);
                    Component component = listCellRenderer.getListCellRendererComponent(this.list, object, n5, false, false);
                    this.rendererPane.add(component);
                    Dimension dimension = component.getPreferredSize();
                    if (n2 == -1) {
                        this.cellWidth = Math.max(dimension.width, this.cellWidth);
                    }
                    if (n == -1) {
                        this.cellHeights[n5] = dimension.height;
                    }
                    ++n5;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                int n6 = 0;
                while (n6 < n4) {
                    this.cellHeights[n6] = 0;
                    ++n6;
                }
            }
        }
        this.list.invalidate();
    }

    public class MouseInputHandler
    implements MouseInputListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            Rectangle rectangle;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicListUI.this.list.isEnabled()) {
                return;
            }
            if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
                return;
            }
            int n = BasicListUI.this.convertYToRow(mouseEvent.getY());
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.scrollRectToVisible(rectangle);
                BasicListUI.this.list.setSelectionInterval(n, n);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (!BasicListUI.this.list.isEnabled()) {
                return;
            }
            if (!BasicListUI.this.list.hasFocus()) {
                BasicListUI.this.list.requestFocus();
            }
            if ((n = BasicListUI.this.convertYToRow(mouseEvent.getY())) != -1) {
                BasicListUI.this.list.setValueIsAdjusting(true);
                int n2 = BasicListUI.this.list.getAnchorSelectionIndex();
                if (mouseEvent.isControlDown()) {
                    if (BasicListUI.this.list.isSelectedIndex(n)) {
                        BasicListUI.this.list.removeSelectionInterval(n, n);
                    } else {
                        BasicListUI.this.list.addSelectionInterval(n, n);
                    }
                } else if (mouseEvent.isShiftDown() && n2 != -1) {
                    BasicListUI.this.list.setSelectionInterval(n2, n);
                } else {
                    BasicListUI.this.list.setSelectionInterval(n, n);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            BasicListUI.this.list.setValueIsAdjusting(false);
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintCellFocus();
        }

        protected void repaintCellFocus() {
            Rectangle rectangle;
            int n = BasicListUI.this.list.getLeadSelectionIndex();
            if (n != -1 && (rectangle = BasicListUI.this.getCellBounds(BasicListUI.this.list, n, n)) != null) {
                BasicListUI.this.list.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public class ListSelectionHandler
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            BasicListUI.this.maybeUpdateLayoutState();
            int n = BasicListUI.this.convertRowToY(listSelectionEvent.getFirstIndex());
            int n2 = BasicListUI.this.convertRowToY(listSelectionEvent.getLastIndex());
            if (n == -1 || n2 == -1) {
                BasicListUI.this.list.repaint(0, 0, BasicListUI.this.list.getWidth(), BasicListUI.this.list.getHeight());
            } else {
                BasicListUI.this.list.repaint(0, n, BasicListUI.this.list.getWidth(), (n2 += BasicListUI.this.getRowHeight(listSelectionEvent.getLastIndex())) - n);
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            BasicListUI.this.redrawList();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.insertIndexInterval(n, n2 - n, true);
            }
            int n3 = Math.max(0, BasicListUI.this.convertRowToY(n));
            int n4 = BasicListUI.this.list.getHeight() - n3;
            BasicListUI.this.list.revalidate();
            BasicListUI.this.list.repaint(0, n3, BasicListUI.this.list.getWidth(), n4);
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            BasicListUI.this.updateLayoutStateNeeded = 1;
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel != null) {
                listSelectionModel.removeIndexInterval(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            }
            int n = Math.min(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            int n2 = Math.max(0, BasicListUI.this.convertRowToY(n));
            int n3 = BasicListUI.this.list.getHeight() - n2;
            BasicListUI.this.list.revalidate();
            BasicListUI.this.list.repaint(0, n2, BasicListUI.this.list.getWidth(), n3);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("model")) {
                ListModel listModel = (ListModel)propertyChangeEvent.getOldValue();
                ListModel listModel2 = (ListModel)propertyChangeEvent.getNewValue();
                if (listModel != null) {
                    listModel.removeListDataListener(BasicListUI.this.listDataListener);
                }
                if (listModel2 != null) {
                    listModel2.addListDataListener(BasicListUI.this.listDataListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string.equals("selectionModel")) {
                ListSelectionModel listSelectionModel = (ListSelectionModel)propertyChangeEvent.getOldValue();
                ListSelectionModel listSelectionModel2 = (ListSelectionModel)propertyChangeEvent.getNewValue();
                if (listSelectionModel != null) {
                    listSelectionModel.removeListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                if (listSelectionModel2 != null) {
                    listSelectionModel2.addListSelectionListener(BasicListUI.this.listSelectionListener);
                }
                BasicListUI.this.updateLayoutStateNeeded |= 1;
                BasicListUI.this.redrawList();
            } else if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string.equals("font")) {
                BasicListUI.this.updateLayoutStateNeeded |= 4;
                BasicListUI.this.redrawList();
            } else if (string.equals("prototypeCellValue")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x20;
                BasicListUI.this.redrawList();
            } else if (string.equals("fixedCellHeight")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x10;
                BasicListUI.this.redrawList();
            } else if (string.equals("fixedCellWidth")) {
                BasicListUI.this.updateLayoutStateNeeded |= 8;
                BasicListUI.this.redrawList();
            } else if (string.equals("cellRenderer")) {
                BasicListUI.this.updateLayoutStateNeeded |= 0x40;
                BasicListUI.this.redrawList();
            } else if (string.equals("selectionForeground")) {
                BasicListUI.this.list.repaint();
            } else if (string.equals("selectionBackground")) {
                BasicListUI.this.list.repaint();
            }
        }
    }

    private abstract class ListAction
    implements ActionListener {
        protected ListAction(String string) {
        }

        public abstract void actionPerformed(ActionEvent var1);

        public boolean isEnabled() {
            return BasicListUI.this.list != null && BasicListUI.this.list.isEnabled();
        }
    }

    private class IncrementLeadSelectionAction
    extends ListAction {
        protected int amount;
        protected int selectionType;

        protected IncrementLeadSelectionAction(String string, int n) {
            this(string, n, -1);
        }

        protected IncrementLeadSelectionAction(String string, int n, int n2) {
            super(string);
            this.amount = n2;
            this.selectionType = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.getNextIndex();
            if (n >= 0 && n < BasicListUI.this.list.getModel().getSize()) {
                ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
                if (this.selectionType == 2) {
                    int n2 = listSelectionModel.getAnchorSelectionIndex();
                    if (n2 == -1) {
                        n2 = n;
                    }
                    BasicListUI.this.list.setSelectionInterval(n2, n);
                    listSelectionModel.setAnchorSelectionIndex(n2);
                    listSelectionModel.setLeadSelectionIndex(n);
                } else if (this.selectionType == 1) {
                    BasicListUI.this.list.setSelectedIndex(n);
                } else {
                    listSelectionModel.setLeadSelectionIndex(n);
                }
                this.ensureIndexIsVisible(n);
            }
        }

        protected void ensureIndexIsVisible(int n) {
            BasicListUI.this.list.ensureIndexIsVisible(n);
        }

        protected int getNextIndex() {
            int n = BasicListUI.this.list.getLeadSelectionIndex();
            int n2 = BasicListUI.this.list.getModel().getSize();
            if (n == -1) {
                if (n2 > 0) {
                    n = this.amount > 0 ? 0 : n2 - 1;
                }
            } else {
                n += this.amount;
            }
            return n;
        }
    }

    private class HomeAction
    extends IncrementLeadSelectionAction {
        protected HomeAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex() {
            return 0;
        }
    }

    private class EndAction
    extends IncrementLeadSelectionAction {
        protected EndAction(String string, int n) {
            super(string, n);
        }

        protected int getNextIndex() {
            return BasicListUI.this.list.getModel().getSize() - 1;
        }
    }

    private class PageUpAction
    extends IncrementLeadSelectionAction {
        protected PageUpAction(String string, int n) {
            super(string, n);
        }

        protected void ensureIndexIsVisible(int n) {
            Rectangle rectangle = BasicListUI.this.list.getVisibleRect();
            Rectangle rectangle2 = BasicListUI.this.list.getCellBounds(n, n);
            rectangle2.height = rectangle.height;
            BasicListUI.this.list.scrollRectToVisible(rectangle2);
        }

        protected int getNextIndex() {
            int n = BasicListUI.this.list.getFirstVisibleIndex();
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = BasicListUI.this.list.getVisibleRect();
                rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                n = BasicListUI.this.list.locationToIndex(rectangle.getLocation());
            }
            return n;
        }
    }

    private class PageDownAction
    extends IncrementLeadSelectionAction {
        protected PageDownAction(String string, int n) {
            super(string, n);
        }

        protected void ensureIndexIsVisible(int n) {
            Rectangle rectangle = BasicListUI.this.list.getVisibleRect();
            Rectangle rectangle2 = BasicListUI.this.list.getCellBounds(n, n);
            rectangle2.y = Math.max(0, rectangle2.y + rectangle2.height - rectangle.height);
            rectangle2.height = rectangle.height;
            BasicListUI.this.list.scrollRectToVisible(rectangle2);
        }

        protected int getNextIndex() {
            int n = BasicListUI.this.list.getLastVisibleIndex();
            ListSelectionModel listSelectionModel = BasicListUI.this.list.getSelectionModel();
            if (n == -1) {
                n = BasicListUI.this.list.getModel().getSize() - 1;
            }
            if (listSelectionModel.getLeadSelectionIndex() == n) {
                Rectangle rectangle = BasicListUI.this.list.getVisibleRect();
                rectangle.y += rectangle.height + rectangle.height - 1;
                n = BasicListUI.this.list.locationToIndex(rectangle.getLocation());
                if (n == -1) {
                    n = BasicListUI.this.list.getModel().getSize() - 1;
                }
            }
            return n;
        }
    }

    private class SelectAllAction
    extends ListAction {
        private SelectAllAction(String string) {
            super(string);
        }

        /* synthetic */ SelectAllAction(1 var2_2, String string) {
            this(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicListUI.this.list.setSelectionInterval(0, BasicListUI.this.list.getModel().getSize() - 1);
        }
    }

    private class ClearSelectionAction
    extends ListAction {
        private ClearSelectionAction(String string) {
            super(string);
        }

        /* synthetic */ ClearSelectionAction(1 var2_2, String string) {
            this(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicListUI.this.list.clearSelection();
        }
    }
}

