/* AddressBook - NewContactFrame
 * Copyright (C) 1999 Dmitry Rogatkin.  All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 *  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 *  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package addressbook;

import java.awt.event.*;
import java.awt.Container;
import java.awt.FlowLayout;

import javax.swing.*;
import javax.swing.table.AbstractTableModel;

import rogatkin.*;

public class NewContactFrame extends JFrame implements ActionListener {
    Contact contact;

    NewContactFrame() {
	super(AddressBookResources.TITLE_NEWCONTACT);
        JTabbedPane tabbedpane = new JTabbedPane(SwingConstants.TOP);
        tabbedpane.insertTab(AddressBookResources.TAB_GENERAL, (Icon)null,
            new GeneralTab(),
            AddressBookResources.TTIP_GENERALCONTACTINFO,
            0);
        tabbedpane.insertTab(AddressBookResources.TAB_DETAILS, (Icon)null,
            new DetailsTab(),
            AddressBookResources.TTIP_DETAILCONTACTINFO,
            1);
        // TODO: add tab For Memory
        // with: Gender, Spouse, Children, Birthday, Anniversary, University
        tabbedpane.insertTab(AddressBookResources.TAB_CERTIFICATES, (Icon)null,
            new CertificatesTab(),
            AddressBookResources.TTIP_CERTIFICATES,
            2);
        getContentPane().add(tabbedpane, "Center");
	getContentPane().add(createButtons(this), "South");
	pack();
	setVisible(true);
    }
    
    public JPanel createButtons(ActionListener al) {
	JButton btn;
        JPanel result = new JPanel();
        result.setLayout(new FlowLayout(FlowLayout.RIGHT));
        result.add(btn = new JButton(AddressBookResources.CMD_OK));
        btn.addActionListener(al);
        result.add(btn = new JButton(AddressBookResources.CMD_APPLY));
        btn.addActionListener(al);
        result.add(btn = new JButton(AddressBookResources.CMD_CANCEL));
        btn.addActionListener(al);
        return result;
    }

    public void actionPerformed(ActionEvent a) {
	String cmd = a.getActionCommand();
	if (AddressBookResources.CMD_OK.equals(cmd)) {
	    dispose();
	} else if (AddressBookResources.CMD_CANCEL.equals(cmd)) {
	    dispose();
	} else if (AddressBookResources.CMD_APPLY.equals(cmd)) {
	}
    }

    class GeneralTab extends JPanel {
	GeneralTab() {
	    setLayout(new GranulatedLayout(2, 10, AddressBookResources.CTRL_VERT_SIZE, AddressBookResources.CTRL_VERT_GAP,
		AddressBookResources.CTRL_HORIS_INSET, AddressBookResources.CTRL_HORIZ_GAP));
	    add(new JLabel(AddressBookResources.LABEL_NAME), "0,0,1");
	    add(tf_name = new JTextField(), "0,1,2");
            tb_emails = new JTable(new EmailsTableModel());
            add(new JScrollPane(tb_emails), "0,2,2,4,0,12");
	    tb_tphones = new JTable(new PnonesTableModel());
	    add(new JScrollPane(tb_tphones), "0,6,2,4,0,12");
	}
	
	JTextField tf_name;
	JTable tb_tphones, tb_emails;
	class EmailsTableModel extends AbstractTableModel {
	    String [][] emails = { {"Home", "home@hotmail.com"},
		{"Work", "george@intercompany.com"},
		{"Hobby", "sprut@georgia.org"},
	    {"New ", "name@domain.net"} };
	    
	    public String getColumnName(int column) {
		if (column == 1)
		    return "E-Mail";
		else
		    return "Abrev";
	    }

	    public int getRowCount() {
		return emails.length;

	    }

	    public int getColumnCount() {
		return 2;
	    }
	    
	    public Object getValueAt(int row, int column) {
		return emails[row][column];
	    }
	}
	
        class PnonesTableModel extends AbstractTableModel {
	    String [][] tel_phones = { {"Home", "238-3782"},
		{"Work", "238-8782"},
		{"Mobile", "288-3782"},
		{"Isdn", "258-3782"},
	    {"New ", "xxx-xxxx"} };
	    
	    public String getColumnName(int column) {
		if (column == 1)
		    return "Phone";
		else
		    return "Abrev";
	    }

	    public int getRowCount() {
		return tel_phones.length;

	    }

	    public int getColumnCount() {
		return 2;
	    }
	    
	    public Object getValueAt(int row, int column) {
		return tel_phones[row][column];
	    }
	}
    }
    
    class DetailsTab extends JPanel implements ActionListener {
	DetailsTab() {
	    setLayout(new GranulatedLayout(4, 10, AddressBookResources.CTRL_VERT_SIZE, AddressBookResources.CTRL_VERT_GAP,
		AddressBookResources.CTRL_HORIS_INSET, AddressBookResources.CTRL_HORIZ_GAP));
	    add(new JLabel(AddressBookResources.LABEL_ADDRESSES), "0,0,2");
	    add(tf_name = new JTextField(), "3,1");
            JButton b;
            add(b = new JButton(AddressBookResources.CMD_ADD), "3,2,1"); // only graphical button for add/modify a new addr
            b.addActionListener(this);
            add(b = new JButton(AddressBookResources.CMD_MODIFY), "3,3,1"); // only graphical button for add/modify a new addr
            b.addActionListener(this);
            add(b = new JButton(AddressBookResources.CMD_DELETE), "3,4,1"); // only graphical button for add/modify a new addr
            b.addActionListener(this);
            // TODO: add it to tabbed pane to specify many addresses, like home, company, parents, friend
            // button view map, follows to the link:
            // http://www.expediamaps.com/AddressFinder.asp?Street=230+Twin+Dolphin+Dr&City=Redwood+City&State=CA&Zip=94065
            add(addrs = new TabbedArrayOfComponents(JTabbedPane.BOTTOM) {
		JComponent produce() {
		return new JTextArea();
		}
	    }, "0,1,3,4");
            add(new JLabel(AddressBookResources.LABEL_PHOTO), "0,5,1");
            add(new JLabel(AddressBookResources.LABEL_COMMENT), "0,9,1");
            // TODO: add WEB pages, Chat pgm Ids/IPs
                        
                    
        }
        public void actionPerformed(ActionEvent a) {
            String cmd = a.getActionCommand();
            if (AddressBookResources.CMD_ADD.equals(cmd)) {
                addrs.addElement(tf_name.getText());
		tf_name.setText("");
            } else if (AddressBookResources.CMD_MODIFY.equals(cmd)) {
                addrs.modifyElement(tf_name.getText());
		tf_name.setText("");
            } else if (AddressBookResources.CMD_DELETE.equals(cmd)) {
                addrs.deleteElement();
            }
        }
        
        TabbedArrayOfComponents addrs;
        JTextField tf_name;
    }

    abstract class TabbedArrayOfComponents extends JTabbedPane {

	TabbedArrayOfComponents(int tabPlacement) {
	    super(tabPlacement);
	}

	abstract JComponent produce();

	void addElement(String name) {
            if (indexOfTab(name) > 0) {
                setSelectedIndex(indexOfTab(name));
                return;
            }
            addTab(name, produce());
	}
	
	void modifyElement(String name, String newname) {
            int i = indexOfTab(name);
            if (i >= 0)
                setTitleAt(i, newname);
	}
	
        void modifyElement(String newname) {
            int i = getSelectedIndex();
            if (i >= 0)
                setTitleAt(i, newname);
        }
        
        void deleteElement() {
            int i = getSelectedIndex();
            if (i >= 0)
                removeTabAt(i);
        }

	void deleteElement(String name) {
            int i = indexOfTab(name);
            if (i >= 0)
                removeTabAt(i);
	}

	JComponent getElement(String name) {
            int i = indexOfTab(name);
            if (i < 0)
                return null;
	    return (JComponent)getComponentAt(i);
	}
    }
    
    class CertificatesTab extends JPanel {
    }
}