/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;

public class FileNameFormat
extends Format {
    public static int counter;
    public static String timemask;
    public static String datemask;
    public static Object[] transformCodes;
    final int TEXT = 0;
    final int ESC = 1;
    final char PERCENT = (char)37;
    private String mask;
    private int rotation;
    private boolean inccount;

    public FileNameFormat(String string) {
        this(string, false);
    }

    public FileNameFormat(String string, boolean bl) {
        this.mask = string;
        this.inccount = bl;
    }

    public FileNameFormat(String string, int n) {
        this(string);
        this.rotation = n;
    }

    public FileNameFormat(String string, int n, boolean bl) {
        this(string, bl);
        this.rotation = n;
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        AbstractImageInfo abstractImageInfo = null;
        long l = 0L;
        try {
            abstractImageInfo = ((BasicJpeg)object).getImageInfo();
            l = new File(((BasicJpeg)object).getLocationName()).length();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int n = 0;
        String string = "";
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = 0;
        while (n2 < this.mask.length()) {
            char c = this.mask.charAt(n2);
            block2 : switch (n) {
                case 0: {
                    if (c != '%') {
                        stringBuffer2.append(c);
                        break;
                    }
                    n = 1;
                    break;
                }
                case 1: {
                    n = 0;
                    switch (c) {
                        case 'D': {
                            DateFormat dateFormat = datemask == null || datemask.length() == 0 || timemask == null || timemask.length() == 0 ? DateFormat.getDateTimeInstance(3, 3) : new SimpleDateFormat(datemask + timemask);
                            if (abstractImageInfo == null) {
                                stringBuffer2.append(dateFormat.format(new Date()));
                                break block2;
                            }
                            stringBuffer2.append(dateFormat.format(abstractImageInfo.getDateTimeOriginal()));
                            break block2;
                        }
                        case 'd': {
                            DateFormat dateFormat = datemask == null || datemask.length() == 0 ? DateFormat.getDateInstance(3) : new SimpleDateFormat(datemask);
                            if (abstractImageInfo == null) {
                                stringBuffer2.append(dateFormat.format(new Date()));
                                break block2;
                            }
                            stringBuffer2.append(dateFormat.format(abstractImageInfo.getDateTimeOriginal()));
                            break block2;
                        }
                        case 't': {
                            DateFormat dateFormat = timemask == null || timemask.length() == 0 ? DateFormat.getTimeInstance(3) : new SimpleDateFormat(timemask);
                            if (abstractImageInfo == null) {
                                stringBuffer2.append(dateFormat.format(new Date()));
                                break block2;
                            }
                            stringBuffer2.append(dateFormat.format(abstractImageInfo.getDateTimeOriginal()));
                            break block2;
                        }
                        case 's': {
                            try {
                                stringBuffer2.append(abstractImageInfo.getShutter().toString());
                            }
                            catch (NullPointerException nullPointerException) {}
                            break block2;
                        }
                        case 'a': {
                            if (abstractImageInfo == null) break block2;
                            stringBuffer2.append(abstractImageInfo.getFNumber());
                            break block2;
                        }
                        case 'f': {
                            if (abstractImageInfo == null) break block2;
                            stringBuffer2.append(abstractImageInfo.isFlash() ? "Yes" : "No");
                            break block2;
                        }
                        case 'q': {
                            if (abstractImageInfo == null) break block2;
                            stringBuffer2.append(abstractImageInfo.getQuality());
                            break block2;
                        }
                        case 'c': {
                            if (string.length() > 0) {
                                string = string + '0';
                            }
                            stringBuffer2.append(new DecimalFormat(string).format(counter));
                            string = "";
                            break block2;
                        }
                        case 'o': {
                            if (abstractImageInfo != null) {
                                stringBuffer2.append(abstractImageInfo.getName());
                                break block2;
                            }
                            new File(((BasicJpeg)object).getLocationName()).getName();
                            break block2;
                        }
                        case 'r': {
                            stringBuffer2.append((String)transformCodes[this.rotation]);
                            break block2;
                        }
                        case 'S': {
                            stringBuffer2.append(l);
                            break block2;
                        }
                        case 'z': {
                            if (abstractImageInfo == null) break block2;
                            stringBuffer2.append(abstractImageInfo.getFocalLength());
                            break block2;
                        }
                        case 'm': {
                            if (abstractImageInfo == null) break block2;
                            stringBuffer2.append(abstractImageInfo.getModel());
                            break block2;
                        }
                        case 'M': {
                            if (abstractImageInfo == null) break block2;
                            stringBuffer2.append(abstractImageInfo.getMake());
                            break block2;
                        }
                        case '0': {
                            string = string + '0';
                            n = 1;
                            break block2;
                        }
                        case '%': {
                            stringBuffer2.append(c);
                            break block2;
                        }
                    }
                    stringBuffer2.append('%');
                    stringBuffer2.append(c);
                }
            }
            ++n2;
        }
        if (this.inccount) {
            ++counter;
        }
        return stringBuffer2;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        return null;
    }

    public static String makeValidPathName(String string) {
        return FileNameFormat.makeValidPathName(string, null);
    }

    public static String makeValidPathName(String string, String string2) {
        string = string.replace('/', '-');
        string = string.replace('\\', '-');
        string = string.replace(':', '_');
        string = string.replace(File.pathSeparatorChar, '-');
        string = string.replace('*', '_');
        string = string.replace('?', '_');
        if ((string = string.replace(' ', '_')).indexOf(46) < 0 && string2 != null) {
            string = string + '.' + string2;
        }
        return string;
    }
}

