#ifndef MAIN_H
#define MAIN_H

#include <qstring.h>
#include <qobject.h>
#include <qwidget.h>
#include <qpixmap.h>

#include "quat.h"   // also includes common.h

#define stringlength 1024

class QCmds : public QObject
{
   Q_OBJECT
public:
   QCmds(QObject* parent=0, const char* name = 0);
   void SetScrollBars();
   void SetMenuState();
   void DoImgOpen(const char *givenfile, int zflag);
   void DoSaveParamsAs(const char *def_suffix, unsigned char mode);
   void Backup();
   void Restore();
   static int QT_ReturnVideoInfo(struct vidinfo_struct *vidinfo);
   static int QT_SetColors(struct disppal_struct *disppal);
   static int QT_Initialize(int x, int y, char *Error);
   static int QT_Done();
   static int QT_update_bitmap(long x1, long x2, long xres, int y, unsigned char *Buf, int which);
   static int QT_getline(unsigned char *line, int y, long xres, int whichbuf);
   static int QT_putline(long x1, long x2, long xres, int y, unsigned char *Buf, int whichbuf);
   static int QT_check_event();
   static int QT_Change_Name(const char *s);
   static void QT_Debug(char *s);
   static void QT_eol(int line);
   static void QT_eol_4(int line);
   struct frac_struct frac, _f;
   struct view_struct view, _v;
   struct realpal_struct realpal, _r;
   char colscheme[251], _col[251];
   double cutbuf[140], _cut[140];
public slots:
   void ImageOpen();
   int ImageClose();
   void ImageSave();
   void ImageSaveAs();
   void ImageAdjustWindow();
   void ImageAbout();
   void Exit();
   void CalculationStartImage();
   void CalculationStartZBuf();
   void CalculationStop();
   void ParametersReset();
   void ParametersReadINI();
   void ParametersReadPNG();
   void ParametersSaveAs();
   void ParametersObjectEditor();
   void ParametersViewEditor();
   void ParametersColorEditor();
   void ParametersIntersectionEditor();
   void ParametersOther();
   void ZBufferOpen();
   int ZBufferClose();
   void ZBufferSave();
   void ZBufferSaveAs();
private:
   int DoImgClose();
   int DoZBufClose();
   void DoStartCalc(char zflag);
   int DoInitMem(int x, int y, char *Error, char zbuf);
   // _* variables for backup purposes
   bool ImgInMem, ZBufInMem, ImgChanged, ZBufChanged, 
      ImgReady, ZBufReady, InCalc;
   int imgxstart, imgystart, zbufxstart, zbufystart;
};
#endif
