// Win3DFView.cpp : implementation of the CWin3DFView class
//

#include "stdafx.h"
#include "Win3DF.h"
#include "Win3DFDoc.h"
#include "Win3DFView.h"
#include "WinPlot3DF.h"
#include "DlgEditPlotF.h"
#include "DlgWinResize.h"
#include "DlgGetStart.h"
#include "DlgIntro.h"
#include "DlgTips.h"
#include "DlgHiddenLine.h"
#include "DlgHelpParm.h"
#include "DlgCppProgram.h"

#define	INITIAL_WINDOW_SIZE		300

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern	CWin3DFApp theApp;	// access the windows application

/////////////////////////////////////////////////////////////////////////////
// CWin3DFView

IMPLEMENT_DYNCREATE(CWin3DFView, CView)

BEGIN_MESSAGE_MAP(CWin3DFView, CView)
	//{{AFX_MSG_MAP(CWin3DFView)
	ON_COMMAND(ID_DRAW_PLOT, OnDrawPlot)
	ON_COMMAND(ID_RESIZE_WINDOW, OnResizeWindow)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	ON_COMMAND(ID_HELP_GETTINGSTARTED, OnHelpGettingstarted)
	ON_COMMAND(ID_HELP_HIDDENLINEREMOVAL, OnHelpHiddenlineremoval)
	ON_COMMAND(ID_HELP_INTRODUCTION, OnHelpIntroduction)
	ON_COMMAND(ID_HELP_PLOTPARAMETERS, OnHelpPlotparameters)
	ON_COMMAND(ID_HELP_TIPS, OnHelpTips)
	ON_COMMAND(ID_HELP_CPROGRAMMING, OnHelpCprogramming)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWin3DFView construction/destruction

CWin3DFView::CWin3DFView()
{
	m_is_drawn = 0;

	char* pName=0;
	pName = _tempnam( "", "p3d" );
	if(pName == NULL)
	{
		pName = "p3d";
	}
	m_fn_cap = CString(pName) + CString(".tmp");
	m_abort_plotting = 0;
}

CWin3DFView::~CWin3DFView()
{
	remove((LPCTSTR)m_fn_cap);	// remove the scratch file
}

BOOL CWin3DFView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CWin3DFView drawing

void CWin3DFView::OnDraw(CDC* pDC)
{
	if (!m_is_drawn) return;
	FILE* fh;
	char ReadBuf[100];
	char TextBuf[100];
	char FontNameBuf[100];
	int	is_color=0,xv,yv,it1,it2;
	char* pStr;
	long color=1, ltemp, ltemp2, ltemp3;

	// get window size
	RECT rect;
	GetClientRect(&rect);
	CSize wsize = CSize(rect.right-rect.left, rect.bottom-rect.top);

	// rescale for printer
	if (pDC->IsPrinting())
	{
		CWnd* pdcWnd = pDC->GetWindow();
		if (pdcWnd)
		{
			pdcWnd->GetClientRect(&rect);
			wsize = CSize(rect.right-rect.left, rect.bottom-rect.top);
		}
	}

	// set mapping mode and view port extents
	pDC->SetMapMode(MM_ISOTROPIC);
	pDC->SetWindowOrg(0,wsize.cy);
	pDC->SetWindowExt(wsize);
	pDC->SetViewportExt(wsize);
	pDC->ScaleViewportExt(1,1,-1,1);	// invert y coordinate

	// open the drawing command file
	fh = fopen((LPCTSTR)m_fn_cap,"r");
	if (fh==0) return;
	memset(ReadBuf,0,sizeof(ReadBuf));
	fgets(ReadBuf,sizeof(ReadBuf)-1,fh);
	if (memcmp(ReadBuf,PLOT3D_FILE_SIG,strlen(PLOT3D_FILE_SIG)) != 0) { fclose(fh); return; }
	pStr = &ReadBuf[strlen(PLOT3D_FILE_SIG)+1];
	if (memcmp(pStr,PLOT3D_COLOR_MODE,strlen(PLOT3D_COLOR_MODE)) == 0) is_color=1;

	// interpret drawing commands from file
	while( !feof(fh) )
	{
		memset(ReadBuf,0,sizeof(ReadBuf));
		fgets(ReadBuf,sizeof(ReadBuf)-1,fh);
		if (ReadBuf[0] == 'S')
		{
			// "S=%ld,%ld"  background,pencolor
			if (sscanf(&ReadBuf[2],"%ld,%ld",&ltemp, &ltemp2) != EOF)
			{
				// clear screen to background color
				RECT rect;
				GetClientRect(&rect);
				pDC->FillSolidRect(&rect,ltemp);

				// set pen color
				CPen* pOldPen;
				CPen Pen(PS_SOLID,1,ltemp2);		// construct a pen with the desired color
		        pOldPen = pDC->SelectObject(&Pen);	// select the pen into the device context
			}
		}
		else if (ReadBuf[0] == 'C')	// color
		{
			// "C=%-12d\n"
			if (sscanf(&ReadBuf[2],"%d",&ltemp) != EOF) color = ltemp;
		}
		else if (ReadBuf[0] == 'M')	// move
		{
			// "M=%6d,%6d\n"
			if (sscanf(&ReadBuf[2],"%6d,%6d",&it1,&it2) != EOF)
			{
				xv = it1;
				yv = it2;
				pDC->MoveTo(xv,yv);
			}
		}
		else if (ReadBuf[0] == 'D')	// draw
		{
			// "D=%6d,%6d\n"
			if (sscanf(&ReadBuf[2],"%6d,%6d",&it1,&it2) != EOF)
			{
				xv = it1;
				yv = it2;

				if (is_color)
				{
					CPen* pOldPen;
					CPen Pen(PS_SOLID,1,color);	// construct a pen with the desired color
			        pOldPen = pDC->SelectObject(&Pen);	// select the pen into the device context
					pDC->LineTo(xv,yv);		   	// draw the colored line
			        pDC->SelectObject(pOldPen);	// restore the original pen
				}
				else
				{
					// just draw the line if in monochrome mode
					pDC->LineTo(xv,yv);
				}
			}
		}
		else if (ReadBuf[0] == 'T')	// text
		{
			// "T=%6d,%6d,%ld,%ld,%ld,%s,%s\n",
			if (sscanf(&ReadBuf[2],"%6d,%6d,%ld,%ld,%ld,%s %s",&it1,&it2,&ltemp,&ltemp2,&ltemp3,FontNameBuf,TextBuf) != EOF)
			{
				xv = it1;
				yv = it2;

				// setup font info
				LOGFONT logFont;
				memset((char*)&logFont,0,sizeof(logFont));
				strcpy(logFont.lfFaceName,FontNameBuf);
				logFont.lfHeight = ltemp;
				logFont.lfWidth  = ltemp2;
				logFont.lfEscapement = ltemp3;
		
				// create a rotated font
				CFont rotFont;
				rotFont.CreateFontIndirect(&logFont);
		
				// output the text
				pDC->SelectObject(rotFont);
				// ### show text in m_line_color
				pDC->TextOut(xv,yv,CString(TextBuf));
			}
		}

	} // while
	fclose(fh);
}

/////////////////////////////////////////////////////////////////////////////
// CWin3DFView diagnostics

#ifdef _DEBUG
void CWin3DFView::AssertValid() const
{
	CView::AssertValid();
}

void CWin3DFView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CWin3DFDoc* CWin3DFView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWin3DFDoc)));
	return (CWin3DFDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWin3DFView message handlers

void CWin3DFView::OnDrawPlot() 
{
	// create a plot object
	WinPlot3DF	 plot3D;

	// create a dialog box and allow user input
	DlgEditPlotF  dlg;
	dlg.AttachCalculator(plot3D.m_pPlotCalc);
	if (dlg.DoModal()!=IDOK)
		return;

	// get clients rectangle size
	GetClientRect(&m_plot_rect);

	// set plot object parameters from dialog info
	plot3D.SetWnd(this,&theApp);
	plot3D.SetRanges(dlg.m_xmin,dlg.m_xmax,dlg.m_ymin,dlg.m_ymax,dlg.m_zmin,dlg.m_zmax);
	plot3D.SetViewingPosition(dlg.m_xytilt,dlg.m_zrotate);
	plot3D.SetParameters(dlg.m_nzplanes,dlg.m_remove_hidden_lines);
	plot3D.SetVideoRes((int)m_plot_rect.left,(int)m_plot_rect.top,(int)m_plot_rect.right,(int)m_plot_rect.bottom,dlg.m_scale);
	plot3D.SetColorMode(dlg.m_is_color);
	plot3D.SetFileName(m_fn_cap);
	plot3D.SetAbortFlag(&m_abort_plotting);
	plot3D.SetAxisParameters(dlg.m_show_axis);
	plot3D.SetMonochromePen(dlg.m_line_color);
	plot3D.SetBackgroundColor(dlg.m_background_color);
	plot3D.SetSphereRange(dlg.m_use_sphere_range?1:0,dlg.m_sphere_radius,dlg.m_sphere_xcenter,dlg.m_sphere_ycenter,dlg.m_sphere_zcenter);
	plot3D.SetParametric(dlg.m_plot_mode?1:0,0,0,0,0,0,0,0,0);
	plot3D.SetClipMode(dlg.m_clip_mode,dlg.m_is_clip_inverted);

	// draw the plot
	m_is_drawn = 0;
	m_abort_plotting = 0;
	CWaitCursor wait;	// put up hour glass
	if (plot3D.Plot()==0) m_is_drawn = 1;
}

void CWin3DFView::OnResizeWindow() 
{
	DlgWinResize dlg;
	if (dlg.DoModal()!=IDOK || !dlg.IsSizeSet())
		return;

	GetParent()->MoveWindow(0,0,dlg.m_WinCols,dlg.m_WinRows,TRUE);
}

void CWin3DFView::OnEditCopy() 
{
	CDC memdc;
	CDC* dc = GetDC();
	HBITMAP hBitmap;      
	BITMAP bm;
	BOOL bval;
	RECT wrect;
	int	nWidth, nHeight;
	int rc2; 

 	// create a bitmap from the window contents
	GetClientRect(&wrect);
	nWidth  = wrect.right  - wrect.left;
	nHeight = wrect.bottom - wrect.top;
  	bval = memdc.CreateCompatibleDC(NULL);
  	hBitmap = CreateCompatibleBitmap(dc->m_hDC, nWidth, nHeight);
	SelectObject(memdc.m_hDC,hBitmap);
	rc2 = memdc.SetStretchBltMode(STRETCH_DELETESCANS); 
	bval = memdc.StretchBlt(0,0,nWidth,nHeight,dc,0,0,nWidth,nHeight,SRCCOPY);
	rc2 = GetObject(hBitmap,sizeof(bm),&bm);
	
	// Open the clipboard
	if (OpenClipboard())
	{
		// Clean the contents of the clipboard
		bval = EmptyClipboard();

	 	// ----- put data to the clipboard data -----
	 	SetClipboardData(CF_BITMAP, hBitmap);

  		// Close the clipboard
	 	bval = CloseClipboard();
	}
	else
	{
		AfxMessageBox( "Clipboard unavailable" );
	}
}

void CWin3DFView::OnHelpGettingstarted() 
{
	CDlgGettingStarted dlg;
	dlg.DoModal();
}

void CWin3DFView::OnHelpHiddenlineremoval() 
{
	CDlgHiddenLine dlg;
	dlg.DoModal();
}

void CWin3DFView::OnHelpIntroduction() 
{
	CDlgIntro dlg;
	dlg.DoModal();
}

void CWin3DFView::OnHelpPlotparameters() 
{
	CDlgHelpParm dlg;
	dlg.DoModal();
}

void CWin3DFView::OnHelpTips() 
{
	CDlgTips dlg;
	dlg.DoModal();
}

void CWin3DFView::OnHelpCprogramming() 
{
	CDlgCppProgram dlg;
	dlg.DoModal();
}

void CWin3DFView::OnInitialUpdate() 
{
	CView::OnInitialUpdate();

	GetParent()->MoveWindow(0,0,INITIAL_WINDOW_SIZE,INITIAL_WINDOW_SIZE,TRUE);
}
