#!/usr/local/bin/perl
use Dislin;

$nx = 20;
$ny = 20;
$nz = 20;

$stepx = 2. / ($nx - 1);
for ($i = 0; $i < $nx; $i++) {
    $x[$i] = -1.0 + $i * $stepx;
}

$stepy = 2. / ($ny - 1);
for ($i = 0; $i < $ny; $i++) {
    $y[$i] = -1.0 + $i * $stepy;
}

$stepz = 2. / ($nz - 1);
for ($i = 0; $i < $nz; $i++) {
    $z[$i] = -1.0 + $i * $stepz;
}

for ($i = 0; $i < $nx; $i++) {
    $x2 = $x[$i] * $x[$i];
    for ($j = 0; $j < $ny; $j++) {
        $y2 = $y[$j] * $y[$j];
        for ($k = 0; $k < $nz; $k++) {
          $z2 = $z[$k] * $z[$k];
          $wmat[$i][$j][$k] = sqrt ($x2 + $y2 + $z2);
        }
    }
}

Dislin::metafl ('cons');
Dislin::scrmod ('revers');
Dislin::disini ();
Dislin::complx ();
Dislin::setvlt ('grey');
Dislin::pagera ();
Dislin.titlin  ('Isosurface Plot', 4);
Dislin.name    ('X-axis', 'x');
Dislin.name    ('Y-axis', 'y');
Dislin.name    ('Z-axis', 'z');
Dislin::graf3d (-1.,1.,-1.,0.5,-1.,1.,-1.,0.5,-1.,1.,-1.,1.);

Dislin::light  ('on');
Dislin::suriso (\@x, $nx, \@y, $ny, \@z, $nz, \@wmat, 1.0);

Dislin.height  (50);
Dislin::title  ();
Dislin::disfin ();





