// DlgExportPOV.cpp : implementation file
//

#include "stdafx.h"
#include "io.h"
#include "Win3DP.h"
#include "DlgExportPOV.h"
#include "DlgHelpExport.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgExportPOV dialog


CDlgExportPOV::CDlgExportPOV(CWnd* pParent /*=NULL*/, CString sObjectName)
	: CDialog(CDlgExportPOV::IDD, pParent)
{
	m_sPovObjectName = sObjectName;
	//{{AFX_DATA_INIT(CDlgExportPOV)
	//}}AFX_DATA_INIT
}

// ------------------------------------------------------
void CDlgExportPOV::SetDefaults()
{
 	UpdateData(FALSE);	// load these values into the dialog
	// Note: don't set object name
	m_sPovFilePath    = _T(POV_DEFAULT_FILENAME);
	m_sPovTextureName = _T(POV_DEFAULT_TEXTURE);
	m_is_smooth = 1;
	m_is_color  = 1;
	AppendPovExtension();
}

// ------------------------------------------------------------------------
void CDlgExportPOV::SaveToRegistry()
{
	HKEY hkey = 0;

	// open registry
	if (OpenReg(GetExportRegPath(),1,&hkey)!=0) return;

	// save the surface parameters
 	UpdateData(TRUE);	// get values from dialog
	AppendPovExtension();
 	SetRegStr   (hkey, "PovFilePath",     m_sPovFilePath);
 	SetRegStr   (hkey, "PovTexture",      m_sPovTextureName);
	SetRegInt   (hkey, "SmoothTriangles", m_is_smooth);
	SetRegInt   (hkey, "ShowColor",       m_is_color);
	CloseReg(hkey);
}

/////////////////////////////////////////////////////////////////////////////
int  CDlgExportPOV::GetFromRegistry()
{
	HKEY hkey = 0;
	char TempBuf[200];

	// open registry
	if (OpenReg(GetExportRegPath(),1,&hkey)!=0) return(1);

	// get export POV parameters
 	UpdateData(FALSE);	// load these values into the dialog
	if(GetRegStr(hkey, "PovFilePath",   TempBuf,sizeof(TempBuf)) == 0) m_sPovFilePath    = TempBuf;
	if(GetRegStr(hkey, "PovTexture",    TempBuf,sizeof(TempBuf)) == 0) m_sPovTextureName = TempBuf;
	GetRegInt   (hkey, "SmoothTriangles", &m_is_smooth);
	GetRegInt   (hkey, "ShowColor",       &m_is_color);
	CloseReg(hkey);
	AppendPovExtension();
	return(0);
}

// ------------------------------------------------------
void CDlgExportPOV::AppendPovExtension()
{
	if (m_sPovFilePath.Find('.')<0) // check for period (ie extension)
	{
		// add pov extension if none was entered
		m_sPovFilePath += ".";
		m_sPovFilePath += POV_FILE_EXTENSION;
	}
}

// ------------------------------------------------------
// create a string path for the export registry
CString CDlgExportPOV::GetExportRegPath()
{
	CString sHive = PLOT_REGISTRY_HIVE;
	sHive += "\\";
	sHive += EXPORT_HIVE_SUBDIR;
	sHive += "\\";
	sHive += POV_FILE_EXTENSION;
	return(sHive);
}

// ------------------------------------------------------
void CDlgExportPOV::UpdateDialogState()
{
 	UpdateData(FALSE); // load values into dialog
	// set radio buttons
	CButton	*pBtn;
	// basic triangles
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_POV_BASIC_TRIANGLES);
	if (pBtn) pBtn->SetCheck(!m_is_smooth);
	// smooth triangles
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_POV_SMOOTH_TRIANGLES);
	if (pBtn) pBtn->SetCheck(m_is_smooth);

	// monochrome
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_POV_PIGMENT_MONO);
	if (pBtn) pBtn->SetCheck(!m_is_color);
	// color
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_POV_PIGMENT_COLOR);
	if (pBtn) pBtn->SetCheck(m_is_color);
	AppendPovExtension();
}

// ------------------------------------------------------
void CDlgExportPOV::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgExportPOV)
	DDX_Text(pDX, IDC_EDIT_POV_TEXTURE_NAME, m_sPovTextureName);
	DDX_Text(pDX, IDC_EDIT_EXPORT_POV_OBJECT_NAME, m_sPovObjectName);
	DDX_Text(pDX, IDC_EDIT_EXPORT_POV_FILENAME, m_sPovFilePath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgExportPOV, CDialog)
	//{{AFX_MSG_MAP(CDlgExportPOV)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_RADIO_POV_BASIC_TRIANGLES, OnRadioPovBasicTriangles)
	ON_BN_CLICKED(IDC_RADIO_POV_PIGMENT_COLOR, OnRadioPovPigmentColor)
	ON_BN_CLICKED(IDC_RADIO_POV_PIGMENT_MONO, OnRadioPovPigmentMono)
	ON_BN_CLICKED(IDC_RADIO_POV_SMOOTH_TRIANGLES, OnRadioPovSmoothTriangles)
	ON_BN_CLICKED(IDC_BUTTON_POV_FILE_FOLDER, OnButtonPovBrowseFile)
	ON_BN_CLICKED(IDC_BUTTON_POV_HELP, OnButtonPovHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgExportPOV message handlers

BOOL CDlgExportPOV::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// initialize data
	SetDefaults();
	GetFromRegistry();
	// update dialog to reflect state
	UpdateDialogState();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

// ------------------------------------------------------
void CDlgExportPOV::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	UpdateDialogState();
}

// ------------------------------------------------------
void CDlgExportPOV::OnRadioPovBasicTriangles() 
{
	m_is_smooth = 0;
	UpdateDialogState();
}

void CDlgExportPOV::OnRadioPovSmoothTriangles() 
{
	m_is_smooth = 1;
	UpdateDialogState();
}

void CDlgExportPOV::OnRadioPovPigmentMono() 
{
	m_is_color = 0;
	UpdateDialogState();
}

void CDlgExportPOV::OnRadioPovPigmentColor() 
{
	m_is_color = 1;
	UpdateDialogState();
}

// ------------------------------------------------------
// allow operator to browse for file
void CDlgExportPOV::OnButtonPovBrowseFile() 
{
	static char szFilter[] = "POV Files (*.pov;*.inc)|*.pov;*.inc||";

	CFileDialog dlg(FALSE,POV_FILE_EXTENSION,(LPCTSTR)m_sPovFilePath,
		OFN_LONGNAMES | OFN_NOREADONLYRETURN | OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
		szFilter,this);
	if (dlg.DoModal() != IDOK) return;

 	UpdateData(FALSE);	// load these values into the dialog
	m_sPovFilePath = dlg.GetPathName();
	AppendPovExtension();
	Invalidate();
}

// ------------------------------------------------------
void CDlgExportPOV::OnCancel() 
{
	CDialog::OnCancel();
}

void CDlgExportPOV::OnOK() 
{
 	UpdateData(TRUE);	// get values from dialog
	// warn if file exists
	if ( _access((LPCTSTR)m_sPovFilePath,0) == 0)
	{
		CString msg;
		msg.Format("File [%s] exists. Over-write?", (LPCTSTR)m_sPovFilePath);
		if (AfxMessageBox((LPCTSTR)msg, MB_OKCANCEL) != IDOK) return;
	}
	SaveToRegistry();	
	CDialog::OnOK();
}

// ------------------------------------------------------
void CDlgExportPOV::OnButtonPovHelp() 
{
	DlgHelpExport dlg;
	dlg.DoModal();
}

// ------------------------------------------------------
