/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import photoorganizer.Controller;
import photoorganizer.PhotoPlugin;
import photoorganizer.renderer.AlbumOptionsTab;
import photoorganizer.renderer.MiscellaneousOptionsTab;
import photoorganizer.renderer.PluginOptionsTab;
import photoorganizer.renderer.RenameOptionsTab;
import photoorganizer.renderer.ThumbnailsOptionsTab;
import photoorganizer.renderer.TransformOptionsTab;
import photoorganizer.renderer.WebPublishOptionsTab;
import rogatkin.Persistentable;

public class OptionsFrame
extends JFrame
implements ActionListener,
Persistentable {
    Controller controller;

    public OptionsFrame(Controller controller) {
        super("Options");
        this.controller = controller;
        ((Frame)this).setIconImage(controller.getMainIcon());
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.insertTab("Rename", null, new RenameOptionsTab(controller), "Specify a rule for renaming images", 0);
        jTabbedPane.insertTab("Transform", null, new TransformOptionsTab(controller), "Specify options for trnsformation images", 1);
        jTabbedPane.insertTab("Thumbnails", null, new ThumbnailsOptionsTab(controller), "Specify thumbnails panel options", 2);
        jTabbedPane.insertTab("Miscellaneous", null, new MiscellaneousOptionsTab(controller), "Specify misc options concerning layout", 3);
        jTabbedPane.insertTab("Album", null, new AlbumOptionsTab(controller), "Setting album options, includimg database settings", 4);
        jTabbedPane.insertTab("WebPublishing", null, new WebPublishOptionsTab(controller), "Web root and Ftp settings", 5);
        jTabbedPane.insertTab("Plug-ins", null, new PluginOptionsTab(controller), "Adding, editing, and removing plug-ins", 6);
        Enumeration enumeration = controller.names();
        int n = 7;
        while (enumeration.hasMoreElements()) {
            try {
                PhotoPlugin photoPlugin = (PhotoPlugin)((Object)controller.component(enumeration.nextElement()));
                JPanel jPanel = photoPlugin.getOptionsTab();
                if (jPanel == null) continue;
                jTabbedPane.insertTab(photoPlugin.getName(), null, jPanel, photoPlugin.getName(), n++);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)Controller.createButtonPanel(this), "South");
        this.pack();
        ((Component)this).setVisible(true);
        this.load();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.save();
            ((Component)this).setVisible(false);
        } else if (string.equals("<html><i>Apply")) {
            this.save();
        } else if (string.equals("Cancel")) {
            ((Component)this).setVisible(false);
        }
    }

    public void load() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.getContentPane().getComponent(0);
        int n = 0;
        while (n < jTabbedPane.getTabCount()) {
            try {
                ((Persistentable)((Object)jTabbedPane.getComponentAt(n))).load();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void save() {
        JTabbedPane jTabbedPane = (JTabbedPane)this.getContentPane().getComponent(0);
        int n = 0;
        while (n < jTabbedPane.getTabCount()) {
            try {
                ((Persistentable)((Object)jTabbedPane.getComponentAt(n))).save();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++n;
        }
    }
}

