//----------------------------------------------------------
#define __TRACE
#include <checks.h>
//----------------------------------------------------------
#include <fstream.h>
#include <dstring.h>
//----------------------------------------------------------
#include <mapicode.h>
#include <d3drmwin.h>
//----------------------------------------------------------
#pragma hdrstop
#include "D3dInOut.h"
#include "D3dUtil.h"
//----------------------------------------------------------
//  :
static fstream stream;
static HRESULT hr;
static bool IsFrames;
static TStrings *WrittenMeshes;
static LPDIRECT3DRM IRM;
static D3DRMSAVEOPTIONS SaveOptions;
//  :
static void tWriteFrameTemplates();
static void tWriteNamedMeshes();
static void tWriteFrameRecursion(LPDIRECT3DRMFRAME Iframe);
static void WriteMesh(LPDIRECT3DRMMESHBUILDER IBuilder);
static HRESULT tSaveFrame(LPDIRECT3DRMFRAME Iframe,
            const char *FileName, D3DRMSAVEOPTIONS Options);
//       X-Studio:
static void tWriteXStudioTemplates();
static void WriteLights(LPDIRECT3DRMFRAME Iframe);
static void WriteWraps(LPDIRECT3DRMFRAME Iframe);
static void ReadScene (char **ptr);
static void ReadLights(char **ptr);
static void ReadWraps (char **ptr);
static void SkipBlock (char **ptr);
static bool GetToken  (char **ptr, char*dst, int size,
                                              char delim=0);
//----------------------------------------------------------
HRESULT SaveFrame(LPDIRECT3DRMFRAME Iframe,
  const char *FileName,
  D3DRMXOFFORMAT Format, D3DRMSAVEOPTIONS Options)
{
  SaveOptions = Options;
  if (!Iframe) return (D3DRM_OK);
  if (Format == D3DRMXOF_TEXT)
     return (tSaveFrame(Iframe, FileName, Options));
  return (D3DRMERR_NOTDONEYET);
}//---------------------------------------------------------
static void tWriteMeshTemplates() {
stream <<
"template Header {" << endl <<
" <3D82AB43-62DA-11cf-AB39-0020AF71E433>" << endl <<
" WORD major;" << endl <<
" WORD minor;" << endl <<
" DWORD flags;" << endl <<
"}" << endl <<
endl <<
"template Vector {" << endl <<
" <3D82AB5E-62DA-11cf-AB39-0020AF71E433>" << endl <<
" FLOAT x;" << endl <<
" FLOAT y;" << endl <<
" FLOAT z;" << endl <<
"}" << endl <<
endl <<
"template Coords2d {" << endl <<
" <F6F23F44-7686-11cf-8F52-0040333594A3>" << endl <<
" FLOAT u;" << endl <<
" FLOAT v;" << endl <<
"}" << endl <<
endl <<
"template Matrix4x4 {" << endl <<
" <F6F23F45-7686-11cf-8F52-0040333594A3>" << endl <<
" array FLOAT matrix[16];" << endl <<
"}" << endl <<
endl <<
"template ColorRGBA {" << endl <<
" <35FF44E0-6C7C-11cf-8F52-0040333594A3>" << endl <<
" FLOAT red;" << endl <<
" FLOAT green;" << endl <<
" FLOAT blue;" << endl <<
" FLOAT alpha;" << endl <<
"}" << endl <<
endl <<
"template ColorRGB {" << endl <<
" <D3E16E81-7835-11cf-8F52-0040333594A3>" << endl <<
" FLOAT red;" << endl <<
" FLOAT green;" << endl <<
" FLOAT blue;" << endl <<
"}" << endl <<
endl <<
"template IndexedColor {" << endl <<
" <1630B820-7842-11cf-8F52-0040333594A3>" << endl <<
" DWORD index;" << endl <<
" ColorRGBA indexColor;" << endl <<
"}" << endl <<
endl <<
"template Boolean {" << endl <<
" <4885AE61-78E8-11cf-8F52-0040333594A3>" << endl <<
" WORD truefalse;" << endl <<
"}" << endl <<
endl <<
"template Boolean2d {" << endl <<
" <4885AE63-78E8-11cf-8F52-0040333594A3>" << endl <<
" Boolean u;" << endl <<
" Boolean v;" << endl <<
"}" << endl <<
endl <<
"template MaterialWrap {" << endl <<
" <4885AE60-78E8-11cf-8F52-0040333594A3>" << endl <<
" Boolean u;" << endl <<
" Boolean v;" << endl <<
"}" << endl <<
endl <<
"template TextureFilename {" << endl <<
" <A42790E1-7810-11cf-8F52-0040333594A3>" << endl <<
" STRING filename;" << endl <<
"}" << endl <<
endl <<
"template Material {" << endl <<
" <3D82AB4D-62DA-11cf-AB39-0020AF71E433>" << endl <<
" ColorRGBA faceColor;" << endl <<
" FLOAT power;" << endl <<
" ColorRGB specularColor;" << endl <<
" ColorRGB emissiveColor;" << endl <<
" [...]" << endl <<
"}" << endl <<
endl <<
"template MeshFace {" << endl <<
" <3D82AB5F-62DA-11cf-AB39-0020AF71E433>" << endl <<
" DWORD nFaceVertexIndices;" << endl <<
" array DWORD faceVertexIndices[nFaceVertexIndices];"
<< endl <<
"}" << endl <<
endl <<
"template MeshFaceWraps {" << endl <<
" <4885AE62-78E8-11cf-8F52-0040333594A3>" << endl <<
" DWORD nFaceWrapValues;" << endl <<
" Boolean2d faceWrapValues;" << endl <<
"}" << endl <<
endl <<
"template MeshTextureCoords {" << endl <<
" <F6F23F40-7686-11cf-8F52-0040333594A3>" << endl <<
" DWORD nTextureCoords;" << endl <<
" array Coords2d textureCoords[nTextureCoords];" << endl <<
"}" << endl <<
endl <<
"template MeshMaterialList {" << endl <<
" <F6F23F42-7686-11cf-8F52-0040333594A3>" << endl <<
" DWORD nMaterials;" << endl <<
" DWORD nFaceIndexes;" << endl <<
" array DWORD faceIndexes[nFaceIndexes];" << endl <<
" [Material]" << endl <<
"}" << endl <<
endl <<
"template MeshNormals {" << endl <<
" <F6F23F43-7686-11cf-8F52-0040333594A3>" << endl <<
" DWORD nNormals;" << endl <<
" array Vector normals[nNormals];" << endl <<
" DWORD nFaceNormals;" << endl <<
" array MeshFace faceNormals[nFaceNormals];" << endl <<
"}" << endl <<
endl <<
"template MeshVertexColors {" << endl <<
" <1630B821-7842-11cf-8F52-0040333594A3>" << endl <<
" DWORD nVertexColors;" << endl <<
" array IndexedColor vertexColors[nVertexColors];" << endl<<
"}" << endl <<
endl <<
"template Mesh {" << endl <<
" <3D82AB44-62DA-11cf-AB39-0020AF71E433>" << endl <<
" DWORD nVertices;" << endl <<
" array Vector vertices[nVertices];" << endl <<
" DWORD nFaces;" << endl <<
" array MeshFace faces[nFaces];" << endl <<
" [...]" << endl <<
"}" << endl <<
endl;
}//---------------------------------------------------------
static void tWriteFrameTemplates() {
  tWriteMeshTemplates();
stream <<
"template FrameTransformMatrix {" << endl <<
" <F6F23F41-7686-11cf-8F52-0040333594A3>" << endl <<
" Matrix4x4 frameMatrix;" << endl <<
"}" << endl <<
endl <<
"template Frame {" << endl <<
" <3D82AB46-62DA-11cf-AB39-0020AF71E433>" << endl <<
" [...]" << endl <<
"}" << endl <<
endl;
}//---------------------------------------------------------
static void tWriteXStudioTemplates() {
stream <<
"template XS_Light {" << endl <<
" <F3BBF980-7B14-11d1-BFE2-444553540000>" << endl <<
" STRING   FrameName;" << endl <<
" STRING   EnableFrameName;" << endl <<
" BYTE     LightType;" << endl <<
" Vector   Attenuation;" << endl <<
" ColorRGB Color;" << endl <<
" DOUBLE   Penumbra;" << endl <<
" DOUBLE   Range;" << endl <<
"}" << endl
<< endl;
stream <<
"template XS_Wrap {" << endl <<
" <2557EAA0-35E4-11D2-AB8B-444553540000>" << endl <<
" STRING   BuilderName;" << endl <<
" STRING   RefFrameName;" << endl <<
" BYTE     WrapType;" << endl <<
" Vector   Origin;" << endl <<
" Vector   Direction;" << endl <<
" Vector   Up;" << endl <<
" FLOAT    OriginU;" << endl <<
" FLOAT    OriginV;" << endl <<
" FLOAT    ScaleU;" << endl <<
" FLOAT    ScaleV;" << endl <<
"}" << endl
<< endl;
}//---------------------------------------------------------
static void WriteMesh(LPDIRECT3DRMMESHBUILDER IBuilder) {
  if (!IBuilder->GetFaceCount()) return;

  AnsiString name = RMName(IBuilder);
  int index = WrittenMeshes->IndexOf(name);
  if ((index != -1) && (name.Length() > 0)) {
     //   ,  :
     if (IsFrames) stream << "{" << name.c_str() << "}\n";
     return;
  }

  char line[255];
  char* fname = "~mesh.tmp";
  //       :
  hr=IBuilder->Save(fname, D3DRMXOF_TEXT, SaveOptions);
  if (HR_FAILED(hr)) return;
  fstream mesh;
  mesh.open(fname, ios::in);
  do {
     mesh.getline(line, sizeof line);
     if (strstr(line, "template"))
        mesh.getline(line, sizeof line);
  } while (!strstr(line, "Mesh ") && !mesh.eof());
  if (strstr(line, "Mesh ") && !mesh.eof()) {
     stream << line << endl;
     do {
        mesh.getline(line, sizeof line);
        stream << line << endl;
     } while (!mesh.eof());
  }
  mesh.close();
  DeleteFile(fname);
  WrittenMeshes->Add(name);
}//---------------------------------------------------------
static void tWriteNamedMeshes(LPDIRECT3DRMFRAME Iframe) {
  DWORD i;
  // FrameMeshes--------------------------------Begin
  LPDIRECT3DRMVISUAL Ivisual = NULL;
  LPDIRECT3DRMVISUALARRAY IVisuals = NULL;
  LPDIRECT3DRMMESHBUILDER IBuilder = NULL;
  hr = Iframe->GetVisuals(&IVisuals);
  if (HR_FAILED(hr)) goto ErrorReturnMesh;
  for (i = 0; i < IVisuals->GetSize(); i++) {
     hr = IVisuals->GetElement(i, &Ivisual);
     if (HR_FAILED(hr)) goto ErrorReturnMesh;
     hr = Ivisual->QueryInterface(
           IID_IDirect3DRMMeshBuilder, (void **) &IBuilder);
     if (HR_FAILED(hr)) {
        RELEASE(IBuilder);
        continue; //   
     } else {
        AnsiString name = RMName(IBuilder);
        if (name.Length() > 0)  {
           IsFrames = false;
           WriteMesh(IBuilder);
        }
        if (HR_FAILED(hr)) goto ErrorReturnMesh;
        RELEASE(IBuilder);
     }
     RELEASE(Ivisual);
  } RELEASE(IVisuals);
  hr = D3DRM_OK;
  ErrorReturnMesh:
  RELEASE(Ivisual);
  RELEASE(IVisuals);
  RELEASE(IBuilder);
  if (HR_FAILED(hr)) return;
  // FrameMeshes----------------------------------End

  // ChildFrames--------------------------------Begin
  LPDIRECT3DRMFRAME Ichild = NULL;
  LPDIRECT3DRMFRAMEARRAY IFrameArray = NULL;
  hr = Iframe->GetChildren(&IFrameArray);
  if (HR_FAILED(hr)) goto ErrorReturnFrame;
  for (i = 0; i < IFrameArray->GetSize(); i++) {
     hr = IFrameArray->GetElement(i, &Ichild);
     if (HR_FAILED(hr)) goto ErrorReturnFrame;
     tWriteNamedMeshes(Ichild);
     RELEASE(Ichild);
  } RELEASE(IFrameArray);
  hr = D3DRM_OK;
  ErrorReturnFrame:
  RELEASE(Ichild);
  RELEASE(IFrameArray);
  // ChildFrames----------------------------------End
}//---------------------------------------------------------
static void tWriteFrameRecursion(LPDIRECT3DRMFRAME Iframe) {
  DWORD i;
  stream << "Frame " << RMName(Iframe) << " {\n";
  // FrameTransformMatrix ----------------------Begin
  stream << "FrameTransformMatrix {\n";
  D3DRMMATRIX4D rmMatrix;
  hr = Iframe->GetTransform(rmMatrix);
  if (HR_FAILED(hr)) return;
  for (int r = 0; r < 3; r++) {
     for (int c = 0; c < 4; c++)
      stream << rmMatrix[r][c] << ",";
     stream << endl;
  } // for r
  for (int c = 0; c < 3; c++)
     stream << rmMatrix[3][c] << ",";
  stream << rmMatrix[3][3] << ";;";
  stream << endl;
  stream << "}\n";
  // FrameTransformMatrix ------------------------End

  // FrameMeshes--------------------------------Begin
  LPDIRECT3DRMVISUAL Ivisual = NULL;
  LPDIRECT3DRMVISUALARRAY IVisuals = NULL;
  LPDIRECT3DRMMESHBUILDER IBuilder = NULL;
  hr = Iframe->GetVisuals(&IVisuals);
  if (HR_FAILED(hr)) goto ErrorReturnMesh;
  for (i = 0; i < IVisuals->GetSize(); i++) {
     hr = IVisuals->GetElement(i, &Ivisual);
     if (HR_FAILED(hr)) goto ErrorReturnMesh;
     hr = Ivisual->QueryInterface(
           IID_IDirect3DRMMeshBuilder, (void **) &IBuilder);
     if (HR_FAILED(hr)) {
        RELEASE(IBuilder);
        continue; //   
     } else {
        IsFrames = true;
        WriteMesh(IBuilder);
        if (HR_FAILED(hr)) goto ErrorReturnMesh;
        RELEASE(IBuilder);
     }
     RELEASE(Ivisual);
  } RELEASE(IVisuals);
  hr = D3DRM_OK;
  ErrorReturnMesh:
  RELEASE(Ivisual);
  RELEASE(IVisuals);
  RELEASE(IBuilder);
  if (HR_FAILED(hr)) return;
  // FrameMeshes----------------------------------End

  // ChildFrames--------------------------------Begin
  LPDIRECT3DRMFRAME Ichild = NULL;
  LPDIRECT3DRMFRAMEARRAY IFrameArray = NULL;
  hr = Iframe->GetChildren(&IFrameArray);
  if (HR_FAILED(hr)) goto ErrorReturnFrame;
  for (i = 0; i < IFrameArray->GetSize(); i++) {
     hr = IFrameArray->GetElement(i, &Ichild);
     if (HR_FAILED(hr)) goto ErrorReturnFrame;
     tWriteFrameRecursion(Ichild);
     RELEASE(Ichild);
  } RELEASE(IFrameArray);
  hr = D3DRM_OK;
  ErrorReturnFrame:
  RELEASE(Ichild);
  RELEASE(IFrameArray);
  if (HR_FAILED(hr)) return;
  // ChildFrames----------------------------------End
  stream << "}\n";
}//---------------------------------------------------------
static HRESULT tSaveFrame(LPDIRECT3DRMFRAME Iframe,
              const char *FileName,
              D3DRMSAVEOPTIONS Options)
{
  WrittenMeshes = new TStringList;
  hr = D3DRM_OK;
  if (!Iframe || !FileName) return hr;
  stream.open(FileName, ios::out);
  stream.flags(iostream::showpoint);
  stream << "xof 0302txt 0064" << endl;
  if (Options & D3DRMXOFSAVE_TEMPLATES)
     tWriteFrameTemplates();
  stream << "Header {1; 0; 1;}\n";
  tWriteNamedMeshes(Iframe);
  tWriteFrameRecursion(Iframe);
  stream.close();
  delete WrittenMeshes;
  return hr;
}//---------------------------------------------------------
static void WriteLights(LPDIRECT3DRMFRAME Iframe) {
  if (!Iframe) return;

  int type;
  D3DVALUE CAt, LAt, QAt;
  D3DCOLOR c;
  D3DVALUE r, g, b;
  D3DVALUE penumbra;
  D3DVALUE range;

  AnsiString frame = RMName(Iframe);
  if (frame.Length()) {
     LPDIRECT3DRMLIGHTARRAY ILights = NULL;
     Iframe->GetLights(&ILights);
     if (ILights) {
        for (DWORD i = 0; i < ILights->GetSize(); i++) {
           LPDIRECT3DRMLIGHT Ilight = NULL;
           ILights->GetElement(i, &Ilight);
           if (!Ilight) continue;
           LPDIRECT3DRMFRAME Ieframe = NULL;
           Ilight->GetEnableFrame(&Ieframe);
           type     = Ilight->GetType();
           CAt      = Ilight->GetConstantAttenuation();
           LAt      = Ilight->GetLinearAttenuation();
           QAt      = Ilight->GetQuadraticAttenuation();
           c        = Ilight->GetColor();
           r        = D3DRMColorGetRed(c);
           g        = D3DRMColorGetGreen(c);
           b        = D3DRMColorGetBlue(c);
           penumbra = Ilight->GetPenumbra();
           range    = Ilight->GetRange();
           stream <<"XS_Light "<<RMName(Ilight)<<" {\n \""
           << frame << "\";\n \""
           << RMName(Ieframe) << "\";\n "
           << type << ";\n "
           << CAt << "; " << LAt << "; " << QAt << ";;\n "
           << r << "; " << g << "; " << b << ";;\n "
           << penumbra  << ";\n " << range   << ";\n}\n";
           Ilight->Release();
           RELEASE(Ieframe);
        }
        ILights->Release();
     } // if (ILights)
  } // if (frame.Length() > 1)

  LPDIRECT3DRMFRAMEARRAY IFrames = NULL;
  Iframe->GetChildren(&IFrames);
  if (!IFrames) return;
  for (DWORD i = 0; i < IFrames->GetSize(); i++) {
     LPDIRECT3DRMFRAME Iframe = NULL;
     IFrames->GetElement(i, &Iframe);
     WriteLights(Iframe);
     RELEASE(Iframe);
  }  RELEASE(IFrames);
}//---------------------------------------------------------
static void WriteWraps(LPDIRECT3DRMFRAME Iframe) {
  if (!Iframe) return;
  LPDIRECT3DRMVISUALARRAY IVisuals = NULL;
  Iframe->GetVisuals(&IVisuals);
  if (IVisuals) {
     for (DWORD i = 0; i < IVisuals->GetSize(); i++) {
        LPDIRECT3DRMVISUAL Ivis = NULL;
        IVisuals->GetElement(i, &Ivis);
        if (!Ivis) continue;
        if (!IsBuilder(Ivis)) {Ivis->Release(); continue;}
        AnsiString builder = RMName(Ivis);
        TAppData* data = (TAppData*) Ivis->GetAppData();
        if (!data || !data->Wrap || !builder.Length()) {
           Ivis->Release();
           continue;
        }
        TWrap *W = data->Wrap;
        stream << "XS_Wrap " << builder << " {\n \""
        << RMName(W->IFrameRef) << "\";\n "
        << W->type << ";\n "
        << W->ox <<"; " << W->oy << "; " << W->oz << ";;\n "
        << W->dx <<"; " << W->dy << "; " << W->dz << ";;\n "
        << W->ux <<"; " << W->uy << "; " << W->uz << ";;\n "
        << W->ou <<"; " << W->ov << ";\n "
        << W->su <<"; " << W->sv << ";\n}\n";
        Ivis->Release();
     }
     IVisuals->Release();
  }

  LPDIRECT3DRMFRAMEARRAY IFrames = NULL;
  Iframe->GetChildren(&IFrames);
  if (!IFrames) return;
  for (DWORD i = 0; i < IFrames->GetSize(); i++) {
     LPDIRECT3DRMFRAME Iframe = NULL;
     IFrames->GetElement(i, &Iframe);
     WriteWraps(Iframe);
     RELEASE(Iframe);
  }  RELEASE(IFrames);
}//---------------------------------------------------------
bool GetToken(char**ptr, char*dst, int size, char delim) {
  int sdone = 0;
  if (!ptr || !**ptr) return false;
skipcomment:
  while (strchr("/#", **ptr)) {
     do (*ptr)++;
     while (**ptr && **ptr != '\n');
  }
  while (**ptr && strchr(" \t\r\n", **ptr)) (*ptr)++;
  if (**ptr && strchr("/#", **ptr)) goto skipcomment;
  if (!**ptr) return false;

  if (delim)
  while (**ptr && (**ptr != delim)) {
     if (size && (sdone == size-1)) break;
     if (**ptr && strchr("/#", **ptr)) goto skipcomment;
     if (dst && !strchr(" \t\r\n", **ptr))
        dst[sdone++] = **ptr;
     (*ptr)++;
  }
  if (!delim)
  while (**ptr && !strchr(" \t\r\n", **ptr)) {
     if (size && (sdone == size-1)) break;
     if (**ptr && strchr("/#", **ptr)) goto skipcomment;
     if (dst) dst[sdone++] = **ptr;
     (*ptr)++;
  }
  if (**ptr) (*ptr)++;
  if (dst) dst[sdone] = 0;
  return true;
}//---------------------------------------------------------
void SkipBlock(char** ptr) {
  int lbrace = 1;
  if (!ptr || !**ptr) return;
skipcomment:
  while (strchr("/#", **ptr)) {
     do (*ptr)++;
     while (**ptr && **ptr != '\n');
  }
  while (**ptr && lbrace) {
     if (**ptr == '}') lbrace--;
     if (**ptr == '{') lbrace++;
     (*ptr)++;
     if (**ptr && strchr("/#", **ptr)) goto skipcomment;
  }
}//---------------------------------------------------------
static void ReadLights(char **ptr) {
  char light[256];
  char frame[256];
  char enframe[256];
  char temp[10];

  BYTE type;
  D3DVALUE CAt, LAt, QAt;
  D3DVALUE r, g, b;
  D3DVALUE penumbra;
  D3DVALUE range;

  while (GetToken(ptr, temp, sizeof(temp))) {
     light[0] = 0;  frame[0] = 0;  enframe[0] = 0;
     if (strcmp(temp, "template") == 0) {
        GetToken(ptr, NULL, 0, '{');
        SkipBlock(ptr);
        continue;
     }
     if (strcmp(temp, "XS_Light") != 0)
        continue;
     GetToken(ptr, light, sizeof(light), '{');
     GetToken(ptr, frame, sizeof(frame), ';'); 
     //     ""
     strncpy(frame, &frame[1], strlen(frame)-2);
     frame[strlen(frame)-2] = 0;
     GetToken(ptr, enframe, sizeof(enframe), ';');
     //     ""
     strncpy(enframe, &enframe[1], strlen(enframe)-2);
     enframe[strlen(enframe)-2] = 0;
     #define GETEMP GetToken(ptr, temp, sizeof(temp), ';')
     GETEMP; type = (BYTE)atoi(temp);
     GETEMP; CAt = atof(temp);
     GETEMP; LAt = atof(temp);
     GETEMP; QAt = atof(temp);
     GETEMP; // ';'
     GETEMP; r = atof(temp);
     GETEMP; g = atof(temp);
     GETEMP; b = atof(temp);
     GETEMP; // ';'
     GETEMP; penumbra = atof(temp);
     GETEMP; range = atof(temp);
     #undef GETTEMP
     if (!GetToken(ptr, NULL, 0, '}')) {
        hr = D3DRMERR_BADFILE;
        return;
     }
     if (!strcmp(frame, "")) continue;
     LPDIRECT3DRMOBJECT Iobject = NULL;
     IRM->GetNamedObject(frame, &Iobject);
     if (!Iobject) continue;
     LPDIRECT3DRMLIGHT Ilight = NULL;
     IRM->CreateLightRGB((D3DRMLIGHTTYPE)type,
                                          r, g, b, &Ilight);
     if (Ilight) {
        if (strcmp(enframe, "") != 0) {
           LPDIRECT3DRMOBJECT Ieobject = NULL;
           IRM->GetNamedObject(enframe, &Ieobject);
           if (Ieobject) {
              Ilight->SetEnableFrame(
                               LPDIRECT3DRMFRAME(Ieobject));
              Ieobject->Release();
           }
        }
        Ilight->SetConstantAttenuation(CAt);
        Ilight->SetLinearAttenuation(LAt);
        Ilight->SetQuadraticAttenuation(QAt);
        Ilight->SetPenumbra(penumbra);
        Ilight->SetRange(range);
        Ilight->SetName(light);
        LPDIRECT3DRMFRAME(Iobject)->AddLight(Ilight);
        Ilight->Release();
     } // if (Ilight)
     Iobject->Release();
  } // while
}//---------------------------------------------------------
static void ReadWraps(char **ptr) {
  TWrap W;
  char temp[10], reframe[256], builder[256];
  while (GetToken(ptr, temp, sizeof(temp))) {
     reframe[0] = 0;  builder[0] = 0;
     if (strcmp(temp, "template") == 0) {
        GetToken(ptr, NULL, 0, '{');
        SkipBlock(ptr);
        continue;
     }
     if (strcmp(temp, "XS_Wrap") != 0)
        continue;
     GetToken(ptr, builder, sizeof(builder), '{');
     GetToken(ptr, reframe, sizeof(reframe), ';'); 
     //     ""
     strncpy(reframe, &reframe[1], strlen(reframe)-2);
     reframe[strlen(reframe)-2] = 0;
     #define GETEMP GetToken(ptr, temp, sizeof(temp), ';')
     GETEMP; W.type = (D3DRMWRAPTYPE)atoi(temp);
     GETEMP; W.ox = atof(temp);
     GETEMP; W.oy = atof(temp);
     GETEMP; W.oz = atof(temp);
     GETEMP; // ';'
     GETEMP; W.dx = atof(temp);
     GETEMP; W.dy = atof(temp);
     GETEMP; W.dz = atof(temp);
     GETEMP; // ';'
     GETEMP; W.ux = atof(temp);
     GETEMP; W.uy = atof(temp);
     GETEMP; W.uz = atof(temp);
     GETEMP; // ';'
     GETEMP; W.ou = atof(temp);
     GETEMP; W.ov = atof(temp);
     GETEMP; W.su = atof(temp);
     GETEMP; W.sv = atof(temp);
     #undef GETTEMP
     if (!GetToken(ptr, NULL, 0, '}')) {
        hr = D3DRMERR_BADFILE;
        return;
     }
     if (!strcmp(builder, "")) continue;
     IRM->GetNamedObject(builder, &W.IObject);
     if (!W.IObject) continue;
     W.IObject->Release();
     IRM->GetNamedObject(reframe, &(LPDIRECT3DRMOBJECT)W.IFrameRef);
     RELEASE(W.IFrameRef);

     TAppData *data;
     data = (TAppData*) ASOBJECT(W.IObject)->GetAppData();
     if (!data) {
        data = new TAppData;
        W.IObject->SetAppData((DWORD)data);
        W.IObject->AddDestroyCallback(AppDataDestroy, NULL);
     }
     if (!data->Wrap) data->Wrap = new TWrap;
     *data->Wrap = W;
     data->Wrap->ReApply();
  } // while
}//---------------------------------------------------------
HRESULT SaveScene(LPDIRECT3DRMFRAME Iframe,
                  const char *FileName,
                  D3DRMXOFFORMAT Format,
                  D3DRMSAVEOPTIONS Options)
{
  hr = D3DRM_OK;
  SaveOptions = Options;
  if (!Iframe || !FileName) return D3DRMERR_BADVALUE;
  WrittenMeshes = new TStringList;
  stream.open(FileName, ios::out);
  stream.flags(iostream::showpoint);
  stream << "xof 0302txt 0064" << endl;
  if (Options & D3DRMXOFSAVE_TEMPLATES) {
     tWriteFrameTemplates();
     stream << "#Templates for X-Studio\n";
     tWriteXStudioTemplates();
  }
  stream << "Header {1; 0; 1;}\n";
  tWriteNamedMeshes(Iframe);
  tWriteFrameRecursion(Iframe);
  stream << "#Additional data for X-Studio:\n";
  WriteLights(Iframe);
  WriteWraps(Iframe);
  stream.close();
  return hr;
}//---------------------------------------------------------
void ReadScene(char **ptr) {
  char *start;
  try {
     IRM = NULL;
     hr = Direct3DRMCreate(&IRM);
     if (HR_FAILED(hr)) goto end;
     start = *ptr; ReadLights(&start);
     if (HR_FAILED(hr)) goto end;
     start = *ptr; ReadWraps(&start);
     if (HR_FAILED(hr)) goto end;
  } catch(...) {hr = D3DRMERR_BADFILE;}
end:
  RELEASE(IRM);
}//---------------------------------------------------------
HRESULT LoadScene(LPDIRECT3DRMFRAME Iframe,
                     const char *FileName,
                     D3DRMLOADTEXTURECALLBACK OnTextureLoad)
{
  hr = D3DRM_OK;
  if (!Iframe || !FileName) return D3DRMERR_BADVALUE;
  hr = Iframe->Load((void*)FileName, NULL,
                   D3DRMLOAD_FROMFILE, OnTextureLoad, NULL);
  if (HR_FAILED(hr)) {return hr;}

  stream.open(FileName, ios::in);
  stream.seekg(0, ios::end);
  DWORD streamsize = stream.tellg();
  stream.seekg(0, ios::beg);
  char *buffer = new char[streamsize+1];
  stream.read(buffer, streamsize);
  buffer[streamsize+1] = 0;
  stream.close();
  ReadScene(&buffer);
  delete [] buffer;
  return hr;
}//---------------------------------------------------------
HRESULT LoadSceneID(LPDIRECT3DRMFRAME Iframe, int ident,
                     D3DRMLOADTEXTURECALLBACK OnTextureLoad)
{
  //  MAKEINTRESOURCE   WinUser.h 
  // #define MAKEINTRESOURCEA(i) (LPSTR)((DWORD)((WORD)(i)))
  return LoadSceneID(Iframe, MAKEINTRESOURCE(ident),
                                             OnTextureLoad);
}//---------------------------------------------------------
HRESULT LoadSceneID(LPDIRECT3DRMFRAME Iframe, char *ident,
                     D3DRMLOADTEXTURECALLBACK OnTextureLoad)
{
  hr = D3DRM_OK;
  if (!Iframe) return D3DRMERR_BADVALUE;

  //       
  //  IDirect3DRMFrame::Load()  
  D3DRMLOADRESOURCE info;
  info.hModule = NULL;
  info.lpName = ident;
  info.lpType = "X";
  hr = Iframe->Load(&info, NULL, D3DRMLOAD_FROMRESOURCE,
                                       OnTextureLoad, NULL);
  if (HR_FAILED(hr)) {return hr;}

  //   ,    X-Studio
  //     :
  HRSRC hrsrc = FindResource(NULL, ident, "X");
  if (!hrsrc) return D3DRMERR_NOTFOUND;
  HGLOBAL hglobal = LoadResource(NULL, hrsrc);
  if (!hglobal) return D3DRMERR_UNABLETOEXECUTE;
  //     :
  LPVOID pRes = LockResource(hglobal);
  if (!pRes) return D3DRMERR_UNABLETOEXECUTE;
  //-------------------------------------------------
  //      :
  // FILE *f = fopen("Resourse.x", "wb");
  // DWORD size = SizeofResource(NULL, hrsrc);
  // fwrite(pRes, size, 1, f);
  // fclose(f);
  //-------------------------------------------------
  //     Direct3DRM, 
  //     X-Studio   
  ReadScene(&(char*) pRes);
  //    :
  UnlockResource(hglobal);
  FreeResource(hglobal);

  return hr;
}//---------------------------------------------------------