__fastcall TD3dView::TD3dView(TComponent* Owner)
  : TCustomControl(Owner)
{
  (((ControlStyle << csAcceptsControls) >> csSetCaption)
  << csFramed) << csOpaque;

  _control87(MCW_EM,MCW_EM);

  FRMTickValue = 1;
  CtrLst = new TList;
  Width   = 200;
  Height  = 150;

  Direct3DRMCreate(&IRM);
  IRM->CreateFrame(NULL, &IScene);
  IRM->CreateFrame(IScene, &ICamera);
  IcsFrame = IScene; //    
  IRM->CreateLightRGB(D3DRMLIGHT_AMBIENT,
                                    0.5,0.5,0.5, &IAmbient);
  IScene->AddLight(IAmbient);
  DirectDrawCreate(NULL, &IDD, NULL);
  IDD->CreateClipper(0, &IClipper, NULL);
}//---------------------------------------------------------
__fastcall TD3dView::~TD3dView() {
  ReleaseAll();
  delete CtrLst;
}//---------------------------------------------------------
void __fastcall TD3dView::ReleaseAll() {
  for(int i = 0; i < ControlCount; i++) {
     TVport* Vport = dynamic_cast<TVport*>(Controls[i]);
     if (Vport) RELEASE(Vport->IRMVport);
  }
  RELEASE(IRMDevice);

  RELEASE(IAmbient);
  RELEASE(ICamera);
  ClearFrame(IScene);
  RELEASE(IScene);
  RELEASE(IRM);

  RELEASE(IClipper);
  RELEASE(IDD);
  CtrLst->Clear();
}//---------------------------------------------------------
void __fastcall TD3dView::Init(LPGUID DevGUID) {
  TRY(IClipper->SetHWnd(0, Handle));

  for(int i = 0; i < ControlCount; i++) {
     TVport* Vport = dynamic_cast<TVport*>(Controls[i]);
     if (Vport) Vport->Release();
  }
  RELEASE(IRMDevice);

  DWORD width  = Screen->Width;
  DWORD height = Screen->Height;

  HRESULT hr = IRM->CreateDeviceFromClipper(
              IClipper, DevGUID, width, height, &IRMDevice);
  if (HR_FAILED(hr)) {
     AnsiString Error = "Could't create device\nHRESULT = ";
     Error += HRString(hr);
     Error += "\nTrying to use default driver!";
     Application->MessageBox(Error.c_str(), "Device error",
                     MB_ICONEXCLAMATION);
     RELEASE(IRMDevice);
     TRY(IRM->CreateDeviceFromClipper(
                IClipper, NULL, width, height, &IRMDevice));
  }

  for(int i = 0; i < ControlCount; i++) {
     TVport* Vport = dynamic_cast<TVport*>(Controls[i]);
     if (Vport) Vport->Init(IRM, IRMDevice, ICamera);
  }

  if (FCullNone)
     SetRMRenderState(IRMDevice,
                    D3DRENDERSTATE_CULLMODE, D3DCULL_NONE);
  ChangeColor();
}//---------------------------------------------------------
void __fastcall TD3dView::ChangeColor() {
  if (!IScene) return;
  long color = ColorToRGB(Color);
  D3DVALUE r = GetRValue(color) / 255.0;
  D3DVALUE g = GetGValue(color) / 255.0;
  D3DVALUE b = GetBValue(color) / 255.0;
  IScene->SetSceneBackgroundRGB(r, g, b);
  Refresh();
}//---------------------------------------------------------
void __fastcall TD3dView::HandleActivate(WORD wparam) {
  if (!IRMDevice) return;
  LPDIRECT3DRMWINDEVICE IWinDevice = NULL;
  IRMDevice->QueryInterface(
           IID_IDirect3DRMWinDevice, (void **) &IWinDevice);
  if (IWinDevice) {
     (IWinDevice->HandleActivate(wparam));
     IWinDevice->Release();
  }
}//---------------------------------------------------------
void __fastcall TD3dView::Paint() {
  if (!IRM || !IRMDevice || !IScene) return;
  LPDIRECT3DRMWINDEVICE IWinDevice = NULL;
  IRMDevice->QueryInterface(IID_IDirect3DRMWinDevice,
                                     (void **) &IWinDevice);
  if (IWinDevice) {
     PAINTSTRUCT ps;
     BeginPaint(Handle, &ps);
        IWinDevice->HandlePaint(ps.hdc);
     EndPaint(Handle, &ps);
     IWinDevice->Release();
  }
  Update();
  if (FOnRedraw) FOnRedraw(this);
}//---------------------------------------------------------
void __fastcall TD3dView::SetBounds(int ALeft, int ATop,
  int AWidth, int AHeight)
{
  TWinControl::SetBounds(ALeft, ATop, AWidth, AHeight);
  Refresh();
}//---------------------------------------------------------
void __fastcall TD3dView::AlignControls(TControl* AControl,
  TRect &Rect)
{
  TWinControl::AlignControls(AControl, Rect);
  Refresh();
}//---------------------------------------------------------
void __fastcall TD3dView::Refresh() {
  if (IRM && IRMDevice && IScene) IRM->Tick(0);
  InGDISurface = false;
  if (FOnRedraw) FOnRedraw(this);
}//---------------------------------------------------------
void __fastcall TD3dView::Render() {
  if (IRM && IRMDevice && IScene) IRM->Tick(FRMTickValue);
  InGDISurface = false;
  if (FOnRedraw) FOnRedraw(this);
}//---------------------------------------------------------
void __fastcall TD3dView::RenderLoop(TObject*, bool &Done) {
  if (!Application->Active) {
     Done = true;
     return;
  }
  if (!FastLoop || NeedsMove(IScene)) {
     Render();
     Done = false;
  }
}//---------------------------------------------------------
void __fastcall TD3dView::FlipToGDISurface() {
  if ((IDD) && (!InGDISurface)) {
     HRESULT hr = IDD->FlipToGDISurface();
     if (HR_SUCCEEDED(hr)) InGDISurface = true;
  };
}//---------------------------------------------------------
void __fastcall TD3dView::Update() {
  for(int i = 0; i < ControlCount; i++) {
     TVport* Vport = dynamic_cast<TVport*>(Controls[i]);
     if (Vport) Vport->Update();
  }
  if (IRMDevice) IRMDevice->Update();
}//---------------------------------------------------------
void __fastcall TD3dView::SetCSFrame(LPDIRECT3DRMFRAME Ifr){
  if (Ifr) IcsFrame = Ifr;
  else IcsFrame = IScene;
}//---------------------------------------------------------
bool __fastcall TD3dView::NeedsMove(LPDIRECT3DRMFRAME IFr) {
  D3DVALUE Theta;
  D3DVECTOR Vector;
  if (!IFr) return false;
  LPDIRECT3DRMFRAMEARRAY IChildren = NULL;
  IFr->GetChildren(&IChildren);
  if (!IChildren) return false;
  DWORD size = IChildren->GetSize();
  for (DWORD i = 0; i < size; i++) {
     LPDIRECT3DRMFRAME Ichild = NULL;
     IChildren->GetElement(i, &Ichild);
     if (!Ichild) continue;
     Ichild->GetVelocity(IScene, &Vector, TRUE);
     Ichild->GetRotation(IScene, &Vector, &Theta);
     if ((Vector.dvX+Vector.dvY+Vector.dvZ) || Theta) {
        Ichild->Release();
        IChildren->Release();
        return true;
     }
     if (NeedsMove(Ichild)) {
        Ichild->Release();
        IChildren->Release();
        return true;
     }
     Ichild->Release();
  }
  IChildren->Release();
  return false;
}//---------------------------------------------------------
void __fastcall TD3dView::WndProc(TMessage &Message) {
  switch (Message.Msg) {
    //  :
    case WM_CREATE:
       TCustomControl::WndProc(Message);
       if (!IRMDevice) Init();
    break;
    case WM_PALETTECHANGED:
       TCustomControl::WndProc(Message);
       Refresh();
    break;
    case WM_ACTIVATE:
       HandleActivate(Message.WParamLo);
       TCustomControl::WndProc(Message);
    break;
    case CM_COLORCHANGED: //  TControl
       ChangeColor();
    break;
    //  :
    case WM_MOUSEMOVE:
    case WM_LBUTTONDOWN:
    case WM_LBUTTONUP:
    case WM_LBUTTONDBLCLK:
    case WM_RBUTTONDOWN:
    case WM_RBUTTONUP:
    case WM_RBUTTONDBLCLK:
       TWMMouse MMsg;
       memcpy(&MMsg, &Message, sizeof(TMessage));
       // IsControlMouseMsg()  
       // TCustomControl::WndProc(Message);
       if (!IsControlMouseMsg(MMsg))
          if (CtrlMessage(Message))
            if (Application->OnIdle != RenderLoop) Render();
    break;
    case WM_KEYDOWN:
    case WM_KEYUP:
       TCustomControl::WndProc(Message);
       if (!Dragging())
          if (CtrlMessage(Message))
            if (Application->OnIdle != RenderLoop) Render();
    break;
    default:
    TCustomControl::WndProc(Message);
  }// switch
}//---------------------------------------------------------
bool __fastcall TD3dView::CtrlMessage(TMessage &Message) {
  PCtrl ctrl;
  bool result = false;
  int count = CtrLst->Count;
  for (register i = 0; i < count; i++) {
     ctrl = PCtrl(CtrLst->Items[i]);
     if (ctrl && ctrl->CtrlMessage(Message)) result = true;
  }
  return result;
}//---------------------------------------------------------
