//
//
//                   Ivory -- A Memory Management Library
//
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// ivarcppc.cpp
//
// Ivory Allocation - Arena allocation routines for C++.
//
// These routines provide a C++ wrapper for the Ivory Arena allocation
// routines.  Note that there is no delete operator, since arena allocations
// are never deleted individually.
//
//

//
//
//                                Includes
//
//

#include <malloc.h>
#include <memory.h>
#include <new.h>
#include <assert.h>
#include "ivory.hpp"

//
//
//                                 Code
//
//

//
//
//  These are versions of the C++ new and delete operators, wired to
//  use the ivory arena routines.
//
//

void *operator new (size_t size, IvoryArena *arena)
{
    assertMyth("Ivory Arena operator new needs valid inputs",
                size > 0 && arena != 0);
    return ivory_arena_alloc (arena, size);
}

void *operator new (size_t size, IvorySubAlloc *suballoc)
{
    assertMyth("Ivory Sub Alloc operator new needs valid inputs",
                size > 0 && suballoc != 0);
    return ivory_sub_alloc (suballoc, size);
}

#if 0
void *operator new [] (size_t size, IvoryArena *arena)
{
    return ivory_arena_alloc (arena, size);
}
#endif

// End of module - ivarcpp.cpp 
