//
//
//           ^           **   **   **** ***** *    ****     ^      Take me to
//          (_)            * *     *      *   *    *       (_)    / your
//     ^                    *      **     *   *    **            ^  leader...
//    (_)       ^          * *     *      *   *    *            (_)
//             (_)       **   **   *    ***** **** ****
//
//    Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// xfiff.hpp
//
//     Contains the header for the IFF parsing object.
//
//

#ifndef __XFIFF_HPP
#define __XFIFF_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include "xfbase.hpp"

//
//
//                                Equates
//
//

// XFForm flags 
#define XF_IFFFORM_DIRTY   0x1

// Maximum supported depth for form embedding 
const ulong XF_MAX_IFFDEPTH    =16;

//
//
//                               Structures
//
//

// Form Context Structure 
struct XFForm {
   dword   id;
   dword   flags;
   dword   start;
   dword   len;
};

//
//
//                                Classes
//
//

class XFParseIFF {
   ulong           idepth;
   ulong           icurPos;
   ulong           ilength;
   ulong           ichunkSize;
   struct XFForm   iforms[XF_MAX_IFFDEPTH];
   XFileDOS        xfile;

   void initvars(void);

protected:
   XFile           *xf;

   xf_error_codes  errorn;

public:
   XFParseIFF();
   XFParseIFF(XFile *f);
   ~XFParseIFF();

   void attach(XFile *f) { if (!f) {xf=&xfile;} else {xf=f;} };

   xf_error_codes error(void) { return errorn; };

           //Ŀ
           // Various data status members.                                  
           //
   dword formid;
   dword chunkid;
   ulong chunkSize;
   ulong depth;

           //Ŀ
           // Quick access functions for the XFile object embedded.         
           //
   xf_error_codes open(const char *name, dword flags)
           { xf_error_codes err=xf->open(name,flags|XF_OPEN_READ);
             if (!err) {return begin();}
             errorn=err;
             return err; };
   xf_error_codes create(const char *name, dword flags)
           { xf_error_codes err=xf->create(name,flags|XF_OPEN_READ);
             if (!err) {return begin();}
             errorn=err;
             return err; };
   xf_error_codes close(void)
           {  end();
              xf_error_codes err=xf->close();
              if (err) errorn=err;
              return err; };

           //Ŀ
           // Public utilitiy routines.                                     
           //
   dword swapendian(dword c) { return ( ((c & 0xff) << 24) |
                                        ((c & 0xff00) << 8) |
                                        ((c & 0xff0000) >> 8) |
                                        ((c & 0xff000000) >> 24) ); };
   dword makeid(char c1, char c2, char c3, char c4) { return ( (c4 << 24) |
                                                               (c3 << 16) |
                                                               (c2 << 8) |
                                                               c1); };
   char *strid(dword id, char *buff) { buff[0] = (char)((id & 0xff));
                                       buff[1] = (char)((id & 0xff00) >> 8);
                                       buff[2] = (char)((id & 0xff0000) >> 16);
                                       buff[3] = (char)((id & 0xff000000) >> 24);
                                       buff[4] = 0;
                                       return buff; };

           //Ŀ
           // These must be called if the XFile object is not opened/closed 
           // via the member functions for this object.                     
           //
   xf_error_codes begin(void);
   xf_error_codes end(void);

           //Ŀ
           // Form-based file movement.                                     
           //
   xf_error_codes seekform(dword id);

   xf_error_codes newform(dword id);
   xf_error_codes enterform(void);

   xf_error_codes leaveform(void);

           //Ŀ
           // Chunk-based file movement.                                    
           //
   xf_error_codes seekchunk(dword id);

           //Ŀ
           // Item movement.                                                
           //
   xf_error_codes next(void);
   xf_error_codes topofcontext(void);

           //Ŀ
           // Reads/writes a chunk in the current position.                 
           //
   xf_error_codes read(void *ptr);
   xf_error_codes write(dword id, const void *ptr, ulong size);
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - xfiff.hpp 

