/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Observable;
import javax.swing.SwingUtilities;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.BooleanCommandTarget;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandInvocationException;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.CommandTargetManager;
import org.freehep.util.commanddispatcher.SimpleCommandTarget;

public class CommandProcessor
extends Observable
implements CommandGroup {
    private static final Class[] noArg = new Class[0];
    private static final Object[] noArgs = new Object[0];
    private static final Class[] boolArg = new Class[]{Boolean.TYPE};
    private static final Class[] simpleEnableArg = new Class[]{class$org$freehep$util$commanddispatcher$CommandState == null ? (class$org$freehep$util$commanddispatcher$CommandState = CommandProcessor.class$("org.freehep.util.commanddispatcher.CommandState")) : class$org$freehep$util$commanddispatcher$CommandState};
    private static final Class[] booleanEnableArg = new Class[]{class$org$freehep$util$commanddispatcher$BooleanCommandState == null ? (class$org$freehep$util$commanddispatcher$BooleanCommandState = CommandProcessor.class$("org.freehep.util.commanddispatcher.BooleanCommandState")) : class$org$freehep$util$commanddispatcher$BooleanCommandState};
    private CommandTargetManager manager;
    static /* synthetic */ Class class$org$freehep$util$commanddispatcher$CommandState;
    static /* synthetic */ Class class$org$freehep$util$commanddispatcher$BooleanCommandState;

    public void setChanged() {
        if (!this.hasChanged()) {
            super.setChanged();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CommandProcessor.this.notifyObservers();
                    CommandProcessor.this.clearChanged();
                }
            });
        }
    }

    public void setManager(CommandTargetManager m2) {
        this.manager = m2;
    }

    public CommandTarget acceptCommand(String command) {
        return this.acceptCommand(this.getClass(), command);
    }

    protected CommandTarget acceptCommand(Class klass, String command) {
        String t2 = this.translate(command);
        String c2 = "on" + t2;
        String e2 = "enable" + t2;
        try {
            Method me;
            Method mc = klass.getMethod(c2, noArg);
            try {
                me = klass.getMethod(e2, simpleEnableArg);
            }
            catch (NoSuchMethodException x2) {
                me = null;
            }
            try {
                if (me == null) {
                    me = klass.getMethod(e2, booleanEnableArg);
                }
            }
            catch (NoSuchMethodException x3) {
                me = null;
            }
            return new SimpleTarget(mc, me);
        }
        catch (NoSuchMethodException x4) {
            try {
                Method me;
                Method mc = klass.getMethod(c2, boolArg);
                try {
                    me = klass.getMethod(e2, booleanEnableArg);
                }
                catch (NoSuchMethodException x5) {
                    me = null;
                }
                return new BooleanTarget(mc, me);
            }
            catch (NoSuchMethodException x6) {
                return null;
            }
        }
    }

    protected void invoke(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        method.invoke((Object)this, args);
    }

    protected void invokeCommand(SimpleTarget t2) {
        try {
            t2.doCommand();
        }
        catch (CommandInvocationException x2) {
            this.manager.handleCommandError(x2.getTargetException());
        }
    }

    protected void invokeCommand(BooleanTarget t2, boolean arg) {
        try {
            t2.doCommand(arg);
        }
        catch (CommandInvocationException x2) {
            this.manager.handleCommandError(x2.getTargetException());
        }
    }

    protected void invokeCommand(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        this.invoke(method, args);
    }

    protected void invokeEnable(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException {
        this.invoke(method, args);
    }

    protected String translate(String command) {
        if (command.endsWith("...")) {
            command = command.substring(0, command.length() - 3);
        }
        int i2 = command.indexOf(" ");
        while (i2 >= 0) {
            command = command.substring(0, i2) + command.substring(i2 + 1);
            i2 = command.indexOf(" ");
        }
        if (command.length() < 2 || Character.isUpperCase(command.charAt(0))) {
            return command;
        }
        return command.substring(0, 1).toUpperCase() + command.substring(1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class SimpleTarget
    implements SimpleCommandTarget {
        private Method m_command;
        private Method m_enable;

        SimpleTarget(Method command, Method enable) {
            this.m_command = command;
            this.m_enable = enable;
            try {
                command.setAccessible(true);
                if (enable != null) {
                    enable.setAccessible(true);
                }
            }
            catch (SecurityException x2) {}
        }

        public CommandGroup getGroup() {
            return CommandProcessor.this;
        }

        public void doCommand() throws CommandInvocationException {
            try {
                CommandProcessor.this.invokeCommand(this.m_command, noArgs);
            }
            catch (IllegalAccessException x2) {
                throw new RuntimeException("IllegalAccessException during command invocation");
            }
            catch (InvocationTargetException x3) {
                throw new CommandInvocationException(x3.getTargetException());
            }
        }

        public void enable(CommandState state) {
            if (this.m_enable == null) {
                state.setEnabled(true);
            } else {
                try {
                    Object[] args = new Object[]{state};
                    CommandProcessor.this.invokeEnable(this.m_enable, args);
                }
                catch (IllegalAccessException x2) {
                    state.setEnabled(false);
                }
                catch (InvocationTargetException x3) {
                    state.setEnabled(false);
                }
            }
        }

        public void invoke() {
            CommandProcessor.this.invokeCommand(this);
        }
    }

    protected class BooleanTarget
    implements BooleanCommandTarget {
        private Method m_command;
        private Method m_enable;

        BooleanTarget(Method command, Method enable) {
            this.m_command = command;
            this.m_enable = enable;
            try {
                command.setAccessible(true);
                if (enable != null) {
                    enable.setAccessible(true);
                }
            }
            catch (SecurityException x2) {}
        }

        public CommandGroup getGroup() {
            return CommandProcessor.this;
        }

        public void doCommand(boolean arg) throws CommandInvocationException {
            try {
                Object[] args = new Object[]{new Boolean(arg)};
                CommandProcessor.this.invokeCommand(this.m_command, args);
            }
            catch (IllegalAccessException x2) {
                throw new RuntimeException("IllegalAccessException during command invocation");
            }
            catch (InvocationTargetException x3) {
                throw new CommandInvocationException(x3.getTargetException());
            }
        }

        public void enable(CommandState state) {
            if (this.m_enable == null) {
                state.setEnabled(true);
            } else {
                try {
                    Object[] args = new Object[]{(BooleanCommandState)state};
                    CommandProcessor.this.invokeEnable(this.m_enable, args);
                }
                catch (IllegalAccessException x2) {
                    state.setEnabled(false);
                }
                catch (InvocationTargetException x3) {
                    state.setEnabled(false);
                }
            }
        }

        public void invoke(boolean arg) {
            CommandProcessor.this.invokeCommand(this, arg);
        }
    }
}

