/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfWriter;

public abstract class PdfObject {
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int NAME = 4;
    public static final int ARRAY = 5;
    public static final int DICTIONARY = 6;
    public static final int STREAM = 7;
    public static final int INDIRECT = 10;
    public static final String NOTHING = "";
    public static final String ENCODING = "PDF";
    public static final String TEXT_UNICODE = "UnicodeBig";
    protected byte[] bytes;
    protected int type;

    protected PdfObject(int n2) {
        this.type = n2;
    }

    protected PdfObject(int n2, String string) {
        this.type = n2;
        this.bytes = PdfEncodings.convertToBytes(string, null);
    }

    protected PdfObject(int n2, byte[] byArray) {
        this.bytes = byArray;
        this.type = n2;
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        return this.bytes;
    }

    public int pdfLength() {
        return this.toPdf(null).length;
    }

    public String toString() {
        return PdfEncodings.convertToString(this.bytes, null);
    }

    public int length() {
        return this.toString().length();
    }

    protected void setContent(String string) {
        this.bytes = PdfEncodings.convertToBytes(string, null);
    }

    public int type() {
        return this.type;
    }

    public boolean isNull() {
        return this.type == 0;
    }

    public boolean isBoolean() {
        return this.type == 1;
    }

    public boolean isNumber() {
        return this.type == 2;
    }

    public boolean isString() {
        return this.type == 3;
    }

    public boolean isName() {
        return this.type == 4;
    }

    public boolean isArray() {
        return this.type == 5;
    }

    public boolean isDictionary() {
        return this.type == 6;
    }

    public boolean isStream() {
        return this.type == 7;
    }
}

