/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import java.security.MessageDigest;

public class PdfEncryption {
    static final byte[] pad = new byte[]{40, -65, 78, 94, 78, 117, -118, 65, 100, 0, 78, 86, -1, -6, 1, 8, 46, 46, 0, -74, -48, 104, 62, -128, 47, 12, -87, -2, 100, 83, 105, 122};
    byte[] state = new byte[256];
    int x;
    int y;
    byte[] key;
    int keySize;
    byte[] mkey;
    byte[] extra = new byte[5];
    MessageDigest md5;
    byte[] ownerKey = new byte[32];
    byte[] userKey = new byte[32];
    int permissions;
    byte[] documentID;

    public PdfEncryption() {
        try {
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public void setupAllKeys(byte[] byArray, byte[] byArray2, int n2, boolean bl) {
        int n3;
        int n4;
        Object object;
        long l2;
        long l3;
        n2 = bl ? (n2 |= 0xFFFFF0C0) : (n2 |= 0xFFFFFFC0);
        this.permissions = n2 &= 0xFFFFFFFC;
        byte[] byArray3 = new byte[32];
        if (byArray == null) {
            System.arraycopy(pad, 0, byArray3, 0, 32);
        } else {
            System.arraycopy(byArray, 0, byArray3, 0, Math.min(byArray.length, 32));
            if (byArray.length < 32) {
                System.arraycopy(pad, 0, byArray3, byArray.length, 32 - byArray.length);
            }
        }
        byte[] byArray4 = new byte[32];
        if (byArray2 == null || byArray2.length == 0) {
            System.arraycopy(pad, 0, byArray4, 0, 32);
            l3 = System.currentTimeMillis();
            l2 = Runtime.getRuntime().freeMemory();
            object = l3 + "-" + l2;
            System.arraycopy(this.md5.digest(((String)object).getBytes()), 0, byArray4, 0, 16);
        } else {
            System.arraycopy(byArray2, 0, byArray4, 0, Math.min(byArray2.length, 32));
            if (byArray2.length < 32) {
                System.arraycopy(pad, 0, byArray4, byArray2.length, 32 - byArray2.length);
            }
        }
        this.mkey = new byte[bl ? 16 : 5];
        object = this.md5.digest(byArray4);
        if (bl) {
            int n5 = 0;
            while (n5 < 50) {
                object = this.md5.digest((byte[])object);
                ++n5;
            }
            System.arraycopy(byArray3, 0, this.ownerKey, 0, 32);
            n4 = 0;
            while (n4 < 20) {
                n3 = 0;
                while (n3 < this.mkey.length) {
                    this.mkey[n3] = (byte)(object[n3] ^ n4);
                    ++n3;
                }
                this.prepareRC4Key(this.mkey);
                this.encryptRC4(this.ownerKey);
                ++n4;
            }
        } else {
            this.prepareRC4Key((byte[])object, 0, this.mkey.length);
            this.encryptRC4(byArray3, this.ownerKey);
        }
        l3 = System.currentTimeMillis();
        l2 = Runtime.getRuntime().freeMemory();
        String string = l3 + "+" + l2;
        this.documentID = this.md5.digest(string.getBytes());
        this.md5.update(byArray3);
        this.md5.update(this.ownerKey);
        this.extra[0] = (byte)n2;
        this.extra[1] = (byte)(n2 >> 8);
        this.extra[2] = (byte)(n2 >> 16);
        this.extra[3] = (byte)(n2 >> 24);
        this.md5.update(this.extra, 0, 4);
        object = this.md5.digest(this.documentID);
        if (bl) {
            n4 = 0;
            while (n4 < 50) {
                object = this.md5.digest((byte[])object);
                ++n4;
            }
        }
        System.arraycopy(object, 0, this.mkey, 0, this.mkey.length);
        if (bl) {
            this.md5.update(pad);
            object = this.md5.digest(this.documentID);
            System.arraycopy(object, 0, this.userKey, 0, 16);
            n4 = 16;
            while (n4 < 32) {
                this.userKey[n4] = 0;
                ++n4;
            }
            n3 = 0;
            while (n3 < 20) {
                int n6 = 0;
                while (n6 < this.mkey.length) {
                    object[n6] = (byte)(this.mkey[n6] ^ n3);
                    ++n6;
                }
                this.prepareRC4Key((byte[])object, 0, this.mkey.length);
                this.encryptRC4(this.userKey, 0, 16);
                ++n3;
            }
        } else {
            this.prepareRC4Key(this.mkey);
            this.encryptRC4(pad, this.userKey);
        }
    }

    public void prepareKey() {
        this.prepareRC4Key(this.key, 0, this.keySize);
    }

    public void setHashKey(int n2, int n3) {
        this.extra[0] = (byte)n2;
        this.extra[1] = (byte)(n2 >> 8);
        this.extra[2] = (byte)(n2 >> 16);
        this.extra[3] = (byte)n3;
        this.extra[4] = (byte)(n3 >> 8);
        this.md5.update(this.mkey);
        this.key = this.md5.digest(this.extra);
        this.keySize = this.mkey.length + 5;
        if (this.keySize > 16) {
            this.keySize = 16;
        }
    }

    public PdfLiteral getFileID() {
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer.append('[');
        byteBuffer.append(PdfContentByte.escapeString(this.documentID));
        byteBuffer.append(PdfContentByte.escapeString(this.documentID));
        byteBuffer.append(']');
        return new PdfLiteral(byteBuffer.toByteArray());
    }

    public PdfDictionary getEncryptionDictionary() {
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.FILTER, PdfName.STANDARD);
        pdfDictionary.put(PdfName.O, new PdfLiteral(PdfContentByte.escapeString(this.ownerKey)));
        pdfDictionary.put(PdfName.U, new PdfLiteral(PdfContentByte.escapeString(this.userKey)));
        pdfDictionary.put(PdfName.P, new PdfNumber(this.permissions));
        if (this.mkey.length > 5) {
            pdfDictionary.put(PdfName.V, new PdfNumber(2));
            pdfDictionary.put(PdfName.R, new PdfNumber(3));
            pdfDictionary.put(PdfName.LENGTH, new PdfNumber(128));
        } else {
            pdfDictionary.put(PdfName.V, new PdfNumber(1));
            pdfDictionary.put(PdfName.R, new PdfNumber(2));
        }
        return pdfDictionary;
    }

    public void prepareRC4Key(byte[] byArray) {
        this.prepareRC4Key(byArray, 0, byArray.length);
    }

    public void prepareRC4Key(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < 256) {
            this.state[n6] = (byte)n6;
            ++n6;
        }
        this.x = 0;
        this.y = 0;
        int n7 = 0;
        while (n7 < 256) {
            n5 = byArray[n4 + n2] + this.state[n7] + n5 & 0xFF;
            byte by = this.state[n7];
            this.state[n7] = this.state[n5];
            this.state[n5] = by;
            n4 = (n4 + 1) % n3;
            ++n7;
        }
    }

    public void encryptRC4(byte[] byArray, int n2, int n3, byte[] byArray2) {
        int n4 = n3 + n2;
        int n5 = n2;
        while (n5 < n4) {
            this.x = this.x + 1 & 0xFF;
            this.y = this.state[this.x] + this.y & 0xFF;
            byte by = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = by;
            byArray2[n5] = (byte)(byArray[n5] ^ this.state[this.state[this.x] + this.state[this.y] & 0xFF]);
            ++n5;
        }
    }

    public void encryptRC4(byte[] byArray, int n2, int n3) {
        this.encryptRC4(byArray, n2, n3, byArray);
    }

    public void encryptRC4(byte[] byArray, byte[] byArray2) {
        this.encryptRC4(byArray, 0, byArray.length, byArray2);
    }

    public void encryptRC4(byte[] byArray) {
        this.encryptRC4(byArray, 0, byArray.length, byArray);
    }
}

